/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.utils;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.InternalException;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import com.ibm.ws.webservices.utils.BAIS;
import com.ibm.ws.webservices.utils.BufferedWriter;
import com.ibm.ws.webservices.utils.LowFlushFilter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.xml.sax.InputSource;

public final class WebServicesInputSource
extends InputSource {
    protected boolean copyIfNotResettable = false;
    protected static Log log = LogFactory.getLog(WebServicesInputSource.class.getName());
    private String _stringContent = null;
    private byte[] _byteArrayContent = null;
    private BAIS _baisContent = null;
    private Boolean _isPossiblyFault = null;

    public static WebServicesInputSource create(InputStream is) {
        return new WebServicesInputSource(is);
    }

    public static WebServicesInputSource create(Source s) {
        InputSource is = XMLUtils.sourceToInputSource(s);
        return WebServicesInputSource.create(is);
    }

    public static WebServicesInputSource create(InputSource is) {
        if (is instanceof WebServicesInputSource) {
            return (WebServicesInputSource)is;
        }
        WebServicesInputSource wsis = new WebServicesInputSource();
        wsis.setPublicId(is.getPublicId());
        wsis.setSystemId(is.getSystemId());
        wsis.setEncoding(is.getEncoding());
        wsis.setByteStream(is.getByteStream());
        wsis.setCharacterStream(is.getCharacterStream());
        return wsis;
    }

    public static WebServicesInputSource create(byte[] bytes) {
        WebServicesInputSource wsis = new WebServicesInputSource();
        wsis.setByteArrayContent(bytes);
        return wsis;
    }

    public static WebServicesInputSource create(String text) {
        WebServicesInputSource wsis = new WebServicesInputSource();
        wsis.setStringContent(text);
        return wsis;
    }

    private WebServicesInputSource() {
    }

    private WebServicesInputSource(String s) {
        super(s);
    }

    private WebServicesInputSource(InputStream inputstream) {
        super(inputstream);
    }

    private WebServicesInputSource(Reader reader) {
        super(reader);
    }

    public boolean getCopyIfNotResettable() {
        return this.copyIfNotResettable;
    }

    public void setCopyIfNotResettable(boolean value2) {
        this.copyIfNotResettable = value2;
    }

    public void setEncoding(String s) {
        if (this.getEncoding() != null && !this.getEncoding().equalsIgnoreCase(s)) {
            throw new InternalException(Messages.getMessage("cantChangeEncoding", this.getEncoding(), s));
        }
        super.setEncoding(s);
    }

    public String getEncoding() {
        return super.getEncoding();
    }

    public void setCharacterStream(Reader reader) {
        this.clearCache();
        super.setCharacterStream(reader);
    }

    public Reader getCharacterStream() {
        return super.getCharacterStream();
    }

    public void setByteStream(InputStream inputstream) {
        this.clearCache();
        super.setByteStream(inputstream);
    }

    public InputStream getByteStream() {
        InputStream is = super.getByteStream();
        if (is == null || !is.markSupported() && this.copyIfNotResettable) {
            is = this.getBAISContent();
        } else if (!(is instanceof FilterIS)) {
            is = new FilterIS(is);
        }
        super.setByteStream(is);
        return is;
    }

    public int getContentLength() {
        int contentLength = 0;
        if (this.hasBAISContent()) {
            BAIS bais = this.getBAISContent();
            contentLength = bais.getContentLength();
        } else {
            InputStream is = this.getByteStream();
            if (is instanceof FilterIS) {
                contentLength = (int)((FilterIS)is).getLength();
            } else if (is != null && is.markSupported()) {
                try {
                    is.reset();
                    int avail = is.available();
                    is.skip(avail);
                    contentLength = avail;
                }
                catch (IOException io) {
                    FFDCFilter.processException((Throwable)io, "com.ibm.ws.webservices.utils.WebServicesInputSource.getContentLength", "271", this);
                    throw new InternalException(io);
                }
            } else {
                BAIS bais = this.getBAISContent();
                contentLength = bais.getContentLength();
            }
        }
        return contentLength;
    }

    public byte[] getBytes() {
        return this.getByteArrayContent();
    }

    public String getString() {
        return this.getStringContent();
    }

    public void reset() {
        try {
            InputStream _is = this.getByteStream();
            if (_is.markSupported()) {
                _is.reset();
            }
        }
        catch (IOException ioe) {
            log.error(Messages.getMessage("exception00"), ioe);
        }
    }

    public boolean isPossiblyFault() {
        boolean found = false;
        if (this._isPossiblyFault != null) {
            found = this._isPossiblyFault;
        } else if (this.hasStringContent()) {
            String text = this.getStringContent();
            int index = text.lastIndexOf(62);
            found = index >= 0 && text.lastIndexOf("Fault", index) >= 0;
        } else if (this.hasByteArrayContent()) {
            byte[] bytes = this.getByteArrayContent();
            int start = 0;
            int end = bytes.length - 1;
            found = this.isPossiblyFault(bytes, start, end, this.getEncoding());
        } else if (this.hasBAISContent()) {
            BAIS bais = this.getBAISContent();
            byte[] bytes = bais.getBuff();
            int start = bais.getMark();
            int end = bais.getCount() - 1;
            found = this.isPossiblyFault(bytes, start, end, this.getEncoding());
        } else {
            InputStream is = super.getByteStream();
            if (is == null || !is.markSupported()) {
                BAIS bais = this.getBAISContent();
                byte[] bytes = bais.getBuff();
                int start = bais.getMark();
                int end = bais.getCount() - 1;
                found = this.isPossiblyFault(bytes, start, end, this.getEncoding());
            } else {
                try {
                    is.reset();
                    int avail = is.available();
                    int LEN = 4096;
                    byte[] bytes = new byte[LEN];
                    for (int start = avail - LEN; start > 0 && !found; start -= LEN / 2) {
                        is.skip(start);
                        is.read(bytes, 0, LEN);
                        is.reset();
                        if (!this.isPossiblyFault(bytes, 0, LEN - 1, this.getEncoding())) continue;
                        found = true;
                    }
                    if (!found) {
                        is.reset();
                        int readLen = avail > LEN ? LEN : avail;
                        is.read(bytes, 0, readLen);
                        is.reset();
                        found = this.isPossiblyFault(bytes, 0, readLen - 1, this.getEncoding());
                    }
                }
                catch (IOException io) {
                    FFDCFilter.processException((Throwable)io, "com.ibm.ws.webservices.utils.WebServicesInputSource.isPossiblyFault", "381", this);
                    throw new InternalException(io);
                }
            }
        }
        this._isPossiblyFault = new Boolean(found);
        return found;
    }

    private boolean isPossiblyFault(byte[] bytes, int start, int end, String encoding) {
        byte[] fault2;
        byte[] gt;
        if (encoding == null || encoding.length() == 0) {
            gt = new String(">").getBytes();
            fault2 = new String("Fault").getBytes();
        } else {
            try {
                gt = new String(">").getBytes(encoding);
                fault2 = new String("Fault").getBytes(encoding);
            }
            catch (IOException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.utils.WebServicesInputSource.isPossiblyFault", "411", this);
                return true;
            }
        }
        int index = JavaUtils.find(gt, bytes, start, end, false);
        return index >= 0 && JavaUtils.find(fault2, bytes, start, index, false) >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream os, String characterEncoding) throws IOException {
        if (this.hasByteArrayContent() && this.getEncoding().equalsIgnoreCase(characterEncoding)) {
            byte[] bytes = this.getByteArrayContent();
            if (bytes.length == 0) {
                throw new IOException(Messages.getMessage("wsisWriteError"));
            }
            os.write(this.getByteArrayContent());
        } else {
            os = new LowFlushFilter(os);
            Writer writer = null;
            writer = characterEncoding != null ? new OutputStreamWriter(os, characterEncoding) : new OutputStreamWriter(os);
            writer = new BufferedWriter(writer, os, characterEncoding);
            try {
                this.writeTo(writer);
            }
            finally {
                writer.flush();
            }
        }
    }

    public void writeTo(Writer writer) throws IOException {
        String value2 = this.getStringContent();
        if (value2 == null || value2.length() == 0) {
            throw new IOException(Messages.getMessage("wsisWriteError"));
        }
        writer.write(value2);
    }

    public Source createTransformSource() {
        BAIS bais = this.getBAISContent();
        bais.reset();
        return new StreamSource(bais);
    }

    public String dumpStats() {
        return "WebServicesInputSource Stats: " + this + " hasStringContent()?" + this.hasStringContent() + " hasByteArrayContent()?" + this.hasByteArrayContent() + " hasBAISContent()?" + this.hasBAISContent() + " character encoding = " + this.getEncoding() + " StringContent = " + (this.hasStringContent() ? this.getStringContent() : "n/a");
    }

    private void clearCache() {
        this._stringContent = null;
        this._byteArrayContent = null;
        this._baisContent = null;
        this._isPossiblyFault = null;
    }

    private boolean hasStringContent() {
        return this._stringContent != null;
    }

    private String getStringContent() {
        if (!this.hasStringContent()) {
            byte[] bytes = this.getByteArrayContent();
            String value2 = JavaUtils.convertBytesToString(bytes, this.getEncoding());
            this.setStringContent(value2);
        }
        return this._stringContent;
    }

    private void setStringContent(String value2) {
        this._stringContent = value2;
    }

    private boolean hasByteArrayContent() {
        return this._byteArrayContent != null;
    }

    private byte[] getByteArrayContent() {
        if (!this.hasByteArrayContent()) {
            if (this.hasBAISContent()) {
                BAIS bais = this.getBAISContent();
                byte[] bytes = bais.getBuff();
                if (bais.getContentLength() != bytes.length) {
                    bytes = new byte[bais.getContentLength()];
                    System.arraycopy(bais.getBuff(), bais.getMark(), bytes, 0, bais.getContentLength());
                }
                this.setByteArrayContent(bytes);
            } else if (this.hasStringContent()) {
                String value2 = this.getStringContent();
                byte[] bytes = JavaUtils.convertStringToBytes(value2, this.getEncoding());
                this.setByteArrayContent(bytes);
            } else {
                BAIS bais = this.getBAISContent();
                byte[] bytes = bais.getBuff();
                if (bais.getContentLength() != bytes.length) {
                    bytes = new byte[bais.getContentLength()];
                    System.arraycopy(bais.getBuff(), bais.getMark(), bytes, 0, bais.getContentLength());
                }
                this.setByteArrayContent(bytes);
            }
        }
        return this._byteArrayContent;
    }

    private void setByteArrayContent(byte[] value2) {
        this._byteArrayContent = value2;
    }

    private boolean hasBAISContent() {
        return this._baisContent != null;
    }

    private BAIS getBAISContent() {
        if (!this.hasBAISContent()) {
            if (this.hasByteArrayContent() || this.hasStringContent()) {
                byte[] bytes = this.getByteArrayContent();
                BAIS bais = BAIS.create(bytes);
                this.setBAISContent(bais);
            } else if (super.getByteStream() != null) {
                try {
                    InputStream is = super.getByteStream();
                    BAIS bais = BAIS.create(is);
                    this.setBAISContent(bais);
                }
                catch (IOException io) {
                    FFDCFilter.processException((Throwable)io, "com.ibm.ws.webservices.utils.WebServicesInputSource.getBAISContent", "450", this);
                    throw new InternalException(io);
                }
            } else if (this.getCharacterStream() != null) {
                try {
                    BAIS bais = BAIS.create(this.getCharacterStream(), this.getEncoding());
                    this.setCharacterStream(null);
                    this.setBAISContent(bais);
                }
                catch (IOException io) {
                    FFDCFilter.processException((Throwable)io, "com.ibm.ws.webservices.utils.WebServicesInputSource.getBAISContent", "453", this);
                    throw new InternalException(io);
                }
            } else {
                throw new InternalException(Messages.getMessage("wsisInternal", "getBAISContent"));
            }
        }
        return this._baisContent;
    }

    private void setBAISContent(BAIS value2) {
        this._baisContent = value2;
        super.setByteStream(value2);
    }

    private static class FilterIS
    extends FilterInputStream {
        private long length = 0L;

        FilterIS(InputStream is) {
            super(is);
        }

        public final int read() throws IOException {
            int bite = super.read();
            if (bite != -1) {
                ++this.length;
            }
            return bite;
        }

        public final int read(byte[] buffer) throws IOException {
            int bytes = super.read(buffer);
            if (bytes != -1) {
                this.length += (long)bytes;
            }
            return bytes;
        }

        public final int read(byte[] b, int off, int len) throws IOException {
            int bytes = super.read(b, off, len);
            if (bytes != -1) {
                this.length += (long)bytes;
            }
            return bytes;
        }

        public final void close() throws IOException {
            super.close();
        }

        long getLength() {
            return this.length;
        }

        public final void reset() throws IOException {
            this.length = 0L;
            super.reset();
        }
    }
}

