/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.utils;

import java.io.BufferedWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;

public final class JavaUtils {
    private static HashMap loadableMap = new HashMap();

    public static String stackToString(Throwable e) {
        StringWriter sw = new StringWriter();
        BufferedWriter bw = new BufferedWriter(sw);
        PrintWriter pw = new PrintWriter(bw);
        e.printStackTrace(pw);
        pw.close();
        return sw.getBuffer().toString();
    }

    public static boolean hasValue(String str) {
        return str != null && str.length() > 0;
    }

    public static final boolean isTrueExplicitly(String value2) {
        return value2 != null && (value2.equalsIgnoreCase("true") || value2.equals("1") || value2.equalsIgnoreCase("yes"));
    }

    public static final boolean isTrueExplicitly(Object value2, boolean defaultVal) {
        if (value2 == null) {
            return defaultVal;
        }
        if (value2 instanceof Boolean) {
            return (Boolean)value2;
        }
        if (value2 instanceof Integer) {
            return (Integer)value2 != 0;
        }
        if (value2 instanceof String) {
            return JavaUtils.isTrueExplicitly((String)value2);
        }
        return true;
    }

    public static final boolean isTrueExplicitly(Object value2) {
        return JavaUtils.isTrueExplicitly(value2, false);
    }

    public static String getLoadableClassName(String text) {
        String loadClass;
        int bracket = text.indexOf("[");
        if (text == null || bracket < 0 || bracket == 0) {
            return text;
        }
        String className = text;
        if (bracket > 0) {
            className = className.substring(0, bracket);
        }
        if ((loadClass = (String)loadableMap.get(className)) == null) {
            loadClass = "L" + className + ";";
        }
        if (bracket > 0) {
            int i = text.indexOf("]");
            while (i > 0) {
                loadClass = "[" + loadClass;
                i = text.indexOf("]", i + 1);
            }
        }
        return loadClass;
    }

    public static final boolean isTrue(String value2) {
        return !JavaUtils.isFalseExplicitly(value2);
    }

    public static final boolean isTrue(Object value2, boolean defaultVal) {
        return !JavaUtils.isFalseExplicitly(value2, !defaultVal);
    }

    public static final boolean isTrue(Object value2) {
        return JavaUtils.isTrue(value2, false);
    }

    public static final boolean isFalseExplicitly(String value2) {
        return value2 == null || value2.equalsIgnoreCase("false") || value2.equals("0") || value2.equalsIgnoreCase("no");
    }

    public static final boolean isFalseExplicitly(Object value2, boolean defaultVal) {
        if (value2 == null) {
            return defaultVal;
        }
        if (value2 instanceof Boolean) {
            return (Boolean)value2 == false;
        }
        if (value2 instanceof Integer) {
            return (Integer)value2 == 0;
        }
        if (value2 instanceof String) {
            return JavaUtils.isFalseExplicitly((String)value2);
        }
        return false;
    }

    public static final boolean isFalseExplicitly(Object value2) {
        return JavaUtils.isFalseExplicitly(value2, true);
    }

    public static final boolean isFalse(Object value2, boolean defaultVal) {
        return JavaUtils.isFalseExplicitly(value2, defaultVal);
    }

    public static final boolean isFalse(Object value2) {
        return JavaUtils.isFalse(value2, true);
    }

    static {
        loadableMap.put("byte", "B");
        loadableMap.put("char", "C");
        loadableMap.put("double", "D");
        loadableMap.put("float", "F");
        loadableMap.put("int", "I");
        loadableMap.put("long", "J");
        loadableMap.put("short", "S");
        loadableMap.put("boolean", "Z");
    }
}

