/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.utils;

import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.commons.logging.Log;

public final class BufferedWriter
extends Writer {
    protected static Log log = LogFactory.getLog(BufferedWriter.class.getName());
    private Writer out;
    private char[] cb;
    private int nChars;
    private int nextChar;
    private OutputStream os;
    private String outEnc;
    private static int defaultCharBufferSize = 8192;

    public BufferedWriter(Writer out) {
        this(out, null, null, defaultCharBufferSize);
    }

    public BufferedWriter(Writer out, OutputStream os, String enc) {
        this(out, os, enc, defaultCharBufferSize);
    }

    public BufferedWriter(Writer out, int sz) {
        this(out, null, null, sz);
    }

    public BufferedWriter(Writer out, OutputStream os, String enc, int sz) {
        super((Object)out);
        this.os = os;
        this.outEnc = enc;
        if (sz <= 0) {
            throw new IllegalArgumentException(Messages.getMessage("bufferSize00"));
        }
        this.out = out;
        this.cb = new char[sz];
        this.nChars = sz;
        this.nextChar = 0;
    }

    private void ensureOpen() throws IOException {
        if (this.out == null) {
            throw new IOException(Messages.getMessage("streamClosed00"));
        }
    }

    public void flushBuffer() throws IOException {
        this.ensureOpen();
        if (this.nextChar == 0) {
            return;
        }
        this.out.write(this.cb, 0, this.nextChar);
        if (log.isDebugEnabled()) {
            String text = new String(this.cb, 0, this.nextChar);
            log.debug("flushBuffer:(" + text + ")");
        }
        this.nextChar = 0;
    }

    public final void write(int c) throws IOException {
        if (this.nextChar >= this.nChars) {
            this.flushBuffer();
        }
        this.cb[this.nextChar++] = (char)c;
    }

    public final void write(int c, int c2) throws IOException {
        if (this.nextChar + 1 >= this.nChars) {
            this.flushBuffer();
        }
        this.cb[this.nextChar++] = (char)c;
        this.cb[this.nextChar++] = (char)c2;
    }

    private int min(int a, int b) {
        return a < b ? a : b;
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException(Messages.getMessage("buffedWriterOutOfBounds00"));
        }
        if (len == 0) {
            return;
        }
        if (len >= this.nChars) {
            this.flushBuffer();
            this.out.write(cbuf, off, len);
            return;
        }
        int b = off;
        int t = off + len;
        while (b < t) {
            int d = this.min(this.nChars - this.nextChar, t - b);
            System.arraycopy(cbuf, b, this.cb, this.nextChar, d);
            b += d;
            this.nextChar += d;
            if (this.nextChar < this.nChars) continue;
            this.flushBuffer();
        }
    }

    public void write(String s, int off, int len) throws IOException {
        if (len >= this.nChars) {
            this.flushBuffer();
            this.out.write(s, off, len);
            return;
        }
        int b = off;
        int t = off + len;
        while (b < t) {
            int d = this.min(this.nChars - this.nextChar, t - b);
            s.getChars(b, b + d, this.cb, this.nextChar);
            b += d;
            this.nextChar += d;
            if (this.nextChar < this.nChars) continue;
            this.flushBuffer();
        }
    }

    public final void write(String s) throws IOException {
        int len = s.length();
        if (len >= this.nChars - this.nextChar) {
            this.write(s, 0, len);
            return;
        }
        s.getChars(0, len, this.cb, this.nextChar);
        this.nextChar += len;
    }

    public final void write(String s, int c) throws IOException {
        int len = s.length();
        if (len + 1 >= this.nChars - this.nextChar) {
            this.write(s, 0, len);
            this.write(c);
            return;
        }
        s.getChars(0, len, this.cb, this.nextChar);
        this.nextChar += len;
        this.cb[this.nextChar++] = (char)c;
    }

    public final void write(int c, String s) throws IOException {
        int len = s.length();
        if (len + 1 >= this.nChars - this.nextChar) {
            this.write(c);
            this.write(s, 0, len);
            return;
        }
        this.cb[this.nextChar++] = (char)c;
        s.getChars(0, len, this.cb, this.nextChar);
        this.nextChar += len;
    }

    public void flush() throws IOException {
        this.flushBuffer();
        this.out.flush();
    }

    public void close() throws IOException {
        if (this.out == null) {
            return;
        }
        this.flushBuffer();
        this.out.close();
        this.out = null;
        this.cb = null;
    }

    public void write(byte[] b, int start, int len, String inEnc) throws IOException {
        if (this.os != null && (inEnc == this.outEnc || inEnc != null && inEnc.equalsIgnoreCase(this.outEnc) || inEnc == null && this.outEnc.equalsIgnoreCase("utf-8"))) {
            this.flush();
            this.os.write(b, start, len);
        } else {
            if (inEnc == null) {
                inEnc = "utf-8";
            }
            String str = new String(b, start, len, inEnc);
            this.write(str);
        }
    }

    public void write(byte[] b, String inEnc) throws IOException {
        this.write(b, 0, b.length, inEnc);
    }
}

