/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.pmi.modules;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webservices.pmi.modules.ServicePmiModule;
import com.ibm.wsspi.pmi.factory.StatisticActions;
import com.ibm.wsspi.pmi.factory.StatsFactory;
import com.ibm.wsspi.pmi.factory.StatsFactoryException;
import com.ibm.wsspi.pmi.factory.StatsGroup;
import com.ibm.wsspi.pmi.factory.StatsInstance;
import com.ibm.wsspi.pmi.stat.SPICountStatistic;
import com.ibm.wsspi.pmi.stat.SPIStatistic;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ModulePmiModule
extends StatisticActions {
    private static TraceComponent _tc = Tr.register(ModulePmiModule.class, "WebServices.Shared", "com.ibm.ws.webservices.resources.WSMessages");
    private static final String moduleTemplate = "/com/ibm/ws/webservices/pmi/modules/webServicesModuleStats.xml";
    public static final String MODULE_PMI_MODULE = "pmiWebServiceModule";
    private static StatsGroup moduleStatsGroup = null;
    private StatsGroup serviceStatsGroup = null;
    private StatsInstance moduleStatsInstance = null;
    private Map serviceData = null;
    private String moduleName = null;
    private SPICountStatistic loadedServices = null;
    public static final int LOADED_SERVICES = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModulePmiModule(String appName, String modName) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "ModulePmiModule.ModulePmiModule()...");
        }
        this.moduleName = appName + "." + modName;
        this.serviceData = new HashMap();
        try {
            String string = moduleTemplate;
            synchronized (moduleTemplate) {
                moduleStatsGroup = StatsFactory.getStatsGroup((String[])new String[]{MODULE_PMI_MODULE});
                if (moduleStatsGroup == null) {
                    moduleStatsGroup = StatsFactory.createStatsGroup((String)MODULE_PMI_MODULE, (String)moduleTemplate, null);
                }
                this.moduleStatsInstance = StatsFactory.getStatsInstance((String[])new String[]{MODULE_PMI_MODULE, this.moduleName});
                if (this.moduleStatsInstance == null) {
                    this.moduleStatsInstance = StatsFactory.createStatsInstance((String)this.moduleName, (StatsGroup)moduleStatsGroup, null, (StatisticActions)this);
                } else {
                    this.copyStatisticCreated();
                }
                this.createServiceStatsGroup();
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        }
        catch (StatsFactoryException e) {
            Object[] inserts = new Object[]{this.moduleName, e};
            Tr.error(_tc, "createModulePmiModuleFail", inserts);
        }
        {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "...ModulePmiModule.ModulePmiModule()");
            }
            return;
        }
    }

    private void createServiceStatsGroup() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "ModulePmiModule.createServiceStatsGroup()...");
        }
        try {
            this.serviceStatsGroup = StatsFactory.getStatsGroup((String[])new String[]{MODULE_PMI_MODULE, this.moduleName, "pmiWebServiceService"});
            if (this.serviceStatsGroup == null) {
                this.serviceStatsGroup = StatsFactory.createStatsGroup((String)"pmiWebServiceService", (String)"/com/ibm/ws/webservices/pmi/modules/webServicesServiceStats.xml", (StatsInstance)this.moduleStatsInstance, null);
            }
        }
        catch (StatsFactoryException e) {
            Object[] inserts = new Object[]{this.moduleName, e};
            Tr.error(_tc, "createServicePmiGroupFail", inserts);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...ModulePmiModule.createServiceStatsGroup()");
        }
    }

    public void statisticCreated(SPIStatistic data) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "ServicePmiModule.statisticCreated()...");
        }
        switch (data.getId()) {
            case 1: {
                this.loadedServices = (SPICountStatistic)data;
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...ServicePmiModule.statisticCreated()");
        }
    }

    private void copyStatisticCreated() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "ModulePmiModule.copyStatisticCreated()...");
        }
        if (this.moduleStatsInstance != null) {
            this.loadedServices = (SPICountStatistic)this.moduleStatsInstance.getStatistic(1);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...ModulePmiModule.copyStatisticCreated()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServicePmiModule registerService(String serviceName) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "ModulePmiModule.registerService()...", this.moduleName + "#" + serviceName);
        }
        ServicePmiModule module = null;
        Map map = this.serviceData;
        synchronized (map) {
            module = (ServicePmiModule)((Object)this.serviceData.get(serviceName));
            if (module == null) {
                module = new ServicePmiModule(this.moduleName, serviceName, this.serviceStatsGroup);
                this.serviceData.put(serviceName, module);
                if (this.loadedServices != null) {
                    this.loadedServices.increment();
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Registered new service PMI module.");
                }
            } else if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Service PMI module already registered.");
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...ModulePmiModule.registerService()");
        }
        return module;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterService(String serviceName) {
        ServicePmiModule module;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "ModulePmiModule.unregisterService()...", this.moduleName + "#" + serviceName);
        }
        if ((module = (ServicePmiModule)((Object)this.serviceData.get(serviceName))) != null) {
            Map map = this.serviceData;
            synchronized (map) {
                this.serviceData.remove(serviceName);
            }
            module.destroy();
            if (this.loadedServices != null) {
                this.loadedServices.decrement();
            }
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Could not find service PMI module.");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...ModulePmiModule.unregisterService()");
        }
    }

    public ServicePmiModule getService(String serviceName) {
        ServicePmiModule module;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "ModulePmiModule.getService()...");
        }
        if ((module = (ServicePmiModule)((Object)this.serviceData.get(serviceName))) == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Service not registered, registering now...");
            }
            module = this.registerService(serviceName);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...ModulePmiModule.getService()");
        }
        return module;
    }

    public void destroy() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "ModulePmiModule.destroy()...");
        }
        try {
            StatsFactory.removeStatsInstance((StatsInstance)this.moduleStatsInstance);
            if (this.serviceStatsGroup != null) {
                StatsFactory.removeStatsGroup((StatsGroup)this.serviceStatsGroup);
            }
        }
        catch (Exception e) {
            Object[] inserts = new Object[]{this.moduleName, e};
            Tr.error(_tc, "removeModulePmiModuleFail", inserts);
        }
        if (this.serviceData != null) {
            Collection entryValues = this.serviceData.values();
            Iterator it = entryValues.iterator();
            while (it.hasNext()) {
                ((ServicePmiModule)((Object)it.next())).destroy();
            }
        }
        this.serviceData = null;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...ModulePmiModule.destroy()");
        }
    }
}

