/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.multiprotocol.resources;

import com.ibm.ws.webservices.engine.resources.MessageBundle;
import com.ibm.ws.webservices.engine.resources.MessagesConstants;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Messages {
    public static final String TR_GROUP = "WebServices";
    public static final String TR_RESOURCE_BUNDLE = "com.ibm.ws.webservices.multiprotocol.resources.mpMessages";
    private static final Class thisClass = Messages.class;
    private static final String projectName = "com.ibm.ws.webservices.multiprotocol".intern();
    private static final String resourcesName = "mpText".intern();
    private static final String messagesName = "mpMessages".intern();
    private static final String englishTextName = "mp".intern();
    private static final Locale locale = MessagesConstants.locale;
    private static final String packageName = Messages.getPackage(thisClass.getName());
    private static final ClassLoader classLoader = thisClass.getClassLoader();
    private static final ResourceBundle messageParent = MessagesConstants.rootPackageName == packageName ? null : MessagesConstants.rootMessageBundle;
    private static final ResourceBundle resourceParent = MessagesConstants.rootPackageName == packageName ? null : MessagesConstants.rootResourceBundle;
    private static final ResourceBundle englishParent = MessagesConstants.rootPackageName == packageName ? null : MessagesConstants.rootEnglishBundle;
    private static final MessageBundle messagesBundle = new MessageBundle(projectName, packageName, messagesName, locale, classLoader, messageParent);
    private static final MessageBundle resourcesBundle = new MessageBundle(projectName, packageName, resourcesName, locale, classLoader, resourceParent);
    private static final MessageBundle englishTextBundle = new MessageBundle(projectName, packageName, englishTextName, locale, classLoader, englishParent);

    public static String getMessage(String key) {
        try {
            return englishTextBundle.getMessage(key);
        }
        catch (Exception e) {
            try {
                return resourcesBundle.getMessage(key);
            }
            catch (Exception f) {
                try {
                    return messagesBundle.getMessage(key);
                }
                catch (Exception g) {
                    return g.getMessage();
                }
            }
        }
    }

    public static String getMessage(String key, String arg0) {
        try {
            return englishTextBundle.getMessage(key, arg0);
        }
        catch (Exception e) {
            try {
                return resourcesBundle.getMessage(key, arg0);
            }
            catch (Exception f) {
                try {
                    return messagesBundle.getMessage(key, arg0);
                }
                catch (Exception g) {
                    return g.getMessage();
                }
            }
        }
    }

    public static String getMessage(String key, String arg0, String arg1) {
        try {
            return englishTextBundle.getMessage(key, arg0, arg1);
        }
        catch (Exception e) {
            try {
                return resourcesBundle.getMessage(key, arg0, arg1);
            }
            catch (Exception f) {
                try {
                    return messagesBundle.getMessage(key, arg0, arg1);
                }
                catch (Exception g) {
                    return g.getMessage();
                }
            }
        }
    }

    public static String getMessage(String key, String arg0, String arg1, String arg2) {
        try {
            return englishTextBundle.getMessage(key, arg0, arg1, arg2);
        }
        catch (Exception e) {
            try {
                return resourcesBundle.getMessage(key, arg0, arg1, arg2);
            }
            catch (Exception f) {
                try {
                    return messagesBundle.getMessage(key, arg0, arg1, arg2);
                }
                catch (Exception g) {
                    return g.getMessage();
                }
            }
        }
    }

    public static String getMessage(String key, String arg0, String arg1, String arg2, String arg3) {
        try {
            return englishTextBundle.getMessage(key, arg0, arg1, arg2, arg3);
        }
        catch (Exception e) {
            try {
                return resourcesBundle.getMessage(key, arg0, arg1, arg2, arg3);
            }
            catch (Exception f) {
                try {
                    return messagesBundle.getMessage(key, arg0, arg1, arg2, arg3);
                }
                catch (Exception g) {
                    return g.getMessage();
                }
            }
        }
    }

    public static String getMessage(String key, String arg0, String arg1, String arg2, String arg3, String arg4) {
        try {
            return englishTextBundle.getMessage(key, arg0, arg1, arg2, arg3, arg4);
        }
        catch (Exception e) {
            try {
                return resourcesBundle.getMessage(key, arg0, arg1, arg2, arg3, arg4);
            }
            catch (Exception f) {
                try {
                    return messagesBundle.getMessage(key, arg0, arg1, arg2, arg3, arg4);
                }
                catch (Exception g) {
                    return g.getMessage();
                }
            }
        }
    }

    public static String getMessage(String key, String[] args) {
        try {
            return englishTextBundle.getMessage(key, args);
        }
        catch (Exception e) {
            try {
                return resourcesBundle.getMessage(key, args);
            }
            catch (Exception f) {
                try {
                    return messagesBundle.getMessage(key, args);
                }
                catch (Exception g) {
                    return g.getMessage();
                }
            }
        }
    }

    public static ResourceBundle getMessagesBundle() {
        return messagesBundle.getResourceBundle();
    }

    public static String getFormattedMessage(String key, Object[] args, String defaultString) {
        try {
            String result = Messages.getMessage(key);
            return MessageFormat.format(result, args);
        }
        catch (MissingResourceException e) {
            return MessageFormat.format(defaultString, args);
        }
    }

    public static String getString(String key, String defaultString) {
        if (key == null) {
            return defaultString;
        }
        try {
            return Messages.getMessage(key);
        }
        catch (MissingResourceException e) {
            return defaultString;
        }
    }

    public static ResourceBundle getResourceBundle() {
        return resourcesBundle.getResourceBundle();
    }

    public static ResourceBundle getEnglishTextBundle() {
        return englishTextBundle.getResourceBundle();
    }

    private static MessageBundle getMessageBundle() {
        return messagesBundle;
    }

    private static final String getPackage(String name2) {
        return name2.substring(0, name2.lastIndexOf(46)).intern();
    }
}

