/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.multiprotocol.provider.soap;

import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.enumtype.MIMEStyle;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.multiprotocol.models.ModelBindingGenerator;
import com.ibm.ws.webservices.multiprotocol.resources.Messages;
import com.ibm.ws.webservices.utils.OptionDescriptor;
import com.ibm.ws.webservices.wsdl.extensions.ExtensionUtils;
import com.ibm.ws.webservices.wsdl.extensions.UsingAddressingExtensibilityElement;
import com.ibm.wsdl.BindingFaultImpl;
import com.ibm.wsdl.extensions.mime.MIMEContentImpl;
import com.ibm.wsdl.extensions.mime.MIMEMultipartRelatedImpl;
import com.ibm.wsdl.extensions.mime.MIMEPartImpl;
import com.ibm.wsdl.extensions.soap.SOAPAddressImpl;
import com.ibm.wsdl.extensions.soap.SOAPBindingImpl;
import com.ibm.wsdl.extensions.soap.SOAPBodyImpl;
import com.ibm.wsdl.extensions.soap.SOAPFaultImpl;
import com.ibm.wsdl.extensions.soap.SOAPOperationImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.mime.MIMEPart;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPFault;
import javax.xml.namespace.QName;

public class SOAPBindingGenerator
extends ModelBindingGenerator {
    protected OptionDescriptor[] specificOptionDescriptors = new OptionDescriptor[]{new OptionDescriptor(this.bindingTypeName + ".soapAction", false, Messages.getMessage("desc.soapAction", this.bindingTypeName)), new OptionDescriptor(this.bindingTypeName + ".MIMEStyle", false, Messages.getMessage("desc.MIMEStyle", this.bindingTypeName))};
    private static Map axisTypeToMIMEString = new HashMap();

    public SOAPBindingGenerator(String name2) {
        super(name2);
    }

    public String getBindingTypeName() {
        return this.bindingTypeName;
    }

    public String getBindingName(Properties properties) {
        String bindingName;
        String specificBindingName = properties.getProperty(this.bindingTypeName + ".bindingName");
        if (specificBindingName != null) {
            bindingName = specificBindingName;
        } else {
            String genericBindingName = properties.getProperty("bindingName");
            bindingName = this.bindingTypeName.equalsIgnoreCase("HTTP") ? genericBindingName + "SoapBinding" : (this.bindingTypeName.equalsIgnoreCase("JMS") ? genericBindingName + "JMSSoapBinding" : genericBindingName + JavaUtils.capitalizeFirstChar(this.bindingTypeName) + "Binding");
        }
        return bindingName;
    }

    public String getPortName(Properties properties) {
        String portName;
        String specificPortName = properties.getProperty(this.bindingTypeName + ".servicePortName");
        if (specificPortName != null) {
            portName = specificPortName;
        } else {
            String genericPortName = properties.getProperty("servicePortName");
            portName = this.bindingTypeName.equalsIgnoreCase("HTTP") ? genericPortName : (this.bindingTypeName.equalsIgnoreCase("JMS") ? genericPortName + "JMS" : genericPortName + JavaUtils.capitalizeFirstChar(this.bindingTypeName));
        }
        return portName;
    }

    public Binding makeBinding(Definition def, PortType portType, QName bindingQName, Properties properties) {
        Binding otherBinding = this.getOtherBinding(def, portType);
        Binding binding = def.createBinding();
        binding.setUndefined(false);
        binding.setQName(bindingQName);
        binding.setPortType(portType);
        String styleStr = properties.getProperty("style", "rpc");
        SOAPBindingImpl soapBinding = new SOAPBindingImpl();
        soapBinding.setStyle(styleStr);
        soapBinding.setTransportURI(this.getTransportURI());
        ExtensionUtils.addExtensibilityElement(binding, new UsingAddressingExtensibilityElement());
        binding.addExtensibilityElement(soapBinding);
        if (portType.getOperations() != null) {
            boolean hasMIME = false;
            Iterator ops = portType.getOperations().iterator();
            while (ops.hasNext()) {
                ExtensibilityElement otherElement;
                Message message;
                Operation op = (Operation)ops.next();
                BindingOperation bindingOper = def.createBindingOperation();
                bindingOper.setName(op.getName());
                bindingOper.setOperation(op);
                binding.addBindingOperation(bindingOper);
                SOAPOperationImpl soapOper = new SOAPOperationImpl();
                String saStr = properties.getProperty(this.bindingTypeName + ".soapAction");
                if (saStr == null) {
                    saStr = properties.getProperty("soapAction", "DEFAULT");
                }
                String soapAction = "";
                if (saStr.equalsIgnoreCase("OPERATION")) {
                    soapAction = op.getName();
                }
                soapOper.setSoapActionURI(soapAction);
                bindingOper.addExtensibilityElement(soapOper);
                BindingOperation otherOperation = this.getOtherBindingOperation(otherBinding, op);
                if (op.getInput() != null) {
                    BindingInput bindingInput = def.createBindingInput();
                    bindingInput.setName(op.getInput().getName());
                    message = op.getInput().getMessage();
                    otherElement = this.getOtherInputElement(otherOperation);
                    ExtensibilityElement input = this.getIfMIME(message, otherElement, properties);
                    if (input == null) {
                        input = this.getSOAPBody(message, properties);
                    } else {
                        hasMIME = true;
                    }
                    bindingInput.addExtensibilityElement(input);
                    bindingOper.setBindingInput(bindingInput);
                }
                if (op.getOutput() != null) {
                    BindingOutput bindingOutput = def.createBindingOutput();
                    bindingOutput.setName(op.getOutput().getName());
                    message = op.getOutput().getMessage();
                    otherElement = this.getOtherInputElement(otherOperation);
                    ExtensibilityElement output = this.getIfMIME(message, otherElement, properties);
                    if (output == null) {
                        output = this.getSOAPBody(message, properties);
                    } else {
                        hasMIME = true;
                    }
                    bindingOutput.addExtensibilityElement(output);
                    bindingOper.setBindingOutput(bindingOutput);
                }
                if (op.getFaults() == null) continue;
                Iterator it = op.getFaults().values().iterator();
                while (it.hasNext()) {
                    Fault fault2 = (Fault)it.next();
                    BindingFaultImpl bindingFault = new BindingFaultImpl();
                    SOAPFault soapFault = this.getSOAPFault(fault2.getMessage(), properties);
                    soapFault.setName(fault2.getName());
                    bindingFault.setName(fault2.getName());
                    bindingFault.addExtensibilityElement(soapFault);
                    bindingOper.addBindingFault(bindingFault);
                }
            }
            if (hasMIME) {
                def.addNamespace("mime", "http://schemas.xmlsoap.org/wsdl/mime/");
            }
        }
        return binding;
    }

    private ExtensibilityElement getIfMIME(Message msg, ExtensibilityElement otherElement, Properties properties) {
        MIMEMultipartRelatedImpl multipart;
        block6: {
            int i;
            String styleStr;
            block7: {
                multipart = null;
                styleStr = properties.getProperty(this.bindingTypeName + ".MIMEStyle");
                if (styleStr == null) {
                    styleStr = properties.getProperty("MIMEStyle", MIMEStyle.WSDL11.toString());
                }
                if (!styleStr.equals(MIMEStyle.WSDL11.toString())) break block6;
                if (!(otherElement instanceof MIMEMultipartRelated)) break block7;
                MIMEMultipartRelated otherMultipart = (MIMEMultipartRelated)otherElement;
                multipart = new MIMEMultipartRelatedImpl();
                multipart.setElementType(otherMultipart.getElementType());
                multipart.setRequired(otherMultipart.getRequired());
                List otherParts = otherMultipart.getMIMEParts();
                for (int i2 = 0; i2 < otherParts.size(); ++i2) {
                    Object otherSubElement;
                    MIMEPart otherPart = (MIMEPart)otherParts.get(i2);
                    List otherElements = otherPart.getExtensibilityElements();
                    Object v0 = otherSubElement = otherElements.isEmpty() ? null : otherElements.get(0);
                    if (otherSubElement instanceof SOAPBody) {
                        SOAPBody soapBody = (SOAPBody)this.getSOAPBody(msg, properties);
                        soapBody.setParts(((SOAPBody)otherSubElement).getParts());
                        MIMEPartImpl mimePart = new MIMEPartImpl();
                        mimePart.addExtensibilityElement(soapBody);
                        multipart.addMIMEPart(mimePart);
                        continue;
                    }
                    multipart.addMIMEPart(otherPart);
                }
                break block6;
            }
            ArrayList mimeTypes = new ArrayList();
            ArrayList xmlTypes = new ArrayList();
            this.sortTypes(msg, mimeTypes, xmlTypes, styleStr);
            if (mimeTypes.size() <= 0) break block6;
            multipart = new MIMEMultipartRelatedImpl();
            MIMEPartImpl mimePart = new MIMEPartImpl();
            multipart.addMIMEPart(mimePart);
            SOAPBody soapBody = (SOAPBody)this.getSOAPBody(msg, properties);
            mimePart.addExtensibilityElement(soapBody);
            ArrayList<String> xmlParts = new ArrayList<String>();
            for (i = 0; i < xmlTypes.size(); ++i) {
                Part part = (Part)xmlTypes.get(i);
                xmlParts.add(part.getName());
            }
            if (xmlParts.size() > 0) {
                soapBody.setParts(xmlParts);
            }
            for (i = 0; i < mimeTypes.size(); ++i) {
                mimePart = new MIMEPartImpl();
                multipart.addMIMEPart(mimePart);
                MIMEContentImpl mimeContent = new MIMEContentImpl();
                mimePart.addExtensibilityElement(mimeContent);
                Part part = (Part)mimeTypes.get(i);
                mimeContent.setPart(part.getName());
                mimeContent.setType(this.mimeType(part.getTypeName()));
                part.setTypeName(Constants.XSD_HEXBIN);
            }
        }
        return multipart;
    }

    private void sortTypes(Message msg, List mimeTypes, List xmlTypes, String styleStr) {
        Iterator parts = msg.getParts().values().iterator();
        while (parts.hasNext()) {
            Part part = (Part)parts.next();
            QName type = part.getTypeName();
            if (Constants.MIME_IMAGE.equals(type) || Constants.MIME_PLAINTEXT.equals(type) || Constants.MIME_MULTIPART.equals(type) || Constants.MIME_SOURCE.equals(type) || Constants.MIME_OCTETSTREAM.equals(type) || Constants.WSI_SWAREF.equals(type) || Constants.MIME_DATA_HANDLER.equals(type) && styleStr.equals(MIMEStyle.WSDL11.toString())) {
                mimeTypes.add(part);
                continue;
            }
            xmlTypes.add(part);
        }
    }

    private String mimeType(QName axisMIMEType) {
        return (String)axisTypeToMIMEString.get(axisMIMEType);
    }

    private ExtensibilityElement getSOAPBody(Message msg, Properties properties) {
        SOAPBodyImpl soapBody = new SOAPBodyImpl();
        String useStr = properties.getProperty("use", "encoded");
        if (useStr.equalsIgnoreCase("encoded")) {
            soapBody.setUse("encoded");
            ArrayList<String> encodingList = new ArrayList<String>();
            encodingList.add(properties.getProperty("encodingStyle", Constants.URI_DEFAULT_SOAP_ENC));
            soapBody.setEncodingStyles(encodingList);
        } else {
            soapBody.setUse("literal");
        }
        String styleStr = properties.getProperty("style", "rpc");
        if (styleStr.equalsIgnoreCase("rpc")) {
            soapBody.setNamespaceURI(properties.getProperty("intfNS", "unknownInterfaceNamespace"));
        }
        return soapBody;
    }

    private SOAPFault getSOAPFault(Message msg, Properties properties) {
        SOAPFaultImpl soapFault = new SOAPFaultImpl();
        String useStr = properties.getProperty("use", "encoded");
        if (!useStr.equalsIgnoreCase("encoded")) {
            soapFault.setUse("literal");
        } else {
            soapFault.setUse("encoded");
            ArrayList<String> encodingList = new ArrayList<String>();
            encodingList.add(properties.getProperty("encodingStyle", Constants.URI_DEFAULT_SOAP_ENC));
            soapFault.setEncodingStyles(encodingList);
        }
        return soapFault;
    }

    public ExtensibilityElement makePortAddress(Definition def, Port port2, Properties properties) {
        String endpointURL = properties.getProperty(this.bindingTypeName + ".location");
        if (endpointURL == null) {
            endpointURL = properties.getProperty("location");
        }
        if (this.bindingTypeName.equalsIgnoreCase("JMS")) {
            endpointURL = endpointURL.replace('|', '&');
        }
        SOAPAddressImpl addr = new SOAPAddressImpl();
        addr.setLocationURI(endpointURL);
        return addr;
    }

    public String getTransportURI() {
        if (this.bindingTypeName.equalsIgnoreCase("http")) {
            return "http://schemas.xmlsoap.org/soap/http";
        }
        return "http://schemas.xmlsoap.org/soap/jms";
    }

    public OptionDescriptor[] getOptionDescriptors() {
        int i;
        OptionDescriptor[] defaultOptionDescriptors = this.getDefaultOptionDescriptors();
        int dl = defaultOptionDescriptors.length;
        int sl = this.specificOptionDescriptors.length;
        OptionDescriptor[] allOptionDescriptors = new OptionDescriptor[dl + sl];
        for (i = 0; i < dl; ++i) {
            allOptionDescriptors[i] = defaultOptionDescriptors[i];
        }
        for (i = 0; i < sl; ++i) {
            allOptionDescriptors[i + dl] = this.specificOptionDescriptors[i];
        }
        return allOptionDescriptors;
    }

    private Binding getOtherBinding(Definition def, PortType portType) {
        Iterator bindings = def.getBindings().values().iterator();
        while (bindings.hasNext()) {
            Binding binding = (Binding)bindings.next();
            if (!binding.getPortType().getQName().equals(portType.getQName())) continue;
            return binding;
        }
        return null;
    }

    private BindingOperation getOtherBindingOperation(Binding binding, Operation op) {
        if (binding == null || op == null) {
            return null;
        }
        String name2 = op.getName();
        Input bi = op.getInput();
        String input = bi == null ? null : bi.getName();
        Output bo = op.getOutput();
        String output = bo == null ? null : bo.getName();
        return binding.getBindingOperation(name2, input, output);
    }

    private ExtensibilityElement getOtherInputElement(BindingOperation op) {
        if (op == null) {
            return null;
        }
        List elements = op.getBindingInput().getExtensibilityElements();
        return elements.isEmpty() ? null : (ExtensibilityElement)elements.get(0);
    }

    private ExtensibilityElement getOtherOutputElement(BindingOperation op) {
        if (op == null) {
            return null;
        }
        List elements = op.getBindingOutput().getExtensibilityElements();
        return elements.isEmpty() ? null : (ExtensibilityElement)elements.get(0);
    }

    protected ExtensibilityElement getBindingExtension(PortType portType) {
        return null;
    }

    protected ExtensibilityElement getBindingOperation(Operation op) {
        return null;
    }

    protected Map getRequiredNamespaces() {
        return null;
    }

    static {
        axisTypeToMIMEString.put(Constants.MIME_IMAGE, "image/jpeg");
        axisTypeToMIMEString.put(Constants.MIME_PLAINTEXT, "text/plain");
        axisTypeToMIMEString.put(Constants.MIME_MULTIPART, "multipart/*");
        axisTypeToMIMEString.put(Constants.MIME_SOURCE, "text/xml");
        axisTypeToMIMEString.put(Constants.MIME_OCTETSTREAM, "application/octetstream");
        axisTypeToMIMEString.put(Constants.MIME_DATA_HANDLER, "application/octetstream");
        axisTypeToMIMEString.put(Constants.WSI_SWAREF, "application/octetstream");
    }
}

