/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.multiprotocol.provider.java;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.multiprotocol.InvocationContext;
import com.ibm.ws.webservices.multiprotocol.ServiceContext;
import com.ibm.ws.webservices.multiprotocol.extensions.agnostic.AgnosticAddress;
import com.ibm.ws.webservices.multiprotocol.models.ModelTransport;
import com.ibm.ws.webservices.multiprotocol.resources.Messages;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.server.ServiceLifecycle;

public class JavaTransport
extends ModelTransport {
    private static final TraceComponent _tc = Tr.register(JavaTransport.class, "WebServices", "com.ibm.ws.webservices.multiprotocol.resources.mpMessages");
    public static final String PROTOCOL = "wsjava";
    protected static final String CTX_MSG_CONTEXT = "java.message.context";
    static /* synthetic */ Class class$java$lang$Object;

    public JavaTransport(ServiceContext ctx) {
        super(ctx);
    }

    public String getProtocol() {
        return PROTOCOL;
    }

    public Object getTargetKey(InvocationContext invContext) {
        return invContext.getEndpoint();
    }

    public void close(InvocationContext invContext, Object target) {
        if (target instanceof ServiceLifecycle) {
            ((ServiceLifecycle)target).destroy();
        }
    }

    public Object makeTargetObject(InvocationContext invContext) throws RemoteException {
        Object targetObject;
        String endpointString = invContext.getEndpoint();
        AgnosticAddress endpoint = new AgnosticAddress();
        endpoint.setLocationURI(endpointString);
        String className = this.getClassName(endpoint);
        Class targetClass = this.getTargetObjectClass(className);
        try {
            targetObject = targetClass.newInstance();
        }
        catch (Throwable e) {
            FFDCFilter.processException(e, "com.ibm.ws.webservices.multiprotocol.provider.java.JavaTransport.makeTargetObject", "94", this);
            throw new RemoteException(Messages.getMessage("errorInstObj", targetClass.getName(), e.toString()));
        }
        if (targetObject instanceof ServiceLifecycle) {
            try {
                ((ServiceLifecycle)targetObject).init(invContext);
            }
            catch (ServiceException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.multiprotocol.provider.java.JavaTransport.makeTargetObject", "103", this);
                throw new RemoteException(Messages.getMessage("errorInitObj", "ServiceException", targetClass.getName(), e.toString()));
            }
        }
        return targetObject;
    }

    protected Class getTargetObjectClass(String className) throws RemoteException {
        Class targetObjectClass = null;
        try {
            targetObjectClass = ClassUtils.forName(className);
        }
        catch (Throwable e) {
            FFDCFilter.processException(e, "com.ibm.ws.webservices.multiprotocol.provider.java.JavaTransport.getTargetObjectClass", "126", this);
            throw new RemoteException(Messages.getMessage("errorLoadTargetClass", e.getClass().getName(), className, e.toString()));
        }
        return targetObjectClass;
    }

    protected String getClassName(AgnosticAddress endpoint) {
        String targetClassName;
        try {
            if (!PROTOCOL.equals(endpoint.getURLProtocol())) {
                throw new JAXRPCException(Messages.getMessage("invalidUrlProtocol2", PROTOCOL, endpoint.getURLProtocol()));
            }
            targetClassName = endpoint.getURLHost();
        }
        catch (WSDLException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.multiprotocol.provider.java.JavaTransport.getClassName", "150", this);
            throw new JAXRPCException(Messages.getMessage("errorGetClass", "WSDLException", endpoint.getLocationURI(), e.toString()));
        }
        return targetClassName;
    }

    public Object invoke(InvocationContext invContext, Object target, QName operationName, Object[] inputParams, Class returnClass) throws RemoteException {
        String methodName = JavaUtils.xmlNameToJava(operationName.getLocalPart());
        Class[] argClasses = this.getArgClasses(invContext, operationName, inputParams);
        Object response = this.doReflectiveInvoke(target, methodName, inputParams, argClasses);
        return response;
    }

    protected Class[] getArgClasses(InvocationContext invContext, QName operationQName, Object[] args) {
        Class[] argClasses = invContext.getInputParameterTypes();
        if (argClasses == null) {
            argClasses = new Class[args == null ? 0 : args.length];
            for (int i = 0; i < argClasses.length; ++i) {
                argClasses[i] = args[i] == null ? (class$java$lang$Object == null ? JavaTransport.class$("java.lang.Object") : class$java$lang$Object) : args[i].getClass();
            }
        }
        return argClasses;
    }

    protected Object doReflectiveInvoke(Object stub, String methodName, Object[] args, Class[] argClasses) throws RemoteException {
        Method method = this.getMethod(stub, methodName, argClasses);
        Object result = this.invokeMethod(method, stub, args);
        return result;
    }

    protected Method getMethod(Object target, String methodName, Class[] argClasses) throws RemoteException {
        Method method;
        try {
            method = target.getClass().getDeclaredMethod(methodName, argClasses);
        }
        catch (SecurityException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.multiprotocol.provider.java.JavaTransport.getMethod", "224", this);
            throw new RemoteException(Messages.getMessage("errorGetMethod", "SecurityException", methodName, target.getClass().getName(), e.toString()));
        }
        catch (NoSuchMethodException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.multiprotocol.provider.java.JavaTransport.getMethod", "234", this);
            throw new RemoteException(Messages.getMessage("errorGetMethod", "NoSuchMethodException", methodName, target.getClass().getName(), e.toString()));
        }
        return method;
    }

    protected Object invokeMethod(Method m, Object target, Object[] args) throws RemoteException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "invokeMethod", new Object[]{m, target});
        }
        Object returnValue = null;
        try {
            returnValue = m.invoke(target, args);
        }
        catch (IllegalArgumentException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.multiprotocol.provider.java.JavaTransport.invokeMethod", "259", this);
            throw new RemoteException(Messages.getMessage("errorInvokeTargetMethod", "IllegalArgumentException", m.getName(), target.getClass().getName(), e.toString()));
        }
        catch (IllegalAccessException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.multiprotocol.provider.java.JavaTransport.invokeMethod", "269", this);
            throw new RemoteException(Messages.getMessage("errorInvokeTargetMethod", "IllegalAccessException", m.getName(), target.getClass().getName(), e.toString()));
        }
        catch (InvocationTargetException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.multiprotocol.provider.java.JavaTransport.invokeMethod", "279", this);
            boolean foundNonSerializableBean = false;
            ClassCastException cce = null;
            if (e.getCause() instanceof ClassCastException) {
                cce = (ClassCastException)e.getCause();
                try {
                    Class<?> potentialNonSerializableBean = Class.forName(cce.getMessage());
                    if (!Serializable.class.isAssignableFrom(potentialNonSerializableBean)) {
                        foundNonSerializableBean = true;
                    }
                }
                catch (ClassNotFoundException cnfe) {
                    // empty catch block
                }
            }
            if (foundNonSerializableBean) {
                throw new RemoteException(Messages.getMessage("errorBeanNotSerializable", cce.getMessage(), m.getName(), target.getClass().getName()), e.getCause());
            }
            throw new RemoteException(Messages.getMessage("errorInvokeTargetMethod", "Serializable", m.getName(), target.getClass().getName(), e.toString()), e.getCause());
        }
        return returnValue;
    }
}

