/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.multiprotocol.models;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.multiprotocol.InvocationContext;
import com.ibm.ws.webservices.multiprotocol.ServiceContext;
import com.ibm.ws.webservices.multiprotocol.extensions.agnostic.AgnosticAddress;
import com.ibm.ws.webservices.multiprotocol.handlers.MessageContext;
import com.ibm.ws.webservices.multiprotocol.handlers.sdo.impl.SDOMessageContextImpl;
import com.ibm.ws.webservices.multiprotocol.provider.Transport;
import com.ibm.ws.webservices.multiprotocol.resources.Messages;
import java.rmi.RemoteException;
import java.util.Hashtable;
import javax.wsdl.WSDLException;
import javax.xml.rpc.JAXRPCException;

public abstract class ModelTransport
implements Transport {
    protected ServiceContext context;
    protected Hashtable endpoint2TargetCache;
    protected static final String CTX_MSG_CONTEXT = "multiprotocol.message.context";

    public ModelTransport(ServiceContext context) {
        this.context = context;
        this.endpoint2TargetCache = new Hashtable();
    }

    public MessageContext getMessageContext(InvocationContext invContext) {
        MessageContext messageContext = (MessageContext)invContext.getProperty(CTX_MSG_CONTEXT);
        if (messageContext == null) {
            messageContext = this.createMessageContext(invContext);
            invContext.setProperty(CTX_MSG_CONTEXT, messageContext);
        }
        return messageContext;
    }

    protected MessageContext createMessageContext(InvocationContext invocationContext) {
        SDOMessageContextImpl mc = new SDOMessageContextImpl(invocationContext);
        return mc;
    }

    public Object getTargetObject(InvocationContext invCtx) throws RemoteException {
        Object target = null;
        boolean maintainSession = false;
        Object endpoint = null;
        if (invCtx != null) {
            Object obj1 = invCtx.getProperty("javax.xml.rpc.session.maintain");
            if (obj1 != null && obj1 instanceof Boolean) {
                maintainSession = (Boolean)obj1;
            }
            if ((endpoint = this.getTargetKey(invCtx)) != null && maintainSession) {
                target = this.getTargetFromCache(endpoint);
            }
        }
        if (target == null) {
            this.validateEndpoint(endpoint);
            target = this.makeTargetObject(invCtx);
            this.addTarget2Cache(endpoint, target);
        }
        return target;
    }

    protected void validateEndpoint(Object endpoint) {
        if (endpoint == null) {
            throw new JAXRPCException(Messages.getMessage("null_argument", "endpoint"));
        }
        AgnosticAddress address = null;
        if (endpoint instanceof String) {
            address = new AgnosticAddress();
            address.setLocationURI((String)endpoint);
        }
        if (endpoint instanceof AgnosticAddress) {
            address = (AgnosticAddress)endpoint;
        }
        if (address != null) {
            String endpointProtocol;
            try {
                endpointProtocol = address.getURLProtocol();
            }
            catch (WSDLException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.multiprotocol.models.ModelTransport.validateEndpoint", "99", this);
                throw new JAXRPCException(Messages.getMessage("errorGetURLProtocol", e.toString()));
            }
            String requiredProtocol = this.getProtocol();
            if (requiredProtocol != null && !requiredProtocol.equals(endpointProtocol)) {
                throw new JAXRPCException("invalidURLProtocol2" + requiredProtocol + endpointProtocol);
            }
        }
    }

    public void close(Object endpoint) throws RemoteException {
        if (endpoint == null) {
            return;
        }
        Object target = this.endpoint2TargetCache.get(endpoint);
        if (target != null) {
            this.endpoint2TargetCache.remove(endpoint);
            InvocationContext inv = new InvocationContext(this.context);
            this.close(inv, target);
        }
    }

    protected Object getTargetFromCache(Object endpoint) {
        return this.endpoint2TargetCache.get(endpoint);
    }

    protected void addTarget2Cache(Object endpoint, Object target) {
        this.endpoint2TargetCache.put(endpoint, target);
    }

    public Object getTargetKey(InvocationContext invContext) {
        return invContext.getEndpoint();
    }
}

