/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.multiprotocol.models;

import com.ibm.ws.webservices.multiprotocol.provider.StubGenerator;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingOperationEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingParamEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import com.ibm.ws.webservices.wsdl.symbolTable.Type;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import com.ibm.ws.webservices.wsdl.toJava.JavaClassWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaGeneratorFactory;
import com.ibm.ws.webservices.wsdl.toJava.Utils;
import com.ibm.ws.webservices.wsdl.utils.OperationDescBuilder;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;

public abstract class ModelStubGenerator
extends JavaClassWriter
implements StubGenerator {
    protected BindingEntry bindingEntry;
    protected Binding binding;
    protected SymbolTable symbolTable;
    private static final String indent = "    ";
    private static final String indent2 = "        ";
    private static final String indent3 = "            ";
    private static final String indent4 = "                ";
    private int suffixId = 0;
    private int methodNumber = 0;

    public ModelStubGenerator(Emitter emitter, BindingEntry bEntry, SymbolTable symTable) {
        super(emitter, bEntry.getName() + "Stub", "stub");
        this.bindingEntry = bEntry;
        this.binding = bEntry.getBinding();
        this.symbolTable = symTable;
    }

    protected abstract String getExtendsText();

    protected String getImplementsText() {
        return "implements " + this.bindingEntry.getDynamicVar(JavaGeneratorFactory.INTERFACE_NAME) + " ";
    }

    protected void writeFileBody(PrintWriter pw) throws IOException {
        PortType portType = this.binding.getPortType();
        boolean hasMIME = Utils.hasMIME(this.bindingEntry);
        this.writeConstructors(pw, false);
        List operations = this.binding.getBindingOperations();
        for (int i = 0; i < operations.size(); ++i) {
            BindingOperation operation = (BindingOperation)operations.get(i);
            BindingOperationEntry boe = this.bindingEntry.getOperation(operation.getOperation());
            Operation ptOperation = operation.getOperation();
            OperationType type = ptOperation.getStyle();
            if (type == OperationType.NOTIFICATION || type == OperationType.SOLICIT_RESPONSE) {
                pw.println(boe.getDynamicVar(JavaGeneratorFactory.SIGNATURE));
                pw.println();
                continue;
            }
            this.writeOperation(pw, boe, type == OperationType.ONE_WAY);
            ++this.methodNumber;
        }
    }

    protected void writeConstructors(PrintWriter pw, boolean hasTypes) {
        pw.println("    public " + this.className + "(java.net.URL endpointURL, javax.xml.rpc.Service service) throws com.ibm.ws.webservices.engine.WebServicesFault {");
        pw.println("        if (service == null) {");
        pw.println("            super.service = new com.ibm.ws.webservices.multiprotocol.AgnosticService();");
        pw.println("        }");
        pw.println("        else {");
        pw.println("            super.service = service;");
        pw.println("        }");
        pw.println("        setEndpoint(endpointURL);");
        pw.println("        setSEIClass(" + this.bindingEntry.getDynamicVar(JavaGeneratorFactory.INTERFACE_NAME) + ".class);");
        pw.println("    }");
        pw.println();
    }

    protected void writeOperationDesc(PrintWriter pw, BindingOperationEntry boe, BindingEntry bEntry, String soapAction, String opDescName) throws IOException {
        OperationDescBuilder odb = OperationDescBuilder.create(boe, bEntry, this.symbolTable);
        odb.writeOperationDesc(pw, true, indent2, opDescName, this.suffixId++);
    }

    private void writeSerializationInit(PrintWriter pw, Type type) throws IOException {
        QName qname = type.getQName();
        pw.println("        javaType = " + type.getName() + ".class;");
        pw.println("        xmlType = com.ibm.ws.webservices.engine.utils.QNameTable.createQName(\"" + qname.getNamespaceURI() + "\", \"" + qname.getLocalPart() + "\");");
        String sfString = null;
        String dfString = null;
        if (type.getName().equals("org.w3c.dom.Element")) {
            sfString = "com.ibm.ws.webservices.engine.encoding.ser.ElementSerializerFactory.class";
            dfString = "com.ibm.ws.webservices.engine.encoding.ser.ElementDeserializerFactory.class";
        } else if (type.getName().equals("javax.xml.soap.SOAPElement")) {
            sfString = "com.ibm.ws.webservices.engine.encoding.ser.SOAPElementSerializerFactory.class";
            dfString = "com.ibm.ws.webservices.engine.encoding.ser.SOAPElementDeserializerFactory.class";
        } else if (type.getName().endsWith("[]")) {
            sfString = "com.ibm.ws.webservices.engine.encoding.ser.ArraySerializerFactory.class";
            dfString = "com.ibm.ws.webservices.engine.encoding.ser.ArrayDeserializerFactory.class";
        } else if (type.getNode() != null && type.isEnumeration()) {
            sfString = "com.ibm.ws.webservices.engine.encoding.ser.EnumSerializerFactory.class";
            dfString = "com.ibm.ws.webservices.engine.encoding.ser.EnumDeserializerFactory.class";
        } else if (type.isSimpleType()) {
            sfString = "com.ibm.ws.webservices.engine.encoding.ser.SimpleSerializerFactory.class";
            dfString = "com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializerFactory.class";
        } else if (type.isSimpleContent()) {
            sfString = "com.ibm.ws.webservices.engine.encoding.ser.SimpleBeanSerializerFactory.class";
            dfString = "com.ibm.ws.webservices.engine.encoding.ser.SimpleBeanDeserializerFactory.class";
        } else {
            sfString = "com.ibm.ws.webservices.engine.encoding.ser.BeanSerializerFactory.class";
            dfString = "com.ibm.ws.webservices.engine.encoding.ser.BeanDeserializerFactory.class";
        }
        pw.println("        sf = com.ibm.ws.webservices.engine.encoding.ser.BaseSerializerFactory.createFactory(" + sfString + ", javaType, xmlType);");
        pw.println("        df = com.ibm.ws.webservices.engine.encoding.ser.BaseDeserializerFactory.createFactory(" + dfString + ", javaType, xmlType);");
        pw.println("        if (sf != null || df != null) {");
        pw.println("            tm.register(javaType, xmlType, sf, df);");
        pw.println("        }");
        pw.println();
    }

    private void writeOperation(PrintWriter pw, BindingOperationEntry boe, boolean oneway) throws IOException {
        this.writeComment(pw, boe.getBindingOperation().getOperation().getDocumentationElement());
        String signature = (String)boe.getDynamicVar(JavaGeneratorFactory.SIGNATURE);
        pw.println(signature + " {");
        String seiName = (String)this.bindingEntry.getDynamicVar(JavaGeneratorFactory.INTERFACE_NAME);
        pw.println(indent2 + seiName + " _obj = \n" + indent3 + "(" + seiName + ") getTargetObject();");
        String opName = boe.getName();
        pw.print(indent2);
        if (!oneway && boe.getReturn() != null) {
            pw.print(boe.getReturn().getType().getName() + " _resp = ");
        }
        pw.print("_obj." + opName + "(");
        this.writeParameters(pw, boe);
        pw.println(");");
        if (!oneway && boe.getReturn() != null) {
            pw.println("        return _resp;");
        }
        pw.println("    }");
        pw.println();
    }

    private void writeParameters(PrintWriter pw, BindingOperationEntry boe) {
        boolean needComma = false;
        for (int i = 0; i < boe.numParameters(); ++i) {
            BindingParamEntry p = boe.getParameter(i);
            if (p.getMode() == 2) continue;
            if (needComma) {
                pw.print(", ");
            } else {
                needComma = true;
            }
            String javifiedName = p.getName();
            if (p.getMode() != 1) {
                javifiedName = javifiedName + ".value";
            }
            pw.print(javifiedName);
        }
    }

    private void writeResponseHandling(PrintWriter pw, BindingOperationEntry boe) {
        int allOuts = boe.numOuts() + boe.numInOuts();
        if (allOuts > 0) {
            if (allOuts == 1) {
                if (boe.getReturn() != null) {
                    this.writeOutputAssign(pw, indent2, "return ", boe.getReturn(), "((com.ibm.ws.webservices.engine.xmlsoap.ext.ParamValue) _resp.get(0)).getValue()");
                } else {
                    int i = 0;
                    BindingParamEntry p = boe.getParameter(i);
                    while (p.getMode() == 1) {
                        p = boe.getParameter(++i);
                    }
                    String javifiedName = p.getName();
                    this.writeOutputAssign(pw, indent3, javifiedName + ".value = ", p, "((com.ibm.ws.webservices.engine.xmlsoap.ext.ParamValue) _resp.get(0)).getValue()");
                }
            } else {
                if (boe.getReturn() != null) {
                    pw.println("        Object _return = null;");
                }
                pw.println("        for (int _i = 0; _i < _resp.size(); ++_i) {");
                pw.println("            com.ibm.ws.webservices.engine.xmlsoap.ext.ParamValue _param = (com.ibm.ws.webservices.engine.xmlsoap.ext.ParamValue) _resp.get(_i);");
                String ifClause = "if";
                for (int i = 0; i < boe.numParameters(); ++i) {
                    BindingParamEntry p = boe.getParameter(i);
                    if (p.getMode() == 1) continue;
                    String javifiedName = p.getName();
                    String qnameName = Utils.getNewQName((QName)p.getDynamicVar("parameterWireQName"));
                    pw.println(indent3 + ifClause + " (" + qnameName + ".equals(_param.getQName())) {");
                    this.writeOutputAssign(pw, indent4, javifiedName + ".value = ", p, "_param.getValue()");
                    pw.println("            }");
                    ifClause = "else if";
                }
                if (boe.getReturn() != null) {
                    pw.println("            else {");
                    pw.println("                _return = _param.getValue();");
                    pw.println("            }");
                }
                pw.println("        }");
                if (boe.getReturn() != null) {
                    this.writeOutputAssign(pw, indent2, "return ", boe.getReturn(), "_return");
                }
            }
        }
    }

    private void writeOutputAssign(PrintWriter pw, String indent, String target, BindingParamEntry type, String source) {
        if (type != null && type.getName() != null) {
            pw.println(indent + "try {");
            pw.println(indent + indent + target + Utils.getResponseString(type, source));
            pw.println(indent + "} catch (java.lang.Exception _exception) {");
            pw.println(indent + indent + target + Utils.getResponseString(type, "com.ibm.ws.webservices.engine.utils.JavaUtils.convert(" + source + ", " + type.getName() + ".class)"));
            pw.println(indent + "}");
        } else {
            pw.println(indent + target + Utils.getResponseString(type, source));
        }
    }
}

