/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.multiprotocol.models;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.protocol.Protocols;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.multiprotocol.InvocationContext;
import com.ibm.ws.webservices.multiprotocol.ServiceContext;
import com.ibm.ws.webservices.multiprotocol.base.DefaultlInvocationHandler;
import com.ibm.ws.webservices.multiprotocol.encoding.AgnosticTypeMappingRegistry;
import com.ibm.ws.webservices.multiprotocol.extensions.agnostic.AgnosticAddress;
import com.ibm.ws.webservices.multiprotocol.models.ModelCall;
import com.ibm.ws.webservices.multiprotocol.provider.Transport;
import com.ibm.ws.webservices.multiprotocol.resources.Messages;
import com.ibm.wsdl.extensions.soap.SOAPAddressImpl;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.rmi.Remote;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Input;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import javax.xml.rpc.Call;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.Stub;
import javax.xml.rpc.encoding.TypeMappingRegistry;
import javax.xml.rpc.handler.HandlerRegistry;

public abstract class ModelService
implements Service {
    protected static TraceComponent _tc = Tr.register(ModelService.class, "WebServices", "com.ibm.ws.webservices.multiprotocol.resources.mpMessages");
    protected ServiceContext context;
    protected Transport transport;
    protected AgnosticTypeMappingRegistry typeMappingRegistry;

    public ModelService(ServiceContext context) {
        this.context = context;
    }

    public Remote getPort(Class serviceEndpointInterface) throws ServiceException {
        if (!serviceEndpointInterface.isInterface()) {
            throw new ServiceException(Messages.getMessage("badSEI4", serviceEndpointInterface.getName()));
        }
        if (!this.context.hasWSDL()) {
            throw new ServiceException(Messages.getMessage("badSEI1", serviceEndpointInterface.getName()));
        }
        QName portQName = this.getDefaultPortQName(serviceEndpointInterface, null);
        if (portQName == null) {
            throw new ServiceException(Messages.getMessage("badSEI2", serviceEndpointInterface.getName()));
        }
        Remote stub = this.getPort(portQName, serviceEndpointInterface);
        return stub;
    }

    public Remote getPort(QName portName, Class serviceEndpointInterface) throws ServiceException {
        Remote stub = this.doGetPort(portName, serviceEndpointInterface);
        return stub;
    }

    protected Remote doGetPort(QName portName, Class serviceEndpointInterface) throws ServiceException {
        if (!this.context.hasWSDL()) {
            throw new ServiceException(Messages.getMessage("proxyError1"));
        }
        if (portName == null) {
            throw new ServiceException(Messages.getMessage("proxyError2"));
        }
        Remote stubProxy = this.makeDynamicProxyStub(portName, serviceEndpointInterface);
        return stubProxy;
    }

    protected Remote makeDynamicProxyStub(QName portName, Class serviceEndpointInterface) throws ServiceException {
        ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        Class[] implementedInterfaces = new Class[]{serviceEndpointInterface, Stub.class, Remote.class};
        InvocationHandler invocationHandler = this.getInvocationHandler(portName, serviceEndpointInterface);
        Remote stubProxy = null;
        try {
            stubProxy = (Remote)Proxy.newProxyInstance(classLoader, implementedInterfaces, invocationHandler);
        }
        catch (IllegalArgumentException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.multiprotocol.models.ModelService.makeDynamicProxyStub", "186", this);
            throw new ServiceException(Messages.getMessage("proxyError3", e.toString()));
        }
        return stubProxy;
    }

    protected InvocationHandler getInvocationHandler(QName portQName, Class sei) throws ServiceException {
        Call call = this.createCall(portQName);
        InvocationContext invContext = null;
        invContext = call instanceof ModelCall ? ((ModelCall)call).invocationContext : new InvocationContext(this.context);
        invContext.setSeiClass(sei);
        if (!this.context.isManagedEnvironment() && this.context.hasWSDL()) {
            invContext.setEndpoint(this.getAddressForPort(portQName));
        }
        DefaultlInvocationHandler invocationHandler = new DefaultlInvocationHandler(invContext, call);
        return invocationHandler;
    }

    protected String getAddressForPort(QName portQName) throws ServiceException {
        String portAddress = null;
        Definition defn = this.context.getDefinition();
        javax.wsdl.Service svc = defn.getService(this.context.getServiceName());
        Port port2 = svc.getPort(portQName.getLocalPart());
        List extElements = port2.getExtensibilityElements();
        Object o = extElements.listIterator().next();
        portAddress = o instanceof SOAPAddressImpl ? ((SOAPAddressImpl)o).getLocationURI() : ((AgnosticAddress)o).getLocationURI();
        return portAddress;
    }

    public Call[] getCalls(QName portName) throws ServiceException {
        if (portName == null) {
            throw new ServiceException(Messages.getMessage("null_argument", "portName"));
        }
        Port port2 = this.context.getPortForQName(portName);
        if (port2 == null) {
            throw new ServiceException(Messages.getMessage("portNotFound", portName.toString()));
        }
        PortType portType = port2.getBinding().getPortType();
        List portTypeOperations = portType.getOperations();
        Call[] calls = new Call[portTypeOperations.size()];
        for (int i = 0; i < calls.length; ++i) {
            Operation portTypeOperation = (Operation)portTypeOperations.get(i);
            String operationName = portTypeOperation.getName();
            String inputMessageName = null;
            Input input = portTypeOperation.getInput();
            if (input != null) {
                inputMessageName = input.getName();
            }
            calls[i] = this.createCall(portName, QNameTable.createQName("", operationName), inputMessageName);
        }
        return calls;
    }

    public Call createCall() throws ServiceException {
        Call call = this.createCallInternal(null, null, null, null);
        return call;
    }

    public Call createCall(QName portName) throws ServiceException {
        Call call = this.createCallInternal(portName, null, null, null);
        return call;
    }

    public Call createCall(QName portName, QName operationName) throws ServiceException {
        Call call = this.createCallInternal(portName, operationName, null, null);
        return call;
    }

    public Call createCall(QName portName, String operationName) throws ServiceException {
        QName operationQName = null;
        if (operationName != null) {
            operationQName = QNameTable.createQName("", operationName);
        }
        Call call = this.createCallInternal(portName, operationQName, null, null);
        return call;
    }

    public Call createCall(QName portName, QName operationName, String inputMessageName) throws ServiceException {
        Call call = this.createCallInternal(portName, operationName, inputMessageName, null);
        return call;
    }

    public Call createCall(QName portName, QName operationName, String inputMessageName, InvocationContext invCtx) throws ServiceException {
        Call call = this.createCallInternal(portName, operationName, inputMessageName, invCtx);
        return call;
    }

    public Call createCall(QName portName, String operationName, String inputMessageName) throws ServiceException {
        Call call = this.createCallInternal(portName, QNameTable.createQName("", operationName), inputMessageName, null);
        return call;
    }

    protected Call createCallInternal(QName portQName, QName operationName, String inputMessageName, InvocationContext invCtx) throws ServiceException {
        Port port2;
        javax.wsdl.Service wsdlService;
        Class sei;
        QName qn;
        String portName = null;
        if (portQName != null) {
            portName = portQName.getLocalPart();
        }
        if (portName == null && (qn = this.getDefaultPortQName(sei = invCtx != null ? invCtx.getSeiClass() : null, null)) != null) {
            portName = qn.getLocalPart();
        }
        if (portName == null) {
            portName = this.getDefaultPortName();
        }
        if ((wsdlService = this.context.getWSDLService()) != null && (port2 = wsdlService.getPort(portName)) == null) {
            throw new JAXRPCException(Messages.getMessage("portNotFound", portName));
        }
        Call call = this.doCreateCall(portName, operationName, inputMessageName, invCtx);
        return call;
    }

    protected abstract Call doCreateCall(String var1, QName var2, String var3, InvocationContext var4) throws ServiceException;

    public Iterator getPorts() throws ServiceException {
        if (!this.context.hasWSDL()) {
            throw new ServiceException(Messages.getMessage("noWSDL"));
        }
        List availablePorts = this.getAvailablePortNames();
        String namespace = this.context.getServiceNamespace();
        ArrayList<QName> portQNames = new ArrayList<QName>();
        Iterator i = availablePorts.iterator();
        while (i.hasNext()) {
            String portName = (String)i.next();
            QName portQName = QNameTable.createQName(namespace, portName);
            portQNames.add(portQName);
        }
        return portQNames.iterator();
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        if (this.typeMappingRegistry == null) {
            this.typeMappingRegistry = new AgnosticTypeMappingRegistry();
        }
        return this.typeMappingRegistry;
    }

    public HandlerRegistry getHandlerRegistry() {
        throw new UnsupportedOperationException(Messages.getMessage("notSupported1", "getHandlerRegistry", this.getClass().getName()));
    }

    public QName getServiceName() {
        QName serviceName = this.context.getServiceName();
        return serviceName;
    }

    public URL getWSDLDocumentLocation() {
        URL wsdlDocumentLocation = this.context.getWSDLDocumentLocation();
        return wsdlDocumentLocation;
    }

    protected String getDefaultPortName() throws ServiceException {
        List availablePorts = this.getAvailablePortNames();
        String preferredPortName = this.getDefaultPortName(availablePorts);
        return preferredPortName;
    }

    protected QName getDefaultPortQName(Class seiClass, Map port2NamespaceMap) throws ServiceException {
        QName portQName;
        QName portTypeQName;
        if (seiClass != null && (portTypeQName = this.getPortTypeForSEI(seiClass.getName())) != null && (portQName = this.getPreferredPortForPortType(portTypeQName)) != null) {
            return portQName;
        }
        List ports = this.getPortsForSEI(seiClass);
        String portName = this.getDefaultPortName(ports);
        if (portName != null) {
            return QNameTable.createQName(this.context.getServiceNamespace(), portName);
        }
        return null;
    }

    protected List getAvailablePortNames() throws ServiceException {
        ArrayList<String> availablePorts = new ArrayList<String>();
        javax.wsdl.Service service = this.context.getWSDLService();
        if (service != null) {
            Map ports = service.getPorts();
            Iterator i = ports.keySet().iterator();
            while (i.hasNext()) {
                String portName = (String)i.next();
                if (!this.isPortAvailable(portName)) continue;
                availablePorts.add(portName);
            }
        }
        return availablePorts;
    }

    protected boolean isPortAvailable(String portName) {
        return true;
    }

    protected String getDefaultPortName(List candidatePorts) throws ServiceException {
        String defaultPort = null;
        if (candidatePorts.size() > 0) {
            defaultPort = (String)candidatePorts.get(0);
        }
        return defaultPort;
    }

    protected String getDefaultPortNameForSEI(Class sei) throws ServiceException {
        String defaultPortName = null;
        if (sei != null) {
            QName portQName;
            QName portTypeQName = this.getPortTypeForSEI(sei.getName());
            if (portTypeQName != null && (portQName = this.getPreferredPortForPortType(portTypeQName)) != null) {
                defaultPortName = portQName.getLocalPart();
            }
            if (defaultPortName == null) {
                List ports = this.getPortsForSEI(sei);
                defaultPortName = this.getDefaultPortName(ports);
            }
        }
        return defaultPortName;
    }

    protected List getPortsForSEI(Class sei) throws ServiceException {
        javax.wsdl.Service wsdlService = this.context.getWSDLService();
        if (wsdlService == null || sei == null) {
            return new ArrayList();
        }
        QName portTypeQName = this.getPortTypeForSEI(sei.getName());
        if (portTypeQName == null) {
            throw new ServiceException(Messages.getMessage("badSEI3", sei.getName()));
        }
        List matchingPorts = this.context.getPortsForPortType(portTypeQName);
        return matchingPorts;
    }

    protected QName getPortTypeForSEI(String seiClassName) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getPortTypeForSEI", new Object[]{seiClassName});
        }
        QName seiPortTypeName = null;
        Map seiToPortTypeMapping = this.context.getSEIToPortTypeMapping();
        if (seiToPortTypeMapping != null) {
            seiPortTypeName = (QName)seiToPortTypeMapping.get(seiClassName);
        }
        if (seiPortTypeName == null) {
            Collection ports = this.context.getServicePorts();
            Iterator i = ports.iterator();
            while (seiPortTypeName == null && i.hasNext()) {
                Port port2 = (Port)i.next();
                QName portTypeQName = port2.getBinding().getPortType().getQName();
                String guessedName = this.guessAtClassName(portTypeQName);
                if (!seiClassName.equals(guessedName)) continue;
                seiPortTypeName = portTypeQName;
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getPortTypeForSEI", seiPortTypeName);
        }
        return seiPortTypeName;
    }

    protected QName getPreferredPortForPortType(QName portTypeQName) {
        Map defaultPortMapping;
        QName defaultPortQName = null;
        if (portTypeQName != null && (defaultPortMapping = this.context.getPortTypeToPortMapping()) != null) {
            defaultPortQName = (QName)defaultPortMapping.get(portTypeQName);
        }
        return defaultPortQName;
    }

    private String guessAtClassName(QName qName) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "guessAtClassName", new Object[]{qName});
        }
        String pkg = null;
        String namespace = qName.getNamespaceURI();
        Map namespace2PackageMapping = this.context.getNamespace2PackageMapping();
        if (namespace2PackageMapping != null) {
            pkg = (String)namespace2PackageMapping.get(namespace);
        }
        if (pkg == null) {
            pkg = JavaUtils.makePackageName(namespace);
        }
        StringBuffer fullyQualifiedName = pkg != null && pkg != "" ? new StringBuffer(pkg).append('.').append(JavaUtils.xmlNameToJavaClass(qName.getLocalPart())) : new StringBuffer(JavaUtils.xmlNameToJavaClass(qName.getLocalPart()));
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "guessAtClassName", fullyQualifiedName.toString());
        }
        return fullyQualifiedName.toString();
    }

    public Transport getTransport() {
        if (this.transport == null) {
            this.transport = this.makeTransport();
        }
        return this.transport;
    }

    protected abstract Transport makeTransport();

    static {
        Protocols.init();
    }
}

