/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.multiprotocol.handlers;

import com.ibm.ws.webservices.multiprotocol.handlers.JAXRPCHandlerChain;
import com.ibm.ws.webservices.multiprotocol.resources.Messages;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.HandlerRegistry;

public class AgnosticHandlerRegistry
implements HandlerRegistry {
    protected HashMap port2HandlerChainCache = new HashMap();
    protected HandlerRegistry shadowRegistry = null;

    public List getHandlerChain(QName portName) {
        List chain = null;
        if (this.shadowRegistry != null) {
            chain = this.shadowRegistry.getHandlerChain(portName);
        } else {
            chain = (List)this.port2HandlerChainCache.get(portName);
            if (chain == null) {
                chain = new JAXRPCHandlerChain(null, null);
                this.port2HandlerChainCache.put(portName, chain);
            }
        }
        return chain;
    }

    public void setHandlerChain(QName portName, List chain) {
        if (this.shadowRegistry != null) {
            this.shadowRegistry.setHandlerChain(portName, chain);
        } else {
            this.port2HandlerChainCache.put(portName, new JAXRPCHandlerChain(chain, null));
        }
    }

    public void transferContents(HandlerRegistry reg) {
        if (reg == this.shadowRegistry) {
            return;
        }
        if (this.shadowRegistry != null) {
            throw new UnsupportedOperationException(Messages.getMessage("dupShadowRegistry"));
        }
        this.shadowRegistry = reg;
        Set entries = this.port2HandlerChainCache.entrySet();
        Iterator i = entries.iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            this.shadowRegistry.setHandlerChain((QName)entry.getKey(), (List)entry.getValue());
        }
        this.port2HandlerChainCache = null;
    }
}

