/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.multiprotocol.extensions.models;

import com.ibm.ws.webservices.multiprotocol.extensions.ExtensionDescription;
import com.ibm.ws.webservices.multiprotocol.extensions.models.ExtensionDescriptionImpl;
import com.ibm.ws.webservices.multiprotocol.extensions.models.ModelExtensibilityElementDeserializer;
import com.ibm.ws.webservices.multiprotocol.extensions.models.ModelExtensibilityElementSerializer;
import com.ibm.ws.webservices.multiprotocol.resources.Messages;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.namespace.QName;

public abstract class ModelExtensibilityElement
implements ExtensibilityElement,
Serializable {
    protected Class parentClass;
    protected QName elementType;
    protected Boolean required;
    protected List validAttributeNames;
    protected Map elementAttributes;

    public ModelExtensibilityElement(Class parentClass, QName elementQName) {
        this.parentClass = parentClass;
        this.setElementType(elementQName);
        this.elementAttributes = new HashMap();
        this.validAttributeNames = Arrays.asList(this.getAttributeNames());
    }

    protected abstract String[] getAttributeNames();

    public Class getParentClass() {
        return this.parentClass;
    }

    public void setElementType(QName elementType) {
        this.elementType = elementType;
    }

    public QName getElementType() {
        return this.elementType;
    }

    public void setRequired(Boolean required) {
        this.required = required;
    }

    public Boolean getRequired() {
        return this.required;
    }

    public String getAttribute(String attributeName) {
        if (!this.validAttributeNames.contains(attributeName)) {
            throw new IllegalArgumentException(Messages.getMessage("badAttrName", attributeName));
        }
        String value2 = (String)this.elementAttributes.get(attributeName);
        return value2;
    }

    public void setAttribute(String attributeName, String value2) {
        if (!this.validAttributeNames.contains(attributeName)) {
            throw new IllegalArgumentException(Messages.getMessage("badAttrName", attributeName));
        }
        this.elementAttributes.put(attributeName, value2);
    }

    public Iterator getAttributes() {
        return this.validAttributeNames.iterator();
    }

    public ExtensionDescription getExtensionDescription() {
        ExtensionDescriptionImpl extensionDescription = new ExtensionDescriptionImpl(this.getClass(), this.getElementType(), this.getParentClass(), new ModelExtensibilityElementSerializer(), new ModelExtensibilityElementDeserializer());
        return extensionDescription;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Element(").append(this.elementType).append("):");
        sb.append("\n required=").append(this.required);
        Iterator i = this.elementAttributes.keySet().iterator();
        while (i.hasNext()) {
            String attributeName = (String)i.next();
            String value2 = (String)this.elementAttributes.get(attributeName);
            sb.append("\n ").append(attributeName).append("=").append(value2);
        }
        return sb.toString();
    }
}

