/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.multiprotocol.encoding;

import com.ibm.ws.webservices.engine.encoding.TypeMappingRegistryImpl;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.rpc.encoding.TypeMapping;
import javax.xml.rpc.encoding.TypeMappingRegistry;

public class AgnosticTypeMappingRegistry
extends TypeMappingRegistryImpl
implements TypeMappingRegistry {
    private Hashtable consistencies = new Hashtable();

    public TypeMapping register(String encodingStyleURI, TypeMapping mapping) {
        this.markAllInconsistent();
        return super.register(encodingStyleURI, mapping);
    }

    public void registerDefault(TypeMapping mapping) {
        this.markAllInconsistent();
        super.registerDefault(mapping);
    }

    public TypeMapping unregisterTypeMapping(String encodingStyleURI) {
        this.markAllInconsistent();
        return super.unregisterTypeMapping(encodingStyleURI);
    }

    public boolean removeTypeMapping(TypeMapping mapping) {
        this.markAllInconsistent();
        return super.removeTypeMapping(mapping);
    }

    public void clear() {
        this.markAllInconsistent();
        super.clear();
    }

    private void markAllInconsistent() {
        Set entries = this.consistencies.entrySet();
        Iterator it = entries.iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            entry.setValue(new Boolean(false));
        }
    }

    public void copyContents(TypeMappingRegistry reg) {
        Integer hash = new Integer(reg.hashCode());
        Object check = this.consistencies.get(hash);
        if (check != null && check instanceof Boolean && ((Boolean)check).booleanValue()) {
            return;
        }
        reg.clear();
        TypeMapping dtm = this.getDefaultTypeMapping();
        reg.registerDefault(dtm);
        String[] urls = this.getRegisteredEncodingStyleURIs();
        for (int i = 0; i < urls.length; ++i) {
            String enc = urls[i];
            TypeMapping tm = this.getTypeMapping(enc);
            if (tm == null) continue;
            reg.register(enc, tm);
        }
        this.consistencies.put(new Integer(reg.hashCode()), new Boolean(true));
    }
}

