/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.multiprotocol.discovery;

import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import com.ibm.ws.webservices.multiprotocol.provider.ServiceProvider;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;

public class ServiceProviderLocator {
    protected static Log log = LogFactory.getLog(ServiceProviderLocator.class.getName());
    protected List discoveredServiceProviders;
    public static final String CONFIGURATION_FILE_NAME = "META-INF/services/" + ServiceProvider.class.getName();
    protected static ServiceProviderLocator instance = new ServiceProviderLocator();

    protected ServiceProviderLocator() {
        if (log.isDebugEnabled()) {
            log.debug("Enter: ServiceProviderLocator ctor");
        }
        this.discoveredServiceProviders = this.findAllServiceProviders();
        if (log.isDebugEnabled()) {
            log.debug("Exit: ServiceProviderLocator ctor");
        }
    }

    public static ServiceProviderLocator getInstance() {
        return instance;
    }

    public List getServiceProviders() {
        return this.discoveredServiceProviders;
    }

    protected List findAllServiceProviders() {
        List al = (List)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ServiceProviderLocator.this.discoverServiceProviders();
            }
        });
        return Collections.unmodifiableList(al);
    }

    protected ArrayList discoverServiceProviders() {
        if (log.isDebugEnabled()) {
            log.debug("Enter: ServiceProviderLocator::discoverServiceProviders");
        }
        ArrayList<ServiceProvider> serviceProviders = new ArrayList<ServiceProvider>();
        this.findServiceProvidersViaExtPtRegistry(serviceProviders);
        if (serviceProviders.isEmpty()) {
            List classNames;
            if (log.isDebugEnabled()) {
                log.debug("No service providers via extension point registry, searching for ServiceProvider files...");
            }
            if ((classNames = this.getServiceProviderClassNames()) != null) {
                Iterator i = classNames.iterator();
                while (i.hasNext()) {
                    String className = (String)i.next();
                    ServiceProvider dsf = this.instantiateServiceProvider(className);
                    if (dsf == null) continue;
                    if (log.isDebugEnabled()) {
                        log.debug("Instantiated service provider: " + className);
                    }
                    serviceProviders.add(dsf);
                }
            }
        }
        if (log.isDebugEnabled()) {
            Iterator i = serviceProviders.iterator();
            while (i.hasNext()) {
                Object spObj = i.next();
                log.debug("Found multiprotocol service provider: " + spObj.getClass().getName());
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: ServiceProviderLocator::discoverServiceProviders");
        }
        return serviceProviders;
    }

    protected ServiceProvider instantiateServiceProvider(String className) {
        ServiceProvider p;
        ServiceProvider dsf = null;
        Object o = null;
        try {
            o = ClassUtils.forName(className).newInstance();
        }
        catch (ClassNotFoundException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.multiprotocol.discovery.ServiceProviderLocator.instantiateServiceProvider", "229", this);
        }
        catch (InstantiationException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.multiprotocol.discovery.ServiceProviderLocator.instantiateServiceProvider", "231", this);
        }
        catch (IllegalAccessException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.multiprotocol.discovery.ServiceProviderLocator.instantiateServiceProvider", "233", this);
        }
        if (o instanceof ServiceProvider && (p = (ServiceProvider)o).isEnabled()) {
            dsf = p;
        }
        return dsf;
    }

    protected List getServiceProviderClassNames() {
        ArrayList classNames = new ArrayList();
        try {
            ClassLoader loader = this.getClass().getClassLoader();
            Enumeration<URL> e = loader.getResources(CONFIGURATION_FILE_NAME);
            if (e == null || !e.hasMoreElements()) {
                loader = ExtClassLoader.getInstance();
                e = loader.getResources(CONFIGURATION_FILE_NAME);
            }
            while (e != null && e.hasMoreElements()) {
                this.readMETAINFClassNames(e.nextElement(), classNames);
            }
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.multiprotocol.discovery.ServiceProviderLocator.getServiceProviderClassNames", "264", this);
        }
        return classNames;
    }

    private void findServiceProvidersViaExtPtRegistry(ArrayList serviceProviders) {
        IExtensionRegistry registry;
        if (log.isDebugEnabled()) {
            log.debug("Enter: ServiceProviderLocator::findServiceProvidersViaExtPtRegistry");
        }
        if ((registry = ExtensionRegistryFactory.instance().getExtensionRegistry()) == null) {
            if (log.isDebugEnabled()) {
                log.debug("Unable to get eclipse extension registry");
            }
            return;
        }
        String epid = ExtensionRegistryFactory.instance().getDefaultPluginID() + ".service-provider";
        if (log.isDebugEnabled()) {
            log.debug("Looking for instances of epid: " + epid);
        }
        IConfigurationElement[] elements = registry.getConfigurationElementsFor(epid);
        for (int i = 0; i < elements.length; ++i) {
            IConfigurationElement element = elements[i];
            if (!"serviceProvider".equals(element.getName())) continue;
            try {
                serviceProviders.add(element.createExecutableExtension("classname"));
                continue;
            }
            catch (CoreException ce) {
                FFDCFilter.processException((Throwable)ce, "com.ibm.ws.webservices.multiprotocol.discovery.ServiceProviderLocator.addServiceProvidersFromExtensionPoint", "350", this);
                if (!log.isDebugEnabled()) continue;
                log.debug("Couldn't load ServiceProvider implementation with classname: " + element.getAttribute("classname"));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: ServiceProviderLocator::findServiceProvidersViaExtPtRegistry");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readMETAINFClassNames(URL u, ArrayList classNames) {
        String inputLine;
        if (log.isDebugEnabled()) {
            log.debug("Reading class names from file: " + u.toString());
        }
        BufferedReader in = null;
        InputStreamReader reader = new InputStreamReader(u.openStream(), "UTF-8");
        in = new BufferedReader(reader);
        while ((inputLine = in.readLine()) != null) {
            int i = inputLine.indexOf(35);
            if (i >= 0) {
                inputLine = inputLine.substring(0, i);
            }
            if ((inputLine = inputLine.trim()).length() <= 0 || classNames.contains(inputLine)) continue;
            classNames.add(inputLine);
            if (!log.isDebugEnabled()) continue;
            log.debug("Found classname: " + inputLine);
        }
        Object var8_8 = null;
        if (in == null) return;
        try {
            in.close();
            return;
        }
        catch (IOException ex2) {
            FFDCFilter.processException((Throwable)ex2, "com.ibm.ws.webservices.multiprotocol.discovery.ServiceProviderLocator.readMETAINFClassNames", "305", this);
        }
        return;
        {
            catch (IOException ex) {
                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.multiprotocol.discovery.ServiceProviderLocator.readMETAINFClassNames", "298", this);
                Object var8_9 = null;
                if (in == null) return;
                try {
                    in.close();
                    return;
                }
                catch (IOException ex2) {
                    FFDCFilter.processException((Throwable)ex2, "com.ibm.ws.webservices.multiprotocol.discovery.ServiceProviderLocator.readMETAINFClassNames", "305", this);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException ex2) {
                FFDCFilter.processException((Throwable)ex2, "com.ibm.ws.webservices.multiprotocol.discovery.ServiceProviderLocator.readMETAINFClassNames", "305", this);
            }
            throw throwable;
        }
    }
}

