/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.multiprotocol.base;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDJAXRPCHandlerInfo;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDJAXRPCHandlerInfoChain;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDPort;
import com.ibm.ws.webservices.engine.handlers.jaxrpc.ExtendedHandlerInfo;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.metadata.ClientPortMetaData;
import com.ibm.ws.webservices.metadata.ClientServiceMetaData;
import com.ibm.ws.webservices.multiprotocol.InvocationContext;
import com.ibm.ws.webservices.multiprotocol.ServiceContext;
import com.ibm.ws.webservices.multiprotocol.base.DefaultCall;
import com.ibm.ws.webservices.multiprotocol.handlers.AgnosticHandlerRegistry;
import com.ibm.ws.webservices.multiprotocol.models.ModelService;
import com.ibm.ws.webservices.multiprotocol.provider.Transport;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.rpc.Call;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.handler.HandlerRegistry;

public class DefaultService
extends ModelService {
    AgnosticHandlerRegistry handlerRegistry;

    public DefaultService(ServiceContext context, Transport transport2) {
        super(context);
        this.transport = transport2;
    }

    protected Transport makeTransport() {
        return this.transport;
    }

    protected Call doCreateCall(String portName, QName operationName, String inputMessageName, InvocationContext invCtx) throws ServiceException {
        InvocationContext invContext = null;
        invContext = invCtx != null ? invCtx : new InvocationContext(this.context);
        invContext.setPortName(portName);
        DefaultCall call = new DefaultCall(invContext, this.transport, operationName, inputMessageName);
        return call;
    }

    public HandlerRegistry getHandlerRegistry() {
        if (this.handlerRegistry == null) {
            this.handlerRegistry = new AgnosticHandlerRegistry();
            if (this.context.isManagedEnvironment()) {
                this.initHandlerRegistry(this.handlerRegistry);
            }
        }
        return this.handlerRegistry;
    }

    protected void initHandlerRegistry(HandlerRegistry handlerRegistry) {
        String serviceRefName = this.context.getServiceRefName();
        ClientServiceMetaData clientServiceMetaData = this.context.getClientServiceMetaData();
        Collection clientPortMetaDatas = null;
        if (clientServiceMetaData != null) {
            clientPortMetaDatas = clientServiceMetaData.getPorts();
        }
        if (clientPortMetaDatas != null) {
            Iterator i = clientPortMetaDatas.iterator();
            while (i.hasNext()) {
                QName portQName;
                boolean useHandlers;
                List handlerInfos;
                ClientPortMetaData clientPortMetaData = (ClientPortMetaData)i.next();
                WSDDPort wsddPort = clientPortMetaData.getWsddPort();
                WSDDJAXRPCHandlerInfoChain wsddHandlerInfoChain = wsddPort.getHandlerInfoChain();
                if (wsddHandlerInfoChain == null || (handlerInfos = wsddHandlerInfoChain.getHandlerInfoList()) == null || handlerInfos.size() <= 0 || !(useHandlers = !this.context.isProtocolOverridden(portQName = this.makePortQName(serviceRefName, wsddPort)) || this.context.isNonBoundWSDL())) continue;
                this.addHandlerInfos(handlerRegistry, handlerInfos, portQName);
            }
        }
    }

    protected void addHandlerInfos(HandlerRegistry handlerRegistry, List wsddHandlerInfos, QName portQName) {
        List handlers = handlerRegistry.getHandlerChain(portQName);
        Iterator i = wsddHandlerInfos.iterator();
        while (i.hasNext()) {
            ExtendedHandlerInfo jaxrpcHandlerInfo;
            WSDDJAXRPCHandlerInfo wsddHandlerInfo = (WSDDJAXRPCHandlerInfo)i.next();
            try {
                jaxrpcHandlerInfo = wsddHandlerInfo.getHandlerInfo();
            }
            catch (ClassNotFoundException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.multiprotocol.base.DefaultService.addHandlerInfos", "159", this);
                throw new JAXRPCException("exception getting HandlerInfo: " + e, e);
            }
            handlers.add(jaxrpcHandlerInfo);
        }
        handlerRegistry.setHandlerChain(portQName, handlers);
    }

    protected QName makePortQName(String serviceRefName, WSDDPort wsddPort) {
        QName crapQName = wsddPort.getQName();
        String portName = crapQName.getLocalPart().substring(serviceRefName.length() + 1);
        QName portQName = QNameTable.createQName(this.context.getServiceNamespace(), portName);
        return portQName;
    }
}

