/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.multiprotocol.base;

import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.multiprotocol.InvocationContext;
import com.ibm.ws.webservices.multiprotocol.ServiceContext;
import com.ibm.ws.webservices.multiprotocol.handlers.JAXRPCHandlerChain;
import com.ibm.ws.webservices.multiprotocol.handlers.MessageContext;
import com.ibm.ws.webservices.multiprotocol.models.ModelCall;
import com.ibm.ws.webservices.multiprotocol.provider.Transport;
import java.rmi.RemoteException;
import javax.xml.namespace.QName;
import javax.xml.rpc.Service;
import javax.xml.rpc.handler.HandlerRegistry;

public class DefaultCall
extends ModelCall {
    protected DefaultCall(InvocationContext invContext, Transport transport2, QName operationName, String inputMessageName) {
        super(invContext, transport2, operationName, inputMessageName);
    }

    protected Object doInvoke(InvocationContext invocationContext) throws RemoteException {
        invocationContext.setPastPivot(false);
        MessageContext mc = this.transport.getMessageContext(invocationContext);
        MessageContext.setCurrentThreadsContext(mc);
        JAXRPCHandlerChain handlerChain = this.getHandlerChain();
        if (handlerChain != null) {
            handlerChain.handleRequest(mc);
        }
        Object response = null;
        if (mc.isPastPivot()) {
            Object[] os = invocationContext.getOutputParams();
            if (os != null && os.length > 0) {
                response = os[0];
            }
        } else {
            response = this.invokeService(invocationContext);
            invocationContext.setPastPivot(true);
            invocationContext.setOutputParams(new Object[]{response});
            if (handlerChain != null) {
                handlerChain.handleResponse(mc);
            }
        }
        return response;
    }

    protected JAXRPCHandlerChain getHandlerChain() {
        JAXRPCHandlerChain handlerChain;
        String portName = this.invocationContext.getPortName();
        if (portName == null) {
            handlerChain = null;
        } else {
            String namespace = this.invocationContext.getServiceContext().getServiceNamespace();
            QName portQName = QNameTable.createQName(namespace, portName);
            ServiceContext sc = this.invocationContext.getServiceContext();
            Service service = sc.getProtocolSpecificService();
            HandlerRegistry hr = service.getHandlerRegistry();
            handlerChain = (JAXRPCHandlerChain)hr.getHandlerChain(portQName);
        }
        return handlerChain;
    }

    protected Object invokeService(InvocationContext invocationContext) throws RemoteException {
        QName operationName = invocationContext.getOperationName();
        Object[] inputParams = invocationContext.getInputParams();
        Class returnClass = this.getReturnClass();
        Object target = this.getTarget();
        Object response = this.transport.invoke(invocationContext, target, operationName, inputParams, returnClass);
        this.closeIfRequired(target);
        return response;
    }
}

