/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.multiprotocol;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webservices.engine.client.ClientEngine;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.metadata.ClientEntityMetaData;
import com.ibm.ws.webservices.metadata.ClientServiceMetaData;
import com.ibm.ws.webservices.multiprotocol.ServiceInformation;
import com.ibm.ws.webservices.multiprotocol.sdo.SDOConvertorException;
import com.ibm.ws.webservices.multiprotocol.sdo.SDOWSDLAdder;
import com.ibm.ws.webservices.multiprotocol.utils.DynamicServiceInformation;
import com.ibm.ws.webservices.multiprotocol.utils.ServiceManager;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.Service;

public class ServiceContext {
    protected static TraceComponent _tc = Tr.register(ServiceContext.class, "WebServices", "com.ibm.ws.webservices.multiprotocol.resources.mpMessages");
    private URL wsdlDocumentLocation;
    private Definition wsdlDefinition;
    private QName serviceName;
    private Map seiToPortTypeMapping;
    private Map portTypeToPortMapping;
    private Map namespace2PackageMapping;
    private ServiceInformation serviceInfo;
    private String defaultNamespace;
    private String serviceNamespace;
    private String locatorClassName;
    private String serviceRefName = null;
    private boolean managedEnv = false;
    private ClientEntityMetaData clientMetaData = null;
    private Map overriddingEndpointURIs = null;
    private Map overriddingBindingNamespaces = null;
    private Service protocolSpecificService;
    private ServiceManager serviceManager;
    private String sdoRepositoryKey;
    private QName sdoServiceName;
    private Service locator = null;
    private boolean dynamicRuntimeEnv = false;
    private ClientEngine clientEngine = null;

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ServiceContext: \n\tserviceName=");
        sb.append(this.serviceName != null ? this.serviceName.toString() : "<null>");
        sb.append("\n\tserviceRefName=");
        sb.append(this.serviceRefName != null ? this.serviceRefName : "<null>");
        sb.append("\n\tdefaultNamespace=");
        sb.append(this.defaultNamespace != null ? this.defaultNamespace : "<null>");
        sb.append("\n\tserviceNamespace=");
        sb.append(this.serviceNamespace != null ? this.serviceNamespace : "<null>");
        sb.append("\n\tlocatorClassName=");
        sb.append(this.locatorClassName != null ? this.locatorClassName : "<null>");
        sb.append("\n\tmanagedEnv=");
        sb.append(this.managedEnv ? "true" : "false");
        sb.append("\n\tclientReference=[");
        sb.append(this.clientMetaData != null ? this.clientMetaData.toString() : "<null>");
        sb.append("]\n\twsdlDocumentLocation=");
        sb.append(this.wsdlDocumentLocation != null ? this.wsdlDocumentLocation.toString() : "<null>");
        sb.append("\n\tWSDL Definition=\n****** WSDL Definition ******\n");
        sb.append(this.wsdlDefinition != null ? this.wsdlDefinition.toString() : "<none>");
        sb.append("\n\n****** End of WSDL Definition ******\n\n");
        return sb.toString();
    }

    public ServiceContext(URL wsdlDocumentLocation, Definition wsdlDefinition, QName serviceName) {
        this.wsdlDocumentLocation = wsdlDocumentLocation;
        this.wsdlDefinition = wsdlDefinition;
        this.serviceName = serviceName;
    }

    public URL getWSDLDocumentLocation() {
        return this.wsdlDocumentLocation;
    }

    public Definition getDefinition() {
        return this.wsdlDefinition;
    }

    public QName getServiceName() {
        return this.serviceName;
    }

    void setServiceName(QName svcName) {
        if (svcName != null) {
            this.serviceName = svcName;
        }
    }

    public Map getSEIToPortTypeMapping() {
        return this.seiToPortTypeMapping;
    }

    public void setSEIToPortTypeMapping(Map map) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "setSEIToPortTypeMapping", new Object[]{map});
        }
        this.seiToPortTypeMapping = map;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "setSEIToPortTypeMapping");
        }
    }

    public Map getPortTypeToPortMapping() {
        return this.portTypeToPortMapping;
    }

    public void setPortTypeToPortMapping(Map map) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "setPortTypeToPortMapping", new Object[]{map});
        }
        this.portTypeToPortMapping = map;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "setPortTypeToPortMapping");
        }
    }

    public Map getNamespace2PackageMapping() {
        return this.namespace2PackageMapping;
    }

    public void setNamespace2PackageMapping(Map map) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "setNamespace2PackageMapping", new Object[]{map});
        }
        this.namespace2PackageMapping = map;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "setNamespace2PackageMapping");
        }
    }

    public String getDefaultNamespace() {
        if (this.defaultNamespace == null) {
            this.defaultNamespace = "http://schemas.xmlsoap.org/wsdl/soap/";
        }
        return this.defaultNamespace;
    }

    public QName getPortQName(Port port2) {
        QName portQName = QNameTable.createQName(this.getServiceNamespace(), port2.getName());
        return portQName;
    }

    public QName getPortQName(String portName) {
        QName portQName = portName == null ? null : QNameTable.createQName(this.getServiceNamespace(), portName);
        return portQName;
    }

    public Port getNamedPort(String portName) {
        QName portQName = QNameTable.createQName(this.getServiceName().getNamespaceURI(), portName == null ? "" : portName);
        Port port2 = this.getPortForQName(portQName);
        return port2;
    }

    public void setDefaultNamespace(String string) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "setDefaultNamespace", new Object[]{string});
        }
        this.defaultNamespace = string;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "setDefaultNamespace");
        }
    }

    public void setServiceRefName(String s) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "setServiceRefName", new Object[]{s});
        }
        this.serviceRefName = s;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "setServiceRefName");
        }
    }

    public String getServiceRefName() {
        return this.serviceRefName;
    }

    public ClientServiceMetaData getClientServiceMetaData() {
        ClientServiceMetaData clientServiceMetaData = null;
        if (this.clientMetaData != null) {
            clientServiceMetaData = this.clientMetaData.getService(this.serviceRefName);
        }
        return clientServiceMetaData;
    }

    public void setClientMetaData(ClientEntityMetaData md) {
        this.clientMetaData = md;
    }

    public ClientEngine getClientEngine() {
        if (this.clientEngine != null) {
            return this.clientEngine;
        }
        if (this.clientMetaData != null) {
            return this.clientMetaData.getEngine();
        }
        return null;
    }

    public void setClientEngine(ClientEngine engine2) {
        this.clientEngine = engine2;
    }

    public Port getPortForQName(QName portQName) {
        javax.wsdl.Service wsdlService = this.getWSDLService();
        Port port2 = null;
        if (wsdlService != null && portQName != null) {
            port2 = wsdlService.getPort(portQName.getLocalPart());
        }
        return port2;
    }

    public Collection getServicePorts() {
        javax.wsdl.Service service = this.getWSDLService();
        Collection ports = service != null ? service.getPorts().values() : new ArrayList(0);
        return ports;
    }

    public javax.wsdl.Service getWSDLService() {
        javax.wsdl.Service service = null;
        Definition definition = this.getDefinition();
        if (definition != null) {
            QName serviceName = this.getServiceName();
            service = definition.getService(serviceName);
        }
        return service;
    }

    public String getServiceNamespace() {
        if (this.serviceNamespace == null) {
            QName serviceName = this.getServiceName();
            this.serviceNamespace = serviceName == null ? "" : serviceName.getNamespaceURI();
        }
        return this.serviceNamespace;
    }

    public List getPortsForPortType(QName portTypeName) {
        ArrayList<String> matchingPorts = new ArrayList<String>();
        Collection ports = this.getServicePorts();
        Iterator i = ports.iterator();
        while (i.hasNext()) {
            Port p = (Port)i.next();
            if (!p.getBinding().getPortType().getQName().equals(portTypeName)) continue;
            matchingPorts.add(p.getName());
        }
        return matchingPorts;
    }

    public String getPortBindingNamespace(Port port2) {
        List bindingExList;
        String bindingNS = null;
        Map overriddingBindingNamespaces = this.getOverriddingBindingNamespaces();
        if (overriddingBindingNamespaces != null) {
            bindingNS = (String)overriddingBindingNamespaces.get(port2.getName());
        }
        if (bindingNS == null && (bindingExList = port2.getBinding().getExtensibilityElements()) != null && bindingExList.size() > 0) {
            Iterator iter = bindingExList.iterator();
            while (iter.hasNext() && bindingNS == null) {
                ExtensibilityElement bindingFirstEx = (ExtensibilityElement)iter.next();
                if (!bindingFirstEx.getElementType().getLocalPart().equals("binding")) continue;
                bindingNS = bindingFirstEx.getElementType().getNamespaceURI();
            }
        }
        return bindingNS;
    }

    public boolean hasWSDL() {
        boolean wsdlAvailable = this.wsdlDefinition != null;
        return wsdlAvailable;
    }

    public void setLocatorName(String locatorCN) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "setLocatorName", new Object[]{locatorCN});
        }
        this.locatorClassName = locatorCN;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "setLocatorName");
        }
    }

    public String getLocatorName() {
        return this.locatorClassName;
    }

    public void setServiceInformation(ServiceInformation si) {
        this.serviceInfo = si;
    }

    public ServiceInformation getServiceInformation() {
        if (this.serviceInfo != null) {
            return this.serviceInfo;
        }
        ServiceInformation si = null;
        if (!this.dynamicRuntimeEnv) {
            String pkg;
            if (this.locatorClassName != null) {
                String base = this.locatorClassName.substring(0, this.locatorClassName.lastIndexOf("Locator"));
                String dataName = base + "Information";
                try {
                    si = (ServiceInformation)ClassUtils.forName(dataName).newInstance();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (si != null) {
                this.serviceInfo = si;
                return si;
            }
            String string = pkg = this.namespace2PackageMapping == null ? null : (String)this.namespace2PackageMapping.get(this.serviceNamespace);
            if (pkg == null) {
                String ns;
                String string2 = this.serviceNamespace != null ? this.serviceNamespace : (ns = this.serviceName != null ? this.serviceName.getNamespaceURI() : null);
                if (ns != null) {
                    pkg = JavaUtils.makePackageName(ns);
                }
            }
            if (pkg != null && pkg != "" && this.serviceName != null) {
                String sn = JavaUtils.xmlNameToJavaClass(this.serviceName.getLocalPart());
                String full = pkg + "." + sn + "Information";
                try {
                    si = (ServiceInformation)ClassUtils.forName(full).newInstance();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        if (si == null && this.serviceName != null && (this.wsdlDocumentLocation != null || this.wsdlDefinition != null)) {
            si = new DynamicServiceInformation(this.wsdlDefinition, this.wsdlDocumentLocation == null ? null : this.wsdlDocumentLocation.toString(), this.serviceName);
        }
        this.serviceInfo = si;
        return si;
    }

    public Map getOperationDescriptions(String portName) {
        ServiceInformation si = this.getServiceInformation();
        if (si == null) {
            return null;
        }
        return si.getOperationDescriptions(portName);
    }

    public List getOperationDescriptions(String portName, String operationName) {
        ServiceInformation si = this.getServiceInformation();
        if (si == null) {
            return null;
        }
        return si.getOperationDescriptions(portName, operationName);
    }

    public Map getTypeMappings() {
        ServiceInformation si = this.getServiceInformation();
        if (si == null) {
            return null;
        }
        return si.getTypeMappings();
    }

    public boolean isManagedEnvironment() {
        return this.managedEnv;
    }

    public void setManagedEnvironment(boolean b) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "setManagedEnvironment", new Object[]{new Boolean(b)});
        }
        this.managedEnv = b;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "setManagedEnvironment");
        }
    }

    public void setOverriddingEndpointURIs(Map overridingEndpointURIs) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "setOverriddingEndpointURIs", new Object[]{overridingEndpointURIs});
        }
        this.overriddingEndpointURIs = overridingEndpointURIs;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "setOverriddingEndpointURIs");
        }
    }

    public Map getOverriddingEndpointURIs() {
        return this.overriddingEndpointURIs;
    }

    public void setOverriddingBindingNamespaces(Map overriddingBindingNamespaces) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "setOverriddingBindingNamespaces", new Object[]{overriddingBindingNamespaces});
        }
        this.overriddingBindingNamespaces = overriddingBindingNamespaces;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "setOverriddingBindingNamespaces");
        }
    }

    public Map getOverriddingBindingNamespaces() {
        return this.overriddingBindingNamespaces;
    }

    public Service getProtocolSpecificService() {
        return this.protocolSpecificService;
    }

    public void setProtocolSpecificService(Service service) {
        this.protocolSpecificService = service;
    }

    public ServiceManager getServiceManager() {
        return this.serviceManager;
    }

    public void setServiceManager(ServiceManager manager) {
        this.serviceManager = manager;
    }

    public String getSdoRepositoryKey() {
        if (this.sdoRepositoryKey == null) {
            this.sdoRepositoryKey = this.initSDORepositoryKey();
        }
        return this.sdoRepositoryKey;
    }

    public void setSdoRepositoryKey(String string) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "setSdoRepositoryKey", new Object[]{string});
        }
        this.sdoRepositoryKey = string;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "setSdoRepositoryKey");
        }
    }

    protected String initSDORepositoryKey() {
        URL wsdlURL = this.getWSDLDocumentLocation();
        if (wsdlURL == null) {
            throw new JAXRPCException("attempting to store WSDL in SDO repository but WSDL URL is null");
        }
        String wsdlLocation = wsdlURL.toString();
        ClientServiceMetaData clientServiceMetaData = this.getClientServiceMetaData();
        String sdoRepositoryKey = clientServiceMetaData != null ? clientServiceMetaData.getName() + ":" + wsdlLocation : Thread.currentThread().getName() + ":" + wsdlLocation;
        try {
            SDOWSDLAdder.getInstance().addWSDLToSDORepository(sdoRepositoryKey, wsdlLocation);
        }
        catch (SDOConvertorException e) {
            throw new JAXRPCException("exception storing WSDL in SDO repository: " + e, e);
        }
        return sdoRepositoryKey;
    }

    public QName getSdoServiceName() {
        if (this.sdoServiceName == null) {
            this.sdoServiceName = this.getServiceName();
        }
        return this.sdoServiceName;
    }

    public void setSdoServiceName(QName name2) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "setSdoServiceName", new Object[]{name2});
        }
        this.sdoServiceName = name2;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "setSdoServiceName");
        }
    }

    public String getOverriddenProtocol(String portName) {
        String overriddenNamespace = null;
        Map overrides = this.getOverriddingBindingNamespaces();
        if (overrides != null && portName != null && (overriddenNamespace = (String)overrides.get(portName)) != null && overriddenNamespace.length() < 1) {
            overriddenNamespace = null;
        }
        return overriddenNamespace;
    }

    public boolean isProtocolOverridden(QName portQName) {
        boolean protocolOverridden = false;
        if (portQName != null) {
            protocolOverridden = this.getOverriddenProtocol(portQName.getLocalPart()) != null;
        }
        return protocolOverridden;
    }

    public boolean isNonBoundWSDL() {
        Port port2;
        Binding binding;
        Map ports;
        boolean nonBound = false;
        javax.wsdl.Service service = this.getWSDLService();
        if (service != null && (ports = service.getPorts()) != null && ports.size() == 1 && (binding = (port2 = (Port)ports.get(ports.keySet().iterator().next())).getBinding()) != null) {
            List ees = binding.getExtensibilityElements();
            nonBound = ees == null || ees.size() == 0;
        }
        return nonBound;
    }

    void setGeneratedService(Service loc) {
        this.locator = loc;
    }

    public Service getGeneratedService() {
        return this.locator;
    }

    public boolean isDynamicRuntimeEnv() {
        return this.dynamicRuntimeEnv;
    }

    public void setDynamicRuntimeEnv(boolean val) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "setDynamicRuntimeEnv", new Object[]{new Boolean(val)});
        }
        this.dynamicRuntimeEnv = val;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "setDynamicRuntimeEnv");
        }
    }
}

