/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.multiprotocol;

import com.ibm.ws.webservices.engine.description.OperationDesc;
import com.ibm.ws.webservices.engine.description.ParameterDesc;
import com.ibm.ws.webservices.multiprotocol.ServiceContext;
import com.ibm.ws.webservices.multiprotocol.sdo.SDOConvertor;
import com.ibm.ws.webservices.multiprotocol.sdo.SDOConvertorException;
import com.ibm.ws.webservices.multiprotocol.sdo.SDOConvertorFactory;
import commonj.sdo.DataGraph;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;

public class InvocationContext {
    private ServiceContext serviceContext = null;
    private Class generatedStubClass;
    private String endpoint;
    private String initialEndpoint;
    private Class seiClass;
    private String portName;
    private QName operationName;
    private String inputMessageName;
    private boolean oneWay;
    private boolean pastPivot;
    private Class[] inputParameterTypes;
    private Object[] inputParams;
    private Object[] outputParams;
    private HashMap properties = new HashMap();
    private List requestPropertyNames;
    private DataGraph inputDataGraph;
    private DataGraph outputDataGraph;
    private SDOConvertor sdoConvertor;
    private String sdoPortName;
    private boolean protocolOverridden;
    private Boolean wsdlOperationOneWay;

    public InvocationContext(ServiceContext serviceCxt) {
        this.serviceContext = serviceCxt != null ? serviceCxt : new ServiceContext(null, null, null);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("InvocationContext: [seiClass=");
        sb.append(this.seiClass != null ? this.seiClass.getName() : "<none>");
        sb.append(", generatedStubClass=");
        sb.append(this.generatedStubClass != null ? this.generatedStubClass.getName() : "<none>");
        sb.append(", endpoint=");
        sb.append(this.endpoint != null ? this.endpoint : "<none>");
        sb.append(", portName=");
        sb.append(this.portName != null ? this.portName.toString() : "<null>");
        sb.append(", operationName=");
        sb.append(this.operationName != null ? this.operationName.toString() : "<none>");
        sb.append("]");
        return sb.toString();
    }

    public void setServiceContext(ServiceContext sc) {
        if (sc != null) {
            this.serviceContext = sc;
        }
    }

    public ServiceContext getServiceContext() {
        return this.serviceContext;
    }

    public Class getGeneratedStubClass() {
        return this.generatedStubClass;
    }

    public void setGeneratedStubClass(Class generatedStubClass) {
        this.generatedStubClass = generatedStubClass;
    }

    public boolean isUsingGeneratedStub() {
        return this.generatedStubClass != null;
    }

    public void setArgClasses(Class[] argClasses) {
        this.inputParameterTypes = argClasses;
    }

    public String getInputMessageName() {
        if (this.inputMessageName == null && this.inputDataGraph != null) {
            this.getInputParams();
        }
        return this.inputMessageName;
    }

    public String getPortName() {
        return this.portName;
    }

    public Port getPort() {
        String portName = this.getPortName();
        return this.serviceContext.getPortForQName(this.serviceContext.getPortQName(portName));
    }

    public Class getSeiClass() {
        return this.seiClass;
    }

    public void setInputMessageName(String string) {
        this.inputMessageName = string;
    }

    public void setPortName(String string) {
        this.portName = string;
    }

    public void setSeiClass(Class class1) {
        this.seiClass = class1;
    }

    public String getEndpoint() {
        Map oeu;
        if (this.endpoint == null && (oeu = this.serviceContext.getOverriddingEndpointURIs()) != null) {
            this.endpoint = (String)oeu.get(this.portName);
        }
        return this.endpoint;
    }

    public void setEndpoint(String string) {
        if (this.endpoint == null) {
            this.setInitialEndpoint(string);
        }
        this.endpoint = string;
    }

    protected Class[] getInputParameterTypes(QName operationName, int numberOfInParams) {
        if (this.inputParameterTypes != null) {
            return this.inputParameterTypes;
        }
        OperationDesc[] descs = this.getOperationDescs(operationName);
        if (descs == null) {
            return null;
        }
        ArrayList<OperationDesc> descsCands = new ArrayList<OperationDesc>();
        for (int d = 0; d < descs.length; ++d) {
            OperationDesc opDesc = descs[d];
            if (opDesc.getNumInParams() != numberOfInParams) continue;
            descsCands.add(opDesc);
        }
        ArrayList inputTypes = new ArrayList();
        boolean found = false;
        if (descsCands.size() > 1 && this.inputParams == null) {
            return null;
        }
        block1: for (int i = 0; i < descsCands.size(); ++i) {
            OperationDesc opDesc = (OperationDesc)descsCands.get(i);
            ArrayList params = opDesc.getParameters();
            ArrayList<Class> pTypes = new ArrayList<Class>();
            Iterator iter = params.iterator();
            while (iter.hasNext()) {
                Object obj;
                ParameterDesc pDesc = (ParameterDesc)iter.next();
                if (pDesc.getMode() == 2) continue;
                Class cls = pDesc.getJavaType();
                if (descsCands.size() != 1 && this.inputParams != null && (obj = this.inputParams[pTypes.size()]) != null) {
                    Class<?> objCls = obj.getClass();
                    if (!this.isAParamMatch(cls, obj)) continue block1;
                }
                pTypes.add(cls);
            }
            if (pTypes.size() != numberOfInParams) continue;
            inputTypes = pTypes;
            found = true;
            break;
        }
        if (!found) {
            return null;
        }
        this.inputParameterTypes = inputTypes.toArray(new Class[inputTypes.size()]);
        return this.inputParameterTypes;
    }

    private boolean isAParamMatch(Class cls, Object obj) {
        if (cls.isPrimitive()) {
            if (cls.getName() == "int" && obj instanceof Integer) {
                return true;
            }
            if (cls.getName() == "long" && obj instanceof Long) {
                return true;
            }
            if (cls.getName() == "boolean" && obj instanceof Boolean) {
                return true;
            }
            if (cls.getName() == "char" && obj instanceof Character) {
                return true;
            }
            if (cls.getName() == "byte" && obj instanceof Byte) {
                return true;
            }
            if (cls.getName() == "float" && obj instanceof Float) {
                return true;
            }
            if (cls.getName() == "double" && obj instanceof Double) {
                return true;
            }
            if (cls.getName() == "short" && obj instanceof Short) {
                return true;
            }
        }
        return cls.isAssignableFrom(obj.getClass());
    }

    public QName[] getInputParameterNames(QName operationName, int numberOfInParams) {
        OperationDesc[] descs = this.getOperationDescs(operationName);
        if (descs == null) {
            return null;
        }
        ArrayList<QName> pNames = new ArrayList<QName>();
        boolean found = false;
        for (int i = 0; i < descs.length; ++i) {
            OperationDesc opDesc = descs[i];
            if (opDesc.getNumInParams() != numberOfInParams) continue;
            ArrayList params = opDesc.getParameters();
            if (found) {
                return null;
            }
            found = true;
            Iterator iter = params.iterator();
            while (iter.hasNext()) {
                ParameterDesc pDesc = (ParameterDesc)iter.next();
                if (pDesc.getMode() == 2) continue;
                QName name2 = pDesc.getQName();
                pNames.add(name2);
            }
        }
        return pNames.toArray(new QName[pNames.size()]);
    }

    public Class getReturnType() {
        QName operationName = this.getOperationName();
        Object[] temp = this.getInputParams();
        int paramsLength = 0;
        if (temp != null) {
            paramsLength = temp.length;
        }
        Class returnClass = this.getReturnType(operationName, paramsLength);
        return returnClass;
    }

    public Class getReturnType(QName operationName, int numberOfInParams) {
        OperationDesc[] descs = this.getOperationDescs(operationName);
        if (descs == null) {
            return null;
        }
        Class retType = null;
        boolean found = false;
        for (int i = 0; i < descs.length; ++i) {
            OperationDesc opDesc = descs[i];
            if (opDesc.getNumInParams() != numberOfInParams) continue;
            if (found) {
                return null;
            }
            found = true;
            retType = opDesc.getReturnClass();
        }
        return retType;
    }

    protected OperationDesc[] getOperationDescs(QName operationName) {
        if (operationName == null || this.portName == null) {
            return null;
        }
        String opName = operationName.getLocalPart();
        if (opName == null) {
            return null;
        }
        List list = this.serviceContext.getOperationDescriptions(this.portName, opName);
        if (list == null) {
            return null;
        }
        return list.toArray(new OperationDesc[list.size()]);
    }

    public Object getProperty(String name2) {
        return this.properties.get(name2);
    }

    public void setProperty(String name2, Object value2) {
        this.properties.put(name2, value2);
        if ("com.ibm.websphere.webservices.protocolNamespace".equals(name2)) {
            this.setProtocolOverridden(false);
        }
    }

    public void removeProperty(String name2) {
        this.properties.remove(name2);
    }

    public boolean isPropertiesSet(String name2) {
        return this.properties.keySet().contains(name2);
    }

    public List getPropertyNames() {
        return new ArrayList(this.properties.keySet());
    }

    public List getRequestPropertyNames() {
        return this.requestPropertyNames;
    }

    public void setRequestPropertyNames(List propertyNames) {
        this.requestPropertyNames = propertyNames;
    }

    public QName getOperationName() {
        if (this.operationName == null && this.inputDataGraph != null) {
            this.getInputParams();
        }
        return this.operationName;
    }

    public void setOperationName(QName name2) {
        if (name2 != null || !name2.equals(this.operationName)) {
            this.wsdlOperationOneWay = null;
        }
        this.operationName = name2;
    }

    public Object[] getInputParams() {
        if (this.inputParams == null && this.inputDataGraph != null) {
            SDOConvertor sdoConvertor = this.getSDOConvertor();
            sdoConvertor.setDataGraph(this.inputDataGraph);
            try {
                this.inputParams = sdoConvertor.getParameterValues();
                this.setInputParameterTypes(sdoConvertor.getParameterTypes());
                this.setOperationName(new QName(sdoConvertor.getOperationName()));
                this.setInputMessageName(sdoConvertor.getMessageName());
            }
            catch (SDOConvertorException e) {
                throw new JAXRPCException("exception getting input parameters: " + e, e);
            }
        }
        return this.inputParams;
    }

    public Object[] getOutputParams() {
        if (this.outputParams == null && this.outputDataGraph != null) {
            SDOConvertor sdoConvertor = this.getSDOConvertor();
            sdoConvertor.setDataGraph(this.outputDataGraph);
            try {
                this.outputParams = sdoConvertor.getParameterValues();
            }
            catch (SDOConvertorException e) {
                throw new JAXRPCException("exception getting output parameters: " + e, e);
            }
        }
        return this.outputParams;
    }

    public Object getOutputObject() {
        Object[] os = this.getOutputParams();
        Object responseObject = os.length > 0 ? os[0] : null;
        return responseObject;
    }

    public void setInputParams(Object[] objects) {
        this.inputParams = objects;
    }

    public void setOutputParams(Object[] objects) {
        this.outputParams = objects;
    }

    public boolean isOneWay() {
        if (this.wsdlOperationOneWay == null && this.serviceContext.getDefinition() != null) {
            List tempOps;
            this.wsdlOperationOneWay = new Boolean(false);
            Port tempPort = this.getPort();
            if (tempPort != null && this.operationName != null && (tempOps = tempPort.getBinding().getPortType().getOperations()) != null) {
                Iterator it = tempOps.iterator();
                while (it.hasNext()) {
                    Operation op = (Operation)it.next();
                    if (!this.operationName.getLocalPart().equals(op.getName()) || op.getOutput() != null) continue;
                    this.wsdlOperationOneWay = new Boolean(true);
                }
            }
        }
        if (this.wsdlOperationOneWay != null) {
            return this.wsdlOperationOneWay != false ? true : this.oneWay;
        }
        return this.oneWay;
    }

    public void setOneWay(boolean b) {
        this.oneWay = b;
    }

    public boolean isPastPivot() {
        return this.pastPivot;
    }

    public void setPastPivot(boolean b) {
        this.pastPivot = b;
        if (this.pastPivot) {
            this.setRequestPropertyNames(new ArrayList(this.properties.keySet()));
        }
    }

    public String getInitialEndpoint() {
        return this.initialEndpoint;
    }

    public void setInitialEndpoint(String initialEndpoint) {
        this.initialEndpoint = initialEndpoint;
    }

    public Class[] getInputParameterTypes() {
        if (this.inputParameterTypes == null) {
            this.inputParameterTypes = this.inputParams == null || this.inputParams.length < 1 ? new Class[0] : this.getInputParameterTypes(this.operationName, this.inputParams.length);
        }
        return this.inputParameterTypes;
    }

    public void setInputParameterTypes(Class[] classes) {
        this.inputParameterTypes = classes;
    }

    public SDOConvertor getSDOConvertor() {
        if (this.sdoConvertor == null) {
            ServiceContext sc = this.getServiceContext();
            String sdoRepositoryKey = sc.getSdoRepositoryKey();
            QName sdoServiceQName = sc.getSdoServiceName();
            String sdoPortName = this.getSdoPortName();
            Map typeMappings = sc.getTypeMappings();
            try {
                this.sdoConvertor = SDOConvertorFactory.getSDOConvertor(sdoServiceQName, sdoPortName, sdoRepositoryKey, typeMappings);
            }
            catch (SDOConvertorException e) {
                throw new JAXRPCException("exception getting SDOConvertor", e);
            }
        }
        return this.sdoConvertor;
    }

    public DataGraph getInputDataGraph() {
        if (this.inputDataGraph == null && this.inputParams != null) {
            SDOConvertor sdoConvertor = this.getSDOConvertor();
            sdoConvertor.setParameterValues(this.getOperationName().getLocalPart(), this.inputParams, this.getInputParameterTypes(), true);
            try {
                this.inputDataGraph = sdoConvertor.getDataGraph();
            }
            catch (SDOConvertorException e) {
                throw new JAXRPCException("exception getting DataGraph: " + e, e);
            }
        }
        return this.inputDataGraph;
    }

    public void setInputDataGraph(DataGraph graph) {
        this.inputDataGraph = graph;
    }

    public DataGraph getOutputDataGraph() {
        if (this.outputDataGraph == null && this.outputParams != null) {
            SDOConvertor sdoConvertor = this.getSDOConvertor();
            sdoConvertor.setParameterValues(this.getOperationName().getLocalPart(), this.outputParams, null, false);
            try {
                this.outputDataGraph = sdoConvertor.getDataGraph();
            }
            catch (SDOConvertorException e) {
                throw new JAXRPCException("exception getting DataGraph: " + e, e);
            }
        }
        return this.outputDataGraph;
    }

    public void setOutputDataGraph(DataGraph graph) {
        this.outputDataGraph = graph;
    }

    public String getSdoPortName() {
        if (this.sdoPortName == null) {
            this.sdoPortName = this.getPortName();
        }
        return this.sdoPortName;
    }

    public void setSdoPortName(String name2) {
        this.sdoPortName = name2;
    }

    public boolean isProtocolOverridden() {
        return this.protocolOverridden;
    }

    public void setProtocolOverridden(boolean b) {
        this.protocolOverridden = b;
    }
}

