/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.multiprotocol;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.utils.Namespaces;
import com.ibm.ws.webservices.multiprotocol.AgnosticService;
import com.ibm.ws.webservices.multiprotocol.ServiceContext;
import com.ibm.ws.webservices.multiprotocol.discovery.ServiceProviderManager;
import com.ibm.ws.webservices.multiprotocol.provider.ServiceProvider;
import com.ibm.ws.webservices.multiprotocol.resources.Messages;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Properties;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.ServiceFactory;

public class AgnosticServiceFactory
extends ServiceFactory
implements com.ibm.wsspi.webservices.rpc.ServiceFactory {
    protected ServiceProviderManager serviceProviderManager;
    protected static TraceComponent _tc = Tr.register(AgnosticServiceFactory.class, "WebServices", "com.ibm.ws.webservices.multiprotocol.resources.mpMessages");
    private String whichGlobalHandlersToUse = "DEFAULT";
    private static final String PACKAGE_SEPERATOR = ".";

    protected TraceComponent getTraceObj() {
        return _tc;
    }

    public Service createService(URL wsdlDocumentLocation, QName serviceName) throws ServiceException {
        if (this.getTraceObj().isEntryEnabled()) {
            Tr.entry(this.getTraceObj(), "createService(URL,QName)");
        }
        if (serviceName == null) {
            throw new ServiceException(Messages.getMessage("null_argument", "serviceName"));
        }
        Definition wsdlDefinition = this.getDefinitionFromURL(wsdlDocumentLocation);
        if (wsdlDefinition == null) {
            throw new ServiceException(Messages.getMessage("noWsdlDefn", wsdlDocumentLocation.toString()));
        }
        javax.wsdl.Service svc = wsdlDefinition.getService(serviceName);
        if (svc == null) {
            throw new ServiceException(Messages.getMessage("noWsdlService", wsdlDocumentLocation.toString(), serviceName.toString()));
        }
        ServiceProviderManager serviceProviderManager = this.getServiceProviderManager();
        ServiceContext context = new ServiceContext(wsdlDocumentLocation, wsdlDefinition, serviceName);
        AgnosticService service = new AgnosticService(context, serviceProviderManager);
        if (this.getTraceObj().isEntryEnabled()) {
            Tr.exit(this.getTraceObj(), "createService(URL,QName)");
        }
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Service createService(QName serviceName) throws ServiceException {
        if (this.getTraceObj().isEntryEnabled()) {
            Tr.entry(this.getTraceObj(), "createService(QName)");
        }
        AgnosticService service = null;
        try {
            ServiceProviderManager serviceProviderManager = this.getServiceProviderManager();
            ServiceContext context = new ServiceContext(null, null, serviceName);
            service = new AgnosticService(context, serviceProviderManager);
            Object var6_5 = null;
            if (!this.getTraceObj().isEntryEnabled()) return service;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (!this.getTraceObj().isEntryEnabled()) throw throwable;
            Tr.exit(this.getTraceObj(), "createService(QName)");
            throw throwable;
        }
        Tr.exit(this.getTraceObj(), "createService(QName)");
        return service;
    }

    protected Service createService(QName serviceName, ServiceContext context) {
        ServiceProviderManager serviceProviderManager = this.getServiceProviderManager();
        if (this.getTraceObj().isEntryEnabled()) {
            Tr.entry(this.getTraceObj(), "createService(QName,ServiceContext)");
        }
        AgnosticService service = new AgnosticService(context, serviceProviderManager);
        if (this.getTraceObj().isEntryEnabled()) {
            Tr.exit(this.getTraceObj(), "createService(QName,ServiceContext)");
        }
        return service;
    }

    public Service loadService(Class serviceInterface) throws ServiceException {
        return this.findGeneratedServiceLocator(serviceInterface.getName(), serviceInterface);
    }

    public Service loadService(URL wsdlDocumentLocation, Class serviceInterface, Properties properties) throws ServiceException {
        return this.findGeneratedServiceLocator(serviceInterface.getName(), serviceInterface);
    }

    public Service loadService(URL wsdlDocumentLocation, QName serviceName, Properties properties) throws ServiceException {
        Namespaces namespaces = this.getNs2PkgMapping(properties);
        String javaPackage = namespaces.getCreate(serviceName.getNamespaceURI());
        String serviceClass = javaPackage + PACKAGE_SEPERATOR + serviceName.getLocalPart();
        return this.findGeneratedServiceLocator(serviceClass, null);
    }

    private Namespaces getNs2PkgMapping(Properties properties) {
        Namespaces namespaces = new Namespaces(null, PACKAGE_SEPERATOR.charAt(0));
        if (properties != null) {
            Enumeration<Object> keys = properties.keys();
            while (keys.hasMoreElements()) {
                String namespaceProperty = (String)keys.nextElement();
                String packageProperty = (String)properties.get(namespaceProperty);
                namespaces.put(namespaceProperty, packageProperty);
            }
        }
        return namespaces;
    }

    private Service findGeneratedServiceLocator(String serviceClassFQName, Class serviceInterface) throws ServiceException {
        String translatedMessage;
        String generatedServiceLocator = serviceClassFQName + "Locator";
        ClassLoader classloader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        Class<?> serviceClass = null;
        Service service = null;
        try {
            serviceClass = classloader.loadClass(generatedServiceLocator);
        }
        catch (ClassNotFoundException ex) {
            Tr.error(_tc, "noClassForService00", generatedServiceLocator);
        }
        if (serviceInterface == null) {
            try {
                serviceInterface = classloader.loadClass(serviceClassFQName);
            }
            catch (ClassNotFoundException ex) {
                Tr.error(_tc, "noClassForService00", serviceClassFQName);
            }
        }
        if (serviceClass != null) {
            if (!Service.class.isAssignableFrom(serviceInterface)) {
                translatedMessage = Messages.getMessage("mustSubclassService", serviceInterface.getName());
                Tr.error(_tc, "mustSubclassService", serviceInterface.getName());
                throw new ServiceException(translatedMessage);
            }
            if (!serviceInterface.isAssignableFrom(serviceClass)) {
                translatedMessage = Messages.getMessage("mustSubclassServiceInterface", serviceInterface.getName(), serviceClass.getName());
                Tr.error(_tc, "mustSubclassServiceInterface", new Object[]{serviceInterface.getName(), serviceClass.getName()});
                throw new ServiceException(translatedMessage);
            }
            try {
                service = this.constructServiceLocator(serviceClass);
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.multiprotocol.AgnosticServiceFactory.findGeneratedServiceLocator", "459", this);
                String translatedMessage2 = Messages.getMessage("cantInstantiateClass", serviceClass.getName());
                Tr.error(_tc, "cantInstantiateClass", serviceClass.getName());
                throw new ServiceException(translatedMessage2, ex);
            }
            return service;
        }
        translatedMessage = Messages.getMessage("noClassForService00", generatedServiceLocator);
        Tr.error(_tc, "noClassForService00", generatedServiceLocator);
        throw new ServiceException(translatedMessage);
    }

    public void setServiceProvider(String namespace, ServiceProvider serviceProvider) {
        ServiceProviderManager spm = this.getServiceProviderManager();
        spm.overrideDefaultServiceProvider(namespace, serviceProvider);
    }

    protected ServiceProviderManager getServiceProviderManager() {
        if (this.serviceProviderManager == null) {
            this.serviceProviderManager = new ServiceProviderManager();
        }
        return this.serviceProviderManager;
    }

    protected Definition getDefinitionFromURL(URL wsdlDocumentLocation) throws ServiceException {
        Definition definition;
        WSDLFactory wsdlFactory = this.getServiceProviderManager().getWSDLFactory();
        WSDLReader wsdlReader = wsdlFactory.newWSDLReader();
        try {
            definition = wsdlReader.readWSDL(null, wsdlDocumentLocation.toString());
        }
        catch (WSDLException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.multiprotocol.AgnosticServiceFactory.getDefinitionFromURL", "281", this);
            throw new ServiceException(Messages.getMessage("wsdlReadError", wsdlDocumentLocation.toString()));
        }
        return definition;
    }

    private Service constructServiceLocator(Class serviceClass) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        Service service = null;
        service = (Service)serviceClass.newInstance();
        if (service instanceof AgnosticService) {
            ((AgnosticService)service).useGlobalHandlers(this.whichGlobalHandlersToUse);
        }
        return service;
    }

    public void useGlobalHandlers(String whichGlobalHandlersToUse) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "useGlobalHandlers");
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "com.ibm.ws.webservices.multiprotocol.AgnosticServiceFactory.useGlobalHandlers(whichGlobalHandlersToUse): setting handlers-to-use to " + whichGlobalHandlersToUse);
        }
        if ("DEFAULT".equals(whichGlobalHandlersToUse) || "APPLICATION_ENGINE".equals(whichGlobalHandlersToUse) || "SYSTEM_ENGINE".equals(whichGlobalHandlersToUse)) {
            this.whichGlobalHandlersToUse = whichGlobalHandlersToUse;
        } else {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "com.ibm.ws.webservices.multiprotocol.AgnosticServiceFactory.useGlobalHandlers(whichGlobalHandlersToUse): Ignoring invalid parameter value " + whichGlobalHandlersToUse);
            }
            this.whichGlobalHandlersToUse = "DEFAULT";
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "useGlobalHandlers");
        }
    }
}

