/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.multiprotocol;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.webservices.rpc.IBMCall;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.client.Service;
import com.ibm.ws.webservices.engine.description.ParameterDesc;
import com.ibm.ws.webservices.multiprotocol.InvocationContext;
import com.ibm.ws.webservices.multiprotocol.ServiceContext;
import com.ibm.ws.webservices.multiprotocol.models.ModelCall;
import com.ibm.ws.webservices.multiprotocol.models.ModelService;
import com.ibm.ws.webservices.multiprotocol.resources.Messages;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Port;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.xml.namespace.QName;
import javax.xml.rpc.Call;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.ParameterMode;
import javax.xml.rpc.ServiceException;

public class AgnosticCall
extends ModelCall {
    private static final TraceComponent _tc = Tr.register(AgnosticCall.class, "WebServices", "com.ibm.ws.webservices.multiprotocol.resources.mpMessages");
    protected Call protocolSpecificCall;
    private int numberOfParamsSet = 0;

    protected AgnosticCall(InvocationContext invContext, QName operationName, String inputMessageName) {
        super(invContext, null, operationName, inputMessageName);
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "AgnosticCall ctor");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "AgnosticCall ctor");
        }
    }

    protected Object doInvoke(InvocationContext invocationContext) throws RemoteException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object invoke(Object[] inputParams) throws RemoteException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "invoke(Object[])");
        }
        Object response = null;
        this.invocationContext.setPastPivot(false);
        try {
            Call call = null;
            try {
                call = this.getProtocolSpecificCall();
            }
            catch (ServiceException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.multiprotocol.AgnosticCall.invoke", "142", this);
                throw new RemoteException(Messages.getMessage("errorProtCall0", "ServiceException", e.toString()), e);
            }
            if (call instanceof ModelCall) {
                ModelCall modelCall = (ModelCall)call;
                response = modelCall.invoke(this.operationName, this.inputMessageName, inputParams);
            } else {
                response = call.invoke(inputParams);
            }
            this.invocationContext.setOutputParams(new Object[]{response});
            Object var6_6 = null;
            if (!_tc.isEntryEnabled()) return response;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (!_tc.isEntryEnabled()) throw throwable;
            Tr.exit(_tc, "invoke(Object[])");
            throw throwable;
        }
        Tr.exit(_tc, "invoke(Object[])");
        return response;
    }

    public Object invoke(QName operationName, Object[] inputParams) throws RemoteException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "invoke(QName,Object[])");
        }
        Object o = this.invoke(operationName, this.inputMessageName, inputParams);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "invoke(QName,Object[])");
        }
        return o;
    }

    public Object invoke(QName operationName, String inputMessageName, Object[] inputParams) throws RemoteException {
        Call call;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "invoke(QName,String,Object[])");
        }
        Object response = null;
        this.invocationContext.setPastPivot(false);
        try {
            call = this.getProtocolSpecificCall();
        }
        catch (ServiceException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.multiprotocol.AgnosticCall.invoke", "174", this);
            throw new RemoteException(Messages.getMessage("errorProtCall0", "ServiceException", e.toString()), e);
        }
        if (call instanceof ModelCall) {
            ModelCall modelCall = (ModelCall)call;
            response = modelCall.invoke(operationName, inputMessageName, inputParams);
        } else {
            response = call.invoke(operationName, inputParams);
        }
        this.invocationContext.setOutputParams(new Object[]{response});
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "invoke(QName,String,Object[])");
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void invokeOneWay(Object[] inputParams) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "invokeOneWay(Object[])");
        }
        Object response = null;
        this.invocationContext.setPastPivot(false);
        try {
            Call call = null;
            try {
                call = this.getProtocolSpecificCall();
            }
            catch (ServiceException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.multiprotocol.AgnosticCall.invokeOneWay", "143", this);
                throw new JAXRPCException(Messages.getMessage("errorProtCall0", "ServiceException", e.toString()), e);
            }
            if (call instanceof ModelCall) {
                ModelCall modelCall = (ModelCall)call;
                modelCall.setInputMessageName(this.inputMessageName);
                modelCall.setOperationName(this.operationName);
            }
            call.invokeOneWay(inputParams);
            Object var6_6 = null;
            if (!_tc.isEntryEnabled()) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (!_tc.isEntryEnabled()) throw throwable;
            Tr.exit(_tc, "invokeOneWay(Object[])");
            throw throwable;
        }
        Tr.exit(_tc, "invokeOneWay(Object[])");
    }

    public QName getOperationName() {
        return this.protocolSpecificCall != null ? this.protocolSpecificCall.getOperationName() : this.operationName;
    }

    public void setOperationName(QName opName) {
        this.operationName = opName;
        if (this.protocolSpecificCall != null) {
            this.protocolSpecificCall.setOperationName(opName);
        }
    }

    public Map getOutputParams() {
        if (this.protocolSpecificCall != null) {
            return this.protocolSpecificCall.getOutputParams();
        }
        throw new JAXRPCException(Messages.getMessage("noOutputForGetOutput", "getOutputParams"));
    }

    public List getOutputValues() {
        if (this.protocolSpecificCall != null) {
            return this.protocolSpecificCall.getOutputValues();
        }
        throw new JAXRPCException(Messages.getMessage("noOutputForGetOutput", "getOutputValues"));
    }

    protected void doUnknownPortExtensibilityElement(Port port2, ExtensibilityElement ee) {
        if (ee instanceof SOAPAddress) {
            String soapEndpoint = ((SOAPAddress)ee).getLocationURI();
            this.setTargetEndpointAddress(soapEndpoint);
        } else {
            super.doUnknownPortExtensibilityElement(port2, ee);
        }
    }

    protected Call getProtocolSpecificCall() throws ServiceException {
        if (this.protocolSpecificCall == null) {
            String portName = this.invocationContext.getPortName();
            String namespace = this.getProtocolNamespace(portName);
            ServiceContext serviceContext = this.invocationContext.getServiceContext();
            javax.xml.rpc.Service service = serviceContext.getServiceManager().getServiceForNamespace(namespace);
            this.invocationContext.getServiceContext().setProtocolSpecificService(service);
            QName portQName = null;
            if (portName != null) {
                portQName = this.invocationContext.getServiceContext().getPortQName(portName);
            }
            this.protocolSpecificCall = this.createCall(service, portQName);
            this.copyProperties(this.protocolSpecificCall);
        }
        this.initialiseCall(this.protocolSpecificCall);
        return this.protocolSpecificCall;
    }

    protected String getProtocolNamespace(String portName) {
        String endpoint;
        ServiceContext serviceContext;
        javax.wsdl.Service wsdlService;
        String protocolNamespace = (String)this.getProperty("com.ibm.websphere.webservices.protocolNamespace");
        if ((protocolNamespace == null || protocolNamespace.length() < 1) && portName != null && portName.length() > 1 && (wsdlService = (serviceContext = this.invocationContext.getServiceContext()).getWSDLService()) != null) {
            Port port2 = wsdlService.getPort(portName);
            protocolNamespace = serviceContext.getPortBindingNamespace(port2);
        }
        if ((protocolNamespace == null || protocolNamespace.length() < 1) && (endpoint = this.invocationContext.getEndpoint()) != null && endpoint.startsWith("sib")) {
            protocolNamespace = "http://www.ibm.com/ns/2004/02/wsdl/mp/sib";
        }
        if (protocolNamespace == null || protocolNamespace.length() < 1) {
            protocolNamespace = this.invocationContext.getServiceContext().getDefaultNamespace();
        }
        return protocolNamespace;
    }

    public void removeAllParameters() {
        super.initialize();
        this.numberOfParamsSet = 0;
        if (this.protocolSpecificCall != null) {
            this.protocolSpecificCall.removeAllParameters();
        }
    }

    protected Call createCall(javax.xml.rpc.Service service, QName portQName) throws ServiceException {
        Call call;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "createCall(Service,QName)");
        }
        if (this.operationName == null) {
            call = service instanceof ModelService ? ((ModelService)service).createCall(portQName, null, null, this.invocationContext) : (portQName == null ? service.createCall() : service.createCall(portQName));
        } else if (service instanceof ModelService) {
            ModelService modelService = (ModelService)service;
            call = modelService.createCall(portQName, this.operationName, this.inputMessageName, this.invocationContext);
        } else if (service instanceof Service) {
            Service maelstromService = (Service)service;
            call = maelstromService.createCall(portQName, this.operationName.getLocalPart(), this.inputMessageName);
            if (call.getOperationName().getNamespaceURI().length() != 0) {
                this.operationName = call.getOperationName();
            } else if (this.operationName.getNamespaceURI().length() > 0) {
                call.setOperationName(this.operationName);
            }
            if (this.invocationContext != null && this.invocationContext.getServiceContext() != null && this.invocationContext.getServiceContext().getClientServiceMetaData() != null && this.invocationContext.getServiceContext().getClientServiceMetaData().getLoadStrategy() != null) {
                try {
                    maelstromService.setWsdlLoadStrategyPath(this.invocationContext.getServiceContext().getClientServiceMetaData().getLoadStrategy().getAbsolutePath());
                }
                catch (Exception e) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Setting of wsdlLoadStrategyPath failed with Exception, processing continues: ", e);
                    }
                }
            }
        } else {
            Call call2 = call = portQName == null ? service.createCall() : service.createCall(portQName);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "createCall(Service,QName)");
        }
        return call;
    }

    protected void initialiseCall(Call call) {
        String endpoint;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "initialiseCall");
        }
        if ((endpoint = this.getTargetEndpointAddress()) != null) {
            call.setTargetEndpointAddress(endpoint);
        }
        if (call.isParameterAndReturnSpecRequired(this.getOperationName())) {
            for (int i = this.numberOfParamsSet; i < this.parameters.size(); ++i) {
                ParameterDesc param = (ParameterDesc)this.parameters.get(i);
                QName name2 = param.getQName();
                QName type = param.getTypeQName();
                Class clazz = param.getJavaType();
                byte mode = param.getMode();
                ParameterMode parameterMode = ParameterMode.IN;
                if (mode == 3) {
                    parameterMode = ParameterMode.INOUT;
                } else if (mode == 2) {
                    parameterMode = ParameterMode.OUT;
                }
                if (clazz == null) {
                    if (call instanceof IBMCall) {
                        ((IBMCall)call).addParameter(name2, type, parameterMode);
                    } else {
                        call.addParameter(name2.getLocalPart(), type, parameterMode);
                    }
                } else if (call instanceof IBMCall) {
                    ((IBMCall)call).addParameter(name2, type, parameterMode);
                } else {
                    call.addParameter(name2.getLocalPart(), type, clazz, parameterMode);
                }
                ++this.numberOfParamsSet;
            }
            if (this.returnParameter != null) {
                Class javaType = this.returnParameter.getJavaType();
                if (javaType == null) {
                    call.setReturnType(this.returnParameter.getTypeQName());
                } else {
                    call.setReturnType(this.returnParameter.getTypeQName(), this.returnParameter.getJavaType());
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "initialiseCall");
        }
    }

    protected void copyProperties(Call call) {
        Iterator i = this.invocationContext.getPropertyNames().iterator();
        while (i.hasNext()) {
            String propertyName = (String)i.next();
            if (propertyName.equals("javax.xml.rpc.service.endpoint.address")) {
                call.setTargetEndpointAddress(this.invocationContext.getEndpoint());
                continue;
            }
            Object propertyValue = this.invocationContext.getProperty(propertyName);
            call.setProperty(propertyName, propertyValue);
        }
    }

    protected void setSpecialProperty(String name2, Object value2) {
        Call call;
        try {
            call = this.getProtocolSpecificCall();
        }
        catch (ServiceException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.multiprotocol.AgnosticCall.setSpecialProperty", "408", this);
            throw new JAXRPCException(Messages.getMessage("errorProtCall0", "ServiceException", e.toString()), e);
        }
        call.setProperty(name2, value2);
    }

    protected void doSetProperty(String name2, Object value2) {
        super.doSetProperty(name2, value2);
        if (this.protocolSpecificCall != null) {
            this.protocolSpecificCall.setProperty(name2, value2);
        }
    }

    public void setTargetEndpointAddress(String address) {
        if (!this.invocationContext.isProtocolOverridden()) {
            super.setTargetEndpointAddress(address);
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "AgnosticCall.setTargetEndpointAddress ignoring client endpoint: " + address);
        }
    }
}

