/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.modutils;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.webservice.wscbnd.ClientBinding;
import com.ibm.etools.webservice.wscbnd.ComponentScopedRefs;
import com.ibm.etools.webservice.wscbnd.DefaultMapping;
import com.ibm.etools.webservice.wscbnd.ServiceRef;
import com.ibm.ws.webservices.modutils.PreferredPortDescriptor;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.EList;

public class ClientBndUtil {
    protected static final TraceComponent tc = Tr.register(ClientBndUtil.class, "WebServices", "com.ibm.ws.webservices.deploy.resources.deployMessages");
    private ClientBinding clientBinding = null;
    private HashMap preferredPortMappings = new HashMap();

    public ClientBndUtil(ClientBinding clientBinding) {
        this.clientBinding = clientBinding;
    }

    public void setupPreferredPortMappings(HashMap partialMap, String serviceName, String ejbName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setupPreferredPortMappings", new Object[]{serviceName, ejbName});
        }
        this.preferredPortMappings = partialMap;
        if (this.clientBinding != null) {
            EList scopedRefs = this.clientBinding.getComponentScopedRefs();
            EList serviceRefs = null;
            if (scopedRefs != null && scopedRefs.size() > 0) {
                Iterator scopes = scopedRefs.iterator();
                if (scopes != null) {
                    while (scopes.hasNext()) {
                        ComponentScopedRefs csRef = (ComponentScopedRefs)scopes.next();
                        String csEjbName = csRef.getComponentNameLink();
                        if (!ejbName.equals(csEjbName)) continue;
                        serviceRefs = csRef.getServiceRefs();
                        if (serviceRefs != null) {
                            this.addChoices(serviceRefs, serviceName, ejbName);
                        }
                        break;
                    }
                }
            } else {
                serviceRefs = this.clientBinding.getServiceRefs();
                this.addChoices(serviceRefs, serviceName, ejbName);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setupPreferredPortMappings");
        }
    }

    private void addChoices(EList serviceRefs, String serviceName, String ejbName) {
        Iterator services = serviceRefs.iterator();
        while (services.hasNext()) {
            String serviceNameNorm;
            ServiceRef sRef = (ServiceRef)services.next();
            String nextName = sRef.getServiceRefLink();
            if (!(nextName = ClientBndUtil.normalizeServiceName(nextName)).equals(serviceNameNorm = ClientBndUtil.normalizeServiceName(serviceName))) continue;
            this.insertDefaultMapping(sRef, ejbName);
        }
    }

    private void insertDefaultMapping(ServiceRef sRef, String ejbName) {
        EList defaultMappings;
        Iterator dmIterator;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "insertDefaultMapping", new Object[]{ejbName});
        }
        if ((dmIterator = (defaultMappings = sRef.getDefaultMappings()).iterator()) != null) {
            while (dmIterator.hasNext()) {
                DefaultMapping dm = (DefaultMapping)dmIterator.next();
                String typeLocal = dm.getPortTypeLocalName();
                String typeSpace = dm.getPortTypeNamespace();
                QName qName = new QName(typeSpace, typeLocal);
                PreferredPortDescriptor ppd = (PreferredPortDescriptor)this.preferredPortMappings.get(qName.toString());
                if (ppd == null) {
                    Object[] fillins = new Object[]{qName.toString()};
                    Tr.warning(tc, "WSWS0050E", fillins);
                    break;
                }
                String portLocal = dm.getPortLocalName();
                String portSpace = dm.getPortNamespace();
                QName qNamePort = new QName(portSpace, portLocal);
                ppd.setPortPreferred(qNamePort.toString());
                ppd.setEjbName(ejbName);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "insertDefaultMapping");
        }
    }

    public static String normalizeServiceName(String bindServiceRefLink) {
        String retString = bindServiceRefLink;
        if (bindServiceRefLink.startsWith("service/")) {
            retString = bindServiceRefLink.substring(8);
        }
        return retString;
    }

    public EList getServiceRefs(String ejbName) {
        EList serviceRefs = null;
        if (this.clientBinding != null) {
            EList scopedRefs = this.clientBinding.getComponentScopedRefs();
            if (scopedRefs != null && scopedRefs.size() > 0) {
                Iterator scopes = scopedRefs.iterator();
                if (scopes != null) {
                    while (scopes.hasNext()) {
                        ComponentScopedRefs csRef = (ComponentScopedRefs)scopes.next();
                        String csEjbName = csRef.getComponentNameLink();
                        if (!ejbName.equals(csEjbName)) continue;
                        serviceRefs = csRef.getServiceRefs();
                        break;
                    }
                }
            } else {
                serviceRefs = this.clientBinding.getServiceRefs();
            }
        }
        return serviceRefs;
    }

    public String getDeployedWSDL(String serviceName, String ejbName) {
        EList serviceRefs;
        String retName = null;
        serviceName = ClientBndUtil.normalizeServiceName(serviceName);
        if (this.clientBinding != null && (serviceRefs = this.getServiceRefs(ejbName)) != null) {
            Iterator sRefs = serviceRefs.iterator();
            while (sRefs.hasNext()) {
                ServiceRef sref1 = (ServiceRef)sRefs.next();
                String sName = sref1.getServiceRefLink();
                if (!serviceName.equals(sName = ClientBndUtil.normalizeServiceName(sName))) continue;
                retName = sref1.getDeployedWSDLFile();
                if (retName == null || !retName.equals("")) break;
                retName = null;
                break;
            }
        }
        return retName;
    }
}

