/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.metadata;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.runtime.metadata.ApplicationMetaData;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.MetaDataSlot;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.runtime.service.MetaDataService;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.ws.webcontainer.metadata.WebModuleMetaDataImpl;
import com.ibm.ws.webcontainer.webapp.WebAppConfiguration;
import com.ibm.ws.webservices.metadata.ApplicationMetaDataHolder;
import com.ibm.ws.webservices.metadata.ClientEntityMetaData;
import com.ibm.ws.webservices.metadata.ClientEntityMetaDataHolder;
import com.ibm.ws.webservices.metadata.ClientModuleMetaData;
import com.ibm.ws.webservices.metadata.ComponentMetaDataHolder;
import com.ibm.ws.webservices.metadata.ModuleMetaDataHolder;
import com.ibm.ws.webservices.metadata.ServerModuleMetaData;
import java.util.Map;

public class WASWebServicesServerMetaDataImpl {
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.webservices.resources.webservicesMessages");
    private static final TraceComponent _tc = Tr.register(WASWebServicesServerMetaDataImpl.class, "WebServices", "com.ibm.ws.webservices.resources.webservicesMessages");
    private MetaDataSlot componentSlot = null;
    private MetaDataSlot moduleSlot = null;
    private MetaDataSlot applicationSlot = null;

    public WASWebServicesServerMetaDataImpl(MetaDataService service) {
        this.applicationSlot = service.reserveSlot(ApplicationMetaData.class);
        this.moduleSlot = service.reserveSlot(ModuleMetaData.class);
        this.componentSlot = service.reserveSlot(ComponentMetaData.class);
    }

    public void destroy(ApplicationMetaData amd) {
        ApplicationMetaDataHolder amdh = (ApplicationMetaDataHolder)amd.getMetaData(this.applicationSlot);
        if (amdh != null) {
            if (_tc.isDebugEnabled()) {
                this.logDebug(amd, "Destroying webservices application " + amd + " metadata");
            }
            amd.setMetaData(this.applicationSlot, null);
            amdh.destroy();
        }
    }

    public void destroy(ModuleMetaData mmd) {
        ModuleMetaDataHolder mmdh = (ModuleMetaDataHolder)mmd.getMetaData(this.moduleSlot);
        if (mmdh != null) {
            if (_tc.isDebugEnabled()) {
                this.logDebug(mmd, "Destroying webservices module " + mmd + " metadata");
            }
            mmd.setMetaData(this.moduleSlot, null);
            mmdh.destroy();
        }
    }

    public void destroy(ComponentMetaData cmd) {
        ComponentMetaDataHolder cmdh = (ComponentMetaDataHolder)cmd.getMetaData(this.componentSlot);
        if (cmdh != null) {
            if (_tc.isDebugEnabled()) {
                this.logDebug(cmd, "Destroying webservices component " + cmd + " metadata");
            }
            cmd.setMetaData(this.componentSlot, null);
            cmdh.destroy();
        }
    }

    public ServerModuleMetaData getServerModuleMetaData(ModuleMetaData mmd) {
        ServerModuleMetaData result;
        if (mmd == null) {
            return null;
        }
        ModuleMetaDataHolder mmdh = (ModuleMetaDataHolder)mmd.getMetaData(this.moduleSlot);
        ServerModuleMetaData serverModuleMetaData = result = mmdh == null ? null : mmdh.getServerMetaData();
        if (result != null) {
            if (_tc.isDebugEnabled()) {
                this.logDebug(mmd, "Located " + result + " in " + mmd);
            }
        } else {
            result = this.getServerModuleMetaData(mmd.getApplicationMetaData(), mmd.getName());
            if (result != null) {
                if (_tc.isDebugEnabled()) {
                    this.logDebug(mmd, "Binding " + result + " to " + mmd);
                }
                if (mmd instanceof WebModuleMetaDataImpl) {
                    result.bindRouterURLPatterns((WebAppConfiguration)((WebModuleMetaDataImpl)mmd).getWebAppConfig());
                }
                if (mmdh == null) {
                    mmdh = new ModuleMetaDataHolder();
                    mmd.setMetaData(this.moduleSlot, mmdh);
                }
                mmdh.setServerMetaData(result);
            }
        }
        return result;
    }

    public ServerModuleMetaData getServerModuleMetaData(ApplicationMetaData amd, String moduleName) {
        ServerModuleMetaData result;
        if (amd == null) {
            return null;
        }
        ApplicationMetaDataHolder amdh = (ApplicationMetaDataHolder)amd.getMetaData(this.applicationSlot);
        if (amdh != null) {
            result = amdh.getServerModuleMetaData(moduleName);
            if (result != null && _tc.isDebugEnabled()) {
                this.logDebug(amd, "Located " + result + " in " + amd + " for module " + moduleName);
            }
        } else {
            result = null;
        }
        return result;
    }

    public void addServerModuleMetaData(ApplicationMetaData amd, ServerModuleMetaData semd) {
        ApplicationMetaDataHolder holder = (ApplicationMetaDataHolder)amd.getMetaData(this.applicationSlot);
        if (holder == null) {
            holder = new ApplicationMetaDataHolder();
            amd.setMetaData(this.applicationSlot, holder);
        }
        if (_tc.isDebugEnabled()) {
            this.logDebug(amd, "Binding " + semd + " to " + amd + " for module " + semd.getRouterModuleName());
        }
        holder.addServerModuleMetaData(semd);
    }

    public void setServerModuleMetaData(ModuleMetaData mmd, ServerModuleMetaData semd) {
        if (_tc.isDebugEnabled()) {
            this.logDebug(mmd, "Binding " + semd + " to " + mmd);
        }
        ModuleMetaDataHolder mmdh = this.createModuleMetaDataHolder(mmd);
        mmdh.setServerMetaData(semd);
    }

    public ClientModuleMetaData getClientModuleMetaData(ModuleMetaData mmd) {
        ModuleMetaDataHolder mmdh = (ModuleMetaDataHolder)mmd.getMetaData(this.moduleSlot);
        return mmdh == null ? null : mmdh.getClientModuleMetaData();
    }

    public void setClientModuleMetaData(ModuleMetaData mmd, ClientModuleMetaData cmmd) {
        ModuleMetaDataHolder mmdh = this.createModuleMetaDataHolder(mmd);
        mmdh.setClientModuleMetaData(cmmd);
    }

    public void syncModuleMetaData(ModuleMetaData mmd, ClientModuleMetaData cmmd) {
        ClientEntityMetaData cemd = cmmd.getModuleScopedMetaData();
        if (cemd != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Storing clientMetaData " + cemd + " for module");
            }
            this.setModuleClientEntityMetaData(mmd, cemd);
        }
    }

    public ClientEntityMetaData getComponentClientEntityMetaData(ComponentMetaData cmd) {
        ClientEntityMetaDataHolder cemdh = (ClientEntityMetaDataHolder)cmd.getMetaData(this.componentSlot);
        return cemdh == null ? null : cemdh.getClientEntityMetaData();
    }

    public void setComponentClientEntityMetaData(ComponentMetaData cmd, ClientEntityMetaData cemd) {
        ComponentMetaDataHolder cmdh = (ComponentMetaDataHolder)cmd.getMetaData(this.componentSlot);
        if (cmdh == null) {
            cmdh = new ComponentMetaDataHolder();
            cmd.setMetaData(this.componentSlot, cmdh);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "setComponentClientEntityMetaData: cmd=" + cmd.toString() + ", slot=" + this.componentSlot.toString() + ", cmdh=" + cmdh.toString());
            }
        }
        cmdh.setClientEntityMetaData(cemd);
    }

    public ClientEntityMetaData getModuleClientEntityMetaData(ModuleMetaData mmd) {
        ClientEntityMetaDataHolder cemdh = (ClientEntityMetaDataHolder)mmd.getMetaData(this.moduleSlot);
        return cemdh == null ? null : cemdh.getClientEntityMetaData();
    }

    public void setModuleClientEntityMetaData(ModuleMetaData mmd, ClientEntityMetaData cemd) {
        ModuleMetaDataHolder mmdh = (ModuleMetaDataHolder)mmd.getMetaData(this.moduleSlot);
        if (mmdh == null) {
            mmdh = new ModuleMetaDataHolder();
            mmd.setMetaData(this.moduleSlot, mmdh);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "setModuleClientEntityMetaData: mmd=" + mmd.toString() + ", slot=" + this.moduleSlot.toString() + ", mmdh=" + mmdh.toString());
            }
        }
        mmdh.setClientEntityMetaData(cemd);
    }

    private ModuleMetaDataHolder getModuleMetaDataHolder(ModuleMetaData mmd) {
        return (ModuleMetaDataHolder)mmd.getMetaData(this.moduleSlot);
    }

    private ModuleMetaDataHolder createModuleMetaDataHolder(ModuleMetaData mmd) {
        ModuleMetaDataHolder mmdh = (ModuleMetaDataHolder)mmd.getMetaData(this.moduleSlot);
        if (mmdh == null) {
            mmdh = new ModuleMetaDataHolder();
            mmd.setMetaData(this.moduleSlot, mmdh);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "createModuleMetaDataHolder: mmd=" + mmd.toString() + ", slot=" + this.moduleSlot.toString() + ", mmdh=" + mmdh.toString());
            }
        }
        return mmdh;
    }

    public synchronized Map getWSDLModuleData() {
        return this.getWSDLModuleData(this.getModuleMetaData());
    }

    public synchronized Map getWSDLModuleData(ModuleMetaData mmd) {
        Map wsdlModuleData = null;
        if (mmd != null) {
            ApplicationMetaData amd = mmd.getApplicationMetaData();
            ApplicationMetaDataHolder amdh = (ApplicationMetaDataHolder)amd.getMetaData(this.applicationSlot);
            if (amdh == null) {
                amdh = new ApplicationMetaDataHolder();
                amd.setMetaData(this.applicationSlot, amdh);
            }
            wsdlModuleData = amdh.getWSDLModuleData();
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "No ModuleMetaData is found,  null will be returned");
        }
        return wsdlModuleData;
    }

    public synchronized void setWSDLModuleData(ModuleMetaData mmd, Map moduleDatas) {
        ApplicationMetaData amd = mmd.getApplicationMetaData();
        ApplicationMetaDataHolder amdh = (ApplicationMetaDataHolder)amd.getMetaData(this.applicationSlot);
        if (amdh == null) {
            amdh = new ApplicationMetaDataHolder();
            amd.setMetaData(this.applicationSlot, amdh);
        }
        amdh.setWSDLModuleData(moduleDatas);
    }

    private ComponentMetaData getComponentMetaData() {
        return ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
    }

    private ModuleMetaData getModuleMetaData() {
        return this.getComponentMetaData().getModuleMetaData();
    }

    public ServerModuleMetaData getServerModuleMetaData() {
        return this.getServerModuleMetaData(this.getModuleMetaData());
    }

    public ClientEntityMetaData getClientEntityMetaData() {
        ModuleMetaData mmd;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getClientEntityMetaData");
        }
        ComponentMetaData cmd = this.getComponentMetaData();
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "cmd: " + cmd.toString());
        }
        ClientEntityMetaDataHolder cemdh = null;
        Object metaDataObj = cmd.getMetaData(this.componentSlot);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "metaDataObj: " + (metaDataObj != null ? metaDataObj.toString() : "null"));
            Tr.debug(_tc, "componentSlot: " + this.componentSlot.toString());
        }
        if (metaDataObj != null && metaDataObj instanceof ClientEntityMetaDataHolder) {
            cemdh = (ClientEntityMetaDataHolder)metaDataObj;
        }
        if ((cemdh == null || cemdh.getClientEntityMetaData() == null) && (mmd = cmd.getModuleMetaData()) != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "mmd: " + mmd.toString());
                Tr.debug(_tc, "moduleSlot: " + this.moduleSlot.toString());
            }
            cemdh = (ClientEntityMetaDataHolder)mmd.getMetaData(this.moduleSlot);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getClientEntityMetaData");
        }
        return cemdh != null ? cemdh.getClientEntityMetaData() : null;
    }

    private void logDebug(ApplicationMetaData amd, String msg) {
        this.logDebug(amd.getName(), null, null, msg);
    }

    private void logDebug(ModuleMetaData mmd, String msg) {
        this.logDebug(mmd.getApplicationMetaData().getName(), mmd.getName(), null, msg);
    }

    private void logDebug(ComponentMetaData cmd, String msg) {
        ModuleMetaData mmd = cmd.getModuleMetaData();
        if (mmd != null) {
            this.logDebug(mmd.getApplicationMetaData().getName(), mmd.getName(), cmd.getName(), msg);
        } else {
            this.logDebug("null MMD", "null MMD", cmd.getName(), msg);
        }
    }

    private void logDebug(String app, String mod, String comp, String msg) {
        String id = null;
        if (app != null) {
            id = "Application=" + app;
        }
        if (mod != null) {
            id = id != null ? id + "#" : "";
            id = id + "Module=" + mod;
        }
        if (comp != null) {
            id = id != null ? id + "#" : "";
            id = id + "Component=" + comp;
        }
        Tr.debug(_tc, id + ": " + msg);
    }
}

