/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.metadata;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.WebServicesException;
import com.ibm.ws.webservices.metadata.ClientEntityMetaData;
import com.ibm.wsspi.webservices.models.WSModels;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.Context;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.eclipse.jst.j2ee.webservice.wsclient.ComponentScopedRefs;
import org.eclipse.jst.j2ee.webservice.wsclient.ServiceRef;
import org.eclipse.jst.j2ee.webservice.wsclient.WebServicesClient;

public class ClientModuleMetaData {
    private static final TraceComponent _tc = Tr.register(ClientModuleMetaData.class, "WebServices", "com.ibm.ws.webservices.resources.webservicesMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.webservices.resources.webservicesMessages");
    private static final String MODULE_REF = null;
    private Map clientMetaDatas = new HashMap();
    private LoadStrategy loadStrategy = null;
    private ClassLoader classLoader = null;
    private boolean boundAndExtended = false;
    private static final String SERVICE_AND_PORTNAME_SEPARATOR = "/";

    public void destroy() {
        if (this.clientMetaDatas != null) {
            Iterator iter = this.clientMetaDatas.values().iterator();
            while (iter.hasNext()) {
                ClientEntityMetaData cemd = (ClientEntityMetaData)iter.next();
                if (cemd == null) continue;
                cemd.destroy();
            }
            this.clientMetaDatas.clear();
            this.clientMetaDatas = null;
        }
        this.loadStrategy = null;
        this.classLoader = null;
    }

    protected LoadStrategy getLoadStrategy() {
        return this.loadStrategy;
    }

    public void setLoadStrategy(LoadStrategy strategy) {
        this.loadStrategy = strategy;
    }

    protected ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader loader) {
        this.classLoader = loader;
    }

    public ClientEntityMetaData createComponentScopedMetaData(String componentName) {
        ClientEntityMetaData cmd = (ClientEntityMetaData)this.clientMetaDatas.get(componentName);
        if (cmd == null) {
            cmd = new ClientEntityMetaData(componentName, this);
            this.clientMetaDatas.put(componentName, cmd);
        }
        return cmd;
    }

    public ClientEntityMetaData createModuleScopedMetaData() {
        ClientEntityMetaData cmd = (ClientEntityMetaData)this.clientMetaDatas.get(MODULE_REF);
        if (cmd == null) {
            cmd = new ClientEntityMetaData(MODULE_REF, this);
            this.clientMetaDatas.put(MODULE_REF, cmd);
        }
        return cmd;
    }

    public ClientEntityMetaData getComponentScopedMetaData(String componentName) {
        return (ClientEntityMetaData)this.clientMetaDatas.get(componentName);
    }

    public ClientEntityMetaData getModuleScopedMetaData() {
        return this.getComponentScopedMetaData(MODULE_REF);
    }

    public Iterator getMetaData() {
        return this.clientMetaDatas.values().iterator();
    }

    public void bindServiceRefs(String componentName, List refs) throws RuntimeError {
        if (refs != null && refs.size() > 0) {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "bindServiceRefs(componentName=" + componentName + ")");
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Binding " + refs.size() + " service-refs to " + (componentName == null ? "module" : "component " + componentName));
            }
            ClientEntityMetaData cemd = this.createComponentScopedMetaData(componentName);
            for (int ii = 0; ii < refs.size(); ++ii) {
                ServiceRef sr = (ServiceRef)refs.get(ii);
                cemd.newService(sr);
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "bindServiceRefs");
            }
        }
    }

    public void bindServiceRefs(String componentName, Context javaColonCompEnvContext) throws RuntimeError {
        ClientEntityMetaData cemd = this.getComponentScopedMetaData(componentName);
        if (cemd != null) {
            cemd.bindServiceRefs(javaColonCompEnvContext);
        }
    }

    public void bindBindingsAndExtensions(String componentName, String bindFile, String extFile) throws RuntimeError {
        ClientEntityMetaData cemd = this.getComponentScopedMetaData(componentName);
        if (cemd != null) {
            cemd.bindBindingsAndExtensions(bindFile, extFile);
            cemd.loadNow();
        }
    }

    public boolean hasBinding(String componentName) {
        return this.getComponentScopedMetaData(componentName) != null;
    }

    public WebServicesClient getJ2EEWebServicesClient(String xmlFilename) throws RuntimeError {
        WebServicesClient wsc = null;
        if (this.loadStrategy.getContainer().containsFile(xmlFilename)) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Processing J2EE 1.3 Web Services Client XML file: " + xmlFilename);
            }
            try {
                wsc = WSModels.getWebServicesClient(this.loadStrategy, xmlFilename);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.client.ClientModuleMetaData.getJ2EEWebServicesClient", "211", this);
                throw new RuntimeError(e);
            }
        }
        return wsc;
    }

    public boolean bindJ2EE13ComponentServiceRefs(String componentName, String xmlFilename, WebServicesClient wsc) throws RuntimeError, WebServicesException {
        boolean bound = false;
        if (wsc != null) {
            int csrSize = wsc.getComponentScopedRefs().size();
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "ComponentScopedRefs count is " + csrSize);
            }
            if (csrSize != 0) {
                for (int jj = 0; jj < csrSize; ++jj) {
                    ComponentScopedRefs csr = (ComponentScopedRefs)wsc.getComponentScopedRefs().get(jj);
                    if (!componentName.equals(csr.getComponentName())) continue;
                    this.bindServiceRefs(componentName, csr.getServiceRefs());
                    bound = true;
                }
            } else {
                String msgKey = "j2ee13.webservicesclient.missing.component.scoped.ref";
                Object[] params = new Object[]{xmlFilename};
                Tr.error(_tc, msgKey, params);
                throw new RuntimeError(nls.getFormattedMessage(msgKey, params, null));
            }
        }
        return bound;
    }

    public boolean bindJ2EE13ModuleServiceRefs(String xmlFilename, WebServicesClient wsc) throws RuntimeError, WebServicesException {
        if (wsc != null) {
            int csrSize = wsc.getComponentScopedRefs().size();
            if (csrSize == 0) {
                this.bindServiceRefs(null, wsc.getServiceRefs());
                return true;
            }
            String msgKey = "j2ee13.webservicesclient.unexpected.component.scoped.ref";
            Object[] params = new Object[]{xmlFilename};
            Tr.error(_tc, msgKey, params);
            throw new RuntimeError(nls.getFormattedMessage(msgKey, params, null));
        }
        return false;
    }

    public static String clientConfigurationPortName(String serviceRefName, String portName) {
        String clientPortName = null;
        if (serviceRefName != null && portName != null) {
            clientPortName = serviceRefName + SERVICE_AND_PORTNAME_SEPARATOR + portName;
        } else if (serviceRefName != null) {
            clientPortName = serviceRefName;
        } else if (portName != null) {
            clientPortName = portName;
        } else {
            Tr.error(_tc, "internal.error", "Port name and service ref name are both null");
        }
        return clientPortName;
    }

    public static String unravelPortName(String mergedPortName) {
        if (mergedPortName != null) {
            int idx = mergedPortName.lastIndexOf(SERVICE_AND_PORTNAME_SEPARATOR);
            if (idx >= 0) {
                return mergedPortName.substring(idx + 1);
            }
            return mergedPortName;
        }
        return null;
    }

    public static String unravelServiceRefName(String mergedPortName) {
        int idx;
        if (mergedPortName != null && (idx = mergedPortName.lastIndexOf(SERVICE_AND_PORTNAME_SEPARATOR)) >= 0) {
            return mergedPortName.substring(0, idx);
        }
        return null;
    }

    public boolean classLoaderInitialized() {
        return this.classLoader != null;
    }
}

