/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.metadata;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.webservice.wscbnd.ClientBinding;
import com.ibm.etools.webservice.wscext.ComponentScopedRefs;
import com.ibm.etools.webservice.wscext.WsClientExtension;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.WebServicesException;
import com.ibm.ws.webservices.configuration.WASEngineConfigurationProvider;
import com.ibm.ws.webservices.configuration.WebServicesEngineConfigurationGenerator;
import com.ibm.ws.webservices.engine.EngineConfiguration;
import com.ibm.ws.webservices.engine.client.ClientEngine;
import com.ibm.ws.webservices.engine.client.ClientEngineFactory;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDDeployment;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.metadata.ClientModuleMetaData;
import com.ibm.ws.webservices.metadata.ClientServiceMetaData;
import com.ibm.wsspi.webservices.models.WSModels;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.Reference;
import org.eclipse.jst.j2ee.common.QName;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.eclipse.jst.j2ee.webservice.wsclient.ServiceRef;

public class ClientEntityMetaData {
    private static final TraceComponent _tc = Tr.register(ClientEntityMetaData.class, "WebServices", "com.ibm.ws.webservices.resources.webservicesMessages");
    private String componentName;
    private Map services = new HashMap();
    private ClientModuleMetaData moduleMetaData;
    private WSDDDeployment deployment;
    private EngineConfiguration configuration;
    private ClientEngine engine;

    ClientEntityMetaData(String name2, ClientModuleMetaData parent) {
        this.componentName = name2;
        this.moduleMetaData = parent;
    }

    public void destroy() {
        if (this.services != null) {
            Iterator iter = this.services.values().iterator();
            while (iter.hasNext()) {
                ClientServiceMetaData csmd = (ClientServiceMetaData)iter.next();
                if (csmd == null) continue;
                csmd.destroy();
            }
            this.services.clear();
            this.services = null;
        }
        this.moduleMetaData = null;
        if (this.engine != null) {
            this.engine.destroy();
            this.engine = null;
            this.configuration = null;
            this.deployment = null;
        }
    }

    ClientModuleMetaData getParentMetaData() {
        return this.moduleMetaData;
    }

    private WSDDDeployment getDeployment() {
        if (this.deployment == null) {
            this.deployment = WebServicesEngineConfigurationGenerator.createClientDeployment(this.getPorts());
        }
        return this.deployment;
    }

    public synchronized EngineConfiguration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new WASEngineConfigurationProvider(this.getDeployment());
        }
        return this.configuration;
    }

    public synchronized ClientEngine getEngine() {
        if (this.engine == null) {
            this.engine = ClientEngineFactory.getEngine(this.getConfiguration());
        }
        return this.engine;
    }

    public String getName() {
        return this.componentName;
    }

    public ClientServiceMetaData newService(String serviceName) {
        ClientServiceMetaData service = new ClientServiceMetaData(serviceName, this);
        this.services.put(service.getName(), service);
        return service;
    }

    public ClientServiceMetaData getService(String serviceName) {
        return (ClientServiceMetaData)this.services.get(serviceName);
    }

    public Map getServices() {
        return this.services;
    }

    public ClientServiceMetaData newService(ServiceRef sr) {
        ClientServiceMetaData service = this.newService(sr.getServiceRefName());
        QName ddQName = sr.getServiceQname();
        if (ddQName != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Getting ServiceQName from 109 DD.");
            }
            service.setQName(QNameTable.createQName(ddQName.getNamespaceURI(), ddQName.getLocalPart()));
        }
        if (sr.getServiceInterface() != null) {
            service.setServiceInterface(sr.getServiceInterface().getJavaName());
        }
        service.setJaxrpcMappingFileName(sr.getJaxrpcMappingFile());
        if (service.getWsdlFileName() == null && sr.getWsdlFile() != null) {
            service.setWsdlFileName(sr.getWsdlFile());
        }
        if (sr.getHandlers().size() > 0) {
            service.addHandlers(sr.getHandlers());
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Found a service-ref w/name of " + service.getName());
            Tr.debug(_tc, "ServiceQName being used: " + service.getQName());
            Tr.debug(_tc, "ServiceInterface is: " + service.getServiceInterface());
        }
        return service;
    }

    protected LoadStrategy getLoadStrategy() {
        return this.moduleMetaData.getLoadStrategy();
    }

    protected ClassLoader getClassLoader() {
        return this.moduleMetaData.getClassLoader();
    }

    public Collection getPorts() {
        ArrayList list = new ArrayList();
        Iterator iter = this.getServices().values().iterator();
        while (iter.hasNext()) {
            ClientServiceMetaData service = (ClientServiceMetaData)iter.next();
            list.addAll(service.getPorts());
        }
        return list;
    }

    public void bindServiceRefs(Context javaColonCompEnvContext) {
        Iterator iter = this.services.values().iterator();
        while (iter.hasNext()) {
            ClientServiceMetaData service = (ClientServiceMetaData)iter.next();
            try {
                service.bind(javaColonCompEnvContext);
            }
            catch (NamingException ne) {
                FFDCFilter.processException((Throwable)ne, "com.ibm.ws.webservices.metadata.ClientEntityMetaData.bindServiceRefs", "218", this);
                Tr.error(_tc, "error.binding.service.refs", ne);
            }
        }
    }

    public void bindBindingsAndExtensions(String xmlBindingsFilename, String xmlExtensionsFilename) throws RuntimeError {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Processing Web Services client bindings");
        }
        try {
            ClientBinding wscb = WSModels.getWSClientBinding(this.getLoadStrategy(), xmlBindingsFilename);
            WsClientExtension wsce = WSModels.getWSClientExtension(this.getLoadStrategy(), xmlExtensionsFilename);
            if (wscb != null || wsce != null) {
                if (this.componentName == null) {
                    this.extendServiceRefs(wscb == null ? null : wscb.getServiceRefs(), wsce == null ? null : wsce.getServiceRefs());
                } else {
                    Object[] params;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Bindings for Service Refs for Component w/name=" + this.componentName);
                    }
                    com.ibm.etools.webservice.wscbnd.ComponentScopedRefs cbsrs = ClientEntityMetaData.getComponentBinding(wscb, this.componentName);
                    ComponentScopedRefs cesrs = ClientEntityMetaData.getComponentExtension(wsce, this.componentName);
                    if (cbsrs == null) {
                        params = new Object[]{"ClientBinding", xmlBindingsFilename};
                        Tr.warning(_tc, "notContain.componentScopedRefs", params);
                    }
                    if (cesrs == null) {
                        params = new Object[]{"WsClientExtension", xmlBindingsFilename};
                        Tr.warning(_tc, "notContain.componentScopedRefs", params);
                    }
                    this.extendServiceRefs(cbsrs == null ? null : cbsrs.getServiceRefs(), cesrs == null ? null : cesrs.getServiceRefs());
                }
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.client.ClientEntityMetaData.bindBindingsAndExtensions", "269", this);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Exception: ", e);
            }
            throw new RuntimeError(e);
        }
    }

    public void loadNow() {
        Iterator iter = this.getServices().values().iterator();
        while (iter.hasNext()) {
            ClientServiceMetaData csmd = (ClientServiceMetaData)iter.next();
            csmd.getWsdlDoc();
            csmd.getSeiToPortTypeMapping();
        }
    }

    public ClientServiceMetaData getClientServiceMetaData(Reference ref) throws WebServicesException {
        String serviceName = ClientServiceMetaData.getServiceName(ref);
        ClientServiceMetaData service = this.getService(serviceName);
        if (service == null) {
            String msg = "ClientServiceMetaData for service " + serviceName + " is not available";
            Tr.error(_tc, "internal.error", msg);
            throw new WebServicesException(msg);
        }
        return service;
    }

    private static com.ibm.etools.webservice.wscbnd.ComponentScopedRefs getComponentBinding(ClientBinding wscb, String componentName) {
        com.ibm.etools.webservice.wscbnd.ComponentScopedRefs bindingComponentScopedRefs = null;
        if (wscb != null) {
            int bindingComponentScopedRefsCount = wscb.getComponentScopedRefs().size();
            for (int ll = 0; ll < bindingComponentScopedRefsCount; ++ll) {
                com.ibm.etools.webservice.wscbnd.ComponentScopedRefs checkBindingComponentScopedRefs = (com.ibm.etools.webservice.wscbnd.ComponentScopedRefs)wscb.getComponentScopedRefs().get(ll);
                String bindingComponentNameLink = checkBindingComponentScopedRefs.getComponentNameLink();
                if (!bindingComponentNameLink.equals(componentName)) continue;
                bindingComponentScopedRefs = checkBindingComponentScopedRefs;
                if (!_tc.isDebugEnabled()) break;
                Tr.debug(_tc, "Found client binding info for ComponentScopedRef " + componentName);
                break;
            }
        }
        return bindingComponentScopedRefs;
    }

    private static ComponentScopedRefs getComponentExtension(WsClientExtension wsce, String componentName) {
        ComponentScopedRefs extensionComponentScopedRefs = null;
        if (wsce != null) {
            int count = wsce.getComponentScopedRefs().size();
            for (int mm = 0; mm < count; ++mm) {
                ComponentScopedRefs checkExtensionComponentScopedRefs = (ComponentScopedRefs)wsce.getComponentScopedRefs().get(mm);
                String extensionComponentNameLink = checkExtensionComponentScopedRefs.getComponentNameLink();
                if (!extensionComponentNameLink.equals(componentName)) continue;
                extensionComponentScopedRefs = checkExtensionComponentScopedRefs;
                if (!_tc.isDebugEnabled()) break;
                Tr.debug(_tc, "Found client extension info for ComponentScopedRef " + componentName);
                break;
            }
        }
        return extensionComponentScopedRefs;
    }

    private void extendServiceRefs(List bindingServiceRefs, List extensionServiceRefs) throws NoSuchMethodException, ClassNotFoundException, InstantiationException, IllegalAccessException, ConfigurationError {
        Iterator iter = this.getServices().values().iterator();
        while (iter.hasNext()) {
            ClientServiceMetaData service = (ClientServiceMetaData)iter.next();
            com.ibm.etools.webservice.wscbnd.ServiceRef cbsr = ClientEntityMetaData.getServiceRefBinding(bindingServiceRefs, service.getName());
            com.ibm.etools.webservice.wscext.ServiceRef cesr = ClientEntityMetaData.getServiceRefExtension(extensionServiceRefs, service.getName());
            service.extendServiceRef(cbsr, cesr);
        }
    }

    private static com.ibm.etools.webservice.wscbnd.ServiceRef getServiceRefBinding(List wscbsr, String serviceRefName) {
        com.ibm.etools.webservice.wscbnd.ServiceRef cbsr = null;
        if (wscbsr != null) {
            int srbc = wscbsr.size();
            for (int kk = 0; kk < srbc; ++kk) {
                com.ibm.etools.webservice.wscbnd.ServiceRef sr = (com.ibm.etools.webservice.wscbnd.ServiceRef)wscbsr.get(kk);
                if (!serviceRefName.equals(sr.getServiceRefLink())) continue;
                cbsr = sr;
                if (!_tc.isDebugEnabled()) break;
                Tr.debug(_tc, "Found client binding info for ServiceRef " + serviceRefName);
                break;
            }
        }
        return cbsr;
    }

    private static com.ibm.etools.webservice.wscext.ServiceRef getServiceRefExtension(List wscesr, String serviceRefName) {
        com.ibm.etools.webservice.wscext.ServiceRef cesr = null;
        if (wscesr != null) {
            int srec = wscesr.size();
            for (int nn = 0; nn < srec; ++nn) {
                com.ibm.etools.webservice.wscext.ServiceRef sr = (com.ibm.etools.webservice.wscext.ServiceRef)wscesr.get(nn);
                if (!serviceRefName.equals(sr.getServiceRefLink())) continue;
                cesr = sr;
                if (!_tc.isDebugEnabled()) break;
                Tr.debug(_tc, "Found client extension info for ServiceRef " + serviceRefName);
                break;
            }
        }
        return cesr;
    }
}

