/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.management;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.webservices.SharedConstants;
import com.ibm.ws.webservices.management.EndpointManagerMBeanImpl;
import com.ibm.wsspi.webservices.management.EndpointManagerMBean;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class EndpointManagerMBeanFactory {
    private static final TraceComponent _tc = Tr.register(EndpointManagerMBeanFactory.class, "WebServices.Shared", "com.ibm.ws.webservices.resources.WSMessages");
    private static Map<String, EndpointManagerMBean> endptMgrMap = new HashMap<String, EndpointManagerMBean>();

    public static synchronized EndpointManagerMBean locateOrGenerateMBean(String appName, String modName) {
        String appModuleName;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "EndpointManagerMBeanFactory.locateOrGenerateMBean()...", appName + "#" + modName);
        }
        if (endptMgrMap.get(appModuleName = appName + "#" + modName) != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Found existing MBean, returning instance.");
            }
            return endptMgrMap.get(appModuleName);
        }
        EndpointManagerMBeanImpl mbean = new EndpointManagerMBeanImpl();
        MBeanFactory mbfactory = AdminServiceFactory.getMBeanFactory();
        String mbeanId = SharedConstants.runtimeHash + "_" + appModuleName;
        Properties props = new Properties();
        props.put("ApplicationName", appName);
        props.put("ModuleName", modName);
        try {
            mbfactory.activateMBean("EndpointManager", mbean, mbeanId, null, props);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "MBean generated: " + mbean);
            }
            endptMgrMap.put(appModuleName, mbean);
        }
        catch (AdminException e) {
            Object[] inserts = new Object[]{appName, modName, e};
            Tr.error(_tc, "registerMBeanFail", inserts);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...EndpointManagerMBeanFactory.locateOrGenerateMBean()");
        }
        return mbean;
    }

    public static synchronized void unregisterMBean(String appName, String modName) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "EndpointManagerMBeanFactory.unregisterMBean()...", appName + "#" + modName);
        }
        String appModuleName = appName + "#" + modName;
        MBeanFactory mbfactory = AdminServiceFactory.getMBeanFactory();
        EndpointManagerMBeanImpl mbean = (EndpointManagerMBeanImpl)endptMgrMap.remove(appModuleName);
        if (mbean == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, appModuleName + " did not have MBean currently associated with it.");
            }
            return;
        }
        try {
            mbfactory.deactivateMBean(mbean.getObjectName());
        }
        catch (AdminException e) {
            Object[] inserts = new Object[]{appName, modName, e};
            Tr.error(_tc, "unregisterMBeanFail", inserts);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...EndpointManagerMBeanFactory.unregisterMBean()");
        }
    }
}

