/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.handlers;

import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.transport.http.HTTPConstants;
import com.ibm.wsspi.soapcontainer.SOAPRequest;
import com.ibm.wsspi.webservices.rpc.handler.GenericHandler;
import com.ibm.wsspi.webservices.rpc.handler.SystemHandler;
import com.ibm.wsspi.webservices.sysapp.SystemEndpointContext;
import javax.servlet.http.HttpServletRequest;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.MessageContext;
import org.apache.commons.logging.Log;

public class WSURLMapper
extends GenericHandler
implements SystemHandler {
    protected static Log log = LogFactory.getLog(WSURLMapper.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preHandleIncoming(MessageContext context) {
        if (log.isDebugEnabled()) {
            log.debug("enter: WSURLMapper::handleRequest");
        }
        try {
            String portName;
            com.ibm.ws.webservices.engine.MessageContext msgContext = (com.ibm.ws.webservices.engine.MessageContext)context;
            String servletPath = (String)context.getProperty("path");
            if (servletPath != null && servletPath.length() > 1) {
                String pathInfo = (String)msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETPATHINFO);
                portName = pathInfo != null && pathInfo.length() > 1 ? servletPath.substring(1) + pathInfo : servletPath.substring(1);
                int scIndex = portName.indexOf(59);
                if (scIndex > 0) {
                    portName = portName.substring(0, scIndex);
                }
                if (log.isDebugEnabled()) {
                    log.debug("invoke: MC_RELATIVE_PATH = " + servletPath);
                    log.debug("invoke: MC_HTTP_SERVLETPATHINFO = " + pathInfo);
                    log.debug("invoke: portName = " + portName);
                }
                try {
                    msgContext.setTargetPort(portName);
                }
                catch (WebServicesFault wsf) {
                    log.debug(Messages.getMessage("exception00"), wsf);
                }
            } else {
                portName = "<null>";
            }
            if (msgContext.getPort() == null) {
                String translatedMessage;
                HttpServletRequest servletRequest = (HttpServletRequest)context.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
                if (servletRequest != null) {
                    translatedMessage = Messages.getMessage("serviceHandler.not.found", new String[]{portName, servletRequest.getRequestURI()});
                } else {
                    SystemEndpointContext sec = (SystemEndpointContext)context.getProperty("servletEndpointContext");
                    SOAPRequest soapRequest = sec.getRequest();
                    translatedMessage = Messages.getMessage("serviceHandler.not.found", new String[]{portName, soapRequest.getRequestURI()});
                }
                log.error(translatedMessage);
                throw new JAXRPCException(translatedMessage);
            }
            Object var10_11 = null;
            if (log.isDebugEnabled()) {
                log.debug("exit: WSURLMapper::handleRequest");
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (log.isDebugEnabled()) {
                log.debug("exit: WSURLMapper::handleRequest");
            }
            throw throwable;
        }
    }
}

