/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.handlers;

import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.description.PortDesc;
import com.ibm.ws.webservices.pmi.modules.EndpointPmiModule;
import com.ibm.ws.webservices.pmi.modules.ModulePmiModule;
import com.ibm.ws.webservices.pmi.modules.ServicePmiModule;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;

public class EndpointPMIContext {
    protected static Log log = LogFactory.getLog(EndpointPMIContext.class.getName());
    private EndpointPmiModule endpointPmiModule = null;

    public EndpointPMIContext(MessageContext msgContext, ModulePmiModule pmiModule) {
        PortDesc port2 = msgContext.getPortDesc();
        QName serviceQName = port2.getServiceQName();
        QName portQName = port2.getWSDLPort();
        ServicePmiModule servicePmiModule = null;
        if (serviceQName != null) {
            servicePmiModule = pmiModule.getService(serviceQName.toString());
        }
        if (servicePmiModule != null && portQName != null) {
            this.endpointPmiModule = servicePmiModule.getEndpoint(portQName.getLocalPart().toString());
        }
    }

    void onServerReceiveRequest(long receivedRequestTime) {
        if (this.endpointPmiModule != null) {
            this.endpointPmiModule.incReceived(receivedRequestTime);
        }
    }

    void onServerForwardRequestToPort(long sentRequestTime) {
    }

    void onServerReceiveReplyFromPort(long receivedReplyTime) {
    }

    void onServerReturnReply(long sentReplyTime, long totalDispatchTime, long requestSize, long responseSize) {
        if (this.endpointPmiModule != null) {
            this.endpointPmiModule.incReceived(sentReplyTime, true);
            this.endpointPmiModule.addResponseTime(sentReplyTime, totalDispatchTime);
            this.endpointPmiModule.addRequestSize(sentReplyTime, requestSize);
            this.endpointPmiModule.addResponseSize(sentReplyTime, responseSize);
        }
    }

    void close(boolean oneway, long sentReplyTime, long totalDispatchTime, long requestSize, long responseSize) {
        if (this.endpointPmiModule != null) {
            this.endpointPmiModule.addRequestSize(sentReplyTime, requestSize);
            this.endpointPmiModule.addResponseTime(sentReplyTime, totalDispatchTime);
            if (oneway) {
                this.endpointPmiModule.incReceived(sentReplyTime, true);
            } else {
                this.endpointPmiModule.incReceived(sentReplyTime, false);
                this.endpointPmiModule.addResponseSize(sentReplyTime, responseSize);
            }
        }
    }
}

