/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.xmlsoap.dom.impl;

import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import com.ibm.ws.webservices.engine.xmlsoap.Utils;
import com.ibm.ws.webservices.engine.xmlsoap.dom.impl.DOMAttributeMapDelegate;
import com.ibm.ws.webservices.engine.xmlsoap.dom.impl.DOMDocumentImpl;
import com.ibm.ws.webservices.engine.xmlsoap.dom.impl.DOMElementImpl;
import org.apache.commons.logging.Log;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public abstract class DOMElementImpl_MS
extends DOMElementImpl {
    private static Log log = LogFactory.getLog(DOMElementImpl_MS.class.getName());
    private MappingScope mappingScope = null;
    private boolean msOpt = true;
    private boolean reEnableMSOpt = false;
    private static final String XMLNS = "xmlns";
    private static final String XMLNS_COLON = "xmlns:";
    private static final String EMPTY_STRING = "";
    private DOMAttributeMapDelegate attrMapDelegate = null;

    protected DOMElementImpl_MS(DOMDocumentImpl document, String namespace, String localName) {
        super(document, namespace, localName);
    }

    protected MappingScope _getMappingScope() {
        MappingScope ms = this._getMappingScopeInternal();
        return ms;
    }

    private final MappingScope _getMappingScopeInternal() {
        MappingScope ms = null;
        ms = this.msOpt ? this._getCachedMappingScope() : this._getDynamicMappingScope();
        Node parentNode = this.getParentNode();
        if (this.msOpt && parentNode instanceof DOMElementImpl_MS && ((DOMElementImpl_MS)((Object)parentNode)).msOpt && ((DOMElementImpl_MS)((Object)parentNode)).mappingScope == ms.getParent()) {
            return ms;
        }
        if (parentNode instanceof DOMElementImpl_MS) {
            DOMElementImpl_MS parentElement = (DOMElementImpl_MS)((Object)parentNode);
            MappingScope parentMS = ((DOMElementImpl_MS)((Object)parentNode))._getMappingScope();
            ms.setParent(parentMS);
        }
        return ms;
    }

    private final MappingScope _getCachedMappingScope() {
        if (this.mappingScope == null) {
            this.mappingScope = new MappingScope();
        }
        MappingScope ms = this.mappingScope;
        return ms;
    }

    private final MappingScope _getDynamicMappingScope() {
        if (log.isDebugEnabled()) {
            if (this.reEnableMSOpt) {
                log.debug("dynamic build of MappingScope for re-enablement:" + this.getLocalName());
            } else {
                log.debug("dynamic build of MappingScope:" + this.getLocalName());
            }
        }
        MappingScope ms = new MappingScope();
        NamedNodeMap map = this.getSortedAttributes();
        boolean search = true;
        for (int i = DOMElementImpl_MS.findIndex(XMLNS, map); i < map.getLength() && search; ++i) {
            Attr attr = (Attr)map.item(i);
            String itemNodeName = attr.getNodeName();
            if (!itemNodeName.startsWith(XMLNS)) {
                search = false;
            }
            String itemValue = attr.getValue();
            ms = DOMElementImpl_MS.addMapping(ms, itemNodeName, itemValue);
        }
        return ms;
    }

    protected void enableMappingScopeOptimization(boolean newMSOpt) {
        if (this.msOpt == newMSOpt) {
            return;
        }
        if (!newMSOpt) {
            this.mappingScope = null;
        } else if (!this.msOpt) {
            this.reEnableMSOpt = true;
            this.mappingScope = this._getMappingScope();
            this.reEnableMSOpt = false;
        }
        this.msOpt = newMSOpt;
    }

    void modifiedXMLNSAttributes() {
        if (this.msOpt) {
            this.enableMappingScopeOptimization(false);
            this.enableMappingScopeOptimization(true);
        }
    }

    protected void changedParent() {
        if (this.msOpt) {
            MappingScope ms = this._getCachedMappingScope();
            Node parent = this.getParentNode();
            if (parent instanceof DOMElementImpl_MS) {
                ms.setParent(((DOMElementImpl_MS)((Object)parent))._getMappingScope());
            } else {
                ms.setParent(null);
            }
        }
    }

    public NamedNodeMap getAttributes() {
        NamedNodeMap attrs = super.getAttributes();
        if (this.attrMapDelegate == null || this.attrMapDelegate.getAttributes() != attrs) {
            this.attrMapDelegate = new DOMAttributeMapDelegate(attrs, this.getOwnerDocument());
        }
        return this.attrMapDelegate;
    }

    public Attr removeAttributeNode(Attr attr) throws DOMException {
        DOMElementImpl_MS.removeMapping(this.mappingScope, attr.getName());
        return super.removeAttributeNode(attr);
    }

    public Attr removeAttributeNodeNS(Attr attr) throws DOMException {
        DOMElementImpl_MS.removeMapping(this.mappingScope, attr.getName());
        return super.removeAttributeNode(attr);
    }

    public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
        if (this.mappingScope != null && "http://www.w3.org/2000/xmlns/".equals(namespaceURI)) {
            String prefix = localName;
            if (XMLNS.equals(localName)) {
                prefix = EMPTY_STRING;
            }
            boolean removed = this.mappingScope.removeMappingForPrefix(prefix);
        }
        super.removeAttributeNS(namespaceURI, localName);
    }

    public void removeAttribute(String qualifiedName) throws DOMException {
        if (this.msOpt) {
            DOMElementImpl_MS.removeMapping(this.mappingScope, qualifiedName);
        }
        super.removeAttribute(qualifiedName);
    }

    public void setAttribute(String name2, String value2) throws DOMException {
        if (this.msOpt) {
            this.mappingScope = DOMElementImpl_MS.addMapping(this.mappingScope, name2, value2);
        }
        super.setAttribute(name2, value2);
    }

    public Attr setAttributeNode(Attr attr) throws DOMException {
        attr = Utils.create(attr, this.getOwnerDocument());
        if (this.msOpt) {
            this.mappingScope = DOMElementImpl_MS.addMapping(this.mappingScope, attr.getName(), attr.getValue());
        }
        return super.setAttributeNode(attr);
    }

    public void setAttributeNS(String namespace, String qualifiedName, String value2) throws DOMException {
        if (this.msOpt) {
            this.mappingScope = DOMElementImpl_MS.addMapping(this.mappingScope, qualifiedName, value2);
        }
        super.setAttributeNS(namespace, qualifiedName, value2);
    }

    public Attr setAttributeNodeNS(Attr attr) throws DOMException {
        attr = Utils.create(attr, this.getOwnerDocument());
        if (this.msOpt) {
            this.mappingScope = DOMElementImpl_MS.addMapping(this.mappingScope, attr.getName(), attr.getValue());
        }
        return super.setAttributeNodeNS(attr);
    }

    private static final int findIndex(String s, NamedNodeMap nodes) {
        int indx = 0;
        int bot = 0;
        int top = nodes.getLength() - 1;
        while (bot <= top) {
            indx = (bot + top) / 2;
            int comp = s.compareTo(((Attr)nodes.item(indx)).getNodeName());
            if (comp == 0) {
                return indx;
            }
            if (comp < 0) {
                top = indx - 1;
                continue;
            }
            bot = indx + 1;
        }
        if (bot > indx) {
            indx = bot;
        } else if (indx > nodes.getLength()) {
            indx = nodes.getLength();
        }
        return indx;
    }

    private static MappingScope addMapping(MappingScope ms, String qualifiedName, String value2) {
        if (ms == null) {
            ms = new MappingScope();
        }
        if (XMLNS == qualifiedName || XMLNS.equals(qualifiedName)) {
            ms.addMapping(value2, EMPTY_STRING);
        } else if (qualifiedName.startsWith(XMLNS_COLON)) {
            String prefix = qualifiedName.substring(6);
            ms.addMapping(value2, prefix);
        }
        return ms;
    }

    private static void removeMapping(MappingScope ms, String qualifiedName) {
        if (ms != null) {
            if (XMLNS == qualifiedName || XMLNS.equals(qualifiedName)) {
                ms.removeMappingForPrefix(EMPTY_STRING);
            } else if (qualifiedName.startsWith(XMLNS_COLON)) {
                String prefix = qualifiedName.substring(6);
                ms.removeMappingForPrefix(prefix);
            }
        }
    }
}

