/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.xmlsoap.builders;

import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.description.FaultDesc;
import com.ibm.ws.webservices.engine.description.OperationDesc;
import com.ibm.ws.webservices.engine.encoding.DefaultDeserializer;
import com.ibm.ws.webservices.engine.encoding.DeserializationContext;
import com.ibm.ws.webservices.engine.encoding.Deserializer;
import com.ibm.ws.webservices.engine.encoding.utils.Callback;
import com.ibm.ws.webservices.engine.encoding.utils.CallbackTarget;
import com.ibm.ws.webservices.engine.events.DEventProcessor;
import com.ibm.ws.webservices.engine.events.NOOPProcessor;
import com.ibm.ws.webservices.engine.events.P2DConverter;
import com.ibm.ws.webservices.engine.events.WrapperProcessor;
import com.ibm.ws.webservices.engine.utils.AttributeUtils;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.xmlsoap.Detail;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFault;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import javax.xml.namespace.QName;
import javax.xml.rpc.soap.SOAPFaultException;
import org.apache.commons.logging.Log;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class WebServicesFaultProcessor
extends DEventProcessor
implements Callback {
    protected static Log log = LogFactory.getLog(WebServicesFaultProcessor.class.getName());
    private SOAPFault soapFault;
    private FaultDesc faultDesc;
    private Object faultData;
    private boolean inDetail;
    private boolean firstDetail;
    private static HashMap TYPES = new HashMap(8);

    public WebServicesFaultProcessor(SOAPFault soapFault) throws SAXException {
        this.soapFault = soapFault;
    }

    public void startElement(String namespace, String localPart, String prefixedName, Attributes attributes, MappingScope mappingScope, DeserializationContext context) throws SAXException {
    }

    public DEventProcessor onStartChild(String namespace, String localPart, String prefixedName, Attributes attributes, MappingScope mappingScope, DeserializationContext context) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("Enter: WebServicesFaultProcessor.onStartChild()");
        }
        QName qName = QNameTable.createQName(namespace, localPart);
        if (!this.inDetail && this.soapFault.getSOAPFactory().getSOAPConstants().getFaultDetailQName().equals(qName)) {
            this.inDetail = true;
            this.firstDetail = true;
            return this;
        }
        if (this.inDetail && this.firstDetail) {
            this.firstDetail = false;
            this.faultDesc = WebServicesFaultProcessor.getFaultDesc(qName, context, this.soapFault);
            if (this.faultDesc != null && qName.equals(this.faultDesc.getPartQName())) {
                Class faultClass = WebServicesFaultProcessor.getFaultClassFromFaultDesc(this.faultDesc);
                if (faultClass == null || faultClass == javax.xml.soap.SOAPElement.class || faultClass == SOAPFaultException.class) {
                    return new NOOPProcessor();
                }
                Deserializer dser = null;
                if (attributes.getValue("href") == null) {
                    QName type = AttributeUtils.getTypeFromAttributes(namespace, localPart, attributes, mappingScope);
                    type = type == null ? this.faultDesc.getPartXmlType() : type;
                    dser = context.getDeserializer(null, type);
                } else {
                    dser = new DefaultDeserializer();
                    dser.setDefaultType(this.faultDesc.getPartXmlType());
                }
                if (dser != null) {
                    dser.registerValueTarget(new CallbackTarget(this, "faultData"));
                }
                return dser;
            }
        }
        return new NOOPProcessor();
    }

    public void onEndChild(String namespace, String localName, DeserializationContext context) throws SAXException {
        this.inDetail = false;
        super.onEndChild(namespace, localName, context);
    }

    public void endElement(String namespace, String localPart, DeserializationContext context) throws SAXException {
    }

    public void setValue(Object value2, Object hint) {
        this.faultData = value2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WebServicesFault createFault(SOAPFault soapFault, DeserializationContext context) throws SAXException {
        WebServicesFault f = null;
        WebServicesFaultProcessor wsfProcessor = new WebServicesFaultProcessor(soapFault);
        Node parent = soapFault.getParentNode();
        if (parent != null && parent instanceof SOAPElement) {
            Iterator it = ((SOAPElement)((Object)parent)).getChildElements();
            while (it.hasNext()) {
                SOAPElement se;
                String id;
                Node node = (Node)it.next();
                if (!(node instanceof SOAPElement) || (id = AttributeUtils.getID((se = (SOAPElement)((Object)node)).getSAXAttributes())) == null) continue;
                context.getHrefTable().addObjectByID(id, se);
            }
        }
        context.createEventConverter(new WrapperProcessor(wsfProcessor));
        try {
            P2DConverter converter = context.getEventConverter();
            soapFault.toEvents(converter);
            Object var10_9 = null;
            context.freeEventConverter();
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            context.freeEventConverter();
            throw throwable;
        }
        FaultDesc faultDesc = wsfProcessor.faultDesc;
        Object faultData = wsfProcessor.faultData;
        QName faultCode = soapFault.getFaultCodeAsQName();
        String faultString = soapFault.getFaultString();
        if (faultString != null && faultString.startsWith("<![CDATA[") && faultString.endsWith("]]>")) {
            faultString = faultString.substring("<![CDATA[".length());
            faultString = faultString.substring(0, faultString.length() - "]]>".length());
        }
        String faultActor = soapFault.getFaultActor();
        Detail faultDetail = (Detail)soapFault.getDetail();
        SOAPElement[] faultDetails = null;
        if (faultDetail != null) {
            int length = faultDetail.getNumChildren();
            faultDetails = new SOAPElement[length];
            for (int i = 0; i < length; ++i) {
                faultDetails[i] = faultDetail.getChildElement(i);
            }
        }
        if (faultDesc == null && faultDetail != null && faultDetail.getNumChildren() == 0) {
            faultDesc = WebServicesFaultProcessor.getFaultDesc(null, context, soapFault);
        }
        WebServicesFaultProcessor.copyWSAFaultAction(faultDesc, context.getMessageContext());
        Class faultClass = WebServicesFaultProcessor.getFaultClassFromFaultDesc(faultDesc);
        if (faultClass != null && faultClass != javax.xml.soap.SOAPElement.class && faultClass != SOAPFaultException.class) {
            try {
                if (faultData != null) {
                    Exception userFault = null;
                    if (faultData instanceof Exception) {
                        userFault = (Exception)faultData;
                    } else {
                        Class argClass = WebServicesFaultProcessor.ConvertWrapper(faultData.getClass());
                        Constructor con = faultClass.getConstructor(argClass);
                        userFault = (Exception)con.newInstance(faultData);
                    }
                    if (userFault != null) {
                        f = WebServicesFault.makeUserFault(userFault, faultCode);
                    }
                }
                if (WebServicesFault.class.isAssignableFrom(faultClass)) {
                    if (f == null) {
                        f = (WebServicesFault)faultClass.newInstance();
                    }
                    f.setFaultDetail((Element[])faultDetails);
                }
                if (f == null && faultDesc != null) {
                    Exception userFault = (Exception)faultClass.newInstance();
                    f = WebServicesFault.makeUserFault(userFault, faultCode);
                }
                if (f != null) {
                    f.setFaultCode(faultCode);
                    f.setFaultString(faultString);
                    f.setFaultActor(faultActor);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (f == null && faultDetails != null) {
            SOAPFaultException sfe = new SOAPFaultException(faultCode, faultString, faultActor, faultDetail);
            f = WebServicesFault.makeUserFault(sfe, faultCode);
        }
        if (f == null) {
            f = new WebServicesFault(faultCode, faultString, faultActor, (Element[])faultDetails);
        }
        if (soapFault.getSOAPFactory().getSOAPConstants().getSOAPProtocol().equals("SOAP 1.2 Protocol")) {
            String nodeURI;
            Locale locale;
            Iterator it = soapFault.getFaultSubcodes();
            if (it != null && it.hasNext()) {
                ArrayList list = new ArrayList();
                while (it.hasNext()) {
                    list.add(it.next());
                }
                f.setSOAP12_Subcodes(list);
            }
            if ((locale = soapFault.getFaultStringLocale()) != null) {
                f.setSOAP12_ReasonLanguage(locale.getLanguage());
            }
            if ((nodeURI = soapFault.getFaultNode()) != null) {
                f.setSOAP12_Node(nodeURI);
            }
            try {
                Iterator itLocales = soapFault.getFaultReasonLocales();
                Iterator itText = soapFault.getFaultReasonTexts();
                if (itLocales != null && itText != null) {
                    itLocales.next();
                    itText.next();
                    ArrayList<String> list = new ArrayList<String>();
                    while (itLocales.hasNext() && itText.hasNext()) {
                        Locale l = (Locale)itLocales.next();
                        list.add(l.getLanguage());
                        list.add((String)itText.next());
                    }
                    f.setSOAP12_AdditionalReasons(list);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return f;
    }

    public static void copyWSAFaultAction(FaultDesc faultDesc, MessageContext msgCtx) {
        if (faultDesc != null) {
            String wsaAction = (String)faultDesc.getOption(OperationDesc.FAULT_WSA_ACTION);
            if (wsaAction == null) {
                wsaAction = new String("");
            }
            msgCtx.setProperty(OperationDesc.FAULT_WSA_ACTION, wsaAction);
            String faultName = (String)faultDesc.getOption(OperationDesc.FAULT_NAME);
            if (faultName == null) {
                faultName = new String("");
            }
            msgCtx.setProperty(OperationDesc.FAULT_NAME, faultName);
        }
    }

    private static Class getFaultClassFromFaultDesc(FaultDesc faultDesc) {
        if (faultDesc != null) {
            try {
                return ClassUtils.forName(faultDesc.getClassName());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    private static FaultDesc getFaultDesc(QName qName, DeserializationContext context, SOAPFault soapFault) {
        OperationDesc op;
        FaultDesc faultDesc = null;
        MessageContext msgContext = context.getMessageContext();
        if (msgContext != null && (op = msgContext.getOperation()) != null) {
            FaultDesc fd;
            int i;
            ArrayList faults = op.getFaults();
            if (faults != null) {
                for (i = 0; i < faults.size() && faultDesc == null; ++i) {
                    fd = (FaultDesc)faults.get(i);
                    if (fd.getPartQName() == null || fd.getPartQName() != qName && !fd.getPartQName().equals(qName)) continue;
                    faultDesc = fd;
                }
            }
            if (faultDesc == null) {
                faultDesc = op.getFaultByFaultCode(soapFault.getFaultCodeAsQName());
            }
            if (faultDesc == null && faults != null) {
                for (i = 0; i < faults.size() && faultDesc == null; ++i) {
                    fd = (FaultDesc)faults.get(i);
                    String partName = (String)fd.getOption(FaultDesc.MESSAGE_PART_NAME);
                    if (partName == null || partName != qName.getLocalPart() && !partName.equals(qName.getLocalPart())) continue;
                    faultDesc = fd;
                }
            }
        }
        return faultDesc;
    }

    private static Class ConvertWrapper(Class cls) {
        Class ret = (Class)TYPES.get(cls);
        if (ret != null) {
            return ret;
        }
        return cls;
    }

    static {
        TYPES.put(Character.class, Character.TYPE);
        TYPES.put(Integer.class, Integer.TYPE);
        TYPES.put(Float.class, Float.TYPE);
        TYPES.put(Boolean.class, Boolean.TYPE);
        TYPES.put(Double.class, Double.TYPE);
        TYPES.put(Byte.class, Byte.TYPE);
        TYPES.put(Short.class, Short.TYPE);
        TYPES.put(Long.class, Long.TYPE);
    }
}

