/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.xmlsoap;

import com.ibm.websphere.webservices.soap.IBMSOAPHeader;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.Mapping;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import com.ibm.ws.webservices.engine.xmlsoap.Comment;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPConstants;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPEnvelope;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPHeaderElement;
import com.ibm.ws.webservices.engine.xmlsoap.Text;
import com.ibm.ws.webservices.engine.xmlsoap.Utils;
import com.ibm.ws.webservices.engine.xmlsoap.builders.SOAPBuilder;
import com.ibm.ws.webservices.engine.xmlsoap.builders.SOAPHeaderBuilder;
import com.ibm.ws.webservices.engine.xmlsoap.saaj12.SAAJ12Text;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPException;
import org.w3c.dom.Node;

public final class SOAPHeader
extends SOAPElement
implements IBMSOAPHeader {
    private static String emptyString = "".intern();

    SOAPHeader(SOAPFactory soapFactory) {
        super(soapFactory.getSOAPConstants().getHeaderQName().getNamespaceURI(), soapFactory.getSOAPConstants().getHeaderQName().getLocalPart(), soapFactory);
    }

    public void setParentElement(javax.xml.soap.SOAPElement parent) throws SOAPException {
        super.setParentElement((SOAPEnvelope)parent);
    }

    public javax.xml.soap.SOAPHeaderElement addHeaderElement(Name name2) throws SOAPException {
        String namespaceURI = this._validateHeaderQName(name2.getURI(), name2.getPrefix(), name2.getLocalName());
        SOAPHeaderElement headerElement = (SOAPHeaderElement)this.createChildElement(namespaceURI, name2.getLocalName(), this.soapFactory);
        headerElement.setPrefix(name2.getPrefix());
        headerElement = (SOAPHeaderElement)this.addChildElement(headerElement);
        return headerElement;
    }

    public Iterator examineHeaderElements(String actor) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(actor == null ? emptyString : actor);
        return this.getHeadersByActors(list).iterator();
    }

    public Iterator extractHeaderElements(String actor) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(actor == null ? emptyString : actor);
        Vector results = this.getHeadersByActors(list);
        Iterator iterator = results.iterator();
        while (iterator.hasNext()) {
            ((SOAPHeaderElement)iterator.next()).detachNode();
        }
        return results.iterator();
    }

    public Iterator examineAllHeaderElements() {
        ArrayList<Node> headers = new ArrayList<Node>();
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof SOAPHeaderElement)) continue;
            headers.add(node);
        }
        return headers.iterator();
    }

    public Iterator examineMustUnderstandHeaderElements(String actor) {
        if (actor == null) {
            actor = emptyString;
        }
        ArrayList<SOAPHeaderElement> headers = new ArrayList<SOAPHeaderElement>();
        Iterator it = this.getChildElements();
        while (it.hasNext()) {
            SOAPHeaderElement header2;
            Node node = (Node)it.next();
            if (!(node instanceof SOAPHeaderElement) || !(header2 = (SOAPHeaderElement)((Object)node)).getMustUnderstand() || !header2.getActor().equals(actor)) continue;
            headers.add(header2);
        }
        return headers.iterator();
    }

    public Iterator extractAllHeaderElements() {
        ArrayList<Node> headers = new ArrayList<Node>();
        for (Node header2 = this.getFirstChild(); header2 != null; header2 = header2.getNextSibling()) {
            if (!(header2 instanceof SOAPHeaderElement)) continue;
            headers.add(header2);
        }
        for (int i = 0; i < headers.size(); ++i) {
            SOAPHeaderElement header3 = (SOAPHeaderElement)headers.get(i);
            header3.detachNode();
        }
        return headers.iterator();
    }

    public Vector getHeadersByActors(Collection actors) {
        Vector<SOAPHeaderElement> results = new Vector<SOAPHeaderElement>();
        if (actors != null && actors.size() > 0) {
            Iterator i = this.getChildElements();
            while (i.hasNext()) {
                SOAPHeaderElement header2;
                String actor;
                Node node = (Node)i.next();
                if (!(node instanceof SOAPHeaderElement) || !actors.contains(actor = (header2 = (SOAPHeaderElement)((Object)node)).getActor())) continue;
                results.add(header2);
            }
        }
        return results;
    }

    public SOAPHeaderElement getHeaderByName(String namespace, String localPart, boolean accessAllHeaders) throws SOAPException {
        return (SOAPHeaderElement)this.getChildElement(namespace, localPart);
    }

    protected SOAPBuilder createBuilder() {
        return new SOAPHeaderBuilder();
    }

    protected SOAPElement createChildElement(String namespaceURI, String localPart, SOAPFactory factory) throws SOAPException {
        this._validateHeaderQName(namespaceURI, null, localPart);
        return new SOAPHeaderElement(namespaceURI, localPart, factory);
    }

    protected boolean isValidSAAJChild(Node node) {
        Class<?> cls = node.getClass();
        return (cls.equals(SOAPHeaderElement.class) || cls.equals(Text.class) || cls.equals(Comment.class) || cls.equals(SAAJ12Text.class)) && this.getOwnerDocument() == node.getOwnerDocument();
    }

    public javax.xml.soap.SOAPHeaderElement addHeaderElement(QName qname) throws SOAPException {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "addHeaderElement(QName)", "javax.xml.soap.SOAPHeader"));
        }
        String namespaceURI = this._validateHeaderQName(qname.getNamespaceURI(), qname.getPrefix(), qname.getLocalPart());
        SOAPHeaderElement headerElement = (SOAPHeaderElement)this.createChildElement(namespaceURI, qname.getLocalPart(), this.soapFactory);
        headerElement.setPrefix(qname.getPrefix());
        headerElement = (SOAPHeaderElement)this.addChildElement(headerElement);
        return headerElement;
    }

    private String _validateHeaderQName(String uri, String prefix, String value2) throws SOAPException {
        if (disableSOAPNamespaceValidation) {
            return uri;
        }
        String namespaceURI = uri;
        if (uri == null || uri.equals("")) {
            if (prefix == null || prefix.equals("")) {
                throw new SOAPException(Messages.getMessage("unqualifiedName", "SOAPHeaderElement", value2, prefix, uri));
            }
            Mapping map = this._getMappingScope().getMappingForPrefix(prefix, false);
            if (map == null) {
                throw new SOAPException(Messages.getMessage("unqualifiedName", "SOAPHeaderElement", value2, prefix, uri));
            }
            namespaceURI = map.getNamespaceURI();
        }
        return namespaceURI;
    }

    public javax.xml.soap.SOAPHeaderElement addNotUnderstoodHeaderElement(QName qName) throws SOAPException {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "addNotUnderstoodHeaderElement(QName)", "javax.xml.soap.SOAPHeader"));
        }
        SOAPConstants soapConstants = this.soapFactory.getSOAPConstants();
        if (!soapConstants.getSOAPProtocol().equals("SOAP 1.2 Protocol")) {
            throw new UnsupportedOperationException(Messages.getMessage("SOAP12ProtocolRequiredMethod", "addNotUnderstoodHeaderElement(QName)", "javax.xml.soap.Header", this.soapFactory.getSOAPConstants().getSOAPProtocol()));
        }
        QName notUnderstoodHeaderQName = new QName(soapConstants.getNotUnderstoodHeaderQName().getNamespaceURI(), soapConstants.getNotUnderstoodHeaderQName().getLocalPart(), this.getPrefix());
        SOAPHeaderElement she = (SOAPHeaderElement)this.addHeaderElement(notUnderstoodHeaderQName);
        String namespaceURI = she.getNamespaceURI(qName.getPrefix());
        if (!qName.getNamespaceURI().equals(namespaceURI)) {
            she.addNamespaceDeclaration(qName.getPrefix(), qName.getNamespaceURI());
        }
        she.setAttribute("qname", qName.getPrefix() + ":" + qName.getLocalPart());
        return she;
    }

    public javax.xml.soap.SOAPHeaderElement addUpgradeHeaderElement(Iterator supportedSOAPURIs) throws SOAPException {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "addUpgradeHeaderElement(QName)", "javax.xml.soap.SOAPHeader"));
        }
        SOAPConstants soapConstants = this.soapFactory.getSOAPConstants();
        QName upgradeHeaderQName = new QName(soapConstants.getUpgradeHeaderQName().getNamespaceURI(), soapConstants.getUpgradeHeaderQName().getLocalPart(), this.getPrefix());
        SOAPHeaderElement she = (SOAPHeaderElement)this.addHeaderElement(upgradeHeaderQName);
        while (supportedSOAPURIs.hasNext()) {
            String prefix;
            SOAPElement se;
            String namespaceURI;
            String uri = (String)supportedSOAPURIs.next();
            if (!uri.equals(namespaceURI = (se = (SOAPElement)she.addChildElement(soapConstants.getSupportedEnvelopeElementQName().getLocalPart(), this.getPrefix(), soapConstants.getSupportedEnvelopeElementQName().getNamespaceURI())).getNamespaceURI(prefix = "upgrade"))) {
                se.addNamespaceDeclaration(prefix, uri);
            }
            se.setAttribute("qname", prefix + ":Envelope");
        }
        return she;
    }

    public javax.xml.soap.SOAPHeaderElement addUpgradeHeaderElement(String[] supportedSoapUris) throws SOAPException {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "addUpgradeHeaderElement(Sgtring[])", "javax.xml.soap.SOAPHeader"));
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < supportedSoapUris.length; ++i) {
            list.add(supportedSoapUris[i]);
        }
        return this.addUpgradeHeaderElement(list.iterator());
    }

    public javax.xml.soap.SOAPHeaderElement addUpgradeHeaderElement(String supportedSoapUri) throws SOAPException {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "addUpgradeHeaderElement(String)", "javax.xml.soap.SOAPHeader"));
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(supportedSoapUri);
        return this.addUpgradeHeaderElement(list.iterator());
    }

    public javax.xml.soap.SOAPElement addTextNode(String text) throws SOAPException {
        if (this.isSOAP12() && !XMLUtils.isXMLWhitespace(text)) {
            throw new SOAPException(Messages.getMessage("unsupportedSAAJMethod", "addTextNode(String)", "javax.xml.soap.SOAPHeader"));
        }
        return super.addTextNode(text);
    }

    public void setEncodingStyle(String encodingStyle) throws SOAPException {
        if (this.isSOAP12()) {
            throw new SOAPException(Messages.getMessage("unsupportedSAAJMethod", "addEncodingStyle(String)", "javax.xml.soap.SOAPHeader"));
        }
        super.setEncodingStyle(encodingStyle);
    }

    public javax.xml.soap.SOAPElement setElementQName(QName newQName) throws SOAPException {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "setElementQName(QName)", "javax.xml.soap.SOAPHeader"));
        }
        if (!newQName.getNamespaceURI().equals(this.getNamespaceURI()) || !newQName.getLocalPart().equals(this.getLocalName())) {
            throw new SOAPException(Messages.getMessage("unsupportedSAAJMethod", "setElementQName(QName)", "javax.xml.soap.SOAPHeader"));
        }
        return super.setElementQName(newQName);
    }
}

