/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.xmlsoap;

import com.ibm.websphere.webservices.soap.IBMSOAPEnvelope;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.MCUtils;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import com.ibm.ws.webservices.engine.xmlsoap.Comment;
import com.ibm.ws.webservices.engine.xmlsoap.Name;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPBody;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPHeader;
import com.ibm.ws.webservices.engine.xmlsoap.Text;
import com.ibm.ws.webservices.engine.xmlsoap.Utils;
import com.ibm.ws.webservices.engine.xmlsoap.builders.SOAPBuilder;
import com.ibm.ws.webservices.engine.xmlsoap.builders.SOAPEnvelopeBuilder;
import com.ibm.ws.webservices.engine.xmlsoap.saaj12.SAAJ12Text;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import org.apache.commons.logging.Log;
import org.w3c.dom.Node;

public final class SOAPEnvelope
extends SOAPElement
implements IBMSOAPEnvelope {
    protected static Log log = LogFactory.getLog(SOAPEnvelope.class.getName());

    SOAPEnvelope(SOAPFactory soapFactory) throws SOAPException {
        this(false, soapFactory);
    }

    SOAPEnvelope(boolean doBootstrap, SOAPFactory soapFactory) throws SOAPException {
        super(soapFactory.getSOAPConstants().getEnvelopeQName().getNamespaceURI(), soapFactory.getSOAPConstants().getEnvelopeQName().getLocalPart(), soapFactory);
        this.setPrefix(soapFactory.getSOAPConstants().getEnvelopePrefix());
        if (doBootstrap) {
            this.bootstrap();
        }
        this.addHeader();
        this.addBody();
        soapFactory.getOwnerDocument().appendChild((Node)((Object)this));
    }

    private void bootstrap() throws SOAPException {
        this.addNamespaceDeclaration(this.soapFactory.getSOAPConstants().getEnvelopePrefix(), this.soapFactory.getSOAPConstants().getEnvelopeURI());
        this.addNamespaceDeclaration(this.soapFactory.getSOAPConstants().getEncodingPrefix(), this.soapFactory.getSOAPConstants().getEncodingURI());
        this.addNamespaceDeclaration("xsd", "http://www.w3.org/2001/XMLSchema");
        this.addNamespaceDeclaration("xsi", "http://www.w3.org/2001/XMLSchema-instance");
    }

    public javax.xml.soap.SOAPBody addBody() throws SOAPException {
        SOAPBody body = (SOAPBody)this.getBody();
        if (body == null) {
            body = new SOAPBody(this.soapFactory);
            body.setPrefix(this.getPrefix());
            body = (SOAPBody)this.addChildElement(body);
            return body;
        }
        throw new SOAPException(Messages.getMessage("bodyPresent"));
    }

    public javax.xml.soap.SOAPHeader addHeader() throws SOAPException {
        SOAPHeader header2 = (SOAPHeader)this.getHeader();
        if (header2 == null) {
            header2 = new SOAPHeader(this.soapFactory);
            header2.setPrefix(this.getPrefix());
            header2 = (SOAPHeader)((Object)this.insertBefore((Node)((Object)header2), (Node)this.getBody()));
            return header2;
        }
        throw new SOAPException(Messages.getMessage("headerPresent"));
    }

    public javax.xml.soap.Name createName(String localName) throws SOAPException {
        return new Name("", localName, "");
    }

    public javax.xml.soap.Name createName(String localName, String prefix, String uri) throws SOAPException {
        return new Name(uri, localName, prefix);
    }

    public javax.xml.soap.SOAPBody getBody() throws SOAPException {
        Node node;
        for (node = this.getFirstChild(); node != null && !(node instanceof SOAPBody); node = node.getNextSibling()) {
        }
        return (SOAPBody)((Object)node);
    }

    public javax.xml.soap.SOAPHeader getHeader() throws SOAPException {
        Node node;
        for (node = this.getFirstChild(); node != null && !(node instanceof SOAPHeader); node = node.getNextSibling()) {
        }
        return (SOAPHeader)((Object)node);
    }

    public javax.xml.soap.SOAPElement addChildElement(javax.xml.soap.SOAPElement element) throws SOAPException {
        if (element instanceof SOAPHeader) {
            SOAPHeader header2 = (SOAPHeader)this.getHeader();
            if (header2 != null && header2 != element) {
                header2.detachNode();
            }
            element = super.addChildElement(element);
            return element;
        }
        if (element instanceof SOAPBody) {
            SOAPBody body = (SOAPBody)this.getBody();
            if (body != null && body != element) {
                body.detachNode();
            }
            element = super.addChildElement(element);
            return element;
        }
        if (this.isSOAP12()) {
            throw new SOAPException(Messages.getMessage("addChildElement2Err00", element.getClass().getName(), this.getClass().getName()));
        }
        element = super.addChildElement(element);
        return element;
    }

    protected SOAPBuilder createBuilder() {
        return new SOAPEnvelopeBuilder(this);
    }

    protected SOAPElement createChildElement(String namespaceURI, String localPart, SOAPFactory factory) throws SOAPException {
        QName bodyQName = this.soapFactory.getSOAPConstants().getBodyQName();
        QName headerQName = this.soapFactory.getSOAPConstants().getHeaderQName();
        if (bodyQName.getNamespaceURI().equals(namespaceURI) && bodyQName.getLocalPart().equals(localPart)) {
            return new SOAPBody(factory);
        }
        if (headerQName.getNamespaceURI().equals(namespaceURI) && headerQName.getLocalPart().equals(localPart)) {
            return new SOAPHeader(factory);
        }
        return super.createChildElement(namespaceURI, localPart, factory);
    }

    protected boolean isValidSAAJChild(Node node) {
        QName bodyQName = this.soapFactory.getSOAPConstants().getBodyQName();
        QName headerQName = this.soapFactory.getSOAPConstants().getHeaderQName();
        Class<?> cls = node.getClass();
        if (node.getClass().equals(SOAPElement.class)) {
            SOAPElement se = (SOAPElement)((Object)node);
            if (this.getNamespaceURI().equals(se.getNamespaceURI()) && (bodyQName.getLocalPart().equals(se.getLocalName()) || headerQName.getLocalPart().equals(se.getLocalName()))) {
                return false;
            }
        }
        return (cls.equals(SOAPBody.class) || cls.equals(SOAPHeader.class) || cls.equals(SOAPElement.class) || cls.equals(Text.class) || cls.equals(Comment.class) || cls.equals(SAAJ12Text.class)) && this.getOwnerDocument() == node.getOwnerDocument();
    }

    protected void outputImpl(SerializationContext context, boolean includeNSDecls) throws Exception {
        try {
            super.outputImpl(context, includeNSDecls);
        }
        catch (Exception e) {
            throw MCUtils.interceptSerializationException(e, context);
        }
    }

    public javax.xml.soap.SOAPElement addTextNode(String text) throws SOAPException {
        if (this.isSOAP12() && !XMLUtils.isXMLWhitespace(text)) {
            throw new SOAPException(Messages.getMessage("unsupportedSAAJMethod", "addTextNode(String)", "javax.xml.soap.SOAPEnvelope"));
        }
        return super.addTextNode(text);
    }

    public void setEncodingStyle(String encodingStyle) throws SOAPException {
        if (this.isSOAP12()) {
            throw new SOAPException(Messages.getMessage("unsupportedSAAJMethod", "setEncodingStyle(String)", "javax.xml.soap.SOAPEnvelope"));
        }
        super.setEncodingStyle(encodingStyle);
    }

    public javax.xml.soap.SOAPElement setElementQName(QName newQName) throws SOAPException {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "setElementQName(QName)", "javax.xml.soap.SOAPEnvelope"));
        }
        if (!newQName.getNamespaceURI().equals(this.getNamespaceURI()) || !newQName.getLocalPart().equals(this.getLocalName())) {
            throw new SOAPException(Messages.getMessage("unsupportedSAAJMethod", "setElementQName(QName)", "javax.xml.soap.SOAPEnvelope"));
        }
        return super.setElementQName(newQName);
    }
}

