/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.xmlsoap;

import com.ibm.websphere.webservices.soap.IBMSOAPBody;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.xmlsoap.Comment;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPBodyElement;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPDocument;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPEnvelope;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFault;
import com.ibm.ws.webservices.engine.xmlsoap.Text;
import com.ibm.ws.webservices.engine.xmlsoap.Utils;
import com.ibm.ws.webservices.engine.xmlsoap.builders.SOAPBodyBuilder;
import com.ibm.ws.webservices.engine.xmlsoap.builders.SOAPBuilder;
import com.ibm.ws.webservices.engine.xmlsoap.ext.RequestResponse;
import com.ibm.ws.webservices.engine.xmlsoap.saaj12.SAAJ12Text;
import java.util.Iterator;
import java.util.Locale;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SOAPBody
extends SOAPElement
implements IBMSOAPBody {
    SOAPBody(SOAPFactory soapFactory) {
        super(soapFactory.getSOAPConstants().getBodyQName().getNamespaceURI(), soapFactory.getSOAPConstants().getBodyQName().getLocalPart(), soapFactory);
    }

    public RequestResponse getRequestResponse() {
        return this.altContent == null ? null : this.altContent.asRequestResponse();
    }

    public void setParentElement(javax.xml.soap.SOAPElement parent) throws SOAPException {
        if (parent == null) {
            throw new IllegalArgumentException(Messages.getMessage("nullParent00"));
        }
        try {
            super.setParentElement((SOAPEnvelope)parent);
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, "com.ibm.ws.webservices.engine.xmlsoap.SOAPBody.setParentElement", "152", this);
            throw new SOAPException(t);
        }
    }

    public javax.xml.soap.SOAPBodyElement addBodyElement(Name name2) throws SOAPException {
        SOAPBodyElement bodyElement = (SOAPBodyElement)this.createChildElement(name2.getURI(), name2.getLocalName(), this.soapFactory);
        bodyElement.setPrefix(name2.getPrefix());
        bodyElement = (SOAPBodyElement)this.addChildElement(bodyElement);
        return bodyElement;
    }

    public javax.xml.soap.SOAPBodyElement addDocument(Document document) throws SOAPException {
        Element root = document.getDocumentElement();
        SOAPBodyElement sbe = new SOAPBodyElement(root, this.soapFactory);
        sbe = (SOAPBodyElement)this.addChildElement(sbe);
        return sbe;
    }

    public javax.xml.soap.SOAPFault addFault() throws SOAPException {
        SOAPFault fault2 = this.soapFactory.createSOAPFault();
        fault2.setPrefix(this.getPrefix());
        fault2 = (SOAPFault)this.addChildElement(fault2);
        fault2.setFaultCode(this.soapFactory.getSOAPConstants().getDefaultFaultCode());
        return fault2;
    }

    public javax.xml.soap.SOAPFault addFault(Name faultCode, String faultString, Locale locale) throws SOAPException {
        SOAPFault fault2 = this.soapFactory.createSOAPFault();
        fault2.setPrefix(this.getPrefix());
        fault2 = (SOAPFault)this.addChildElement(fault2);
        fault2.setFaultCode(faultCode);
        fault2.setFaultString(faultString, locale);
        return fault2;
    }

    public javax.xml.soap.SOAPFault addFault(Name faultCode, String faultString) throws SOAPException {
        return this.addFault(faultCode, faultString, null);
    }

    public javax.xml.soap.SOAPFault getFault() {
        Node node;
        for (node = this.getFirstChild(); node != null && !(node instanceof SOAPFault); node = node.getNextSibling()) {
        }
        return (SOAPFault)((Object)node);
    }

    public boolean hasFault() {
        return this.getFault() != null;
    }

    protected SOAPBuilder createBuilder() {
        return new SOAPBodyBuilder();
    }

    protected SOAPElement createChildElement(String namespaceURI, String localPart, SOAPFactory factory) throws SOAPException {
        QName faultQName = factory.getSOAPConstants().getFaultQName();
        if (faultQName.getNamespaceURI().equals(namespaceURI) && faultQName.getLocalPart().equals(localPart)) {
            return new SOAPFault(factory);
        }
        if (namespaceURI == null || namespaceURI.length() == 0) {
            return new SOAPBodyElement(null, localPart, factory);
        }
        return new SOAPBodyElement(namespaceURI, localPart, factory);
    }

    protected boolean isValidSAAJChild(Node node) {
        Class<?> cls = node.getClass();
        boolean rc = (cls.equals(SOAPBodyElement.class) || cls.equals(SOAPFault.class) || cls.equals(Text.class) || cls.equals(Comment.class) || cls.equals(SAAJ12Text.class)) && this.getOwnerDocument() == node.getOwnerDocument();
        return rc;
    }

    protected boolean isObjectContent() throws Exception {
        Object alternateContent = this.getAlternateContent();
        if (alternateContent == null || alternateContent instanceof RequestResponse) {
            return false;
        }
        return super.isObjectContent();
    }

    public javax.xml.soap.SOAPFault addFault(QName faultCode, String faultString, Locale locale) throws SOAPException {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "addFault(QName, String, Locale)", "javax.xml.soap.SOAPBody"));
        }
        SOAPFault fault2 = this.soapFactory.createSOAPFault();
        fault2.setPrefix(this.getPrefix());
        fault2 = (SOAPFault)this.addChildElement(fault2);
        fault2.setFaultCode(faultCode);
        fault2.setFaultString(faultString, locale);
        return fault2;
    }

    public javax.xml.soap.SOAPFault addFault(QName faultCode, String faultString) throws SOAPException {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "addFault(QName, String)", "javax.xml.soap.SOAPBody"));
        }
        return this.addFault(faultCode, faultString, null);
    }

    public javax.xml.soap.SOAPBodyElement addBodyElement(QName qName) throws SOAPException {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "addBodyElement(QName, String)", "javax.xml.soap.SOAPBody"));
        }
        SOAPBodyElement bodyElement = (SOAPBodyElement)this.createChildElement(qName.getNamespaceURI(), qName.getLocalPart(), this.soapFactory);
        bodyElement.setPrefix(qName.getPrefix());
        bodyElement = (SOAPBodyElement)this.addChildElement(bodyElement);
        return bodyElement;
    }

    public Document extractContentAsDocument() throws SOAPException {
        SOAPElement se = null;
        Iterator it = this.getChildElements();
        if (!it.hasNext()) {
            throw new SOAPException(Messages.getMessage("extractContentAsDocument", "0"));
        }
        while (it.hasNext()) {
            Node node = (Node)it.next();
            if (!(node instanceof SOAPElement)) continue;
            if (se != null) {
                throw new SOAPException(Messages.getMessage("extractContentAsDocument", ">1"));
            }
            se = (SOAPElement)((Object)node);
        }
        if (se == null) {
            throw new SOAPException(Messages.getMessage("extractContentAsDocument", "0"));
        }
        se.detachNode();
        SOAPDocument document = new SOAPDocument();
        Node node = document.importNode((Node)((Object)se), true);
        document.appendChild(node);
        return document;
    }

    public void setEncodingStyle(String encodingStyle) throws SOAPException {
        if (this.isSOAP12()) {
            throw new SOAPException(Messages.getMessage("unsupportedSAAJMethod", "setEncodingStyle(String)", "javax.xml.soap.SOAPBody"));
        }
        super.setEncodingStyle(encodingStyle);
    }

    public javax.xml.soap.SOAPElement setElementQName(QName newQName) throws SOAPException {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "setElementQName(QName)", "javax.xml.soap.SOAPBody"));
        }
        if (!newQName.getNamespaceURI().equals(this.getNamespaceURI()) || !newQName.getLocalPart().equals(this.getLocalName())) {
            throw new SOAPException(Messages.getMessage("unsupportedSAAJMethod", "setElementQName(QName)", "javax.xml.soap.SOAPBody"));
        }
        return super.setElementQName(newQName);
    }
}

