/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.xmlsoap;

import com.ibm.ws.webservices.engine.xmlsoap.SOAPBody;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPBodyElement;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPEnvelope;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPHeader;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPHeaderElement;
import javax.xml.soap.SOAPException;

class ProtectionChecker {
    ProtectionChecker() {
    }

    static void protectionCheck_changeNamespaces(SOAPElement element) {
        if (ProtectionChecker.isProtect(element) && ProtectionChecker.atOrAboveParameterElement(element)) {
            ProtectionChecker.setProtectionViolation(element);
        }
    }

    static void protectionCheck_removeChildElement(SOAPElement element) {
        if (ProtectionChecker.isProtect(element) && ProtectionChecker.atOrAboveOperationElement(element)) {
            ProtectionChecker.setProtectionViolation(element);
        }
    }

    static void protectionCheck_addChildElement(SOAPElement element) {
        if (ProtectionChecker.isProtect(element) && ProtectionChecker.atOrAboveOperationElement(element)) {
            ProtectionChecker.setProtectionViolation(element);
        }
    }

    static void protectionCheck_removeElement(SOAPElement element) {
        if (ProtectionChecker.isProtect(element) && ProtectionChecker.atOrAboveParameterElement(element)) {
            ProtectionChecker.setProtectionViolation(element);
        }
    }

    static void protectionCheck_changeAttributes(SOAPElement element) {
        if (ProtectionChecker.isProtect(element) && ProtectionChecker.atOrAboveParameterElement(element)) {
            ProtectionChecker.setProtectionViolation(element);
        }
    }

    static void protectionCheck_accessAttributes(SOAPElement element) {
    }

    static void protectionCheck_setAlternateContent(SOAPElement element) {
        if (ProtectionChecker.isProtect(element) && ProtectionChecker.atOrAboveParameterElement(element)) {
            ProtectionChecker.setProtectionViolation(element);
        }
    }

    private static boolean isProtect(SOAPElement element) {
        return element.isProtect && !element.inAsSOAPElement && element.getSOAPFactory().getProtectState();
    }

    private static boolean atOrAboveParameterElement(SOAPElement element) {
        if (!ProtectionChecker.attachedToEnvelope(element)) {
            return false;
        }
        if (element instanceof SOAPEnvelope || element instanceof SOAPBody || element instanceof SOAPHeader || element instanceof SOAPBodyElement || element instanceof SOAPHeaderElement) {
            return true;
        }
        if ((element = (SOAPElement)element.getParentElement()) == null || element instanceof SOAPEnvelope || element instanceof SOAPBody || element instanceof SOAPHeader) {
            return true;
        }
        return element.getParentElement() instanceof SOAPBody && ((SOAPElement)element.getParentElement()).getChildElement(0) == element;
    }

    private static boolean atOrAboveOperationElement(SOAPElement element) {
        if (!ProtectionChecker.attachedToEnvelope(element)) {
            return false;
        }
        if (element instanceof SOAPEnvelope || element instanceof SOAPBody || element instanceof SOAPBodyElement) {
            return true;
        }
        return (element = (SOAPElement)element.getParentElement()) == null || element instanceof SOAPEnvelope || element instanceof SOAPBody;
    }

    private static boolean attachedToEnvelope(SOAPElement element) {
        while (element != null && !(element instanceof SOAPEnvelope)) {
            element = (SOAPElement)element.getParentElement();
        }
        return element != null;
    }

    private static void setProtectionViolation(SOAPElement element) {
        SOAPFactory sf = element.getSOAPFactory();
        sf.setProtectionViolation(true);
        try {
            SOAPEnvelope env = sf.getSOAPEnvelope();
            SOAPBody body = (SOAPBody)env.getBody();
            body.isProtect = false;
        }
        catch (SOAPException sOAPException) {
            // empty catch block
        }
    }
}

