/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.utils;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.Version;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

public class tcpmon
extends JFrame {
    private static String binaryCopyright = Version.getBinaryCopyright();
    private JTabbedPane notebook = new JTabbedPane();
    private static int STATE_COLUMN = 0;
    private static int TIME_COLUMN = 1;
    private static int INHOST_COLUMN = 2;
    private static int OUTHOST_COLUMN = 3;
    private static int REQ_COLUMN = 4;
    private static ResourceBundle messages = null;

    public tcpmon(int listenPort, String targetHost, int targetPort) {
        super(tcpmon.getMessage("tcpmon00", "TCPMonitor"));
        this.getContentPane().add(this.notebook);
        new AdminPage(this.notebook, tcpmon.getMessage("admin00", "Admin"));
        if (listenPort != 0) {
            Listener l = null;
            l = targetHost == null ? new Listener(this.notebook, null, listenPort, targetHost, targetPort, true) : new Listener(this.notebook, null, listenPort, targetHost, targetPort, false);
            this.notebook.setSelectedIndex(1);
            l.HTTPProxyHost = System.getProperty("http.proxyHost");
            if (l.HTTPProxyHost != null && l.HTTPProxyHost.equals("")) {
                l.HTTPProxyHost = null;
            }
            if (l.HTTPProxyHost != null) {
                String tmp = System.getProperty("http.proxyPort");
                if (tmp != null && tmp.equals("")) {
                    tmp = null;
                }
                l.HTTPProxyPort = tmp == null ? 80 : Integer.parseInt(tmp);
            }
        }
        this.pack();
        this.setSize(600, 600);
        this.setVisible(true);
    }

    protected void processWindowEvent(WindowEvent event) {
        switch (event.getID()) {
            case 201: {
                this.exit();
                break;
            }
            default: {
                super.processWindowEvent(event);
            }
        }
    }

    private void exit() {
        System.exit(0);
    }

    public void setInputPort(int port2) {
    }

    public void setOutputHostPort(char hostName, int port2) {
    }

    public static void main(String[] args) {
        try {
            if (args.length == 3) {
                int p1 = Integer.parseInt(args[0]);
                int p2 = Integer.parseInt(args[2]);
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                new tcpmon(p1, args[1], p2);
            } else if (args.length == 1) {
                int p1 = Integer.parseInt(args[0]);
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                new tcpmon(p1, null, 0);
            } else if (args.length != 0) {
                System.err.println(tcpmon.getMessage("usage00", "Usage:") + " tcpmon <listenPort> <targetHost> <targetPort>\n");
            } else {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                new tcpmon(0, null, 0);
            }
        }
        catch (NumberFormatException ex) {
            System.err.println(tcpmon.getMessage("usage00", "Usage:") + " tcpmon <listenPort> <targetHost> <targetPort>\n");
        }
        catch (Throwable exp) {
            FFDCFilter.processException(exp, "com.ibm.ws.webservices.engine.utils.tcpmon.main", "1578");
            exp.printStackTrace();
        }
    }

    public static String getMessage(String key, String defaultMsg) {
        try {
            if (messages == null) {
                tcpmon.initializeMessages();
            }
            return messages.getString(key);
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, "com.ibm.ws.webservices.engine.utils.tcpmon.getMessage", "1599");
            return defaultMsg;
        }
    }

    private static void initializeMessages() {
        messages = ResourceBundle.getBundle("com.ibm.ws.webservices.engine.utils.tcpmon");
    }

    class Listener
    extends JPanel {
        public Socket inputSocket = null;
        public Socket outputSocket = null;
        public JTextField portField = null;
        public JTextField hostField = null;
        public JTextField tPortField = null;
        public JCheckBox isProxyBox = null;
        public JButton stopButton = null;
        public JButton removeButton = null;
        public JButton removeAllButton = null;
        public JCheckBox xmlFormatBox = null;
        public JButton saveButton = null;
        public JButton loadButton = null;
        public JButton resendButton = null;
        public JButton findButton = null;
        public JButton switchButton = null;
        public JButton closeButton = null;
        public JTable connectionTable = null;
        public DefaultTableModel tableModel = null;
        public JSplitPane outPane = null;
        public ServerSocket sSocket = null;
        public SocketWaiter sw = null;
        public JPanel leftPanel = null;
        public JPanel rightPanel = null;
        public JTabbedPane notebook = null;
        public String HTTPProxyHost = null;
        public int HTTPProxyPort = 80;
        public final Vector connections = new Vector();
        private final String POST_START = "POST http://";
        private final String POST_START_NPM = "POST /";
        private final String GET_START = "GET http://";
        private final String GET_START_NPM = "GET /";
        private final String HEADER_END1 = "\n\n";
        private final String HEADER_END2 = "\r\n\r\n";
        private final String CONTENT_LENGTH = "Content-Length:";
        private final String CL_END = "\n";

        public Listener(JTabbedPane _notebook, String name2, int listenPort, String host, int targetPort, boolean isProxy) {
            this.notebook = _notebook;
            if (name2 == null) {
                name2 = tcpmon.getMessage("port01", "Port") + " " + listenPort;
            }
            this.setLayout(new BorderLayout());
            JPanel top = new JPanel();
            top.setLayout(new BoxLayout(top, 0));
            top.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            final String start = tcpmon.getMessage("start00", "Start");
            this.stopButton = new JButton(start);
            top.add(this.stopButton);
            top.add(Box.createRigidArea(new Dimension(5, 0)));
            top.add(new JLabel("  " + tcpmon.getMessage("listenPort01", "Listen Port:") + " ", 4));
            this.portField = new JTextField("" + listenPort, 4);
            top.add(this.portField);
            top.add(new JLabel("  " + tcpmon.getMessage("host00", "Host:"), 4));
            this.hostField = new JTextField(host, 30);
            top.add(this.hostField);
            top.add(new JLabel("  " + tcpmon.getMessage("port02", "Port:") + " ", 4));
            this.tPortField = new JTextField("" + targetPort, 4);
            top.add(this.tPortField);
            top.add(Box.createRigidArea(new Dimension(5, 0)));
            this.isProxyBox = new JCheckBox(tcpmon.getMessage("proxy00", "Proxy"));
            top.add(this.isProxyBox);
            this.isProxyBox.addChangeListener(new BasicButtonListener(this.isProxyBox){

                public void stateChanged(ChangeEvent event) {
                    JCheckBox box = (JCheckBox)event.getSource();
                    boolean state = box.isSelected();
                    Listener.this.tPortField.setEnabled(!state);
                    Listener.this.hostField.setEnabled(!state);
                }
            });
            this.isProxyBox.setSelected(isProxy);
            this.portField.setEditable(false);
            this.portField.setMaximumSize(new Dimension(50, Short.MAX_VALUE));
            this.hostField.setEditable(false);
            this.hostField.setMaximumSize(new Dimension(85, Short.MAX_VALUE));
            this.tPortField.setEditable(false);
            this.tPortField.setMaximumSize(new Dimension(50, Short.MAX_VALUE));
            this.stopButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    if (tcpmon.getMessage("stop00", "Stop").equals(event.getActionCommand())) {
                        Listener.this.stop();
                    }
                    if (start.equals(event.getActionCommand())) {
                        Listener.this.start();
                    }
                }
            });
            this.add((Component)top, "North");
            this.tableModel = new DefaultTableModel(new String[]{tcpmon.getMessage("state00", "State"), tcpmon.getMessage("time00", "Time"), tcpmon.getMessage("requestHost00", "Request Host"), tcpmon.getMessage("targetHost", "Target Host"), tcpmon.getMessage("request00", "Request...")}, 0);
            this.connectionTable = new JTable(1, 2);
            this.connectionTable.setModel(this.tableModel);
            this.connectionTable.setSelectionMode(2);
            TableColumn col = this.connectionTable.getColumnModel().getColumn(STATE_COLUMN);
            col.setMaxWidth(col.getPreferredWidth() / 2);
            col = this.connectionTable.getColumnModel().getColumn(REQ_COLUMN);
            col.setPreferredWidth(col.getPreferredWidth() * 2);
            this.tableModel.addRow(new Object[]{"---", tcpmon.getMessage("mostRecent00", "Most Recent"), "---", "---", "---"});
            JPanel tablePane = new JPanel();
            tablePane.setLayout(new BorderLayout());
            JScrollPane tableScrollPane = new JScrollPane(this.connectionTable);
            tablePane.add((Component)tableScrollPane, "Center");
            JPanel buttons = new JPanel();
            buttons.setLayout(new BoxLayout(buttons, 0));
            buttons.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            final String removeSelected = tcpmon.getMessage("removeSelected00", "Remove Selected");
            this.removeButton = new JButton(removeSelected);
            buttons.add(this.removeButton);
            buttons.add(Box.createRigidArea(new Dimension(5, 0)));
            final String removeAll = tcpmon.getMessage("removeAll00", "Remove All");
            this.removeAllButton = new JButton(removeAll);
            buttons.add(this.removeAllButton);
            tablePane.add((Component)buttons, "South");
            this.removeButton.setEnabled(false);
            this.removeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    if (removeSelected.equals(event.getActionCommand())) {
                        Listener.this.remove();
                    }
                }
            });
            this.removeAllButton.setEnabled(false);
            this.removeAllButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    if (removeAll.equals(event.getActionCommand())) {
                        Listener.this.removeAll();
                    }
                }
            });
            JPanel pane2 = new JPanel();
            pane2.setLayout(new BorderLayout());
            this.leftPanel = new JPanel();
            this.leftPanel.setAlignmentX(0.0f);
            this.leftPanel.setLayout(new BoxLayout(this.leftPanel, 1));
            this.leftPanel.add(new JLabel("  " + tcpmon.getMessage("request01", "Request")));
            this.leftPanel.add(new JLabel(" " + tcpmon.getMessage("wait01", "Waiting for connection")));
            this.rightPanel = new JPanel();
            this.rightPanel.setLayout(new BoxLayout(this.rightPanel, 1));
            this.rightPanel.add(new JLabel("  " + tcpmon.getMessage("response00", "Response")));
            this.rightPanel.add(new JLabel(""));
            this.outPane = new JSplitPane(0, this.leftPanel, this.rightPanel);
            this.outPane.setDividerSize(4);
            pane2.add((Component)this.outPane, "Center");
            JPanel bottomButtons = new JPanel();
            bottomButtons.setLayout(new BoxLayout(bottomButtons, 0));
            bottomButtons.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.xmlFormatBox = new JCheckBox(tcpmon.getMessage("xmlFormat00", "XML Format"), true);
            bottomButtons.add(this.xmlFormatBox);
            bottomButtons.add(Box.createRigidArea(new Dimension(5, 0)));
            final String save = tcpmon.getMessage("save00", "Save");
            this.saveButton = new JButton(save);
            bottomButtons.add(this.saveButton);
            bottomButtons.add(Box.createRigidArea(new Dimension(5, 0)));
            final String resend = tcpmon.getMessage("resend00", "Resend");
            this.resendButton = new JButton(resend);
            bottomButtons.add(this.resendButton);
            bottomButtons.add(Box.createRigidArea(new Dimension(5, 0)));
            final String load = tcpmon.getMessage("load00", "Load / Resend");
            this.loadButton = new JButton(load);
            bottomButtons.add(this.loadButton);
            bottomButtons.add(Box.createRigidArea(new Dimension(5, 0)));
            final String find = tcpmon.getMessage("find00", "Find");
            this.findButton = new JButton(find);
            bottomButtons.add(this.findButton);
            bottomButtons.add(Box.createRigidArea(new Dimension(5, 0)));
            final String switchStr = tcpmon.getMessage("switch00", "Switch Layout");
            this.switchButton = new JButton(switchStr);
            bottomButtons.add(this.switchButton);
            bottomButtons.add(Box.createHorizontalGlue());
            final String close = tcpmon.getMessage("close00", "Close");
            this.closeButton = new JButton(close);
            bottomButtons.add(this.closeButton);
            pane2.add((Component)bottomButtons, "South");
            this.saveButton.setEnabled(false);
            this.saveButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    if (save.equals(event.getActionCommand())) {
                        Listener.this.save();
                    }
                }
            });
            this.loadButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    if (load.equals(event.getActionCommand())) {
                        Listener.this.load();
                    }
                }
            });
            this.resendButton.setEnabled(false);
            this.resendButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    if (resend.equals(event.getActionCommand())) {
                        Listener.this.resend();
                    }
                }
            });
            this.findButton.setEnabled(false);
            this.findButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    if (find.equals(event.getActionCommand())) {
                        Listener.this.find();
                    }
                }
            });
            this.switchButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    if (switchStr.equals(event.getActionCommand())) {
                        int v = Listener.this.outPane.getOrientation();
                        if (v == 0) {
                            Listener.this.outPane.setOrientation(1);
                        } else {
                            Listener.this.outPane.setOrientation(0);
                        }
                        Listener.this.outPane.setDividerLocation(0.5);
                    }
                }
            });
            this.closeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    if (close.equals(event.getActionCommand())) {
                        Listener.this.close();
                    }
                }
            });
            JSplitPane pane1 = new JSplitPane(0);
            pane1.setDividerSize(4);
            pane1.setTopComponent(tablePane);
            pane1.setBottomComponent(pane2);
            pane1.setDividerLocation(150);
            this.add((Component)pane1, "Center");
            ListSelectionModel sel = this.connectionTable.getSelectionModel();
            sel.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent event) {
                    if (event.getValueIsAdjusting()) {
                        return;
                    }
                    ListSelectionModel m = (ListSelectionModel)event.getSource();
                    int divLoc = Listener.this.outPane.getDividerLocation();
                    if (m.isSelectionEmpty()) {
                        Listener.this.setLeft(new JLabel(" " + tcpmon.getMessage("wait00", "Waiting for Connection...")));
                        Listener.this.setRight(new JLabel(""));
                        Listener.this.removeButton.setEnabled(false);
                        Listener.this.removeAllButton.setEnabled(false);
                        Listener.this.saveButton.setEnabled(false);
                        Listener.this.findButton.setEnabled(false);
                        Listener.this.resendButton.setEnabled(false);
                    } else {
                        int row = m.getLeadSelectionIndex();
                        if (row == 0) {
                            if (Listener.this.connections.size() == 0) {
                                Listener.this.setLeft(new JLabel(" " + tcpmon.getMessage("wait00", "Waiting for connection...")));
                                Listener.this.setRight(new JLabel(""));
                                Listener.this.removeButton.setEnabled(false);
                                Listener.this.removeAllButton.setEnabled(false);
                                Listener.this.saveButton.setEnabled(false);
                                Listener.this.findButton.setEnabled(false);
                                Listener.this.resendButton.setEnabled(false);
                            } else {
                                Connection conn = (Connection)Listener.this.connections.lastElement();
                                Listener.this.setLeft(conn.inputScroll);
                                Listener.this.setRight(conn.outputScroll);
                                Listener.this.removeButton.setEnabled(false);
                                Listener.this.removeAllButton.setEnabled(true);
                                Listener.this.saveButton.setEnabled(true);
                                Listener.this.findButton.setEnabled(true);
                                Listener.this.loadButton.setEnabled(true);
                                Listener.this.resendButton.setEnabled(true);
                            }
                        } else {
                            Connection conn = (Connection)Listener.this.connections.get(row - 1);
                            Listener.this.setLeft(conn.inputScroll);
                            Listener.this.setRight(conn.outputScroll);
                            Listener.this.removeButton.setEnabled(true);
                            Listener.this.removeAllButton.setEnabled(true);
                            Listener.this.saveButton.setEnabled(true);
                            Listener.this.findButton.setEnabled(true);
                            Listener.this.loadButton.setEnabled(true);
                            Listener.this.resendButton.setEnabled(true);
                        }
                    }
                    Listener.this.outPane.setDividerLocation(divLoc);
                }
            });
            sel.setSelectionInterval(0, 0);
            this.outPane.setDividerLocation(150);
            this.notebook.addTab(name2, this);
            this.start();
        }

        public void setLeft(Component left) {
            this.leftPanel.removeAll();
            this.leftPanel.add(left);
        }

        public void setRight(Component right) {
            this.rightPanel.removeAll();
            this.rightPanel.add(right);
        }

        public void start() {
            int port2 = Integer.parseInt(this.portField.getText());
            this.portField.setText("" + port2);
            int i = this.notebook.indexOfComponent(this);
            this.notebook.setTitleAt(i, tcpmon.getMessage("port01", "Port") + " " + port2);
            int tmp = Integer.parseInt(this.tPortField.getText());
            this.tPortField.setText("" + tmp);
            this.sw = new SocketWaiter(this, port2);
            this.stopButton.setText(tcpmon.getMessage("stop00", "Stop"));
            this.portField.setEditable(false);
            this.hostField.setEditable(false);
            this.tPortField.setEditable(false);
            this.isProxyBox.setEnabled(false);
        }

        public void close() {
            this.stop();
            this.notebook.remove(this);
        }

        public void stop() {
            try {
                for (int i = 0; i < this.connections.size(); ++i) {
                    Connection conn = (Connection)this.connections.get(i);
                    conn.halt();
                }
                this.sw.halt();
                this.stopButton.setText(tcpmon.getMessage("start00", "Start"));
                this.portField.setEditable(true);
                this.hostField.setEditable(true);
                this.tPortField.setEditable(true);
                this.isProxyBox.setEnabled(true);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.utils.tcpmon.stop", "1367", this);
                e.printStackTrace();
            }
        }

        public void remove() {
            int top;
            ListSelectionModel lsm = this.connectionTable.getSelectionModel();
            int bot = lsm.getMinSelectionIndex();
            for (int i = top = lsm.getMaxSelectionIndex(); i >= bot; --i) {
                ((Connection)this.connections.get(i - 1)).remove();
            }
            if (bot > this.connections.size()) {
                bot = this.connections.size();
            }
            lsm.setSelectionInterval(bot, bot);
        }

        public void removeAll() {
            ListSelectionModel lsm = this.connectionTable.getSelectionModel();
            lsm.clearSelection();
            while (this.connections.size() > 0) {
                ((Connection)this.connections.get(0)).remove();
            }
            lsm.setSelectionInterval(0, 0);
        }

        public void save() {
            JFileChooser dialog = new JFileChooser(".");
            int rc = dialog.showSaveDialog(this);
            if (rc == 0) {
                try {
                    File file = dialog.getSelectedFile();
                    FileOutputStream out = new FileOutputStream(file);
                    ListSelectionModel lsm = this.connectionTable.getSelectionModel();
                    rc = lsm.getLeadSelectionIndex();
                    if (rc == 0) {
                        rc = this.connections.size();
                    }
                    Connection conn = (Connection)this.connections.get(rc - 1);
                    rc = Integer.parseInt(this.portField.getText());
                    out.write(new String(tcpmon.getMessage("listenPort01", "Listen Port:") + " " + rc + "\r").getBytes());
                    out.write(new String(tcpmon.getMessage("targetHost01", "Target Host:") + " " + this.hostField.getText() + "\r").getBytes());
                    rc = Integer.parseInt(this.tPortField.getText());
                    out.write(new String(tcpmon.getMessage("targetPort01", "Target Port:") + " " + rc + "\r").getBytes());
                    out.write(new String("==== " + tcpmon.getMessage("request01", "Request") + " ====\r").getBytes());
                    out.write(conn.inputText.getText().getBytes());
                    out.write(new String("\r==== " + tcpmon.getMessage("response00", "Response") + " ====\r").getBytes());
                    out.write(conn.outputText.getText().getBytes());
                    out.close();
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.utils.tcpmon.save", "1424", this);
                    e.printStackTrace();
                }
            }
        }

        public void load() {
            FileInputStream fis = null;
            BufferedReader in = null;
            String text = "";
            int request = 0;
            JFileChooser dialog = new JFileChooser(".");
            int rc = dialog.showOpenDialog(this);
            if (rc == 0) {
                try {
                    File file = dialog.getSelectedFile();
                    ListSelectionModel lsm = this.connectionTable.getSelectionModel();
                    try {
                        String inputLine = "";
                        fis = new FileInputStream(file.getPath());
                        in = new BufferedReader(new InputStreamReader(fis));
                        while ((inputLine = in.readLine()) != null && inputLine.indexOf("==== Response ====") == -1) {
                            if (request > 1) {
                                text = text + "\r\n";
                            }
                            if (request > 0) {
                                text = text + inputLine;
                            }
                            if (inputLine.indexOf("==== Request ====") != -1) {
                                ++request;
                                continue;
                            }
                            if (request <= 0) continue;
                            ++request;
                        }
                        in.close();
                    }
                    catch (EOFException eof) {
                        // empty catch block
                    }
                    List msgs = this.fixMessagesForResend(text);
                    for (int i = 0; i < msgs.size(); ++i) {
                        ByteArrayInputStream in2 = new ByteArrayInputStream(((String)msgs.get(i)).getBytes());
                        new Connection(this, in2);
                    }
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.utils.tcpmon.load_resend", "1488", this);
                    e.printStackTrace();
                }
            }
        }

        public void resend() {
            try {
                ListSelectionModel lsm = this.connectionTable.getSelectionModel();
                int rc = lsm.getLeadSelectionIndex();
                if (rc == 0) {
                    rc = this.connections.size();
                }
                Connection conn = (Connection)this.connections.get(rc - 1);
                if (rc > 0) {
                    lsm.clearSelection();
                    lsm.setSelectionInterval(0, 0);
                }
                String text = conn.inputText.getText();
                List msgs = this.fixMessagesForResend(text);
                for (int i = 0; i < msgs.size(); ++i) {
                    ByteArrayInputStream in = new ByteArrayInputStream(((String)msgs.get(i)).getBytes());
                    new Connection(this, in);
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.utils.tcpmon.resend", "1488", this);
                e.printStackTrace();
            }
        }

        public void find() {
            String title = "Find";
            JTextField word = new JTextField("");
            JCheckBox caseSen = new JCheckBox("Case sensitive", true);
            JComboBox<String> inputOrOutput = new JComboBox<String>(new String[]{"Incoming SOAP Message", "Outgoing SOAP Message"});
            try {
                ListSelectionModel lsm = this.connectionTable.getSelectionModel();
                int rc = lsm.getLeadSelectionIndex();
                if (rc == 0) {
                    rc = this.connections.size();
                }
                Connection conn = (Connection)this.connections.get(rc - 1);
                if (rc > 0) {
                    lsm.clearSelection();
                    lsm.setSelectionInterval(0, 0);
                }
                Object[] message = new Object[]{"Text Field:", inputOrOutput, Box.createVerticalStrut(10), "Search:", word, Box.createVerticalStrut(10), caseSen, Box.createVerticalStrut(5)};
                int choice = JOptionPane.showConfirmDialog(null, message, title, 2, 3);
                if (0 == choice) {
                    if (word.getText().equals("")) {
                        if (inputOrOutput.getSelectedIndex() == 0) {
                            conn.removeHighlights(conn.getInput());
                        } else {
                            conn.removeHighlights(conn.getOutput());
                        }
                    } else if (inputOrOutput.getSelectedIndex() == 0) {
                        conn.highlight(true, word.getText(), caseSen.isSelected());
                    } else {
                        conn.highlight(false, word.getText(), caseSen.isSelected());
                    }
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.utils.tcpmon.find", "1488", this);
                e.printStackTrace();
            }
        }

        private List fixMessagesForResend(String inText) throws IOException {
            ArrayList<String> list = new ArrayList<String>();
            if (inText.startsWith("POST http://") || inText.startsWith("GET http://") || inText.startsWith("POST /") || inText.startsWith("GET /")) {
                List msgs = null;
                msgs = inText.startsWith("POST http://") || inText.startsWith("GET http://") ? this.splitMessages(inText, true) : this.splitMessages(inText, false);
                for (int i = 0; i < msgs.size(); ++i) {
                    String outMsg = this.fixMessage((String)msgs.get(i));
                    list.add(outMsg);
                }
            } else {
                list.add(inText);
            }
            return list;
        }

        private List splitMessages(String inText, boolean proxyMode) {
            ArrayList<String> list = new ArrayList<String>();
            String postStart = null;
            String getStart = null;
            if (proxyMode) {
                postStart = "POST http://";
                getStart = "GET http://";
            } else {
                postStart = "POST /";
                getStart = "GET /";
            }
            int index = inText.indexOf(postStart);
            int n = index = index == -1 ? inText.indexOf(getStart) : index;
            while (index >= 0 && index < inText.length()) {
                int endIndex = inText.indexOf(postStart, index + 1);
                endIndex = endIndex == -1 ? inText.indexOf(getStart, index + 1) : endIndex;
                endIndex = endIndex == -1 ? inText.length() : endIndex;
                String msg = inText.substring(index, endIndex);
                System.err.println("msg:{" + msg + "}");
                list.add(msg);
                index = endIndex;
            }
            return list;
        }

        private String fixMessage(String inMsg) throws IOException {
            String line;
            String outMsg = inMsg;
            int headerEnd = inMsg.indexOf("\n\n");
            if (headerEnd != -1) {
                headerEnd += "\n\n".length();
            } else {
                headerEnd = inMsg.indexOf("\r\n\r\n");
                if (headerEnd != -1) {
                    headerEnd += "\r\n\r\n".length();
                }
            }
            String header2 = inMsg.substring(0, headerEnd);
            String theRest = inMsg.substring(headerEnd);
            String text = "";
            BufferedReader br = new BufferedReader(new StringReader(theRest));
            while ((line = br.readLine()) != null) {
                text = text + line.trim();
            }
            theRest = text;
            int cl = header2.indexOf("Content-Length:");
            if (cl != -1) {
                int clEnd = header2.indexOf("\n", cl);
                outMsg = header2.substring(0, cl) + "Content-Length:" + theRest.length() + header2.substring(clEnd) + theRest;
            }
            return outMsg;
        }
    }

    class Connection
    extends Thread {
        Listener listener;
        boolean active;
        String fromHost;
        String time;
        JTextArea inputText = null;
        JScrollPane inputScroll = null;
        JTextArea outputText = null;
        JScrollPane outputScroll = null;
        Socket inSocket = null;
        Socket outSocket = null;
        Thread clientThread = null;
        Thread serverThread = null;
        SocketRR rr1 = null;
        SocketRR rr2 = null;
        InputStream inputStream = null;
        String HTTPProxyHost = null;
        int HTTPProxyPort = 80;

        public Connection(Listener l) {
            this.listener = l;
            this.HTTPProxyHost = l.HTTPProxyHost;
            this.HTTPProxyPort = l.HTTPProxyPort;
        }

        public Connection(Listener l, Socket s) {
            this(l);
            this.inSocket = s;
            this.start();
        }

        public Connection(Listener l, InputStream in) {
            this(l);
            this.inputStream = in;
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                byte[] b;
                this.active = true;
                this.HTTPProxyHost = System.getProperty("http.proxyHost");
                if (this.HTTPProxyHost != null && this.HTTPProxyHost.equals("")) {
                    this.HTTPProxyHost = null;
                }
                if (this.HTTPProxyHost != null) {
                    String tmp = System.getProperty("http.proxyPort");
                    if (tmp != null && tmp.equals("")) {
                        tmp = null;
                    }
                    this.HTTPProxyPort = tmp == null ? 80 : Integer.parseInt(tmp);
                }
                this.fromHost = this.inSocket != null ? this.inSocket.getInetAddress().getHostName() : "resend";
                SimpleDateFormat df = new SimpleDateFormat("MM/dd/yy hh:mm:ss aa");
                this.time = df.format(new Date());
                int count = this.listener.connections.size();
                this.listener.tableModel.insertRow(count + 1, new Object[]{tcpmon.getMessage("active00", "Active"), this.time, this.fromHost, this.listener.hostField.getText(), ""});
                this.listener.connections.add(this);
                this.inputText = new JTextArea(null, null, 20, 80);
                this.inputScroll = new JScrollPane(this.inputText);
                this.outputText = new JTextArea(null, null, 20, 80);
                this.outputScroll = new JScrollPane(this.outputText);
                ListSelectionModel lsm = this.listener.connectionTable.getSelectionModel();
                if (count == 0 || lsm.getLeadSelectionIndex() == 0) {
                    this.listener.outPane.setVisible(false);
                    int divLoc = this.listener.outPane.getDividerLocation();
                    this.listener.setLeft(this.inputScroll);
                    this.listener.setRight(this.outputScroll);
                    this.listener.removeButton.setEnabled(false);
                    this.listener.removeAllButton.setEnabled(true);
                    this.listener.saveButton.setEnabled(true);
                    this.listener.findButton.setEnabled(true);
                    this.listener.resendButton.setEnabled(true);
                    this.listener.outPane.setDividerLocation(divLoc);
                    this.listener.outPane.setVisible(true);
                }
                String targetHost = this.listener.hostField.getText();
                int targetPort = Integer.parseInt(this.listener.tPortField.getText());
                InputStream tmpIn1 = this.inputStream;
                OutputStream tmpOut1 = null;
                InputStream tmpIn2 = null;
                OutputStream tmpOut2 = null;
                if (tmpIn1 == null) {
                    tmpIn1 = this.inSocket.getInputStream();
                }
                if (this.inSocket != null) {
                    tmpOut1 = this.inSocket.getOutputStream();
                }
                String bufferedData = null;
                StringBuffer buf = null;
                int index = this.listener.connections.indexOf(this);
                if (this.listener.isProxyBox.isSelected() || this.HTTPProxyHost != null) {
                    int len;
                    b = new byte[1];
                    buf = new StringBuffer();
                    while ((len = tmpIn1.read(b, 0, 1)) != -1) {
                        String s = new String(b);
                        buf.append(s);
                        if (b[0] != 10) continue;
                    }
                    bufferedData = buf.toString();
                    this.inputText.append(bufferedData);
                    if (bufferedData.startsWith("GET ") || bufferedData.startsWith("POST ")) {
                        URL url;
                        int start = bufferedData.indexOf(32) + 1;
                        while (bufferedData.charAt(start) == ' ') {
                            ++start;
                        }
                        int end = bufferedData.indexOf(32, start);
                        String urlString = bufferedData.substring(start, end);
                        if (urlString.charAt(0) == '/') {
                            urlString = urlString.substring(1);
                        }
                        if (this.listener.isProxyBox.isSelected()) {
                            url = new URL(urlString);
                            targetHost = url.getHost();
                            targetPort = url.getPort();
                            if (targetPort == -1) {
                                targetPort = 80;
                            }
                            this.listener.tableModel.setValueAt(targetHost, index + 1, OUTHOST_COLUMN);
                            bufferedData = bufferedData.substring(0, start) + url.getFile() + bufferedData.substring(end);
                        } else {
                            url = new URL("http://" + targetHost + ":" + targetPort + "/" + urlString);
                            this.listener.tableModel.setValueAt(targetHost, index + 1, OUTHOST_COLUMN);
                            bufferedData = bufferedData.substring(0, start) + url.toExternalForm() + bufferedData.substring(end);
                            targetHost = this.HTTPProxyHost;
                            targetPort = this.HTTPProxyPort;
                        }
                    }
                } else {
                    String s1;
                    int len;
                    byte[] b1 = new byte[1];
                    buf = new StringBuffer();
                    String lastLine = null;
                    while ((len = tmpIn1.read(b1, 0, 1)) != -1) {
                        s1 = new String(b1);
                        buf.append(s1);
                        if (b1[0] != 10) continue;
                        String line = buf.toString();
                        buf.setLength(0);
                        if (line.startsWith("Host: ")) {
                            String newHost = "Host: " + targetHost + "\r\n";
                            bufferedData = bufferedData.concat(newHost);
                            break;
                        }
                        bufferedData = bufferedData == null ? line : bufferedData.concat(line);
                        if (line.equals("\r\n") || "\n".equals(lastLine) && line.equals("\n")) break;
                        lastLine = line;
                    }
                    if (bufferedData != null) {
                        this.inputText.append(bufferedData);
                        int idx = bufferedData.length() < 50 ? bufferedData.length() : 50;
                        s1 = bufferedData.substring(0, idx);
                        int i = s1.indexOf(10);
                        if (i > 0) {
                            s1 = s1.substring(0, i - 1);
                        }
                        s1 = s1 + "                           " + "                       ";
                        s1 = s1.substring(0, 51);
                        this.listener.tableModel.setValueAt(s1, index + 1, REQ_COLUMN);
                    }
                }
                if (targetPort == -1) {
                    targetPort = 80;
                }
                this.outSocket = new Socket(targetHost, targetPort);
                tmpIn2 = this.outSocket.getInputStream();
                tmpOut2 = this.outSocket.getOutputStream();
                if (bufferedData != null) {
                    b = bufferedData.getBytes();
                    tmpOut2.write(b);
                }
                boolean format = this.listener.xmlFormatBox.isSelected();
                this.rr1 = new SocketRR(this, this.inSocket, tmpIn1, this.outSocket, tmpOut2, this.inputText, format, this.listener.tableModel, index + 1, "request:");
                this.rr2 = new SocketRR(this, this.outSocket, tmpIn2, this.inSocket, tmpOut1, this.outputText, format, null, 0, "response:");
                while (this.rr1 != null || this.rr2 != null) {
                    if (null != this.rr1 && this.rr1.isDone()) {
                        if (index >= 0 && this.rr2 != null) {
                            this.listener.tableModel.setValueAt(tcpmon.getMessage("resp00", "Resp"), 1 + index, STATE_COLUMN);
                        }
                        this.rr1 = null;
                    }
                    if (null != this.rr2 && this.rr2.isDone()) {
                        if (index >= 0 && this.rr1 != null) {
                            this.listener.tableModel.setValueAt(tcpmon.getMessage("req00", "Req"), 1 + index, STATE_COLUMN);
                        }
                        this.rr2 = null;
                    }
                    Connection connection = this;
                    synchronized (connection) {
                        this.wait(1000L);
                    }
                }
                this.active = false;
                if (index >= 0) {
                    this.listener.tableModel.setValueAt(tcpmon.getMessage("done00", "Done"), 1 + index, STATE_COLUMN);
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.utils.tcpmon.run", "962", this);
                StringWriter st = new StringWriter();
                PrintWriter wr = new PrintWriter(st);
                int index = this.listener.connections.indexOf(this);
                if (index >= 0) {
                    this.listener.tableModel.setValueAt(tcpmon.getMessage("error00", "Error"), 1 + index, STATE_COLUMN);
                }
                e.printStackTrace(wr);
                wr.close();
                this.outputText.append(st.toString());
                this.halt();
            }
        }

        synchronized void wakeUp() {
            this.notifyAll();
        }

        public void halt() {
            try {
                if (this.rr1 != null) {
                    this.rr1.halt();
                }
                if (this.rr2 != null) {
                    this.rr2.halt();
                }
                if (this.inSocket != null) {
                    this.inSocket.close();
                }
                this.inSocket = null;
                if (this.outSocket != null) {
                    this.outSocket.close();
                }
                this.outSocket = null;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.utils.tcpmon.halt", "990", this);
                e.printStackTrace();
            }
        }

        public void remove() {
            int index = -1;
            try {
                this.halt();
                index = this.listener.connections.indexOf(this);
                this.listener.tableModel.removeRow(index + 1);
                this.listener.connections.remove(index);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.utils.tcpmon.remove", "1005", this);
                System.err.println("index:=" + index + this);
                e.printStackTrace();
            }
        }

        public void highlight(boolean inputPane, String pattern, boolean caseSen) {
            JTextArea textComp = inputPane ? this.inputText : this.outputText;
            MyHighlightPainter myHighlightPainter = new MyHighlightPainter(Color.yellow);
            try {
                this.removeHighlights(textComp);
                Highlighter hilite = textComp.getHighlighter();
                Document doc = textComp.getDocument();
                String text = caseSen ? doc.getText(0, doc.getLength()) : doc.getText(0, doc.getLength()).toLowerCase();
                int pos = 0;
                if (!caseSen) {
                    pattern = pattern.toLowerCase();
                }
                while ((pos = text.indexOf(pattern, pos)) >= 0) {
                    hilite.addHighlight(pos, pos + pattern.length(), myHighlightPainter);
                    pos += pattern.length();
                }
            }
            catch (BadLocationException e) {
                // empty catch block
            }
        }

        public void removeHighlights(JTextComponent textComp) {
            Highlighter hilite = textComp.getHighlighter();
            Highlighter.Highlight[] hilites = hilite.getHighlights();
            for (int i = 0; i < hilites.length; ++i) {
                if (!(hilites[i].getPainter() instanceof MyHighlightPainter)) continue;
                hilite.removeHighlight(hilites[i]);
            }
        }

        public JTextArea getInput() {
            return this.inputText;
        }

        public JTextArea getOutput() {
            return this.outputText;
        }

        class MyHighlightPainter
        extends DefaultHighlighter.DefaultHighlightPainter {
            public MyHighlightPainter(Color color) {
                super(color);
            }
        }
    }

    class SocketRR
    extends Thread {
        Socket inSocket = null;
        Socket outSocket = null;
        JTextArea textArea;
        InputStream in = null;
        OutputStream out = null;
        boolean xmlFormat;
        volatile boolean done = false;
        TableModel tmodel = null;
        int tableIndex = 0;
        String type = null;
        Connection myConnection = null;
        byte[] prettyBuffer = null;

        public SocketRR(Connection c, Socket inputSocket, InputStream inputStream, Socket outputSocket, OutputStream outputStream, JTextArea _textArea, boolean format, TableModel tModel, int index, String type) {
            this.inSocket = inputSocket;
            this.in = inputStream;
            this.outSocket = outputSocket;
            this.out = outputStream;
            this.textArea = _textArea;
            this.xmlFormat = format;
            this.tmodel = tModel;
            this.tableIndex = index;
            this.type = type;
            this.myConnection = c;
            this.start();
        }

        public boolean isDone() {
            return this.done;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block62: {
                String tmpStr;
                byte[] buffer = new byte[4096];
                int saved = 0;
                int reqSaved = 0;
                int tabWidth = 3;
                int indent = 0;
                boolean inXML = false;
                boolean prevTagIsStartTag = false;
                boolean onMargin = false;
                this.prettyBuffer = new byte[8192];
                if (this.tmodel != null && !"".equals(tmpStr = (String)this.tmodel.getValueAt(this.tableIndex, REQ_COLUMN))) {
                    reqSaved = tmpStr.length();
                }
                block14: while (!this.done) {
                    int len = buffer.length;
                    if (len == 0) {
                        len = buffer.length;
                    }
                    if (saved + len > buffer.length) {
                        len = buffer.length - saved;
                    }
                    int len1 = 0;
                    while (len1 == 0) {
                        try {
                            len1 = this.in.read(buffer, saved, len);
                        }
                        catch (Exception ex) {
                            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.engine.utils.tcpmon.run", "508", this);
                            if (this.done && saved == 0) break block14;
                            len1 = -1;
                            break;
                        }
                    }
                    if ((len = len1) == -1 && saved == 0) break;
                    if (len == -1) {
                        this.done = true;
                    }
                    if (this.out != null && len > 0) {
                        this.out.write(buffer, saved, len);
                    }
                    if (this.tmodel != null && reqSaved < 50) {
                        String old = (String)this.tmodel.getValueAt(this.tableIndex, REQ_COLUMN);
                        if ((old = old + new String(buffer, saved, len)).length() > 50) {
                            old = old.substring(0, 50);
                        }
                        reqSaved = old.length();
                        int i = old.indexOf(10);
                        if (i > 0) {
                            old = old.substring(0, i - 1);
                            reqSaved = 50;
                        }
                        this.tmodel.setValueAt(old, this.tableIndex, REQ_COLUMN);
                    }
                    if (this.xmlFormat) {
                        int bufferLen = saved;
                        int i2 = 0;
                        if (len != -1) {
                            bufferLen += len;
                        }
                        saved = 0;
                        for (int i1 = 0; i1 < bufferLen; ++i1) {
                            if (len != -1 && i1 + 1 == bufferLen) {
                                saved = 1;
                                break;
                            }
                            byte thisByte = buffer[i1];
                            int nextByte = 32;
                            if (i1 + 1 < bufferLen) {
                                nextByte = buffer[i1 + 1];
                            }
                            if (!(inXML || thisByte != 60 && thisByte != 62 && thisByte != 10 && thisByte != 13)) {
                                inXML = true;
                            }
                            if (!inXML) {
                                this.prettyBufferAdd(i2++, thisByte);
                            } else {
                                if (!onMargin && (thisByte == 60 && nextByte != 47 && nextByte != 33 || thisByte == 60 && nextByte == 47 && !prevTagIsStartTag)) {
                                    this.prettyBufferAdd(i2++, (byte)10);
                                    int indentation = tabWidth * indent;
                                    if (thisByte == 60 && nextByte == 47) {
                                        indentation -= tabWidth;
                                    }
                                    if (indentation < 0) {
                                        indentation = 0;
                                    }
                                    for (int i = indentation; i > 0; --i) {
                                        this.prettyBufferAdd(i2++, (byte)32);
                                    }
                                }
                                this.prettyBufferAdd(i2++, thisByte);
                            }
                            if (thisByte == 60 && nextByte != 47 && nextByte != 33) {
                                prevTagIsStartTag = true;
                                ++indent;
                            } else if (thisByte == 60 && nextByte == 47) {
                                prevTagIsStartTag = false;
                                --indent;
                            } else if (thisByte == 47 && nextByte == 62) {
                                prevTagIsStartTag = false;
                                --indent;
                            }
                            onMargin = thisByte == 10 || thisByte == 13 || onMargin && (thisByte == 32 || thisByte == 9);
                        }
                        this.textArea.append(new String(this.prettyBuffer, 0, i2));
                        for (int i = 0; i < saved; ++i) {
                            buffer[i] = buffer[bufferLen - saved + i];
                        }
                        if (!inXML || saved != 1 || buffer[0] != 62) continue;
                        saved = 2;
                        buffer[1] = 10;
                        continue;
                    }
                    this.textArea.append(new String(buffer, 0, len));
                }
                Object var19_22 = null;
                this.done = true;
                try {
                    if (this.out != null) {
                        this.out.flush();
                        if (null != this.outSocket) {
                            this.outSocket.shutdownOutput();
                        } else {
                            this.out.close();
                        }
                        this.out = null;
                    }
                }
                catch (Exception e2) {
                    FFDCFilter.processException((Throwable)e2, "com.ibm.ws.webservices.engine.utils.tcpmon.run", "620", this);
                }
                try {
                    if (this.in != null) {
                        if (this.inSocket != null) {
                            this.inSocket.shutdownInput();
                        } else {
                            this.in.close();
                        }
                        this.in = null;
                    }
                }
                catch (Exception e2) {
                    FFDCFilter.processException((Throwable)e2, "com.ibm.ws.webservices.engine.utils.tcpmon.run", "631", this);
                }
                this.myConnection.wakeUp();
                {
                    break block62;
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.utils.tcpmon.run", "606", this);
                        e.printStackTrace();
                        Object var19_23 = null;
                        this.done = true;
                        try {
                            if (this.out != null) {
                                this.out.flush();
                                if (null != this.outSocket) {
                                    this.outSocket.shutdownOutput();
                                } else {
                                    this.out.close();
                                }
                                this.out = null;
                            }
                        }
                        catch (Exception e2) {
                            FFDCFilter.processException((Throwable)e2, "com.ibm.ws.webservices.engine.utils.tcpmon.run", "620", this);
                        }
                        try {
                            if (this.in != null) {
                                if (this.inSocket != null) {
                                    this.inSocket.shutdownInput();
                                } else {
                                    this.in.close();
                                }
                                this.in = null;
                            }
                        }
                        catch (Exception e2) {
                            FFDCFilter.processException((Throwable)e2, "com.ibm.ws.webservices.engine.utils.tcpmon.run", "631", this);
                        }
                        this.myConnection.wakeUp();
                    }
                }
                catch (Throwable throwable) {
                    Object var19_24 = null;
                    this.done = true;
                    try {
                        if (this.out != null) {
                            this.out.flush();
                            if (null != this.outSocket) {
                                this.outSocket.shutdownOutput();
                            } else {
                                this.out.close();
                            }
                            this.out = null;
                        }
                    }
                    catch (Exception e2) {
                        FFDCFilter.processException((Throwable)e2, "com.ibm.ws.webservices.engine.utils.tcpmon.run", "620", this);
                    }
                    try {
                        if (this.in != null) {
                            if (this.inSocket != null) {
                                this.inSocket.shutdownInput();
                            } else {
                                this.in.close();
                            }
                            this.in = null;
                        }
                    }
                    catch (Exception e2) {
                        FFDCFilter.processException((Throwable)e2, "com.ibm.ws.webservices.engine.utils.tcpmon.run", "631", this);
                    }
                    this.myConnection.wakeUp();
                    throw throwable;
                }
            }
        }

        private void prettyBufferAdd(int index, byte bite) {
            if (index >= this.prettyBuffer.length) {
                byte[] tempBuffer = this.prettyBuffer;
                this.prettyBuffer = new byte[this.prettyBuffer.length * 2];
                for (int i = 0; i < tempBuffer.length; ++i) {
                    this.prettyBuffer[i] = tempBuffer[i];
                }
            }
            this.prettyBuffer[index] = bite;
        }

        public void halt() {
            try {
                if (this.inSocket != null) {
                    this.inSocket.close();
                }
                if (this.outSocket != null) {
                    this.outSocket.close();
                }
                this.inSocket = null;
                this.outSocket = null;
                if (this.in != null) {
                    this.in.close();
                }
                if (this.out != null) {
                    this.out.close();
                }
                this.in = null;
                this.out = null;
                this.done = true;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.utils.tcpmon.halt", "651", this);
                e.printStackTrace();
            }
        }
    }

    class SocketWaiter
    extends Thread {
        ServerSocket sSocket = null;
        Listener listener;
        int port;
        boolean pleaseStop = false;

        public SocketWaiter(Listener l, int p) {
            this.listener = l;
            this.port = p;
            this.start();
        }

        public void run() {
            block4: {
                try {
                    this.listener.setLeft(new JLabel(tcpmon.getMessage("wait00", " Waiting for Connection...")));
                    this.listener.repaint();
                    this.sSocket = new ServerSocket(this.port);
                    while (true) {
                        Socket inSocket = this.sSocket.accept();
                        if (!this.pleaseStop) {
                            new Connection(this.listener, inSocket);
                            inSocket = null;
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception exp) {
                    FFDCFilter.processException((Throwable)exp, "com.ibm.ws.webservices.engine.utils.tcpmon.run", "404", this);
                    if ("socket closed".equals(exp.getMessage())) break block4;
                    JLabel tmp = new JLabel(exp.toString());
                    tmp.setForeground(Color.red);
                    this.listener.setLeft(tmp);
                    this.listener.setRight(new JLabel(""));
                    this.listener.stop();
                }
            }
        }

        public void halt() {
            try {
                this.pleaseStop = true;
                new Socket("127.0.0.1", this.port);
                if (this.sSocket != null) {
                    this.sSocket.close();
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.utils.tcpmon.halt", "423", this);
                e.printStackTrace();
            }
        }
    }

    class AdminPage
    extends JPanel {
        public JRadioButton listenerButton;
        public JRadioButton proxyButton;
        public JLabel hostLabel;
        public JLabel tportLabel;
        public JTextField port;
        public JTextField host;
        public JTextField tport;
        public JTabbedPane noteb;
        public JCheckBox HTTPProxyBox;
        public JTextField HTTPProxyHost;
        public JTextField HTTPProxyPort;
        public JLabel HTTPProxyHostLabel;
        public JLabel HTTPProxyPortLabel;

        public AdminPage(JTabbedPane notebook, String name2) {
            JPanel mainPane = null;
            JButton addButton = null;
            this.setLayout(new BorderLayout());
            this.noteb = notebook;
            GridBagLayout layout = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            mainPane = new JPanel(layout);
            c.anchor = 17;
            c.gridwidth = 0;
            mainPane.add((Component)new JLabel(tcpmon.getMessage("newTCP00", "Create a new TCP/IP Monitor...") + " "), c);
            mainPane.add(Box.createRigidArea(new Dimension(1, 5)), c);
            JPanel tmpPanel = new JPanel(new GridBagLayout());
            c.anchor = 17;
            c.gridwidth = 1;
            tmpPanel.add((Component)new JLabel(tcpmon.getMessage("listenPort00", "Listen Port #") + " "), c);
            c.anchor = 17;
            c.gridwidth = 0;
            this.port = new JTextField(4);
            tmpPanel.add((Component)this.port, c);
            mainPane.add((Component)tmpPanel, c);
            mainPane.add(Box.createRigidArea(new Dimension(1, 5)), c);
            ButtonGroup btns = new ButtonGroup();
            c.anchor = 17;
            c.gridwidth = 0;
            mainPane.add((Component)new JLabel(tcpmon.getMessage("actAs00", "Act as a...")), c);
            c.anchor = 17;
            c.gridwidth = 0;
            final String listener = tcpmon.getMessage("listener00", "Listener");
            this.listenerButton = new JRadioButton(listener);
            mainPane.add((Component)this.listenerButton, c);
            btns.add(this.listenerButton);
            this.listenerButton.setSelected(true);
            this.listenerButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    if (listener.equals(event.getActionCommand())) {
                        boolean state = AdminPage.this.listenerButton.isSelected();
                        AdminPage.this.tport.setEnabled(state);
                        AdminPage.this.host.setEnabled(state);
                        AdminPage.this.hostLabel.setForeground(state ? Color.black : Color.gray);
                        AdminPage.this.tportLabel.setForeground(state ? Color.black : Color.gray);
                    }
                }
            });
            c.anchor = 17;
            c.gridwidth = 1;
            mainPane.add(Box.createRigidArea(new Dimension(25, 0)));
            this.hostLabel = new JLabel(tcpmon.getMessage("targetHostname00", "Target Hostname") + " ");
            mainPane.add((Component)this.hostLabel, c);
            c.anchor = 17;
            c.gridwidth = 0;
            this.host = new JTextField(30);
            mainPane.add((Component)this.host, c);
            c.anchor = 17;
            c.gridwidth = 1;
            mainPane.add(Box.createRigidArea(new Dimension(25, 0)));
            this.tportLabel = new JLabel(tcpmon.getMessage("targetPort00", "Target Port #") + " ");
            mainPane.add((Component)this.tportLabel, c);
            c.anchor = 17;
            c.gridwidth = 0;
            this.tport = new JTextField(4);
            mainPane.add((Component)this.tport, c);
            c.anchor = 17;
            c.gridwidth = 0;
            final String proxy = tcpmon.getMessage("proxy00", "Proxy");
            this.proxyButton = new JRadioButton(proxy);
            mainPane.add((Component)this.proxyButton, c);
            btns.add(this.proxyButton);
            this.proxyButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    if (proxy.equals(event.getActionCommand())) {
                        boolean state = AdminPage.this.proxyButton.isSelected();
                        AdminPage.this.tport.setEnabled(!state);
                        AdminPage.this.host.setEnabled(!state);
                        AdminPage.this.hostLabel.setForeground(state ? Color.gray : Color.black);
                        AdminPage.this.tportLabel.setForeground(state ? Color.gray : Color.black);
                    }
                }
            });
            c.anchor = 17;
            c.gridwidth = 0;
            mainPane.add(Box.createRigidArea(new Dimension(1, 10)), c);
            JPanel opts = new JPanel(new GridBagLayout());
            opts.setBorder(new TitledBorder(tcpmon.getMessage("options00", "Options")));
            c.anchor = 17;
            c.gridwidth = 0;
            mainPane.add((Component)opts, c);
            c.anchor = 17;
            c.gridwidth = 0;
            final String proxySupport = tcpmon.getMessage("proxySupport00", "HTTP Proxy Support");
            this.HTTPProxyBox = new JCheckBox(proxySupport);
            opts.add((Component)this.HTTPProxyBox, c);
            c.anchor = 17;
            c.gridwidth = 1;
            this.HTTPProxyHostLabel = new JLabel(tcpmon.getMessage("hostname00", "Hostname") + " ");
            opts.add((Component)this.HTTPProxyHostLabel, c);
            this.HTTPProxyHostLabel.setForeground(Color.gray);
            c.anchor = 17;
            c.gridwidth = 0;
            this.HTTPProxyHost = new JTextField(30);
            opts.add((Component)this.HTTPProxyHost, c);
            this.HTTPProxyHost.setEnabled(false);
            c.anchor = 17;
            c.gridwidth = 1;
            this.HTTPProxyPortLabel = new JLabel(tcpmon.getMessage("port00", "Port #") + " ");
            opts.add((Component)this.HTTPProxyPortLabel, c);
            this.HTTPProxyPortLabel.setForeground(Color.gray);
            c.anchor = 17;
            c.gridwidth = 0;
            this.HTTPProxyPort = new JTextField(4);
            opts.add((Component)this.HTTPProxyPort, c);
            this.HTTPProxyPort.setEnabled(false);
            this.HTTPProxyBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    if (proxySupport.equals(event.getActionCommand())) {
                        boolean b = AdminPage.this.HTTPProxyBox.isSelected();
                        Color color = b ? Color.black : Color.gray;
                        AdminPage.this.HTTPProxyHost.setEnabled(b);
                        AdminPage.this.HTTPProxyPort.setEnabled(b);
                        AdminPage.this.HTTPProxyHostLabel.setForeground(color);
                        AdminPage.this.HTTPProxyPortLabel.setForeground(color);
                    }
                }
            });
            String tmp = System.getProperty("http.proxyHost");
            if (tmp != null && tmp.equals("")) {
                tmp = null;
            }
            this.HTTPProxyBox.setSelected(tmp != null);
            this.HTTPProxyHost.setEnabled(tmp != null);
            this.HTTPProxyPort.setEnabled(tmp != null);
            this.HTTPProxyHostLabel.setForeground(tmp != null ? Color.black : Color.gray);
            this.HTTPProxyPortLabel.setForeground(tmp != null ? Color.black : Color.gray);
            if (tmp != null) {
                this.HTTPProxyBox.setSelected(true);
                this.HTTPProxyHost.setText(tmp);
                tmp = System.getProperty("http.proxyPort");
                if (tmp != null && tmp.equals("")) {
                    tmp = null;
                }
                if (tmp == null) {
                    tmp = "80";
                }
                this.HTTPProxyPort.setText(tmp);
            }
            mainPane.add(Box.createRigidArea(new Dimension(1, 10)), c);
            c.anchor = 17;
            c.gridwidth = 0;
            final String add = tcpmon.getMessage("add00", "Add");
            addButton = new JButton(add);
            mainPane.add((Component)addButton, c);
            this.add((Component)new JScrollPane(mainPane), "Center");
            addButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    if (add.equals(event.getActionCommand())) {
                        Listener l = null;
                        int lPort = Integer.parseInt(AdminPage.this.port.getText());
                        String tHost = AdminPage.this.host.getText();
                        int tPort = 0;
                        String text = AdminPage.this.tport.getText();
                        if (text != null && !text.equals("")) {
                            tPort = Integer.parseInt(text);
                        }
                        l = new Listener(AdminPage.this.noteb, null, lPort, tHost, tPort, AdminPage.this.proxyButton.isSelected());
                        text = AdminPage.this.HTTPProxyHost.getText();
                        if ("".equals(text)) {
                            text = null;
                        }
                        l.HTTPProxyHost = text;
                        text = AdminPage.this.HTTPProxyPort.getText();
                        if ("".equals(text)) {
                            text = null;
                        }
                        if (text != null) {
                            l.HTTPProxyPort = Integer.parseInt(text);
                        }
                        AdminPage.this.port.setText(null);
                        AdminPage.this.host.setText(null);
                        AdminPage.this.tport.setText(null);
                    }
                }
            });
            notebook.addTab(name2, this);
            notebook.repaint();
            notebook.setSelectedIndex(notebook.getTabCount() - 1);
        }
    }
}

