/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.utils;

import com.ibm.ws.webservices.engine.utils.JavaUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

public class Namespaces
extends HashMap {
    private String root;
    private static final char[] pkgSeparators = new char[]{'.', ':', '\\', '/'};
    private static final char javaPkgSeparator = pkgSeparators[0];
    private char separatorChar;

    private static String normalizePackageName(String pkg, char separator) {
        if (pkg == null || pkg == "") {
            return pkg;
        }
        for (int i = 0; i < pkgSeparators.length; ++i) {
            pkg = pkg.replace(pkgSeparators[i], separator);
        }
        return pkg;
    }

    public Namespaces(String root, char separator) {
        this.root = root;
        this.separatorChar = separator;
    }

    protected Namespaces(Namespaces clone) {
        super(clone);
        this.root = clone.root;
        this.separatorChar = clone.separatorChar;
    }

    public Object clone() {
        return new Namespaces(this);
    }

    public String getCreate(String key) {
        String value2 = (String)super.get(key);
        if (value2 == null) {
            value2 = Namespaces.normalizePackageName(JavaUtils.makePackageName(key.equals("") ? "unqualified_schema" : key), javaPkgSeparator);
            this.put(key, value2);
        }
        return value2;
    }

    public String getAsDir(String key) {
        String pkg = (String)this.get(key);
        return this.toDir(pkg);
    }

    public String toDir(String pkg) {
        String dir = null;
        pkg = pkg != null ? Namespaces.normalizePackageName(pkg, this.separatorChar) : "";
        dir = this.root == null ? pkg : this.root + this.separatorChar + pkg;
        if (dir == null || dir.length() == 0) {
            dir = ".";
        }
        if (!dir.endsWith("" + this.separatorChar)) {
            dir = dir + this.separatorChar;
        }
        return dir;
    }

    public void putAll(Map map) {
        Iterator i = map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            Object key = entry.getKey();
            String pkg = (String)entry.getValue();
            pkg = this.javify(pkg);
            this.put(key, pkg);
        }
    }

    private String javify(String pkg) {
        StringTokenizer st = new StringTokenizer(pkg, ".");
        pkg = "";
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (JavaUtils.isJavaKeyword(token)) {
                token = JavaUtils.makeNonJavaKeyword(token);
            }
            pkg = pkg + token;
            if (!st.hasMoreTokens()) continue;
            pkg = pkg + '.';
        }
        return pkg;
    }
}

