/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.utils;

import com.ibm.etools.webservice.wsbnd.RouterModule;
import com.ibm.etools.webservice.wsbnd.WSBinding;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.wsspi.webservices.models.WSModels;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.application.WebModule;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EJBJarFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.WARFile;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.ServletMapping;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webservice.wsdd.PortComponent;

public class ModuleUtils {
    protected static Log log = LogFactory.getLog(ModuleUtils.class.getName());

    public static String getContextRoot(ModuleFile moduleFile) {
        String contextRoot = null;
        try {
            if (moduleFile.isWARFile()) {
                if (log.isDebugEnabled()) {
                    log.debug("Looking for context-root in WAR module: " + moduleFile.getName());
                }
                WARFile warFile = (WARFile)moduleFile;
                contextRoot = ModuleUtils.getContextRoot(warFile);
            } else if (moduleFile.isEJBJarFile()) {
                EJBJarFile ejbJarFile;
                WARFile warFile;
                if (log.isDebugEnabled()) {
                    log.debug("Looking for context-root in EJB module: " + moduleFile.getName());
                }
                if ((warFile = ModuleUtils.getRouterWAR(ejbJarFile = (EJBJarFile)moduleFile)) != null) {
                    if (log.isDebugEnabled()) {
                        log.debug("For EJB module: " + ejbJarFile.getName() + " found WAR router " + "module: " + warFile.getName());
                    }
                    contextRoot = ModuleUtils.getContextRoot(warFile);
                }
            }
        }
        catch (Exception e) {
            contextRoot = null;
            if (log.isDebugEnabled()) {
                log.debug("The following error occurred when trying to determine the context-root.");
            }
            e.printStackTrace();
        }
        return contextRoot;
    }

    private static String getContextRoot(WARFile warFile) throws Exception {
        String contextRoot = null;
        EARFile earFile = warFile.getEARFile();
        Application app = earFile.getDeploymentDescriptor();
        Iterator it = app.getModules().iterator();
        while (it.hasNext()) {
            WebModule webModule;
            Object obj = it.next();
            if (!(obj instanceof WebModule) || !(webModule = (WebModule)obj).getUri().equals(warFile.getOriginalURI())) continue;
            contextRoot = webModule.getContextRoot();
            break;
        }
        return contextRoot;
    }

    public static String getURLPattern(ModuleFile moduleFile, PortComponent pc) {
        String urlPattern2 = null;
        try {
            if (moduleFile.isWARFile()) {
                if (log.isDebugEnabled()) {
                    log.debug("Looking for URL pattern for port component: " + pc.getPortComponentName() + " in WAR module: " + moduleFile.getName());
                }
                WARFile warFile = (WARFile)moduleFile;
                urlPattern2 = ModuleUtils.getURLPatternFromWAR(warFile, pc);
            } else if (moduleFile.isEJBJarFile()) {
                EJBJarFile ejbJarFile;
                WARFile warFile;
                if (log.isDebugEnabled()) {
                    log.debug("Looking for URL pattern for port component: " + pc.getPortComponentName() + " in EJB module: " + moduleFile.getName());
                }
                if ((warFile = ModuleUtils.getRouterWAR(ejbJarFile = (EJBJarFile)moduleFile)) != null) {
                    if (log.isDebugEnabled()) {
                        log.debug("For EJB module: " + ejbJarFile.getName() + " found WAR router " + "module: " + warFile.getName());
                    }
                    urlPattern2 = ModuleUtils.getURLPatternFromWAR(warFile, pc);
                }
            }
        }
        catch (Throwable t) {
            urlPattern2 = "/services/" + pc.getPortComponentName();
            if (log.isDebugEnabled()) {
                log.debug("The following error occurred when trying to determine the URL pattern for port component: " + pc.getPortComponentName() + " in the " + "module: " + moduleFile.getName() + ": " + t.toString() + ". The URL pattern will be set to the follwing default: " + urlPattern2);
            }
            t.printStackTrace();
        }
        if (urlPattern2 == null) {
            urlPattern2 = "/services/" + pc.getPortComponentName();
            if (log.isDebugEnabled()) {
                log.debug("Did not find URL pattern within deployment descriptor for port component: " + pc.getPortComponentName() + " in the module: " + moduleFile.getName() + ". The URL pattern will be set to the " + "following default: " + urlPattern2);
            }
        }
        return urlPattern2;
    }

    private static String getURLPatternFromWAR(WARFile warFile, PortComponent pc) {
        String servletName2 = null;
        String urlPattern2 = null;
        if (pc.getServiceImplBean() != null && pc.getServiceImplBean().getEServletLink() != null) {
            servletName2 = pc.getServiceImplBean().getEServletLink().getServletLink();
            WebApp webApp = warFile.getDeploymentDescriptor();
            if (webApp != null) {
                Servlet servlet;
                if (log.isDebugEnabled()) {
                    log.debug("Looking for servlet with name: " + servletName2);
                }
                if ((servlet = webApp.getServletNamed(servletName2)) != null) {
                    Iterator mappingIter = servlet.getMappings().iterator();
                    while (mappingIter.hasNext()) {
                        ServletMapping mapping = (ServletMapping)mappingIter.next();
                        if (mapping.getUrlPattern() == null) continue;
                        if (log.isDebugEnabled()) {
                            log.debug("Found servlet mapping with name: " + servletName2 + ". The URL pattern will be set to: " + mapping.getUrlPattern());
                        }
                        urlPattern2 = mapping.getUrlPattern();
                        break;
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug("Could not find servlet with name: " + servletName2 + " in the WAR module: " + warFile.getName());
                }
            }
        }
        return urlPattern2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static WARFile getRouterWAR(EJBJarFile ejbJarFile) {
        WARFile warFile = null;
        EARFile earFile = ejbJarFile.getEARFile();
        if (earFile != null) {
            try {
                WSBinding wsBinding = WSModels.getWSBinding(ejbJarFile.getLoadStrategy(), "META-INF/ibm-webservices-bnd.xmi");
                if (wsBinding == null) return warFile;
                Iterator rmIter = wsBinding.getRouterModules().iterator();
                while (rmIter.hasNext()) {
                    RouterModule rm = (RouterModule)rmIter.next();
                    if (earFile.getFile(rm.getName()) instanceof WARFile) {
                        return (WARFile)earFile.getFile(rm.getName());
                    }
                    if (!log.isDebugEnabled()) continue;
                    log.debug("The router module: " + rm.getName() + " is not a " + "WAR router module.");
                }
                return warFile;
            }
            catch (Throwable t) {
                if (!log.isDebugEnabled()) return warFile;
                log.debug("Could not determine WAR router module for EJB module: " + ejbJarFile.getName() + " due to the following error: " + t.toString());
                return warFile;
            }
        } else {
            if (!log.isDebugEnabled()) return warFile;
            log.debug("Could not determine WAR router module for EJB module: " + ejbJarFile.getName() + " because containing EAR file could not be loaded");
        }
        return warFile;
    }
}

