/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.utils;

import com.ibm.ws.webservices.engine.schema.SchemaVersion;
import com.ibm.ws.webservices.engine.utils.Mapping;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPConstants;
import java.util.HashMap;

public final class MappingTable {
    private static MappingTable singleton = new MappingTable();
    private transient ThreadLocal _threadLocal = null;
    private static HashMap preferredPrefixes = null;

    static Mapping createMapping(String namespaceURI, String prefix) {
        return singleton._createMapping(namespaceURI, prefix);
    }

    static Mapping createMapping(String namespaceURI) {
        return singleton._createMapping(namespaceURI);
    }

    private Mapping _createMapping(String namespaceURI, String prefix) {
        HashMap table = this._getTable();
        Mapping mapping = null;
        Object value2 = table.get(prefix);
        if (value2 instanceof Mapping) {
            if (((Mapping)value2).getNamespaceURI() == namespaceURI || ((Mapping)value2).getNamespaceURI().equals(namespaceURI)) {
                mapping = (Mapping)value2;
            } else {
                mapping = Mapping.createMapping(namespaceURI, prefix);
                HashMap table2 = new HashMap();
                table.put(prefix, table2);
                table2.put(((Mapping)value2).getNamespaceURI(), value2);
                table2.put(namespaceURI, mapping);
            }
        } else if (value2 == null) {
            mapping = Mapping.createMapping(namespaceURI, prefix);
            table.put(prefix, mapping);
        } else {
            HashMap table2 = (HashMap)value2;
            mapping = (Mapping)table2.get(namespaceURI);
            if (mapping == null) {
                mapping = Mapping.createMapping(namespaceURI, prefix);
                table2.put(namespaceURI, mapping);
            }
        }
        return mapping;
    }

    private Mapping _createMapping(String namespaceURI) {
        String prefix = (String)preferredPrefixes.get(namespaceURI);
        if (prefix == null) {
            int digits = namespaceURI.hashCode() % 1000;
            digits = digits < 0 ? -digits : digits;
            prefix = "p" + digits;
            HashMap table = this._getTable();
            Object value2 = table.get(prefix);
            if (value2 == null) {
                return this._createMapping(namespaceURI, prefix);
            }
            if (value2 instanceof Mapping && ((Mapping)value2).getNamespaceURI().equals(namespaceURI)) {
                return (Mapping)value2;
            }
            prefix = "p" + namespaceURI.hashCode();
            return this._createMapping(namespaceURI, prefix);
        }
        return this._createMapping(namespaceURI, prefix);
    }

    private HashMap _getTable() {
        HashMap table;
        if (this._threadLocal == null) {
            this._threadLocal = new ThreadLocal();
        }
        if ((table = (HashMap)this._threadLocal.get()) == null) {
            table = new HashMap();
            this._threadLocal.set(table);
        }
        return table;
    }

    static {
        preferredPrefixes = new HashMap();
        preferredPrefixes.put(SOAPConstants.SOAP11_CONSTANTS.getEnvelopeURI(), "soapenv");
        preferredPrefixes.put(SOAPConstants.SOAP12_CONSTANTS.getEnvelopeURI(), "soapenv");
        preferredPrefixes.put(SOAPConstants.SOAP11_CONSTANTS.getEncodingURI(), "soapenc");
        preferredPrefixes.put(SOAPConstants.SOAP12_CONSTANTS.getEncodingURI(), "soapenc");
        preferredPrefixes.put("http://www.w3.org/XML/1998/namespace", "xml");
        preferredPrefixes.put(SchemaVersion.SCHEMA_1999.getXsdURI(), "xsd");
        preferredPrefixes.put(SchemaVersion.SCHEMA_1999.getXsiURI(), "xsi");
        preferredPrefixes.put(SchemaVersion.SCHEMA_2000.getXsdURI(), "xsd");
        preferredPrefixes.put(SchemaVersion.SCHEMA_2000.getXsiURI(), "xsi");
        preferredPrefixes.put(SchemaVersion.SCHEMA_2001.getXsdURI(), "xsd");
        preferredPrefixes.put(SchemaVersion.SCHEMA_2001.getXsiURI(), "xsi");
        preferredPrefixes.put("http://websphere.ibm.com/webservices/", "wasws");
        preferredPrefixes.put("http://xml.apache.org/xml-soap", "apachesoap");
        preferredPrefixes.put("http://schemas.xmlsoap.org/wsdl/", "wsdl");
        preferredPrefixes.put("http://schemas.xmlsoap.org/wsdl/soap/", "wsdlsoap");
    }
}

