/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.utils;

import com.ibm.ws.webservices.Version;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesProperties;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.description.OperationDesc;
import com.ibm.ws.webservices.engine.encoding.DeserializationContext;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.handlers.soap.SOAPPort;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.xml.sax.SAXException;

public class MCUtils {
    protected static Log log = LogFactory.getLog(MCUtils.class.getName());
    public static final String PRE_60_BUILD_NUMBER = "pre-WAS 6.0 build";
    static int DUMP_MSGCONTEXT_MASK = 1;
    static int DUMP_WEBSERVICES_MASK = 2;
    static int DUMP_SYSTEM_MASK = 4;
    static int DUMP_ALL = DUMP_MSGCONTEXT_MASK + DUMP_WEBSERVICES_MASK + DUMP_SYSTEM_MASK;

    public static List getLazyParseQNames(MessageContext mc) {
        ArrayList returnList = null;
        List mcQNames = (List)mc.getProperty("lazyParseQNames");
        SOAPPort port2 = mc.getPort();
        List portQNames = null;
        if (port2 != null) {
            portQNames = (List)port2.getOption("lazyParseQNames");
        }
        if (mcQNames != null && mcQNames.size() > 0 || portQNames != null && portQNames.size() > 0) {
            returnList = new ArrayList();
            if (mcQNames != null && mcQNames.size() > 0) {
                returnList.addAll(mcQNames);
            }
            if (portQNames != null && portQNames.size() > 0) {
                returnList.addAll(portQNames);
            }
        }
        return returnList;
    }

    public static void setLazyParseQNames(MessageContext mc, List list) {
        mc.setProperty("lazyParseQNames", list);
    }

    public static final Exception interceptSerializationException(Exception exception, SerializationContext context) {
        if (log.isDebugEnabled()) {
            log.debug("interceptSerializationException: " + exception.toString() + " " + JavaUtils.stackToString(exception));
        }
        context.logBuildNumber(MCUtils.getOperationBuildNumber(context.getMessageContext()));
        List buildNumbers = context.getBuildNumbers();
        if (buildNumbers.size() == 0) {
            return exception;
        }
        String buildText = "Debug deploy artifact build numbers=";
        for (int i = 0; i < buildNumbers.size(); ++i) {
            buildText = buildText + "{" + (String)buildNumbers.get(i) + "} ";
        }
        String msg = Messages.getMessage("migrationErr00", exception.toString(), buildText);
        return new IOException(msg);
    }

    public static final SAXException interceptDeserializationException(Exception exception, DeserializationContext context) {
        if (log.isDebugEnabled()) {
            log.debug("interceptDeserializationException: " + exception.toString() + " " + JavaUtils.stackToString(exception));
        }
        context.logBuildNumber(MCUtils.getOperationBuildNumber(context.getMessageContext()));
        List buildNumbers = context.getBuildNumbers();
        if (buildNumbers.size() == 0) {
            if (exception instanceof SAXException) {
                return (SAXException)exception;
            }
            return new SAXException(exception);
        }
        String buildText = "Debug deploy artifact build numbers=";
        for (int i = 0; i < buildNumbers.size(); ++i) {
            buildText = buildText + "{" + (String)buildNumbers.get(i) + "} ";
        }
        String msg = Messages.getMessage("migrationErr00", exception.toString(), buildText);
        return new SAXException(msg, exception);
    }

    private static String getOperationBuildNumber(MessageContext mc) {
        OperationDesc opDesc;
        String buildNumber = null;
        if (mc != null && (opDesc = mc.getOperation()) != null) {
            buildNumber = (String)opDesc.getOption("buildNum");
            if (buildNumber == null) {
                buildNumber = PRE_60_BUILD_NUMBER;
            } else if (buildNumber.equals(Version.getRawBuildNum())) {
                buildNumber = null;
            }
        }
        return buildNumber;
    }

    public static String getProperty(String propName) {
        return MCUtils.getProperty(MessageContext.getCurrentThreadsContext(), propName, null);
    }

    public static String getProperty(String propName, String dephault) {
        return MCUtils.getProperty(MessageContext.getCurrentThreadsContext(), propName, dephault);
    }

    public static String getProperty(MessageContext ctx, String propName) {
        return MCUtils.getProperty(ctx, propName, null);
    }

    public static String getProperty(MessageContext ctx, String propName, String dephault) {
        String value2 = null;
        if (ctx != null) {
            value2 = (String)ctx.getProperty(propName);
        }
        if (!JavaUtils.hasValue(value2)) {
            value2 = WebServicesProperties.getProperty(propName);
        }
        return JavaUtils.hasValue(value2) ? value2 : dephault;
    }

    public static boolean isPropertyTrue(String propName) {
        return MCUtils.isPropertyTrue(MessageContext.getCurrentThreadsContext(), propName);
    }

    public static boolean isPropertyTrue(MessageContext ctx, String propName) {
        return JavaUtils.isTrueExplicitly(MCUtils.getProperty(ctx, propName, null));
    }

    public static boolean isPropertyEnabled(String propName) {
        return MCUtils.isPropertyEnabled(MessageContext.getCurrentThreadsContext(), propName);
    }

    public static boolean isPropertyEnabled(MessageContext ctx, String propName) {
        boolean retVal = false;
        retVal = MCUtils.isPropertySet(ctx, propName) ? JavaUtils.isTrueExplicitly(MCUtils.getProperty(ctx, propName, null)) : JavaUtils.isTrueExplicitly(MCUtils.getProperty(ctx, "com.ibm.websphere.webservices.enableAllApars", null));
        return retVal;
    }

    public static boolean isPropertySet(String propName) {
        return MCUtils.isPropertySet(MessageContext.getCurrentThreadsContext(), propName);
    }

    public static boolean isPropertySet(MessageContext ctx, String propName) {
        String value2 = MCUtils.getProperty(ctx, propName, null);
        return JavaUtils.hasValue(value2);
    }

    public static String getSettingMsg(String propName, boolean propSetting) {
        String strSetting = propSetting ? "enabled" : "disabled";
        return propName + " is " + strSetting;
    }

    public static void dumpProperties() {
        MCUtils.dumpProperties(DUMP_ALL);
    }

    public static void dumpContextProperties() {
        MCUtils.dumpProperties(DUMP_MSGCONTEXT_MASK);
    }

    public static void dumpProperties(int inType) {
        if (log.isDebugEnabled()) {
            final int type = inType;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Properties allProps;
                    if ((type & DUMP_MSGCONTEXT_MASK) > 0) {
                        MessageContext ctx = MessageContext.getCurrentThreadsContext();
                        if (ctx != null) {
                            StringBuffer buf = new StringBuffer("Message Context Properties:\n{");
                            Iterator itr = ctx.getPropertyNames();
                            while (itr.hasNext()) {
                                String propertyName = (String)itr.next();
                                Object propertyValue = ctx.getProperty(propertyName);
                                if (propertyValue instanceof String) {
                                    buf.append(propertyName + "=" + propertyValue + ", ");
                                    continue;
                                }
                                buf.append(propertyName + "=(non-String), ");
                            }
                            buf.append("}");
                            log.debug(buf);
                        } else {
                            log.debug("No message context found.");
                        }
                    }
                    if ((type & DUMP_WEBSERVICES_MASK) > 0) {
                        allProps = WebServicesProperties.getProperties();
                        log.debug("WebServicesProperties:\n" + allProps);
                    }
                    if ((type & DUMP_SYSTEM_MASK) > 0) {
                        allProps = System.getProperties();
                        log.debug("System Properties:\n" + allProps);
                    }
                    return null;
                }
            });
        }
    }
}

