/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.utils;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import java.io.InputStream;
import java.net.URL;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Hashtable;

public final class ClassUtils {
    private static Hashtable classloaders = new Hashtable();
    private static HashMap loadClassMap = new HashMap();
    static /* synthetic */ Class class$com$ibm$ws$webservices$engine$utils$ClassUtils;

    public static void setClassLoader(String className, ClassLoader loader) {
        if (className != null && loader != null) {
            classloaders.put(className, loader);
        }
    }

    public static ClassLoader getClassLoader(String className) {
        if (className == null) {
            return null;
        }
        return (ClassLoader)classloaders.get(className);
    }

    public static void removeClassLoader(String className) {
        classloaders.remove(className);
    }

    public static Class forName(String className) throws ClassNotFoundException {
        return ClassUtils.loadClass(className);
    }

    public static Class forName(final String className, final boolean init, final ClassLoader loader) throws ClassNotFoundException {
        try {
            Object ret = AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        String lclassName = JavaUtils.getLoadableClassName(className);
                        return Class.forName(lclassName, init, loader);
                    }
                    catch (Throwable e) {
                        return e;
                    }
                }
            });
            if (ret instanceof Class) {
                return (Class)ret;
            }
            if (ret instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)ret;
            }
            throw new ClassNotFoundException(className);
        }
        catch (ClassNotFoundException cnfe) {
            return ClassUtils.loadClass(className);
        }
    }

    private static Class loadClass(final String className) throws ClassNotFoundException {
        Object ret = null;
        try {
            ret = AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    String lclassName = JavaUtils.getLoadableClassName(className);
                    ClassLoader classLoader = ClassUtils.getClassLoader(lclassName);
                    if (classLoader != null) {
                        try {
                            return Class.forName(lclassName, true, classLoader);
                        }
                        catch (ClassNotFoundException cnfe) {
                            // empty catch block
                        }
                    }
                    try {
                        return Class.forName(lclassName, true, Thread.currentThread().getContextClassLoader());
                    }
                    catch (ClassNotFoundException cnfe2) {
                        try {
                            return Class.forName(lclassName, true, (class$com$ibm$ws$webservices$engine$utils$ClassUtils == null ? (class$com$ibm$ws$webservices$engine$utils$ClassUtils = ClassUtils.class$("com.ibm.ws.webservices.engine.utils.ClassUtils")) : class$com$ibm$ws$webservices$engine$utils$ClassUtils).getClassLoader());
                        }
                        catch (ClassNotFoundException cnfe3) {
                            return cnfe3;
                        }
                    }
                }
            });
        }
        catch (SecurityException se) {
            FFDCFilter.processException((Throwable)se, "com.ibm.ws.webservices.engine.utils.ClassUtils.loadClass", "255", null);
            throw new ClassNotFoundException(className);
        }
        if (ret instanceof Class) {
            return (Class)ret;
        }
        if (ret instanceof ClassNotFoundException) {
            Class cls = (Class)loadClassMap.get(className);
            if (cls != null) {
                return cls;
            }
            throw (ClassNotFoundException)ret;
        }
        throw new ClassNotFoundException(className);
    }

    public static InputStream getResourceAsStream(Class clazz, String resource) {
        InputStream myInputStream = null;
        myInputStream = clazz.getClassLoader() != null ? clazz.getClassLoader().getResourceAsStream(resource) : ClassLoader.getSystemClassLoader().getResourceAsStream(resource);
        if (myInputStream == null) {
            myInputStream = clazz.getResourceAsStream(resource);
        }
        return myInputStream;
    }

    public static URL getResource(Class clazz, String resource) {
        URL myResource = null;
        myResource = clazz.getClassLoader() != null ? clazz.getClassLoader().getResource(resource) : ClassLoader.getSystemClassLoader().getResource(resource);
        if (myResource == null) {
            myResource = clazz.getResource(resource);
        }
        return myResource;
    }

    static {
        loadClassMap.put("byte", Byte.TYPE);
        loadClassMap.put("int", Integer.TYPE);
        loadClassMap.put("short", Short.TYPE);
        loadClassMap.put("long", Long.TYPE);
        loadClassMap.put("float", Float.TYPE);
        loadClassMap.put("double", Double.TYPE);
        loadClassMap.put("boolean", Boolean.TYPE);
        loadClassMap.put("char", Character.TYPE);
        loadClassMap.put("void", Void.TYPE);
    }
}

