/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.utils;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesEngine;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.client.ClientEngineFactory;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.handlers.soap.SOAPPort;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.server.ServerEngine;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import java.io.FileInputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Admin {
    protected static Log log = LogFactory.getLog(Admin.class.getName());

    public Element[] AdminService(Element[] xml) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Enter: Admin::AdminService");
        }
        MessageContext msgContext = MessageContext.getCurrentThreadsContext();
        Document doc = this.process(msgContext, xml[0]);
        Element[] result = new Element[]{doc.getDocumentElement()};
        if (log.isDebugEnabled()) {
            log.debug("Exit: Admin::AdminService");
        }
        return result;
    }

    protected static Document processWSDD(MessageContext msgContext, WebServicesEngine engine2, Element root) throws Exception {
        Document doc = null;
        String action = root.getLocalName();
        if (action.equals("quit")) {
            log.error(Messages.getMessage("quitRequest00"));
            if (msgContext != null) {
                msgContext.setProperty(MessageContext.QUIT_REQUESTED, "true");
            }
            doc = XMLUtils.newDocument();
            root = doc.createElementNS("", "Admin");
            doc.appendChild(root);
            root.appendChild(doc.createTextNode(Messages.getMessage("quit00", "")));
            return doc;
        }
        if (action.equals("list")) {
            return engine2.getConfigurationDocument();
        }
        if (action.equals("clientdeploy")) {
            engine2 = engine2.getClientEngine();
        }
        doc = XMLUtils.newDocument();
        root = doc.createElementNS("", "Admin");
        doc.appendChild(root);
        root.appendChild(doc.createTextNode(Messages.getMessage("done00")));
        return doc;
    }

    public Document process(MessageContext msgContext, Element root) throws Exception {
        String remoteIP;
        SOAPPort serviceHandler = msgContext.getPort();
        if (serviceHandler != null && !JavaUtils.isTrueExplicitly(serviceHandler.getOption("enableRemoteAdmin")) && (remoteIP = msgContext.getStrProp("remoteaddr")) != null && !remoteIP.equals("127.0.0.1")) {
            try {
                InetAddress myAddr = InetAddress.getLocalHost();
                InetAddress remoteAddr = InetAddress.getByName(remoteIP);
                if (!myAddr.equals(remoteAddr)) {
                    throw new WebServicesFault("Server.Unauthorized", Messages.getMessage("noAdminAccess00"), null, null);
                }
            }
            catch (UnknownHostException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.utils.Admin.process", "203", this);
                throw new WebServicesFault("Server.UnknownHost", Messages.getMessage("unknownHost00"), null, null);
            }
        }
        String rootNS = root.getNamespaceURI();
        WebServicesEngine engine2 = msgContext.getEngine();
        if (rootNS != null && rootNS.equals("http://websphere.ibm.com/webservices/wsdd/")) {
            return Admin.processWSDD(msgContext, engine2, root);
        }
        throw new Exception(Messages.getMessage("adminProcess00"));
    }

    public static void main(String[] args) throws Exception {
        int i = 0;
        if (args.length < 2 || !args[0].equals("client") && !args[0].equals("server")) {
            log.error(Messages.getMessage("usage00", "Admin client|server <xml-file>"));
            log.error(Messages.getMessage("where00", "<xml-file>"));
            log.error("<deploy>");
            log.error("  <handler name=a class=className/>");
            log.error("  <chain name=a flow=\"a,b,c\" />");
            log.error("  <chain name=a request=\"a,b,c\" pivot=\"d\"");
            log.error("                  response=\"e,f,g\" />");
            log.error("  <service name=a handler=b />");
            log.error("</deploy>");
            log.error("<undeploy>");
            log.error("  <handler name=a/>");
            log.error("  <chain name=a/>");
            log.error("  <service name=a/>");
            log.error("</undeploy>");
            log.error("<list/>");
            throw new IllegalArgumentException(Messages.getMessage("usage00", "Admin client|server <xml-file>"));
        }
        Admin admin = new Admin();
        WebServicesEngine engine2 = args[0].equals("client") ? ClientEngineFactory.getUnmanagedEngine() : new ServerEngine();
        MessageContext msgContext = new MessageContext(engine2);
        try {
            for (i = 1; i < args.length; ++i) {
                if (log.isDebugEnabled()) {
                    log.debug(Messages.getMessage("process00", args[i]));
                }
                Document doc = XMLUtils.newDocument(new FileInputStream(args[i]));
                admin.process(msgContext, doc.getDocumentElement());
            }
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.webservices.engine.utils.Admin.main", "278");
            log.error(Messages.getMessage("errorProcess00", args[i]), e);
            throw e;
        }
    }
}

