/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.transport.local;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.handlers.BasicHandler;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.server.ServerEngine;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPEnvelope;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFault;
import java.net.URL;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.apache.commons.logging.Log;

public class LocalSender
extends BasicHandler {
    protected static Log log = LogFactory.getLog(LocalSender.class.getName());
    private volatile ServerEngine defaultServer;

    public ServerEngine getDefaultServer() {
        if (this.defaultServer == null) {
            this.defaultServer = new ServerEngine();
        }
        return this.defaultServer;
    }

    public void invoke(MessageContext clientContext) throws WebServicesFault {
        String remoteService;
        String transURL;
        if (log.isDebugEnabled()) {
            log.debug("Enter: LocalSender::invoke");
        }
        ServerEngine targetServer = (ServerEngine)clientContext.getProperty("LocalTransport.ServerEngine");
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("usingServer00", "LocalSender", "" + targetServer));
        }
        if (targetServer == null) {
            targetServer = this.getDefaultServer();
        }
        MessageContext serverContext = new MessageContext(targetServer);
        String msgStr = clientContext.getRequestMessage().getSOAPPartAsString();
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("sendingXML00", "LocalSender"));
            log.debug(msgStr);
        }
        serverContext.setRequestMessage(new Message(msgStr));
        serverContext.setTransportName("local");
        String user = clientContext.getUsername();
        if (user != null) {
            serverContext.setUsername(user);
            String pass = clientContext.getPassword();
            if (pass != null) {
                serverContext.setPassword(pass);
            }
        }
        if ((transURL = clientContext.getStrProp(MessageContext.TRANS_URL)) != null) {
            try {
                URL url = new URL(transURL);
                String file = url.getFile();
                if (file.length() > 0 && file.charAt(0) == '/') {
                    file = file.substring(1);
                }
                serverContext.setProperty("realpath", file);
                serverContext.setTargetPort(file);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.transport.local.LocalSender.invoke", "165", this);
                throw WebServicesFault.makeFault(e);
            }
        }
        if ((remoteService = clientContext.getStrProp("LocalTransport.RemoteService")) != null) {
            serverContext.setTargetPort(remoteService);
        }
        try {
            targetServer.invoke(serverContext);
        }
        catch (WebServicesFault fault2) {
            Message respMsg = serverContext.getResponseMessage();
            if (respMsg == null) {
                respMsg = new Message(fault2);
                serverContext.setResponseMessage(respMsg);
            }
            try {
                SOAPEnvelope env = respMsg.getSOAPEnvelope();
                env.getSOAPFactory().setProtectState(false);
                env.getBody().detachNode();
                SOAPFault faultEl = env.getSOAPFactory().createSOAPFault();
                faultEl.setFault(fault2);
                env.addBody();
                env.getBody().addChildElement((SOAPElement)faultEl);
            }
            catch (SOAPException se) {
                FFDCFilter.processException((Throwable)se, "com.ibm.ws.webservices.engine.transport.local.LocalSender.invoke", "197", this);
                throw WebServicesFault.makeFault(se);
            }
        }
        clientContext.setResponseMessage(serverContext.getResponseMessage());
        if (log.isDebugEnabled()) {
            log.debug("Exit: LocalSender::invoke");
        }
    }
}

