/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.transport.jms;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.transport.jms.JMSConnectionCache;
import com.ibm.ws.webservices.engine.transport.jms.JMSConnectionData;
import com.ibm.ws.webservices.engine.transport.jms.JMSURLParser;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public abstract class JMSSenderHelperBase {
    private static Hashtable icTable = new Hashtable();
    private HashMap jndiCache = new HashMap();
    private static final int CHUNK_SIZE = 4096;
    private static final TraceComponent _tc = Tr.register(JMSSenderHelperBase.class, "WebServices", "com.ibm.ws.webservices.engine.resources.engineMessages");
    public JMSConnectionCache activeConnections = JMSConnectionCache.newInstance();
    private boolean connectionManagementChecked = false;
    private boolean connectionManagementDesired = false;
    private boolean JNDICacheExpirationTimeRetrieved = false;
    private long JNDICacheExpirationTime = 0L;

    protected void parseURL(JMSConnectionData cd, URL url) throws WebServicesFault, Exception {
        Integer i;
        String s;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "JMSSenderHelperBase.parseURL()");
        }
        JMSURLParser urlParser = new JMSURLParser(url);
        cd.messageMode = urlParser.getDestinationType();
        cd.connectionFactoryName = urlParser.getConnectionFactory();
        cd.destinationName = urlParser.getDestination();
        cd.targetService = urlParser.getTargetService();
        if (cd.connectionFactoryName == null || cd.connectionFactoryName.length() == 0 || cd.destinationName == null || cd.destinationName.length() == 0 || cd.targetService == null || cd.targetService.length() == 0) {
            Tr.error(_tc, "JMS.MissingRequiredProperties");
            throw new WebServicesFault("JMS", Messages.getMessage("JMS.MissingRequiredProperties"), null, null);
        }
        try {
            s = urlParser.getDeliveryMode();
            if (s != null) {
                i = new Integer(s);
                cd.deliveryMode = i;
            }
        }
        catch (NumberFormatException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.transport.jms.JMSSenderHelperBase.parseURL", "256", this);
            Tr.error(_tc, "JMS.BadPropValue", "deliveryMode");
            throw new WebServicesFault(Messages.getMessage("JMS.BadPropValue", "deliveryMode"), e);
        }
        try {
            s = urlParser.getPriority();
            if (s != null) {
                i = new Integer(s);
                cd.priority = i;
            }
        }
        catch (NumberFormatException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.transport.jms.JMSSenderHelperBase.parseURL", "274", this);
            Tr.error(_tc, "JMS.BadPropValue", "priority");
            throw new WebServicesFault(Messages.getMessage("JMS.BadPropValue", "priority"), e);
        }
        try {
            s = urlParser.getTimeToLive();
            if (s != null) {
                i = new Integer(s);
                cd.timeToLive = i;
            }
        }
        catch (NumberFormatException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.transport.jms.JMSSenderHelperBase.parseURL", "292", this);
            Tr.error(_tc, "JMS.BadPropValue", "timeToLive");
            throw new WebServicesFault(Messages.getMessage("JMS.BadPropValue", "timeToLive"), e);
        }
        cd.initialContextFactory = urlParser.getInitialContextFactory();
        cd.jndiProviderURL = urlParser.getJndiProviderURL();
        cd.permanentReplyToQueueJNDI = urlParser.getReplyTo();
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Permanent reply queue (URL) JNDI name property is " + cd.permanentReplyToQueueJNDI);
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "message mode: [" + cd.messageMode + "], connectionFactoryName: [" + cd.connectionFactoryName + "], destinationName: [" + cd.destinationName + "], targetService: [" + cd.targetService + "]");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "JMSSenderHelperBase.parseURL()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InitialContext getInitialContext(String icFactory, String providerURL) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "JMSSenderHelperBase.getInitialContext()");
        }
        InitialContext ic = null;
        String key = (providerURL != null ? providerURL : "<null>") + (icFactory != null ? icFactory : "<null>");
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "InitialContext key=[" + key + "].");
        }
        Hashtable hashtable = icTable;
        synchronized (hashtable) {
            ic = (InitialContext)icTable.get(key);
            if (ic == null) {
                Hashtable<String, String> icProps = new Hashtable<String, String>();
                if (icFactory != null) {
                    icProps.put("java.naming.factory.initial", icFactory);
                }
                if (providerURL != null) {
                    icProps.put("java.naming.provider.url", providerURL);
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "About to create an InitialContext with the following properties:" + icProps.toString());
                }
                ic = new InitialContext(icProps);
                icTable.put(key, ic);
            } else if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Re-using existing InitialContext with key=[" + key + "].");
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "JMSSenderHelperBase.getInitialContext()");
        }
        return ic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object getJNDIObject(JMSConnectionData cd, String jndiName) throws NamingException {
        JNDICacheObject jcObj;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "JMSSenderHelperBase.getJNDIObject(), jndiName=" + jndiName);
        }
        Object obj = null;
        try {
            String key = jndiName + "#" + (cd.jndiProviderURL != null ? cd.jndiProviderURL : "<null>") + "#" + (cd.initialContextFactory != null ? cd.initialContextFactory : "<null>");
            HashMap hashMap = this.jndiCache;
            synchronized (hashMap) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Looking for object in JNDI cache, key=[" + key + "].");
                }
                if ((jcObj = (JNDICacheObject)this.jndiCache.get(key)) == null || jcObj.cacheObjectIsStale()) {
                    if (_tc.isDebugEnabled()) {
                        if (jcObj == null) {
                            Tr.debug(_tc, "Object not in cache, performing JNDI lookup()...");
                        } else if (jcObj.cacheObjectIsStale()) {
                            Tr.debug(_tc, "Object in cache but stale, performing JNDI lookup()...");
                        }
                    }
                    obj = cd.jndiContext.lookup(jndiName);
                    jcObj = new JNDICacheObject(obj);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Adding object to cache, key=[" + key + "], object=" + (obj != null ? obj.toString() : "<null>"));
                    }
                    this.jndiCache.put(key, jcObj);
                }
            }
            Object var9_8 = null;
            if (!_tc.isEntryEnabled()) return jcObj.getObject();
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (!_tc.isEntryEnabled()) throw throwable;
            Tr.exit(_tc, "JMSSenderHelperBase.getJNDIObject()");
            throw throwable;
        }
        Tr.exit(_tc, "JMSSenderHelperBase.getJNDIObject()");
        return jcObj.getObject();
    }

    protected void setSoapAction(Message jmsMessage, MessageContext msgContext, String soapActionString) throws JMSException {
        String soapAction = msgContext.getSOAPActionURI();
        if (!msgContext.useSOAPAction() || soapAction == null) {
            jmsMessage.setStringProperty(soapActionString, "");
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Setting " + soapActionString + " on JMSMessage to empty string...");
            }
        } else {
            jmsMessage.setStringProperty(soapActionString, "\"" + soapAction + "\"");
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Setting " + soapActionString + " on JMSMessage to: " + "\"" + soapAction + "\"");
            }
        }
    }

    protected boolean connectionManagementIsDesired() {
        if (!this.connectionManagementChecked) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "connectionManagementIsDesired() raw System property = " + System.getProperty("com.ibm.ws.webservices.JMSUseConnectionManagement"));
            }
            this.connectionManagementDesired = JavaUtils.isTrueExplicitly(System.getProperty("com.ibm.ws.webservices.JMSUseConnectionManagement"), false);
            this.connectionManagementChecked = true;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "connectionManagementIsDesired() desired = " + this.connectionManagementDesired);
            }
        }
        return this.connectionManagementDesired;
    }

    protected String getKey(JMSConnectionData cd, String user) {
        String key = cd.connectionFactoryName + "#" + (user != null && user.length() != 0 ? user : "<null>") + (cd.initialContextFactory != null && cd.initialContextFactory.length() != 0 ? cd.initialContextFactory : "<null>") + (cd.jndiProviderURL != null && cd.jndiProviderURL.length() != 0 ? cd.jndiProviderURL : "<null>");
        return key;
    }

    protected void _init() {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "JMSSenderHelperBase._init() " + this.toString());
        }
    }

    protected void _destroy() throws WebServicesFault {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "JMSSenderHelperBase._destroy() " + this.toString());
        }
        try {
            if (this.connectionManagementIsDesired()) {
                this.activeConnections.closeConnections();
            }
        }
        catch (WebServicesFault e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.transport.jms.JMSSenderHelperBase._destroy", "1436", this);
            throw e;
        }
    }

    protected String getPermanentReplyQueueJNDI(String prqSoFar) {
        String retString = null;
        if (prqSoFar != null) {
            if (!prqSoFar.equals("") && !prqSoFar.equals("Transient")) {
                retString = prqSoFar;
            }
            return retString;
        }
        String sp = System.getProperty("com.ibm.websphere.webservices.JMSReplyQueueJndiName");
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Permanent reply queue (System property) is " + sp);
        }
        if (sp != null && !sp.equals("") && !sp.equals("Transient")) {
            retString = sp;
        }
        return retString;
    }

    protected long getJNDICacheExpirationTime() {
        if (!this.JNDICacheExpirationTimeRetrieved) {
            Integer intObj = Integer.getInteger(System.getProperty("com.ibm.websphere.webservices.transport.jms.JNDICacheExpirationThreshhold"), 600);
            this.JNDICacheExpirationTimeRetrieved = true;
            this.JNDICacheExpirationTime = intObj.longValue() * 1000L;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Setting JNDI Cache Expiration time to: " + intObj + " seconds");
            }
        }
        return this.JNDICacheExpirationTime;
    }

    protected void setRequestUserTransportProperties(Message jmsMessage, HashMap requestTransportHeaders) throws WebServicesFault {
        try {
            if (requestTransportHeaders != null) {
                Iterator headerIterator = requestTransportHeaders.entrySet().iterator();
                while (headerIterator.hasNext()) {
                    Map.Entry headerMapEntry = headerIterator.next();
                    String transportHeaderKey = ((String)headerMapEntry.getKey()).trim();
                    if (!JavaUtils.hasValue(transportHeaderKey)) {
                        Tr.warning(_tc, "invalid.transportheader.key");
                        continue;
                    }
                    String transportHeaderValue = ((String)headerMapEntry.getValue()).trim();
                    if (!JavaUtils.hasValue(transportHeaderValue)) {
                        Tr.warning(_tc, "invalid.transportheader.value", new Object[]{transportHeaderKey});
                        continue;
                    }
                    if (jmsMessage.propertyExists(transportHeaderKey)) continue;
                    jmsMessage.setStringProperty(transportHeaderKey, transportHeaderValue);
                }
            }
        }
        catch (JMSException je) {
            FFDCFilter.processException((Throwable)je, "com.ibm.ws.webservices.engine.transport.jms.JMSSenderHelperBase.setRequestUserTransportProperties", "1227", this);
            StringBuffer exceptionInfo = new StringBuffer();
            exceptionInfo.append(Messages.getMessage("JMS.JMSError01", je.toString()));
            Exception e = je.getLinkedException();
            while (e != null) {
                exceptionInfo.append("\n");
                exceptionInfo.append(Messages.getMessage("JMS.JMSError02", e.toString()));
                if (e instanceof JMSException) {
                    e = ((JMSException)e).getLinkedException();
                    continue;
                }
                e = null;
            }
            Tr.error(_tc, exceptionInfo.toString());
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, exceptionInfo.toString());
            }
            throw new WebServicesFault("JMS", exceptionInfo.toString(), null, null);
        }
    }

    protected void getResponseUserTransportProperties(HashMap responseTransportHeaders, Message replyMsg) throws WebServicesFault {
        if (responseTransportHeaders != null) {
            try {
                if (responseTransportHeaders.isEmpty()) {
                    Enumeration enumm = replyMsg.getPropertyNames();
                    while (enumm.hasMoreElements()) {
                        String transportHeaderKey = ((String)enumm.nextElement()).trim();
                        if (!JavaUtils.hasValue(transportHeaderKey)) {
                            Tr.warning(_tc, "invalid.transportheader.key");
                            continue;
                        }
                        String value2 = null;
                        value2 = replyMsg.getStringProperty(transportHeaderKey);
                        responseTransportHeaders.put(transportHeaderKey, value2);
                    }
                } else {
                    Iterator headerIterator = responseTransportHeaders.entrySet().iterator();
                    while (headerIterator.hasNext()) {
                        Map.Entry headerMapEntry = headerIterator.next();
                        String transportHeaderKey = ((String)headerMapEntry.getKey()).trim();
                        if (!JavaUtils.hasValue(transportHeaderKey)) {
                            Tr.warning(_tc, "invalid.transportheader.key");
                            continue;
                        }
                        String value3 = null;
                        value3 = replyMsg.getStringProperty(transportHeaderKey);
                        responseTransportHeaders.put(transportHeaderKey, value3);
                    }
                }
            }
            catch (JMSException je) {
                FFDCFilter.processException((Throwable)je, "com.ibm.ws.webservices.engine.transport.jms.JMSSenderHelperBase.getResponseUserTransportProperties", "1304", this);
                StringBuffer exceptionInfo = new StringBuffer();
                exceptionInfo.append(Messages.getMessage("JMS.JMSError01", je.toString()));
                Exception e = je.getLinkedException();
                while (e != null) {
                    exceptionInfo.append("\n");
                    exceptionInfo.append(Messages.getMessage("JMS.JMSError02", e.toString()));
                    if (e instanceof JMSException) {
                        e = ((JMSException)e).getLinkedException();
                        continue;
                    }
                    e = null;
                }
                Tr.error(_tc, exceptionInfo.toString());
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, exceptionInfo.toString());
                }
                throw new WebServicesFault("JMS", exceptionInfo.toString(), null, null);
            }
        }
    }

    private class JNDICacheObject {
        private long timeCreated = System.currentTimeMillis();
        private Object data = null;

        JNDICacheObject(Object newData) {
            this.data = newData;
        }

        private Object getObject() {
            return this.data;
        }

        private boolean cacheObjectIsStale() {
            return JMSSenderHelperBase.this.getJNDICacheExpirationTime() != 0L && System.currentTimeMillis() - this.timeCreated > JMSSenderHelperBase.this.getJNDICacheExpirationTime();
        }
    }
}

