/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.transport.jms;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.mq.jms.MQDestination;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.WebServicesService;
import com.ibm.ws.webservices.engine.EngineConfiguration;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.SimpleTargetedChain;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.configuration.EngineConfigurationFactoryFinder;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.server.ServerEngine;
import com.ibm.ws.webservices.engine.transport.TransactionSuspender;
import com.ibm.ws.webservices.engine.transport.http.HTTPConstants;
import com.ibm.ws.webservices.engine.transport.http.HTTPSender;
import com.ibm.ws.webservices.engine.transport.jms.JMSSender;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.exception.EndpointException;
import com.ibm.ws.webservices.management.Endpoint;
import com.ibm.ws.webservices.management.EndpointManagerMBeanImpl;
import com.ibm.ws.webservices.metadata.ServerModuleMetaData;
import com.ibm.ws.webservices.trace.MessageTrace;
import com.ibm.ws.webservices.trace.UserExceptionTrace;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import com.ibm.wsspi.webservices.management.EndpointManagerMBean;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.net.URL;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.ejb.EJBException;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.soap.SOAPException;

public class JMSListenerMDB
implements MessageDrivenBean,
MessageListener {
    private static final TraceComponent _tc = Tr.register(JMSListenerMDB.class, "WebServices", "com.ibm.ws.webservices.engine.resources.engineMessages");
    private MessageDrivenContext fMessageDrivenCtx = null;
    private ServerEngine serverEngine = null;
    private InitialContext initialContext = null;
    private QueueConnectionFactory replyQCF = null;
    private EndpointManagerMBean endptMgrMBean = null;
    private boolean checkedForMBean = false;
    private String targetService = null;
    private String contentType = null;
    private String soapAction = null;
    private String inboundURL = null;
    static /* synthetic */ Class class$com$ibm$ws$webservices$WebServicesService;

    public MessageDrivenContext getMessageDrivenContext() {
        return this.fMessageDrivenCtx;
    }

    public void setMessageDrivenContext(MessageDrivenContext ctx) {
        this.fMessageDrivenCtx = ctx;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InitialContext getInitialContext() throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getInitialContext");
        }
        try {
            block5: {
                try {
                    if (this.initialContext != null) break block5;
                    this.initialContext = new InitialContext();
                }
                catch (NamingException e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.transport.jms.JMSListenerMDB.getInitialContext", "185", this);
                    if (!_tc.isDebugEnabled()) throw e;
                    Tr.debug(_tc, "Failed to create initial context!");
                    throw e;
                }
            }
            Object var3_1 = null;
            if (!_tc.isEntryEnabled()) return this.initialContext;
            Tr.exit(_tc, "getInitialContext");
            return this.initialContext;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            if (!_tc.isEntryEnabled()) throw throwable;
            Tr.exit(_tc, "getInitialContext");
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized QueueConnectionFactory getReplyQCF() throws Exception {
        try {
            block6: {
                try {
                    if (_tc.isEntryEnabled()) {
                        Tr.entry(_tc, "getReplyQCF");
                    }
                    if (this.replyQCF != null) break block6;
                    InitialContext ic = this.getInitialContext();
                    String jndiName = "java:comp/env/jms/WebServicesReplyQCF";
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "About to look up QCF: " + jndiName);
                    }
                    this.replyQCF = (QueueConnectionFactory)ic.lookup(jndiName);
                    if (!_tc.isDebugEnabled()) break block6;
                    Tr.debug(_tc, "Found the QCF!");
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.transport.jms.JMSListenerMDB.getReplyQCF", "234", this);
                    if (!_tc.isDebugEnabled()) throw e;
                    Tr.debug(_tc, "Failed to locate my reply QCF, exception = " + e.toString());
                    throw e;
                }
            }
            Object var4_4 = null;
            if (!_tc.isEntryEnabled()) return this.replyQCF;
            Tr.exit(_tc, "getReplyQCF");
            return this.replyQCF;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (!_tc.isEntryEnabled()) throw throwable;
            Tr.exit(_tc, "getReplyQCF");
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void ejbCreate() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "ejbCreate");
        }
        this.setEndptMgrMBean();
        try {
            try {
                HashMap environment = new HashMap();
                this.serverEngine = ServerEngine.getServer(null, environment);
                if (this.serverEngine == null) {
                    throw new WebServicesFault(Messages.getMessage("JMS.ServerEngine"));
                }
                Object var3_3 = null;
                if (!_tc.isEntryEnabled()) return;
            }
            catch (WebServicesFault fault2) {
                FFDCFilter.processException((Throwable)fault2, "com.ibm.ws.webservices.engine.transport.jms.JMSListenerMDB.ejbCreate", "278", this);
                Tr.error(_tc, "JMS.Fault01", fault2.toString());
                throw new EJBException(fault2.toString());
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            if (!_tc.isEntryEnabled()) throw throwable;
            Tr.exit(_tc, "ejbCreate");
            throw throwable;
        }
        Tr.exit(_tc, "ejbCreate");
    }

    private void extractIBMProperties(javax.jms.Message jmsMessage) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "extractIBMProperties");
        }
        this.targetService = jmsMessage.getStringProperty("targetService");
        if (this.targetService == null || this.targetService.length() == 0) {
            Tr.error(_tc, "JMS.NoTargetService", "targetService");
            throw new WebServicesFault("JMS", Messages.getMessage("JMS.NoTargetService", "targetService"), null, null);
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Retrieve targetService property from JMS message: " + (this.targetService == null ? "<null>" : this.targetService));
        }
        this.contentType = jmsMessage.getStringProperty("contentType");
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Retrieve contentType property from JMS message: " + (this.contentType == null ? "<null>" : this.contentType));
        }
        this.soapAction = jmsMessage.getStringProperty("soapAction");
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Retrieve soapAction property from JMS message: " + (this.soapAction == null ? "<null>" : this.soapAction));
        }
        this.inboundURL = jmsMessage.getStringProperty("endpointURL");
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Retrieve endPointURL property from JMS message: " + (this.inboundURL == null ? "<null>" : this.inboundURL));
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "extractIBMProperties");
        }
    }

    private void extractSPECProperties(javax.jms.Message jmsMessage, Queue replyQueue) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "extractSPECProperties");
        }
        this.targetService = jmsMessage.getStringProperty("SOAPJMS_targetService");
        if (this.targetService == null || this.targetService.length() == 0) {
            Tr.error(_tc, "JMS.NoTargetService", "SOAPJMS_targetService");
            throw new WebServicesFault("JMS", Messages.getMessage("JMS.NoTargetService", "SOAPJMS_targetService"), null, null);
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Retrieve targetService property from JMS message: " + (this.targetService == null ? "<null>" : this.targetService));
        }
        this.contentType = jmsMessage.getStringProperty("SOAPJMS_contentType");
        if (this.contentType == null || this.contentType.length() == 0) {
            Tr.error(_tc, "JMS.missingContentType", "SOAPJMS_contentType");
            throw new WebServicesFault("JMS", Messages.getMessage("JMS.missingContentType", "SOAPJMS_contentType"), null, null);
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Retrieve contentType property from JMS message: " + (this.contentType == null ? "<null>" : this.contentType));
        }
        this.soapAction = jmsMessage.getStringProperty("SOAPJMS_soapAction");
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Retrieve soapAction property from JMS message: " + (this.soapAction == null ? "<null>" : this.soapAction));
        }
        this.inboundURL = jmsMessage.getStringProperty("SOAPJMS_requestIRI");
        if (this.inboundURL == null || this.inboundURL.length() == 0) {
            Tr.error(_tc, "JMS.missingRequestIRI", "SOAPJMS_requestIRI");
            throw new WebServicesFault("JMS", Messages.getMessage("JMS.missingRequestIRI", "SOAPJMS_requestIRI"), null, null);
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Retrieve endPointURL property from JMS message: " + (this.inboundURL == null ? "<null>" : this.inboundURL));
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "extractSPECProperties");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void onMessage(javax.jms.Message jmsMessage) {
        block109: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "onMessage");
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Received JMS Message: " + jmsMessage.toString());
            }
            MessageContext msgContext = new MessageContext(this.serverEngine);
            Connection qConnection = null;
            Message requestMessage = null;
            Message responseMessage = null;
            Queue replyQueue = null;
            String requestMessageId = null;
            boolean receivedBytesMessage = false;
            boolean specProtocol = false;
            boolean suspendResumeTran = true;
            TransactionSuspender tranSuspender = null;
            try {
                String enableTransaction = jmsMessage.getStringProperty("enableTransaction");
                suspendResumeTran = JavaUtils.isFalse(enableTransaction);
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (suspendResumeTran) {
                tranSuspender = new TransactionSuspender();
            }
            try {
                Object var19_35;
                block107: {
                    try {
                        String version;
                        if (suspendResumeTran) {
                            tranSuspender.suspendTransaction();
                        }
                        if ((version = jmsMessage.getStringProperty("SOAPJMS_bindingVersion")) != null && version.length() != 0) {
                            if (version.compareTo("1.0") != 0) {
                                Tr.error(_tc, "JMS.unrecognizedBindingVersion", "SOAPJMS_bindingVersion");
                                throw new WebServicesFault("JMS", Messages.getMessage("JMS.unrecognizedBindingVersion", "SOAPJMS_bindingVersion"), null, null);
                            }
                            specProtocol = true;
                        }
                        requestMessageId = jmsMessage.getJMSMessageID();
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "MessageContext : " + msgContext + " setting id : " + requestMessageId);
                        }
                        msgContext.setProperty("asyncCorrelationID", requestMessageId);
                        replyQueue = (Queue)jmsMessage.getJMSReplyTo();
                        if (specProtocol) {
                            this.extractSPECProperties(jmsMessage, replyQueue);
                        } else {
                            this.extractIBMProperties(jmsMessage);
                        }
                        if (this.endptMgrMBean == null && !this.checkedForMBean) {
                            this.setEndptMgrMBean();
                            this.checkedForMBean = true;
                        }
                        if (this.endptMgrMBean != null) {
                            Endpoint endpoint = this.endptMgrMBean.getEndpointListenerWithPortComponentName(this.targetService);
                            if (endpoint != null) {
                                if (endpoint.getState() == 3) {
                                    throw new EndpointException(Messages.getMessage("endpointStopped00", this.targetService));
                                }
                            } else if (_tc.isWarningEnabled()) {
                                Tr.warning(_tc, Messages.getMessage("endpointNotFound01", this.targetService));
                            }
                        }
                        msgContext.setTargetPort(this.targetService);
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Set target port on message context to: " + this.targetService);
                        }
                        if (this.inboundURL != null && this.inboundURL.length() > 0) {
                            msgContext.setProperty("inbound.url", this.inboundURL);
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Set inbound.url property on MessageContext to: " + this.inboundURL);
                            }
                        }
                        this.contentType = this.contentType == null ? null : this.contentType.trim();
                        byte[] iba = null;
                        if (jmsMessage instanceof BytesMessage) {
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Got BytesMessage, contentType=" + this.contentType);
                            }
                            BytesMessage bmsg = (BytesMessage)jmsMessage;
                            receivedBytesMessage = true;
                            ByteArrayOutputStream ostrm = new ByteArrayOutputStream();
                            byte[] chunk = new byte[4096];
                            int numBytes = 1;
                            while (numBytes > 0) {
                                numBytes = bmsg.readBytes(chunk);
                                if (numBytes <= 0) continue;
                                ostrm.write(chunk, 0, numBytes);
                            }
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Extracted the following SOAP message from the JMS request message:\n" + ostrm.toString());
                            }
                            iba = ostrm.toByteArray();
                            ByteArrayInputStream istrm = new ByteArrayInputStream(iba);
                            requestMessage = new Message((Object)istrm, this.contentType, null);
                        } else if (jmsMessage instanceof TextMessage) {
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Got TextMessage, contentType=" + this.contentType);
                            }
                            String strMessage = ((TextMessage)jmsMessage).getText();
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Extracted the following SOAP text message from the JMS request message:\n" + strMessage);
                            }
                            requestMessage = new Message((Object)strMessage, this.contentType, null);
                            if (MessageTrace.isTraceEnabled()) {
                                iba = strMessage.getBytes();
                            }
                        } else {
                            Tr.error(_tc, "JMS.BadMsgType");
                            throw new WebServicesFault("JMS", Messages.getMessage("JMS.BadMsgType"), null, null);
                        }
                        msgContext.setRequestMessage(requestMessage);
                        msgContext.setTransportName("jms");
                        msgContext.setProperty("transport.jms.requestMessage", jmsMessage);
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Setting soapAction in msgContext : " + (this.soapAction == null ? "<null>" : this.soapAction));
                        }
                        this.handleSoapAction(jmsMessage, msgContext, this.soapAction);
                        if (MessageTrace.isTraceEnabled() && iba != null) {
                            MessageTrace.log(MessageTrace.INBOUND_JMS_REQUEST, this.contentType, iba);
                        }
                        if (replyQueue != null) {
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Setting jmsMessage on msgContext : " + msgContext);
                            }
                            msgContext.setProperty("JMSMESSAGE", jmsMessage);
                        }
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Calling ServerEngine.invoke()...");
                        }
                        this.serverEngine.invoke(msgContext);
                        if (!_tc.isDebugEnabled()) break block107;
                        Tr.debug(_tc, "Returned from ServerEngine.invoke()...");
                    }
                    catch (Exception e2222) {
                        boolean userException = false;
                        if (UserExceptionTrace.isUserDefinedException(e2222)) {
                            UserExceptionTrace.log(e2222);
                            userException = true;
                        }
                        WebServicesFault e2222 = WebServicesFault.makeFault(e2222);
                        if (!userException) {
                            FFDCFilter.processException((Throwable)e2222, "com.ibm.ws.webservices.engine.transport.jms.JMSListenerMDB.onMessage", "707", this);
                            Tr.error(_tc, "JMS.JMSError03", ((Throwable)e2222).toString());
                        }
                        if (replyQueue != null || msgContext.getProperty("com.ibm.ws.wsaddressing.RedirectRequired") != null) {
                            responseMessage = new Message(e2222);
                            msgContext.setResponseMessage(responseMessage);
                        }
                        if (replyQueue == null && !userException) {
                            throw new RuntimeException(((Throwable)e2222).getMessage());
                        }
                        var19_35 = null;
                        if (suspendResumeTran) {
                            tranSuspender.resumeTransaction();
                        }
                    }
                }
                var19_35 = null;
                if (suspendResumeTran) {
                    tranSuspender.resumeTransaction();
                }
            }
            catch (Throwable throwable) {
                Object var19_36 = null;
                if (suspendResumeTran) {
                    tranSuspender.resumeTransaction();
                }
                throw throwable;
            }
            if (replyQueue != null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "replyQueue : " + replyQueue);
                }
                if ((responseMessage = msgContext.getResponseMessage()) != null) {
                    QueueConnectionFactory qcf = this.getReplyQCF();
                    qConnection = qcf.createQueueConnection();
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Created the queue connection.");
                    }
                    try {
                        long replyTTL;
                        QueueSession qSession = qConnection.createQueueSession(false, 1);
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Created the queue session.");
                        }
                        if (jmsMessage.getJMSDestination() == null) {
                            try {
                                if (replyQueue instanceof MQDestination) {
                                    ((MQDestination)replyQueue).setTargetClient(1);
                                }
                            }
                            catch (NoClassDefFoundError e) {
                                // empty catch block
                            }
                        }
                        QueueSender sender = qSession.createSender(replyQueue);
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Created the queue sender.");
                        }
                        javax.jms.Message jmsReplyMsg = null;
                        this.contentType = responseMessage.getContentType(msgContext.getSOAPConstants());
                        if (receivedBytesMessage || responseMessage.countAttachments() > 0) {
                            jmsReplyMsg = qSession.createBytesMessage();
                            ByteArrayOutputStream strm = new ByteArrayOutputStream();
                            responseMessage.writeTo(strm, this.contentType);
                            responseMessage.removeAllAttachments();
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "About to write the following reply message into the JMS response message:\n" + strm.toString());
                            }
                            jmsReplyMsg.writeBytes(strm.toByteArray());
                            if (MessageTrace.isTraceEnabled()) {
                                MessageTrace.log(MessageTrace.OUTBOUND_JMS_RESPONSE, this.contentType, strm.toByteArray());
                            }
                        } else {
                            jmsReplyMsg = qSession.createTextMessage();
                            String strReply = responseMessage.getSOAPPartAsString();
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "About to write the following reply message into the JMS response message:\n" + strReply);
                            }
                            ((TextMessage)jmsReplyMsg).setText(strReply);
                            if (MessageTrace.isTraceEnabled()) {
                                MessageTrace.log(MessageTrace.OUTBOUND_JMS_RESPONSE, this.contentType, strReply);
                            }
                        }
                        if (specProtocol) {
                            jmsReplyMsg.setStringProperty("SOAPJMS_contentType", this.contentType);
                            jmsReplyMsg.setStringProperty("SOAPJMS_bindingVersion", "1.0");
                        } else {
                            jmsReplyMsg.setStringProperty("contentType", this.contentType);
                            jmsReplyMsg.setStringProperty("transportVersion", "1");
                        }
                        HashMap responseTransportHeaders = null;
                        responseTransportHeaders = (HashMap)msgContext.getProperty("com.ibm.websphere.webservices.responseTransportProperties");
                        if (responseTransportHeaders != null) {
                            this.setResponseHandlerTransportProperties(jmsReplyMsg, responseTransportHeaders);
                        }
                        jmsReplyMsg.setJMSCorrelationID(requestMessageId);
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "About to send the following reply message:\n" + jmsReplyMsg.toString());
                        }
                        if ((replyTTL = jmsMessage.getJMSExpiration() - jmsMessage.getJMSTimestamp()) < 0L) {
                            replyTTL = 0L;
                        }
                        sender.send(jmsReplyMsg, jmsMessage.getJMSDeliveryMode(), jmsMessage.getJMSPriority(), replyTTL);
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Sent the reply message with a time-to-live of " + replyTTL);
                        }
                    }
                    catch (Exception e3222) {
                        FFDCFilter.processException((Throwable)e3222, "com.ibm.ws.webservices.engine.transport.jms.JMSListenerMDB.onMessage", "1021", this);
                        WebServicesFault e3222 = WebServicesFault.makeFault(e3222);
                        Tr.error(_tc, "JMS.unexpected", ((Throwable)e3222).toString());
                    }
                }
            }
            if (msgContext.getProperty("com.ibm.ws.wsaddressing.RedirectRequired") != null) {
                EngineConfiguration ecfg;
                String target = msgContext.getTargetEndpointAddress();
                boolean jmsRedirect = false;
                boolean httpRedirect = false;
                boolean isDebug = _tc.isDebugEnabled();
                if (target != null && target.toLowerCase().startsWith("jms")) {
                    jmsRedirect = true;
                    if (isDebug) {
                        Tr.debug(_tc, "Redirect directive to JMS found.");
                    }
                }
                if (target != null && target.toLowerCase().startsWith("http")) {
                    httpRedirect = true;
                    if (isDebug) {
                        Tr.debug(_tc, "Redirect directive to http/https found.");
                    }
                }
                if (msgContext.isOneWay()) {
                    Tr.error(_tc, Messages.getMessage("servlet.unexpected.oneway.response00"));
                    if (isDebug) {
                        Tr.debug(_tc, "No Response Sent");
                    }
                } else if (msgContext.getProperty("com.ibm.ws.wsaddressing.NoneURI") != null) {
                    if (isDebug) {
                        Tr.debug(_tc, "Discard Response : WSAddressing NoneURI specified.");
                    }
                    if (isDebug) {
                        Tr.debug(_tc, "No Response Sent");
                    }
                } else if (jmsRedirect) {
                    SimpleTargetedChain jmshdler;
                    ecfg = EngineConfigurationFactoryFinder.newFactory("NONE").getClientEngineConfig();
                    if (ecfg != null && (jmshdler = (SimpleTargetedChain)ecfg.getTransport(QNameTable.createQName(null, "jms"))) != null) {
                        JMSSender jmssender = (JMSSender)jmshdler.getPivotHandler();
                        MessageContext.setCurrentThreadsContext(msgContext);
                        if (jmssender != null) {
                            URL targetURL = msgContext.getTargetEndpointAddressAsURL();
                            if (isDebug) {
                                Tr.debug(_tc, "Attempting to redirect to JMS to " + targetURL);
                            }
                            jmssender.invoke(msgContext);
                            if (isDebug) {
                                Tr.debug(_tc, "Returned from jmssender.invoke()" + targetURL);
                            }
                        }
                    }
                } else if (httpRedirect) {
                    try {
                        ecfg = EngineConfigurationFactoryFinder.newFactory("NONE").getClientEngineConfig();
                        if (ecfg != null) {
                            SimpleTargetedChain hdler = (SimpleTargetedChain)ecfg.getTransport(QNameTable.createQName(null, "http"));
                            HTTPSender hsender = (HTTPSender)hdler.getPivotHandler();
                            MessageContext.setCurrentThreadsContext(msgContext);
                            msgContext.setProperty(HTTPConstants.MC_HTTP_OUTBOUND_ASYNC_RESPONSE, "yes".intern());
                            hsender.invoke(msgContext);
                        }
                    }
                    catch (Exception ex) {
                        FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.engine.transport.jms.JMSListenerMDB.onMessage", "1:825:1.45", this);
                        throw new SOAPException((Throwable)ex);
                    }
                }
            }
            Object var21_40 = null;
            try {
                if (qConnection != null) {
                    qConnection.close();
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Closed the queue connection.");
                    }
                }
                break block109;
            }
            catch (Exception e5) {
                FFDCFilter.processException((Throwable)e5, "com.ibm.ws.webservices.engine.transport.jms.JMSListenerMDB.onMessage", "1039", this);
                e5 = WebServicesFault.makeFault(e5);
                Tr.error(_tc, "JMS.unexpected", e5.toString());
            }
            break block109;
            {
                catch (Exception e4222) {
                    FFDCFilter.processException((Throwable)e4222, "com.ibm.ws.webservices.engine.transport.jms.JMSListenerMDB.onMessage", "1039", this);
                    WebServicesFault e4222 = WebServicesFault.makeFault(e4222);
                    Tr.error(_tc, "JMS.unexpected", ((Throwable)e4222).toString());
                    Object var21_41 = null;
                    try {
                        if (qConnection != null) {
                            qConnection.close();
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Closed the queue connection.");
                            }
                        }
                        break block109;
                    }
                    catch (Exception e5) {
                        FFDCFilter.processException((Throwable)e5, "com.ibm.ws.webservices.engine.transport.jms.JMSListenerMDB.onMessage", "1039", this);
                        e5 = WebServicesFault.makeFault(e5);
                        Tr.error(_tc, "JMS.unexpected", e5.toString());
                    }
                }
            }
            catch (Throwable throwable) {
                Object var21_42 = null;
                try {
                    if (qConnection != null) {
                        qConnection.close();
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Closed the queue connection.");
                        }
                    }
                }
                catch (Exception e5) {
                    FFDCFilter.processException((Throwable)e5, "com.ibm.ws.webservices.engine.transport.jms.JMSListenerMDB.onMessage", "1039", this);
                    e5 = WebServicesFault.makeFault(e5);
                    Tr.error(_tc, "JMS.unexpected", e5.toString());
                }
                throw throwable;
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "onMessage");
        }
    }

    private void handleSoapAction(javax.jms.Message jmsMessage, MessageContext msgContext, String soapAction) throws JMSException {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "handleSoapAction soapAction : " + (soapAction == null ? "<null>" : soapAction));
        }
        if (soapAction == null || soapAction.length() == 0) {
            msgContext.setUseSOAPAction(false);
            msgContext.setSOAPActionURI(null);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Disabling soapAction on MessageContext...");
            }
        } else {
            msgContext.setUseSOAPAction(true);
            if (soapAction.startsWith("\"") && soapAction.endsWith("\"")) {
                soapAction = soapAction.substring(1, soapAction.length() - 1);
            }
            msgContext.setSOAPActionURI(soapAction);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Setting soapAction on MessageContext to: " + soapAction);
            }
        }
    }

    public void ejbRemove() {
    }

    private void setResponseHandlerTransportProperties(javax.jms.Message jmsMessage, HashMap responseTransportHeaders) throws WebServicesFault {
        try {
            if (responseTransportHeaders != null) {
                Iterator headerIterator = responseTransportHeaders.entrySet().iterator();
                while (headerIterator.hasNext()) {
                    Map.Entry headerMapEntry = headerIterator.next();
                    if (headerMapEntry.getKey() == null || !(headerMapEntry.getKey() instanceof String)) {
                        Tr.warning(_tc, "invalid.transportheader.key");
                        continue;
                    }
                    String transportHeaderKey = ((String)headerMapEntry.getKey()).trim();
                    if (!JavaUtils.hasValue(transportHeaderKey)) {
                        Tr.warning(_tc, "invalid.transportheader.key");
                        continue;
                    }
                    if (headerMapEntry.getValue() == null || !(headerMapEntry.getValue() instanceof String)) {
                        Tr.warning(_tc, "invalid.transportheader.value", new Object[]{headerMapEntry.getValue()});
                        continue;
                    }
                    String transportHeaderValue = ((String)headerMapEntry.getValue()).trim();
                    if (!JavaUtils.hasValue(transportHeaderValue)) {
                        Tr.warning(_tc, "invalid.transportheader.value", new Object[]{transportHeaderValue});
                        continue;
                    }
                    if (jmsMessage.propertyExists(transportHeaderKey)) continue;
                    jmsMessage.setStringProperty(transportHeaderKey, transportHeaderValue);
                }
            }
        }
        catch (JMSException je) {
            FFDCFilter.processException((Throwable)je, "com.ibm.ws.webservices.engine.transport.jms.JMSListenerMDB.setResponseHandlerTransportProperties", "1150", this);
            StringBuffer exceptionInfo = new StringBuffer();
            exceptionInfo.append(Messages.getMessage("JMS.JMSError01", je.toString()));
            Exception e = je.getLinkedException();
            while (e != null) {
                exceptionInfo.append("\n");
                exceptionInfo.append(Messages.getMessage("JMS.JMSError02", e.toString()));
                if (e instanceof JMSException) {
                    e = ((JMSException)e).getLinkedException();
                    continue;
                }
                e = null;
            }
            Tr.error(_tc, exceptionInfo.toString());
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, exceptionInfo.toString());
            }
            throw new WebServicesFault("JMS", exceptionInfo.toString(), null, null);
        }
    }

    private synchronized void setEndptMgrMBean() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "Entry :: setEndptMgrMBean");
        }
        if (this.endptMgrMBean != null || this.checkedForMBean) {
            return;
        }
        try {
            WebServicesService service = null;
            try {
                service = (WebServicesService)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return WsServiceRegistry.getService(this, class$com$ibm$ws$webservices$WebServicesService == null ? (class$com$ibm$ws$webservices$WebServicesService = JMSListenerMDB.class$("com.ibm.ws.webservices.WebServicesService")) : class$com$ibm$ws$webservices$WebServicesService);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
            if (service != null) {
                ServerModuleMetaData smmd = service.getServerModuleMetaData();
                if (smmd != null) {
                    this.endptMgrMBean = (EndpointManagerMBeanImpl)smmd.getEndpointManagerMbean();
                } else if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "SMMD was null.");
                }
            } else if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "WebServicesService was null.");
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.transport.http.WebServicesServlet.setEndptMgrMBean", "1232", this);
            Tr.error(_tc, Messages.getMessage("exception00"), e);
        }
        if (this.endptMgrMBean == null) {
            Tr.warning(_tc, Messages.getMessage("endpointMgrNotFound00", "JMS Listener"));
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "Exit :: setEndptMgrMBean");
        }
    }
}

