/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.transport.http;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.server.ServerEngine;
import com.ibm.ws.webservices.engine.session.Session;
import com.ibm.ws.webservices.engine.session.SimpleSession;
import com.ibm.ws.webservices.engine.transport.http.SimpleWebServicesWorker;
import com.ibm.ws.webservices.engine.utils.Options;
import java.io.InterruptedIOException;
import java.net.BindException;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Hashtable;
import org.apache.commons.logging.Log;

public class SimpleServerEngine
implements Runnable {
    protected static Log log = LogFactory.getLog(SimpleServerEngine.class.getName());
    private Hashtable sessions = new Hashtable();
    private static boolean doThreads = true;
    private static boolean doSessions = true;
    public static int sessionIndex = 0;
    private static ServerEngine myServerEngine = null;
    private boolean stopped = false;
    private ServerSocket serverSocket;

    protected boolean isSessionUsed() {
        return doSessions;
    }

    public void setDoThreads(boolean value2) {
        doThreads = value2;
    }

    public boolean getDoThreads() {
        return doThreads;
    }

    protected Session createSession(String cooky) {
        Session session = null;
        if (this.sessions.containsKey(cooky)) {
            session = (Session)this.sessions.get(cooky);
        } else {
            session = new SimpleSession();
            this.sessions.put(cooky, session);
        }
        return session;
    }

    protected static synchronized ServerEngine getServerEngine() {
        if (myServerEngine == null) {
            myServerEngine = new ServerEngine();
        }
        return myServerEngine;
    }

    public void run() {
        log.info(Messages.getMessage("start00", "SimpleServerEngine", new Integer(this.getServerSocket().getLocalPort()).toString()));
        while (!this.stopped) {
            Socket socket = null;
            try {
                socket = this.serverSocket.accept();
            }
            catch (InterruptedIOException iie) {
                FFDCFilter.processException((Throwable)iie, "com.ibm.ws.webservices.engine.transport.http.SimpleServerEngine.run", "164", this);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.transport.http.SimpleServerEngine.run", "166", this);
                if (!log.isDebugEnabled()) break;
                log.debug(Messages.getMessage("exception00"), e);
                break;
            }
            if (socket == null) continue;
            SimpleWebServicesWorker worker = new SimpleWebServicesWorker(this, socket);
            if (doThreads) {
                Thread thread = new Thread(worker);
                thread.setDaemon(true);
                thread.start();
                continue;
            }
            worker.run();
        }
        log.info(Messages.getMessage("quit00", "SimpleServerEngine"));
    }

    public ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    public void setServerSocket(ServerSocket serverSocket) {
        this.serverSocket = serverSocket;
    }

    public void start(boolean daemon) throws Exception {
        if (doThreads) {
            Thread thread = new Thread(this);
            thread.setDaemon(daemon);
            thread.start();
        } else {
            this.run();
        }
    }

    public void start() throws Exception {
        this.start(false);
    }

    public void stop() throws Exception {
        this.stopped = true;
        try {
            this.serverSocket.close();
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.transport.http.SimpleServerEngine.stop", "241", this);
            log.info(Messages.getMessage("exception00"), e);
        }
        log.info(Messages.getMessage("quit00", "SimpleServerEngine"));
        System.exit(0);
    }

    public static void main(String[] args) {
        SimpleServerEngine sas = new SimpleServerEngine();
        Options opts = null;
        try {
            opts = new Options(args);
        }
        catch (MalformedURLException e) {
            FFDCFilter.processException(e, "com.ibm.ws.webservices.engine.transport.http.SimpleServerEngine.main", "262");
            log.error(Messages.getMessage("malformedURLException00"), e);
            return;
        }
        try {
            doThreads = opts.isFlagSet('t') > 0;
            int port2 = opts.getPort();
            ServerSocket ss = null;
            for (int i = 0; i < 5; ++i) {
                try {
                    ss = new ServerSocket(port2);
                    break;
                }
                catch (BindException be) {
                    FFDCFilter.processException(be, "com.ibm.ws.webservices.engine.transport.http.SimpleServerEngine.main", "278");
                    if (log.isDebugEnabled()) {
                        log.debug(Messages.getMessage("exception00"), be);
                    }
                    if (i >= 4) {
                        throw new Exception(Messages.getMessage("unableToStartServer00", Integer.toString(port2)));
                    }
                    Thread.sleep(3000L);
                    continue;
                }
            }
            sas.setServerSocket(ss);
            sas.start();
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.webservices.engine.transport.http.SimpleServerEngine.main", "292");
            log.error(Messages.getMessage("exception00"), e);
            return;
        }
    }
}

