/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.transport.channel;

import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.transport.Config;
import com.ibm.ws.webservices.engine.transport.http.HttpChannelAddress;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.wsspi.channel.framework.CFEndPoint;
import com.ibm.wsspi.http.channel.outbound.HttpAddress;
import java.net.InetSocketAddress;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.logging.Log;

public abstract class WSAddress
implements HttpAddress {
    protected static Log log;
    static int defConnTimeout;
    protected int schemaType = 0;
    protected String keyforPool = null;
    protected CFEndPoint cfEndPt = null;
    protected Config cfg = null;
    protected static final String defaultOBChainName = "OutboundChain";
    protected int connTimeout = defConnTimeout;

    public abstract String keyValueforPool();

    public abstract int getPort();

    public abstract String getOutboundChainName();

    public String defaultOutboundChainName() {
        return defaultOBChainName;
    }

    public void setTransportConfiguration(Config inCfg) {
        this.cfg = inCfg;
    }

    public Config transportConfiguration() {
        return this.cfg;
    }

    public String getHostname() {
        return null;
    }

    public InetSocketAddress getLocalAddress() {
        return null;
    }

    public InetSocketAddress getRemoteAddress() {
        return null;
    }

    public int getSchema() {
        return this.schemaType;
    }

    public String getSchemaInString() {
        String retString = null;
        if (this.schemaType == 1) {
            retString = "http";
        }
        if (this.schemaType == 2) {
            retString = "https";
        }
        return retString;
    }

    public int getConnectTimeout() {
        if (log.isDebugEnabled()) {
            log.debug("getConnectTimeout returning " + this.connTimeout);
        }
        return this.connTimeout;
    }

    public abstract void setConnectTimeout(int var1);

    public CFEndPoint getCFEndPoint() {
        return this.cfEndPt;
    }

    public void setCFEndPoint(CFEndPoint cfpt) {
        this.cfEndPt = cfpt;
    }

    public boolean isInProcess() {
        return this.cfEndPt == null ? false : this.cfEndPt.isLocal();
    }

    public static WSAddress getAddress(URL targetURL) throws URISyntaxException, WebServicesFault {
        if (targetURL.getProtocol().compareToIgnoreCase("http") == 0 || targetURL.getProtocol().compareToIgnoreCase("https") == 0) {
            return new HttpChannelAddress(targetURL);
        }
        throw new WebServicesFault(Messages.getMessage("httpUnsupportedSchema", targetURL.getProtocol()));
    }

    static {
        block10: {
            log = LogFactory.getLog(WSAddress.class.getName());
            defConnTimeout = 300000;
            String propName = "com.ibm.websphere.webservices.http.SocketTimeout";
            try {
                String envString = System.getProperty(propName);
                if (log.isDebugEnabled()) {
                    log.debug(propName + " is " + envString);
                }
                if (!JavaUtils.hasValue(envString)) break block10;
                try {
                    int envInt = Integer.parseInt(envString);
                    if (envInt > 0) {
                        if (envInt < 2147483) {
                            defConnTimeout = envInt * 1000;
                        } else if (log.isDebugEnabled()) {
                            log.debug(propName + "greater than allowed value of " + 2147482);
                        }
                    }
                }
                catch (NumberFormatException numEx) {
                    if (log.isDebugEnabled()) {
                        log.debug(propName + "caused a NumberFormatException");
                    }
                }
            }
            catch (Exception ex) {
                if (!log.isDebugEnabled()) break block10;
                log.debug("getProperty of " + propName + "caused an exception");
            }
        }
    }
}

