/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.soap;

import com.ibm.websphere.webservices.soap.IBMMessageFactory;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.enumtype.MessageType;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPConstants;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPEnvelope;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import com.ibm.ws.webservices.engine.xmlsoap.Utils;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;

public class MessageFactoryImpl
extends IBMMessageFactory {
    SOAPConstants soapConstants = null;

    public MessageFactoryImpl() throws SOAPException {
        this("SOAP 1.1 Protocol");
    }

    public MessageFactoryImpl(String protocol2) throws SOAPException {
        this.soapConstants = Utils.getSOAPConstants(protocol2);
    }

    public SOAPMessage createMessage() throws SOAPException {
        if (this.soapConstants.getSOAPProtocol().equals("Dynamic Protocol")) {
            throw new UnsupportedOperationException(Messages.getMessage("createMessageWDyn00"));
        }
        SOAPFactory sf = new SOAPFactory(this.soapConstants);
        SOAPEnvelope env = sf.createSOAPEnvelope(true);
        Message message = new Message((Object)env, this.soapConstants);
        message.setMessageType(MessageType.REQUEST);
        return message;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SOAPMessage createMessage(MimeHeaders mimeheaders, InputStream inputstream) throws IOException, SOAPException {
        SOAPConstants sc = this.soapConstants;
        String contentType = null;
        String soap11Value = SOAPConstants.SOAP11_CONSTANTS.getContentTypeValue();
        String soap12Value = SOAPConstants.SOAP12_CONSTANTS.getContentTypeValue();
        if (mimeheaders != null) {
            String[] contentTypes = mimeheaders.getHeader("Content-Type");
            String string = contentType = contentTypes != null ? contentTypes[0] : null;
        }
        if (this.soapConstants.getSOAPProtocol().equals("Dynamic Protocol")) {
            if (contentType == null) {
                throw new IllegalArgumentException(Messages.getMessage("invalidContentType", contentType, soap11Value, soap12Value));
            }
            if (contentType.indexOf(soap12Value) >= 0) {
                sc = SOAPConstants.SOAP12_CONSTANTS;
            } else {
                if (contentType.indexOf(soap11Value) < 0) throw new IllegalArgumentException(Messages.getMessage("invalidContentType", contentType, soap11Value, soap12Value));
                sc = SOAPConstants.SOAP11_CONSTANTS;
            }
        } else if (contentType != null && contentType.toLowerCase().indexOf("multipart/related") < 0 && contentType.indexOf(sc.getContentTypeValue()) < 0) {
            throw new IllegalArgumentException(Messages.getMessage("invalidContentType", contentType, "multipart/related", sc.getContentTypeValue()));
        }
        Message message = new Message((Object)inputstream, mimeheaders, sc);
        message.setMessageType(MessageType.REQUEST);
        return message;
    }
}

