/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.server;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.ConfigurationException;
import com.ibm.ws.webservices.engine.EngineConfiguration;
import com.ibm.ws.webservices.engine.Handler;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.PivotHandlerWrapper;
import com.ibm.ws.webservices.engine.WebServicesEngine;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.client.ClientEngineFactory;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.configuration.EngineConfigurationFactoryFinder;
import com.ibm.ws.webservices.engine.handlers.WrappedHandler;
import com.ibm.ws.webservices.engine.handlers.soap.SOAPPort;
import com.ibm.ws.webservices.engine.resources.Messages;
import java.util.Map;
import org.apache.commons.logging.Log;

public class ServerEngine
extends WebServicesEngine {
    protected static Log log = LogFactory.getLog(ServerEngine.class.getName());
    private WebServicesEngine clientEngine;

    public static ServerEngine getServer(Object context, Map environment) throws WebServicesFault {
        if (log.isDebugEnabled()) {
            log.debug("Enter: ServerEngine::getServer");
        }
        ServerEngine ret = null;
        try {
            EngineConfiguration config = ServerEngine.getEngineConfiguration(environment);
            ServerEngine serverEngine = ret = config == null ? new ServerEngine(context) : new ServerEngine(config);
            if (ret != null && environment != null) {
                ret.setOptionDefault("attachments.Directory", (String)environment.get("webservices.attachments.Directory"));
                ret.setOptionDefault("attachments.Directory", (String)environment.get("servlet.realpath"));
            }
        }
        catch (Throwable e) {
            FFDCFilter.processException(e, "com.ibm.ws.webservices.engine.server.ServerEngine.getServer", "134");
            WebServicesFault.makeFault(e);
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: ServerEngine::getServer");
        }
        return ret;
    }

    public ServerEngine() {
        this(EngineConfigurationFactoryFinder.newFactory().getServerEngineConfig());
    }

    public ServerEngine(Object environmentContext) {
        this(EngineConfigurationFactoryFinder.newFactory(environmentContext).getServerEngineConfig());
    }

    public ServerEngine(EngineConfiguration config) {
        super(config == null ? EngineConfigurationFactoryFinder.newFactory().getServerEngineConfig() : config);
    }

    public synchronized WebServicesEngine getClientEngine() {
        if (this.clientEngine == null) {
            this.clientEngine = ClientEngineFactory.getUnmanagedEngine();
        }
        return this.clientEngine;
    }

    protected Handler createMessageFlow(MessageContext msgContext) throws WebServicesFault, ConfigurationException {
        Handler target = new WrappedHandler(){

            private SOAPPort getPort(MessageContext msgContext) throws WebServicesFault {
                SOAPPort p = msgContext.getPort();
                if (p == null) {
                    Message rm = msgContext.getRequestMessage();
                    rm.getSOAPEnvelope();
                    p = msgContext.getPort();
                }
                return p;
            }

            public Handler getHandler(MessageContext msgContext) throws WebServicesFault {
                SOAPPort port2 = this.getPort(msgContext);
                if (port2 == null) {
                    throw new WebServicesFault("Server.NoService", Messages.getMessage("noService05", "" + msgContext.getTargetPortName()), null, null);
                }
                return port2;
            }
        };
        target = PivotHandlerWrapper.factory(this.getGlobalHandler(), target);
        String transportName = msgContext.getTransportName();
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("transport01", "ServerEngine.invoke", transportName));
        }
        return PivotHandlerWrapper.factory(this.getTransport(transportName), target);
    }

    public boolean isServer() {
        return true;
    }

    private static EngineConfiguration getEngineConfiguration(Map environment) {
        if (log.isDebugEnabled()) {
            log.debug("Enter: ServerEngine::getEngineConfiguration");
        }
        EngineConfiguration config = null;
        if (environment != null) {
            try {
                config = (EngineConfiguration)environment.get("engineConfig");
            }
            catch (ClassCastException e) {
                FFDCFilter.processException(e, "com.ibm.ws.webservices.engine.server.DefaultServerEngineFactory.getEngineConfiguration", "173");
                log.warn(Messages.getMessage("engineConfigWrongClass00"), e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: ServerEngine::getEngineConfiguration");
        }
        return config;
    }
}

