/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.handlers.soap;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.ConfigurationException;
import com.ibm.ws.webservices.engine.Handler;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.description.PortDesc;
import com.ibm.ws.webservices.engine.dispatchers.BasicDispatcher;
import com.ibm.ws.webservices.engine.handlers.jaxrpc.JAXRPCSOAPHandler;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import java.io.FileInputStream;
import org.apache.commons.logging.Log;
import org.w3c.dom.Document;

public abstract class SOAPPort
extends JAXRPCSOAPHandler {
    protected static Log log = LogFactory.getLog(SOAPPort.class.getName());
    private PortDesc _portDesc;

    public SOAPPort() throws ConfigurationException {
        this(null, null, null);
    }

    public SOAPPort(Handler serviceHandler) {
        this(null, serviceHandler, null);
    }

    public SOAPPort(Handler reqHandler, Handler pivHandler, Handler respHandler) {
        super(reqHandler, pivHandler, respHandler);
    }

    public PortDesc getPortDesc() {
        if (this._portDesc == null) {
            this._portDesc = new PortDesc();
        }
        return this._portDesc;
    }

    public synchronized PortDesc getInitializedPortDesc(MessageContext msgContext) throws WebServicesFault {
        PortDesc port2 = this.getPortDesc();
        if (port2.getImplClass() == null && this.getOriginalPivotHandler() instanceof BasicDispatcher) {
            ((BasicDispatcher)this.getOriginalPivotHandler()).bindPortToDispatcher(this);
        }
        return port2;
    }

    public void setPortDesc(PortDesc portDesc) {
        if (portDesc == null) {
            return;
        }
        this._portDesc = portDesc;
    }

    public void generateWSDL(MessageContext msgContext) throws WebServicesFault {
        if (this.getPortDesc() == null || this.getPortDesc().getWSDLFile() == null) {
            super.generateWSDL(msgContext);
            return;
        }
        try {
            Document doc = XMLUtils.newDocument(new FileInputStream(this.getPortDesc().getWSDLFile()));
            msgContext.setProperty("WSDL", doc);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.handlers.soap.SOAPPort.generateWSDL", "192", this);
            throw WebServicesFault.makeFault(e);
        }
    }
}

