/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.handlers.jaxrpc;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.ConfigurationException;
import com.ibm.ws.webservices.engine.Handler;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.description.OperationDesc;
import com.ibm.ws.webservices.engine.dispatchers.SoapRPCProcessor;
import com.ibm.ws.webservices.engine.handlers.BasicHandler;
import com.ibm.ws.webservices.engine.handlers.jaxrpc.HandlerChain;
import com.ibm.ws.webservices.engine.handlers.jaxrpc.JAXRPCHandler;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPEnvelope;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPHeader;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPHeaderElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import org.apache.commons.logging.Log;

public class JAXRPCSOAPHandler
extends JAXRPCHandler {
    protected static Log log = LogFactory.getLog(JAXRPCSOAPHandler.class.getName());
    private static String _CHAIN_AND_OPERATION_ACTORS_HEADERS = "com.ibm.ws.webservices.engine.chain_operation.actors_headers";
    private Collection _handlerChainHeaderQNames;
    private final boolean doMisunderstoodHeaders = true;

    public JAXRPCSOAPHandler() throws ConfigurationException {
        this(null, null, null);
    }

    public JAXRPCSOAPHandler(Handler serviceHandler) {
        this(null, serviceHandler, null);
    }

    public JAXRPCSOAPHandler(Handler reqHandler, Handler pivHandler, Handler respHandler) {
        super(reqHandler, pivHandler, respHandler);
    }

    public static Handler factory(Handler reqHandler, Handler pivHandler, Handler respHandler, HandlerChain handlerChain) {
        if (reqHandler == null && respHandler == null && handlerChain == null) {
            return pivHandler;
        }
        JAXRPCSOAPHandler jaxrpcHandler = new JAXRPCSOAPHandler(reqHandler, pivHandler, respHandler);
        if (handlerChain != null) {
            jaxrpcHandler.setHandlerChain(handlerChain);
        }
        return jaxrpcHandler;
    }

    protected Handler jaxrpcServerRequestHandler() {
        return this.getHandlerChain() == null ? new BasicHandler(){

            public void invoke(MessageContext msgContext) throws WebServicesFault {
                JAXRPCSOAPHandler.this.checkSOAPSemantics(msgContext);
            }
        } : super.jaxrpcServerRequestHandler();
    }

    protected Handler jaxrpcClientResponseHandler() {
        return this.getHandlerChain() == null ? new BasicHandler(){

            public void invoke(MessageContext msgContext) throws WebServicesFault {
                JAXRPCSOAPHandler.this.checkSOAPSemantics(msgContext);
            }
        } : super.jaxrpcClientResponseHandler();
    }

    protected boolean invokeServerRequestHandler(MessageContext msgContext) throws WebServicesFault {
        this.checkSOAPSemantics(msgContext);
        return super.invokeServerRequestHandler(msgContext);
    }

    protected boolean invokeClientResponseHandler(MessageContext msgContext) throws WebServicesFault {
        this.checkSOAPSemantics(msgContext);
        return super.invokeClientResponseHandler(msgContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JAXRPCHandler.ActorHeaderBindings getOperationsActorHeaderBindings(MessageContext msgContext) throws WebServicesFault {
        JAXRPCHandler.ActorHeaderBindings actorsHeaders;
        OperationDesc op;
        if (log.isDebugEnabled()) {
            log.debug("Enter: getOperationsActorHeaderBindings()");
        }
        try {
            op = SoapRPCProcessor.getProcessor().getOperation(msgContext);
        }
        catch (WebServicesFault wsf) {
            FFDCFilter.processException((Throwable)wsf, "com.ibm.ws.webservices.engine.handlers.jaxrpc.JAXRPCSOAPHandler.checkMisunderstoodHeader", "222", this);
            throw wsf;
        }
        catch (Exception exp) {
            FFDCFilter.processException((Throwable)exp, "com.ibm.ws.webservices.engine.handlers.jaxrpc.JAXRPCSOAPHandler.getOperationHeaderQNames", "168", this);
            if (log.isDebugEnabled()) {
                log.debug(Messages.getMessage("toWebServicesFault00"), exp);
            }
            throw WebServicesFault.makeFault(exp);
        }
        if (op != null) {
            OperationDesc operationDesc = op;
            synchronized (operationDesc) {
                actorsHeaders = (JAXRPCHandler.ActorHeaderBindings)op.getOption(_CHAIN_AND_OPERATION_ACTORS_HEADERS);
                if (actorsHeaders == null) {
                    actorsHeaders = new JAXRPCHandler.ActorHeaderBindings(this.getAllActorHeaderBindings());
                    Set opHeaderParams = op.getHeaderParamQNames();
                    if (opHeaderParams.size() > 0) {
                        Iterator iter = this.getNodeActors();
                        while (iter.hasNext()) {
                            String opActor = (String)iter.next();
                            actorsHeaders.addBinding(opActor, opHeaderParams);
                        }
                    }
                    opHeaderParams.clear();
                    op.setOption(_CHAIN_AND_OPERATION_ACTORS_HEADERS, actorsHeaders);
                }
            }
        } else {
            actorsHeaders = this.getAllActorHeaderBindings();
        }
        if (log.isDebugEnabled()) {
            log.debug("Actors / Headers: " + actorsHeaders);
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: getOperationsActorHeaderBindings");
        }
        return actorsHeaders;
    }

    private Collection addMisunderstoodHeader(Collection misunderstoodHeaders, SOAPHeaderElement headerElement) {
        if (misunderstoodHeaders == null) {
            misunderstoodHeaders = new Vector<SOAPHeaderElement>();
        }
        misunderstoodHeaders.add(headerElement);
        if (log.isDebugEnabled()) {
            log.debug("Misunderstood Header! " + headerElement);
        }
        return misunderstoodHeaders;
    }

    private void checkSOAPSemantics(MessageContext msgContext) throws WebServicesFault {
        Iterator iter;
        SOAPHeader soapHeader;
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("semanticCheck00"));
        }
        Message msg = (Message)msgContext.getMessage();
        SOAPEnvelope env = msg.getSOAPEnvelope();
        try {
            soapHeader = (SOAPHeader)env.getHeader();
        }
        catch (SOAPException se) {
            FFDCFilter.processException((Throwable)se, "com.ibm.ws.webservices.engine.handlers.jaxrpc.JAXRPCSOAPHandler.checkSOAPSemantics", "174", this);
            throw WebServicesFault.makeFault(se);
        }
        Collection misunderstoodHeaders = null;
        Iterator iterator = iter = soapHeader == null ? null : soapHeader.getChildElements();
        while (iter != null && iter.hasNext()) {
            String actor;
            SOAPHeaderElement headerElement;
            Object candidateElement = iter.next();
            if (!(candidateElement instanceof SOAPHeaderElement) || !(headerElement = (SOAPHeaderElement)candidateElement).getMustUnderstand()) continue;
            QName header2 = headerElement.getQName();
            Set portOperationHeaders = this.getPortOperationHeaders(msgContext);
            JAXRPCHandler.ActorHeaderBindings actorHeaderBindings = portOperationHeaders.contains(header2) ? this.getOperationsActorHeaderBindings(msgContext) : this.getAllActorHeaderBindings();
            if (!actorHeaderBindings.nodeActorNotBoundToHeader(actor = headerElement.getActor(), header2)) continue;
            misunderstoodHeaders = this.addMisunderstoodHeader(misunderstoodHeaders, headerElement);
        }
        if (misunderstoodHeaders != null) {
            String envelopeURI = msgContext.getSOAPConstants().getEnvelopeURI();
            WebServicesFault fault2 = new WebServicesFault(QNameTable.createQName(envelopeURI, "MustUnderstand"), null, null, null);
            StringBuffer whatWasMissUnderstood = new StringBuffer(256);
            iter = misunderstoodHeaders.iterator();
            while (iter.hasNext()) {
                Object candidateElement = iter.next();
                if (!(candidateElement instanceof SOAPHeaderElement)) continue;
                SOAPHeaderElement badHeader = (SOAPHeaderElement)candidateElement;
                if (whatWasMissUnderstood.length() != 0) {
                    whatWasMissUnderstood.append(", ");
                }
                whatWasMissUnderstood.append(badHeader.getQName().toString());
                SOAPHeaderElement newHeader = null;
                try {
                    newHeader = badHeader.getSOAPFactory().createSOAPHeaderElement("http://www.w3.org/2002/06/soap-faults", "Misunderstood");
                }
                catch (SOAPException se) {
                    FFDCFilter.processException((Throwable)se, "com.ibm.ws.webservices.engine.handlers.jaxrpc.JAXRPCSOAPHandler.checkSOAPSemantics", "252", this);
                    throw WebServicesFault.makeFault(se);
                }
                String prefix = null;
                String attrValue = badHeader.getLocalPart();
                if (badHeader.getNamespaceURI() != null && badHeader.getNamespaceURI().length() > 0) {
                    prefix = badHeader.getPrefix();
                    if (prefix != null) {
                        newHeader.addNamespaceDeclaration(prefix, badHeader.getNamespaceURI());
                        attrValue = prefix + ':' + attrValue;
                    } else {
                        newHeader.addNamespaceDeclaration("", badHeader.getNamespaceURI());
                    }
                }
                newHeader.addAttribute("", "qname", attrValue);
                fault2.addHeader(newHeader);
            }
            fault2.setFaultString(Messages.getMessage("noUnderstand00", whatWasMissUnderstood.toString()));
            throw fault2;
        }
    }

    private Set getPortOperationHeaders(MessageContext msgContext) {
        Set portHeaders;
        if (log.isDebugEnabled()) {
            log.debug("Enter: getPortOperationHeaders");
        }
        if ((portHeaders = msgContext.getPortDesc().getPortOperationHeaders()) == null) {
            portHeaders = new JAXRPCHandler.QNameSet();
            ArrayList opDescArray = msgContext.getPortDesc().getOperations();
            for (int i = 0; i < opDescArray.size(); ++i) {
                OperationDesc op = (OperationDesc)opDescArray.get(i);
                Set opHeaderParams = op.getHeaderParamQNames();
                portHeaders.addAll(opHeaderParams);
                opHeaderParams.clear();
            }
            msgContext.getPortDesc().setPortOperationHeaders(portHeaders);
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: getPortOperationHeaders");
        }
        return portHeaders;
    }

    public void _destroy() {
        super._destroy();
        if (this._handlerChainHeaderQNames != null) {
            this._handlerChainHeaderQNames.clear();
            this._handlerChainHeaderQNames = null;
        }
    }
}

