/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.handlers;

import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.handlers.BasicHandler;
import com.ibm.ws.webservices.engine.handlers.soap.SOAPPort;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.security.AuthenticatedUser;
import com.ibm.ws.webservices.engine.security.SecurityProvider;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;

public class SimpleAuthorizationHandler
extends BasicHandler {
    protected static Log log = LogFactory.getLog(SimpleAuthorizationHandler.class.getName());

    public void invoke(MessageContext msgContext) throws WebServicesFault {
        if (log.isDebugEnabled()) {
            log.debug("Enter: SimpleAuthorizationHandler::invoke");
        }
        boolean allowByDefault = JavaUtils.isTrueExplicitly(this.getOption("allowByDefault"));
        AuthenticatedUser user = (AuthenticatedUser)msgContext.getProperty(MessageContext.AUTHUSER);
        if (user == null) {
            throw new WebServicesFault("Server.NoUser", Messages.getMessage("needUser00"), null, null);
        }
        String userID = user.getName();
        SOAPPort serviceHandler = msgContext.getPort();
        if (serviceHandler == null) {
            throw new WebServicesFault(Messages.getMessage("needService00"));
        }
        String serviceName = serviceHandler.getName();
        String allowedRoles = (String)serviceHandler.getOption("allowedRoles");
        if (allowedRoles == null) {
            if (allowByDefault) {
                if (log.isDebugEnabled()) {
                    log.debug(Messages.getMessage("noRoles00"));
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug(Messages.getMessage("noRoles01"));
                }
                throw new WebServicesFault("Server.Unauthorized", Messages.getMessage("notAuth00", userID, serviceName), null, null);
            }
            if (log.isDebugEnabled()) {
                log.debug("Exit: SimpleAuthorizationHandler::invoke");
            }
            return;
        }
        SecurityProvider provider = (SecurityProvider)msgContext.getProperty("securityProvider");
        if (provider == null) {
            throw new WebServicesFault(Messages.getMessage("noSecurity00"));
        }
        StringTokenizer st = new StringTokenizer(allowedRoles, ",");
        while (st.hasMoreTokens()) {
            String thisRole = st.nextToken();
            if (!provider.userMatches(user, thisRole)) continue;
            if (log.isDebugEnabled()) {
                log.debug(Messages.getMessage("auth01", userID, serviceName));
            }
            if (log.isDebugEnabled()) {
                log.debug("Exit: SimpleAuthorizationHandler::invoke");
            }
            return;
        }
        throw new WebServicesFault("Server.Unauthorized", Messages.getMessage("cantAuth02", userID, serviceName), null, null);
    }
}

